/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.api.views.modelexplorerview.resourcelistener;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.util.URI;
import org.eclipse.sirius.business.api.modelingproject.ModelingProject;
import org.eclipse.sirius.business.api.query.FileQuery;
import org.eclipse.sirius.business.api.resource.strategy.ResourceStrategyRegistry;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.internal.query.ResourceDeltaQuery;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ui.tools.api.views.modelexplorerview.resourcelistener.MarkerDeletionJob;

public class ResourceDeltaVisitor
implements IResourceDeltaVisitor {
    protected Set<IProject> projectsToInitialize = Sets.newHashSet();
    protected Set<ModelingProject> projectsToInitializeAndLoad = Sets.newHashSet();
    protected Map<Session, Set<URI>> semanticResourcesURIsToAttachPerSession = new LinkedHashMap<Session, Set<URI>>();
    protected Map<Session, Set<URI>> semanticResourcesURIsToDetachPerSession = new LinkedHashMap<Session, Set<URI>>();
    private final Set<ModelingProject> modelingProjectsBeingImported = new HashSet<ModelingProject>();

    public boolean visit(IResourceDelta delta) throws CoreException {
        boolean visitChildren = true;
        IResource res = delta.getResource();
        if (res.getType() == 1) {
            visitChildren = this.visitFile(delta, (IFile)res);
        } else if (res.getType() == 4) {
            visitChildren = this.visitProject(delta, res.getProject());
        }
        return visitChildren;
    }

    protected boolean visitProject(IResourceDelta delta, IProject project) throws CoreException {
        boolean visitChildren = true;
        Option optionalModelingProject = ModelingProject.asModelingProject((IProject)project);
        if (project != null) {
            if (optionalModelingProject.some()) {
                if (1 == delta.getKind() && !project.isSynchronized(2)) {
                    this.modelingProjectsBeingImported.add((ModelingProject)optionalModelingProject.get());
                } else if (1 == delta.getKind() && project.isSynchronized(2)) {
                    this.projectsToInitialize.add(project);
                } else if (4 == delta.getKind() && this.modelingProjectsBeingImported.contains(optionalModelingProject.get())) {
                    this.modelingProjectsBeingImported.remove(optionalModelingProject.get());
                    this.projectsToInitialize.add(project);
                } else if (4 == delta.getKind() && (delta.getFlags() & 0x4000) != 0) {
                    this.projectsToInitializeAndLoad.add((ModelingProject)optionalModelingProject.get());
                } else if (4 == delta.getKind() && (delta.getFlags() & 0x80000) != 0 && new ResourceDeltaQuery(delta).hasModelingNatureAdded()) {
                    this.projectsToInitializeAndLoad.add((ModelingProject)optionalModelingProject.get());
                }
            } else if (4 == delta.getKind() && (delta.getFlags() & 0x80000) != 0 && new ResourceDeltaQuery(delta).hasModelingNatureRemoved()) {
                MarkerDeletionJob job = new MarkerDeletionJob((IResource)project);
                job.setRule((ISchedulingRule)project);
                job.schedule();
            }
        }
        return visitChildren;
    }

    protected boolean visitFile(IResourceDelta delta, IFile file) {
        boolean visitChildren = true;
        IProject project = file.getProject();
        Option modelingProject = ModelingProject.asModelingProject((IProject)project);
        if (project != null && modelingProject.some() && !this.projectsToInitializeAndLoad.contains(modelingProject.get()) && !this.projectsToInitialize.contains(project)) {
            Session session = ((ModelingProject)modelingProject.get()).getSession();
            if (session != null) {
                this.visitFileWithOpenedRepresentationsFile(delta, file, session);
            } else {
                switch (delta.getKind()) {
                    case 1: 
                    case 2: {
                        if (!new FileQuery(file).isSessionResourceFile()) break;
                        this.projectsToInitializeAndLoad.add((ModelingProject)modelingProject.get());
                        break;
                    }
                    case 4: {
                        int cfr_ignored_0 = delta.getMarkerDeltas().length;
                        break;
                    }
                }
            }
            visitChildren = false;
        }
        return visitChildren;
    }

    protected void visitFileWithOpenedRepresentationsFile(IResourceDelta delta, IFile file, Session session) {
        URI uri = URI.createPlatformResourceURI((String)delta.getFullPath().toString(), (boolean)true);
        switch (delta.getKind()) {
            case 1: {
                if (ResourceStrategyRegistry.getInstance().isPotentialSemanticResource(uri) && ResourceStrategyRegistry.getInstance().isLoadableModel(uri, session)) {
                    if (session == null) break;
                    Set<URI> semanticResourcesURIsToAttach = this.semanticResourcesURIsToAttachPerSession.get(session);
                    if (semanticResourcesURIsToAttach == null) {
                        semanticResourcesURIsToAttach = new LinkedHashSet<URI>();
                        this.semanticResourcesURIsToAttachPerSession.put(session, semanticResourcesURIsToAttach);
                    }
                    semanticResourcesURIsToAttach.add(uri);
                    break;
                }
                if (!new FileQuery(file).isSessionResourceFile()) break;
                this.projectsToInitialize.add(file.getProject());
                break;
            }
            case 2: {
                if (session != null) {
                    Set<URI> semanticResourcesURIsToDetach = this.semanticResourcesURIsToDetachPerSession.get(session);
                    if (semanticResourcesURIsToDetach == null) {
                        semanticResourcesURIsToDetach = new LinkedHashSet<URI>();
                        this.semanticResourcesURIsToDetachPerSession.put(session, semanticResourcesURIsToDetach);
                    }
                    semanticResourcesURIsToDetach.add(uri);
                }
                if (!new FileQuery(file).isSessionResourceFile()) break;
                this.projectsToInitialize.add(file.getProject());
                break;
            }
            case 4: {
                int cfr_ignored_0 = delta.getMarkerDeltas().length;
            }
        }
    }
}

