/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.ui.tools.internal.editor.provider;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.sirius.business.api.dialect.DRepresentationNotificationFilter;
import org.eclipse.sirius.common.ui.tools.api.util.EclipseUIUtil;
import org.eclipse.sirius.table.metamodel.table.DCell;
import org.eclipse.sirius.table.metamodel.table.DCellStyle;
import org.eclipse.sirius.table.metamodel.table.DColumn;
import org.eclipse.sirius.table.metamodel.table.DLine;
import org.eclipse.sirius.table.metamodel.table.DTable;
import org.eclipse.sirius.table.metamodel.table.DTableElementStyle;
import org.eclipse.sirius.table.metamodel.table.DTargetColumn;
import org.eclipse.sirius.table.metamodel.table.TablePackage;
import org.eclipse.sirius.table.ui.tools.internal.editor.DTableTreeViewer;
import org.eclipse.sirius.table.ui.tools.internal.editor.DTableViewerManager;
import org.eclipse.sirius.table.ui.tools.internal.editor.provider.TableUIUpdaterRunnable;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.ViewpointPackage;

public class TableUIUpdater
extends ResourceSetListenerImpl {
    private DTableViewerManager dTableViewerManager;
    private DTableTreeViewer dTableTreeViewer;
    private Set<DLine> toExpands;
    private Set<DLine> toCollapses;
    private Set<Object> toRefreshInViewerWithUpdateLabels;
    private boolean launchGlobalRefreshWithoutUpdateLabels;
    private boolean launchGlobalRefreshWithUpdateLabels;
    private Set<Object> toUpdateInViewer;
    private Set<DColumn> dColumnsToUpdateDirectly;
    private Set<DColumn> dColumnsWidthToUpdate;
    private Set<DColumn> dColumnsToRemove;
    private Map<DColumn, Integer> dColumnsToAdd;
    private Map<DColumn, Boolean> dColumnsToVisibilityChanged;
    private boolean updateHeaderColumnWidth;

    public TableUIUpdater(DTableViewerManager dTableViewerManager, DRepresentation dRepresentation) {
        super((NotificationFilter)new DRepresentationNotificationFilter(dRepresentation));
        this.dTableTreeViewer = (DTableTreeViewer)dTableViewerManager.getTreeViewer();
        this.dTableViewerManager = dTableViewerManager;
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)dRepresentation);
        if (domain != null) {
            domain.addResourceSetListener((ResourceSetListener)this);
        }
    }

    public boolean isPostcommitOnly() {
        return true;
    }

    public void resourceSetChanged(ResourceSetChangeEvent event) {
        this.toRefreshInViewerWithUpdateLabels = Sets.newLinkedHashSet();
        this.toUpdateInViewer = Sets.newLinkedHashSet();
        this.dColumnsToUpdateDirectly = new LinkedHashSet<DColumn>();
        this.dColumnsWidthToUpdate = new LinkedHashSet<DColumn>();
        this.toCollapses = Sets.newLinkedHashSet();
        this.toExpands = Sets.newLinkedHashSet();
        this.dColumnsToRemove = new LinkedHashSet<DColumn>();
        this.dColumnsToAdd = new LinkedHashMap<DColumn, Integer>();
        this.dColumnsToVisibilityChanged = new LinkedHashMap<DColumn, Boolean>();
        this.launchGlobalRefreshWithoutUpdateLabels = false;
        this.launchGlobalRefreshWithUpdateLabels = false;
        this.updateHeaderColumnWidth = false;
        this.analyseNotifications(event.getNotifications());
        this.updateDTableTreeViewer();
    }

    private void analyseNotifications(List<Notification> notifications) {
        for (Notification notification : notifications) {
            this.analyseNotification(notification);
        }
    }

    private void analyseNotification(Notification notification) {
        DCell dCell;
        DLine dLine;
        DCellStyle dCellStyle;
        EObject dCellStyleContainer;
        Object notifier = notification.getNotifier();
        if (notifier instanceof DTable) {
            if (notification.getFeature() == TablePackage.Literals.DTABLE__HEADER_COLUMN_WIDTH) {
                this.updateHeaderColumnWidth = true;
            } else if (notification.getFeature() == TablePackage.Literals.DTABLE__COLUMNS) {
                if (notification.getEventType() == 3) {
                    if (notification.getNewValue() instanceof DColumn) {
                        this.dColumnsToAdd.put((DColumn)notification.getNewValue(), notification.getPosition() + 1);
                    }
                } else if (notification.getEventType() == 7) {
                    if (notification.getNewValue() instanceof DColumn) {
                        DColumn newValue = (DColumn)notification.getNewValue();
                        int newPosition = notification.getPosition() + 1;
                        this.dColumnsToAdd.put(newValue, newPosition);
                        this.dColumnsToRemove.add(newValue);
                    }
                } else if (notification.getEventType() == 4) {
                    if (notification.getOldValue() instanceof DColumn) {
                        this.dColumnsToRemove.add((DColumn)notification.getOldValue());
                    }
                } else if (notification.getEventType() == 6 && notification.getOldValue() instanceof EList) {
                    for (EObject oldValue : (EList)notification.getOldValue()) {
                        if (!(oldValue instanceof DTargetColumn)) continue;
                        this.dColumnsToRemove.add((DColumn)oldValue);
                    }
                }
            } else if (notification.getFeature() == ViewpointPackage.Literals.DSEMANTIC_DECORATOR__TARGET || notification.getFeature() == TablePackage.Literals.LINE_CONTAINER__LINES) {
                DLine dLine2;
                this.toRefreshInViewerWithUpdateLabels.add(notifier);
                if (notification.getFeature() == TablePackage.Literals.LINE_CONTAINER__LINES && notification.getNewValue() instanceof DLine && !(dLine2 = (DLine)notification.getNewValue()).isCollapsed()) {
                    this.toExpands.add(dLine2);
                    this.analyseExpansionStateOfCreatedChildren((Collection<DLine>)dLine2.getLines());
                }
            }
        } else if (notifier instanceof DLine) {
            DLine dLine3 = (DLine)notifier;
            if (notification.getFeature() == TablePackage.Literals.DLINE__LABEL || notification.getFeature() == TablePackage.Literals.DLINE__CELLS || notification.getFeature() == TablePackage.Literals.DLINE__CURRENT_STYLE) {
                this.toUpdateInViewer.add(notifier);
            } else if (notification.getFeature() == TablePackage.Literals.DLINE__ORDERED_CELLS) {
                this.toRefreshInViewerWithUpdateLabels.add(notifier);
            } else if (notification.getFeature() == TablePackage.Literals.LINE_CONTAINER__LINES) {
                this.toRefreshInViewerWithUpdateLabels.add(notifier);
                if (!dLine3.isCollapsed()) {
                    this.toExpands.add(dLine3);
                    this.analyseExpansionStateOfCreatedChildren((Collection<DLine>)dLine3.getLines());
                }
            } else if (notification.getFeature() == TablePackage.Literals.DLINE__VISIBLE) {
                this.launchGlobalRefreshWithoutUpdateLabels = true;
            } else if (notification.getFeature() == TablePackage.Literals.DLINE__COLLAPSED) {
                this.analyseExpansion(dLine3);
            }
        } else if (notifier instanceof DColumn) {
            DColumn dColumn = (DColumn)notifier;
            if (notification.getFeature() == TablePackage.Literals.DCOLUMN__ORDERED_CELLS) {
                this.launchGlobalRefreshWithUpdateLabels = true;
            } else if (notification.getFeature() == TablePackage.Literals.DCOLUMN__LABEL) {
                this.dColumnsToUpdateDirectly.add(dColumn);
            } else if (notification.getFeature() == TablePackage.Literals.DCOLUMN__VISIBLE) {
                this.dColumnsToVisibilityChanged.put(dColumn, dColumn.isVisible());
            } else if (notification.getFeature() == TablePackage.Literals.DCOLUMN__WIDTH) {
                this.dColumnsWidthToUpdate.add(dColumn);
            }
        } else if (notification.getFeature() == TablePackage.Literals.DCELL__LABEL || notification.getFeature() == TablePackage.Literals.DCELL__CURRENT_STYLE && notifier instanceof DCell) {
            DCell dCell2 = (DCell)notifier;
            DLine dLine4 = dCell2.getLine();
            if (dLine4 != null) {
                this.toUpdateInViewer.add(dLine4);
            }
        } else if (this.isDTableElementStyleAttributeChange(notification)) {
            DTableElementStyle dTableElementStyle = (DTableElementStyle)notifier;
            EObject eContainer = dTableElementStyle.eContainer();
            if (eContainer instanceof DCell) {
                DCell dCell3 = (DCell)eContainer;
                DLine dLine5 = dCell3.getLine();
                this.toUpdateInViewer.add(dLine5);
            } else if (eContainer instanceof DLine) {
                this.toUpdateInViewer.add(eContainer);
            } else if (eContainer instanceof DColumn) {
                DColumn dColumn = (DColumn)eContainer;
                this.toRefreshInViewerWithUpdateLabels.add(dColumn.getTable());
            }
        } else if (notification.getNotifier() instanceof DCellStyle && this.isRGBValuesChange(notification) && (dCellStyleContainer = (dCellStyle = (DCellStyle)notification.getNotifier()).eContainer()) instanceof DCell && (dLine = (dCell = (DCell)dCellStyleContainer).getLine()) != null) {
            this.toUpdateInViewer.add(dLine);
        }
    }

    private void analyseExpansionStateOfCreatedChildren(Collection<DLine> ownedDLines) {
        for (DLine ownedDLine : ownedDLines) {
            if (ownedDLine.isCollapsed()) continue;
            this.toExpands.add(ownedDLine);
            this.analyseExpansionStateOfCreatedChildren((Collection<DLine>)ownedDLine.getLines());
        }
    }

    private void analyseExpansion(DLine dLine) {
        if (dLine.isCollapsed()) {
            this.toCollapses.add(dLine);
        } else {
            this.toExpands.add(dLine);
        }
    }

    private boolean isDTableElementStyleAttributeChange(Notification notification) {
        boolean isStyleFeature;
        boolean bl = isStyleFeature = notification.getFeature() == TablePackage.Literals.DTABLE_ELEMENT_STYLE__BACKGROUND_COLOR || notification.getFeature() == TablePackage.Literals.DTABLE_ELEMENT_STYLE__FOREGROUND_COLOR || notification.getFeature() == TablePackage.Literals.DTABLE_ELEMENT_STYLE__LABEL_FORMAT || notification.getFeature() == TablePackage.Literals.DTABLE_ELEMENT_STYLE__LABEL_SIZE;
        return isStyleFeature && notification.getNotifier() instanceof DTableElementStyle;
    }

    private boolean isRGBValuesChange(Notification notification) {
        return notification.getFeature() instanceof EAttribute && ((EAttribute)notification.getFeature()).getEType() == ViewpointPackage.Literals.RGB_VALUES;
    }

    private void updateDTableTreeViewer() {
        if (!(this.toExpands.isEmpty() && this.toCollapses.isEmpty() && this.toRefreshInViewerWithUpdateLabels.isEmpty() && !this.launchGlobalRefreshWithoutUpdateLabels && !this.launchGlobalRefreshWithUpdateLabels && this.toUpdateInViewer.isEmpty() && this.dColumnsToUpdateDirectly.isEmpty() && this.dColumnsWidthToUpdate.isEmpty() && this.dColumnsToRemove.isEmpty() && this.dColumnsToAdd.isEmpty() && this.dColumnsToVisibilityChanged.isEmpty() && !this.updateHeaderColumnWidth)) {
            Object[] objectsToUpdateInViewer = Sets.difference(this.toUpdateInViewer, this.toRefreshInViewerWithUpdateLabels).toArray(new Object[0]);
            TableUIUpdaterRunnable tableUIUpdaterRunnable = new TableUIUpdaterRunnable(this.dTableViewerManager, this.dTableTreeViewer, this.toExpands, this.toCollapses, this.toRefreshInViewerWithUpdateLabels, this.launchGlobalRefreshWithoutUpdateLabels, this.launchGlobalRefreshWithUpdateLabels, objectsToUpdateInViewer, this.dColumnsToUpdateDirectly, this.dColumnsWidthToUpdate, this.dColumnsToRemove, this.dColumnsToAdd, this.dColumnsToVisibilityChanged, this.updateHeaderColumnWidth);
            EclipseUIUtil.displayAsyncExec((Runnable)tableUIUpdaterRunnable);
        }
    }

    public void dispose() {
        if (this.getTarget() != null) {
            this.getTarget().removeResourceSetListener((ResourceSetListener)this);
        }
        this.dTableTreeViewer = null;
        this.dTableViewerManager = null;
    }
}

