/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.ui.tools.internal.editor.action;

import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sirius.table.ui.tools.internal.editor.action.AbstractToolAction;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public abstract class AbstractEditorCreateMenuAction<T extends AbstractToolAction>
extends Action
implements IMenuCreator {
    private final MenuManager menuManager = new MenuManager();
    private T lastCreateAction;
    private final String defaultName;
    private final List<T> createActionsForTable = Lists.newArrayList();
    private final Listener menuItemListener = new Listener(){

        public void handleEvent(Event event) {
            if (13 == event.type && !event.widget.isDisposed()) {
                ActionContributionItem item = (ActionContributionItem)event.widget.getData();
                AbstractEditorCreateMenuAction.this.setLastAction((AbstractToolAction)item.getAction());
            }
        }
    };
    private final MenuListener menuListener = new MenuAdapter(){

        public void menuShown(MenuEvent e) {
            MenuItem[] menuItems;
            MenuItem[] menuItemArray = menuItems = AbstractEditorCreateMenuAction.this.menuManager.getMenu().getItems();
            int n = menuItems.length;
            int n2 = 0;
            while (n2 < n) {
                MenuItem menuItem = menuItemArray[n2];
                if (menuItem.getStyle() != 2) {
                    menuItem.removeListener(13, AbstractEditorCreateMenuAction.this.menuItemListener);
                    menuItem.addListener(13, AbstractEditorCreateMenuAction.this.menuItemListener);
                }
                ++n2;
            }
        }
    };

    protected AbstractEditorCreateMenuAction(String text, ImageDescriptor image) {
        super(text, image);
        this.defaultName = text;
        this.setMenuCreator(this);
        this.setEnabled(false);
    }

    public void run() {
        if (this.lastCreateAction != null && this.lastCreateAction.isEnabled()) {
            this.lastCreateAction.run();
        }
    }

    public void addActionToMenu(Action action) {
        ActionContributionItem contribution = new ActionContributionItem((IAction)action);
        this.menuManager.add((IContributionItem)contribution);
    }

    public void dispose() {
        if (this.menuManager.getMenu() != null) {
            MenuItem[] menuItems;
            MenuItem[] menuItemArray = menuItems = this.menuManager.getMenu().getItems();
            int n = menuItems.length;
            int n2 = 0;
            while (n2 < n) {
                MenuItem menuItem = menuItemArray[n2];
                if (menuItem.getStyle() != 2) {
                    menuItem.removeListener(13, this.menuItemListener);
                }
                ++n2;
            }
            this.menuManager.getMenu().removeMenuListener(this.menuListener);
            this.menuManager.getMenu().dispose();
        }
        this.menuManager.dispose();
    }

    public Menu getMenu(Control parent) {
        if (this.menuManager.getMenu() == null) {
            this.menuManager.createContextMenu(parent);
            this.menuManager.getMenu().addMenuListener(this.menuListener);
            this.update();
        }
        return this.menuManager.getMenu();
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    public void update(List<AbstractToolAction> actions) {
        this.getCreateActionsForTable().clear();
        for (AbstractToolAction toolAction : this.filter(actions)) {
            this.getCreateActionsForTable().add((T)((Object)toolAction));
        }
        if (!this.createActionsForTable.isEmpty()) {
            this.setLastAction((AbstractToolAction)((Object)this.createActionsForTable.get(0)));
        }
        this.update();
    }

    protected abstract List<T> filter(List<AbstractToolAction> var1);

    protected void update() {
        this.menuManager.removeAll();
        this.setEnabled(!this.createActionsForTable.isEmpty());
        if (this.createActionsForTable.isEmpty()) {
            this.setText(this.defaultName);
        } else {
            for (AbstractToolAction createAction : this.createActionsForTable) {
                if (!createAction.canExecute()) continue;
                this.menuManager.add((IAction)createAction);
            }
        }
    }

    public void setLastAction(T createAction) {
        this.lastCreateAction = createAction;
        this.setText(this.lastCreateAction.getText());
    }

    protected List<T> getCreateActionsForTable() {
        return this.createActionsForTable;
    }
}

