/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.tools.api.util;

import com.google.common.collect.Maps;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.common.tools.api.util.StateFullIDFactoryAdapter;

public final class RefreshIdsHolder {
    private static Integer lastID = 0;
    private Map<EObject, Integer> knownObjects = Maps.newHashMap();

    public Integer getOrCreateID(EObject any) {
        Integer id = this.knownObjects.get(any);
        if (id == null) {
            Integer n = lastID;
            lastID = n + 1;
            id = n;
            this.knownObjects.put(any, id);
        }
        return id;
    }

    public void dispose() {
        this.knownObjects.clear();
    }

    public static RefreshIdsHolder getOrCreateHolder(EObject any) {
        RefreshIdsHolder factory = RefreshIdsHolder.findHolder(any);
        if (factory == null) {
            factory = new RefreshIdsHolder();
            any.eAdapters().add((Object)new StateFullIDFactoryAdapter(factory));
        }
        return factory;
    }

    private static RefreshIdsHolder findHolder(EObject any) {
        for (Adapter adapter : any.eAdapters()) {
            if (!(adapter instanceof StateFullIDFactoryAdapter)) continue;
            return ((StateFullIDFactoryAdapter)adapter).getID();
        }
        return null;
    }
}

