/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.unittest.ui.editor;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.ease.modules.unittest.ui.editor.AbstractEditorPage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;

public class SetupTeardown
extends AbstractEditorPage {
    private boolean fEnableChangeTracker = true;
    private Text txtCode;
    private ComboViewer cmbCodeFragment;

    public SetupTeardown(String id, String title) {
        super(id, title);
    }

    public SetupTeardown(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    @Override
    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        managedForm.getForm().getBody().setLayout((Layout)new GridLayout(2, false));
        Label lblCustomCodeUsed = new Label(managedForm.getForm().getBody(), 0);
        lblCustomCodeUsed.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        managedForm.getToolkit().adapt((Control)lblCustomCodeUsed, true, true);
        lblCustomCodeUsed.setText("Custom code used to setup test suites, sets and tests. To run custom code actions use executeUserCode(<location>); in your scripts.");
        Label label = new Label(managedForm.getForm().getBody(), 0);
        managedForm.getToolkit().adapt((Control)label, true, true);
        new Label(managedForm.getForm().getBody(), 0);
        Label lblLocation = new Label(managedForm.getForm().getBody(), 0);
        lblLocation.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        managedForm.getToolkit().adapt((Control)lblLocation, true, true);
        lblLocation.setText("Location:");
        final CCombo combo_1 = new CCombo(managedForm.getForm().getBody(), 0x800008);
        GridData gd_combo_1 = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_combo_1.widthHint = 300;
        combo_1.setLayoutData((Object)gd_combo_1);
        combo_1.setEditable(true);
        combo_1.setVisibleItemCount(10);
        combo_1.setLayoutData((Object)gd_combo_1);
        this.cmbCodeFragment = new ComboViewer(combo_1);
        managedForm.getToolkit().paintBordersFor((Composite)combo_1);
        this.cmbCodeFragment.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.cmbCodeFragment.setInput(this.getLocations());
        combo_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String code = SetupTeardown.this.getModel().getCodeFragment(combo_1.getText());
                SetupTeardown.this.fEnableChangeTracker = false;
                if (code == null || code.isEmpty()) {
                    SetupTeardown.this.txtCode.setText(SetupTeardown.getDefaultText(combo_1.getText()));
                } else {
                    SetupTeardown.this.txtCode.setText(code);
                }
                SetupTeardown.this.fEnableChangeTracker = true;
            }
        });
        this.txtCode = new Text(managedForm.getForm().getBody(), 578);
        this.txtCode.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (SetupTeardown.this.fEnableChangeTracker) {
                    SetupTeardown.this.getModel().setCodeFragment(combo_1.getText(), SetupTeardown.this.txtCode.getText());
                    SetupTeardown.this.setDirty();
                }
            }
        });
        GridData gd_txtCode = new GridData(4, 4, true, true, 2, 1);
        gd_txtCode.verticalIndent = 10;
        this.txtCode.setLayoutData((Object)gd_txtCode);
        managedForm.getToolkit().adapt((Control)this.txtCode, true, true);
    }

    private static String getDefaultText(String location) {
        if ("TestSuite Setup".equals(location)) {
            return "// TestSuite setup is run once before the tests are run.\r\n// User defined variables are available and can be modified if needed.\r\n// All variables set by this code will be available in the tests, however\r\n// functions defined here will not be available. To raise errors use the\r\n// failure(\"Reason\") function.";
        }
        if ("TestSuite Teardown".equals(location)) {
            return "// TestSuite teardown is run once after all tests are finished.";
        }
        if ("TestFile Setup".equals(location)) {
            return "// TestFile setup is run at the beginning of a test file,\r\n// right before the script code is executed.\r\n";
        }
        if ("TestFile Teardown".equals(location)) {
            return "// TestFile teardown is run at the end of a test file.\r\n";
        }
        if ("Test Setup".equals(location)) {
            return "// Test setup is run when startTest() is called";
        }
        if ("Test Teardown".equals(location)) {
            return "// Test teardown is run when endTest() is called.\r\n// If a test runs into a failure() or throws an Exception\r\n// this code will not be reached.";
        }
        return "";
    }

    private Collection<String> getLocations() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("TestSuite Setup");
        result.add("TestFile Setup");
        result.add("Test Setup");
        result.add("Test Teardown");
        result.add("TestFile Teardown");
        result.add("TestSuite Teardown");
        for (String key : this.getModel().getCodeFragments().keySet()) {
            if (result.contains(key)) continue;
            result.add(key);
        }
        return result;
    }

    @Override
    protected String getPageTitle() {
        return "Setup / Teardown Code";
    }

    @Override
    protected void update() {
        this.cmbCodeFragment.setInput(this.getLocations());
    }
}

