/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.chrome.debugger.handlers;

import com.google.gson.Gson;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.websocket.Session;
import org.eclipse.dirigible.runtime.chrome.debugger.DebugConfiguration;
import org.eclipse.dirigible.runtime.chrome.debugger.communication.NoIdResponse;
import org.eclipse.dirigible.runtime.chrome.debugger.communication.PageGetResourceTreeResponse;
import org.eclipse.dirigible.runtime.chrome.debugger.handlers.MessageHandler;
import org.eclipse.dirigible.runtime.chrome.debugger.processing.MessageDispatcher;
import org.eclipse.dirigible.runtime.chrome.debugger.processing.ScriptProcessor;
import org.eclipse.dirigible.runtime.chrome.debugger.processing.ScriptRepository;
import org.eclipse.dirigible.runtime.chrome.debugger.utils.RequestUtils;

public class GetResourceTreeHandler
implements MessageHandler {
    private static final Gson GSON = new Gson();

    @Override
    public void handle(String message, Session session) throws IOException {
        Integer messageId = RequestUtils.getMessageId(message);
        PageGetResourceTreeResponse resourceTree = PageGetResourceTreeResponse.buildForProjectsWithResources(DebugConfiguration.getResources());
        resourceTree.setId(messageId);
        String treeAsJson = GSON.toJson((Object)resourceTree);
        MessageDispatcher.sendSyncMessage(treeAsJson, session);
        this.registerScripts(resourceTree);
        Integer contextId = this.initializeExecutionContext(session, resourceTree);
        this.parseScripts(session, resourceTree, contextId);
    }

    private void registerScripts(PageGetResourceTreeResponse resourceTree) {
        List<Map<String, String>> resources = resourceTree.getResult().getFrameTree().getResources();
        ScriptRepository repo = ScriptRepository.getInstance();
        for (Map<String, String> resource : resources) {
            repo.addScript(resource.get("url"));
        }
    }

    private Integer initializeExecutionContext(Session session, PageGetResourceTreeResponse resourceTree) {
        Context context = new Context(resourceTree.getResult().getFrameTree().getFrame().get("id"));
        NoIdResponse noIdResponse = new NoIdResponse();
        noIdResponse.setMethod("Runtime.executionContextCreated");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("context", context);
        noIdResponse.setParams(params);
        MessageDispatcher.sendMessage(GSON.toJson((Object)noIdResponse), session);
        return context.id;
    }

    private void parseScripts(Session session, PageGetResourceTreeResponse resourceTree, Integer contextId) {
        List<Map<String, String>> resources = resourceTree.getResult().getFrameTree().getResources();
        for (Map<String, String> resource : resources) {
            String type = resource.get("type");
            if (!type.equalsIgnoreCase("script")) continue;
            String url = resource.get("url");
            ScriptProcessor.ScriptResponse parsedScript = ScriptProcessor.getScriptResponseForURL(url, contextId);
            MessageDispatcher.sendMessage(GSON.toJson((Object)parsedScript), session);
        }
    }

    private class Context {
        private final Integer id = new Random().nextInt(10000);
        private final String name = "";
        private final String origin = "";
        private String frameId;
        private Boolean isPageContext = true;

        private Context(String frameId) {
            this.frameId = frameId;
        }
    }
}

