/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.workspace.ui.wizard.file;

import org.eclipse.core.resources.IContainer;
import org.eclipse.dirigible.ide.workspace.ui.shared.FocusableWizardPage;
import org.eclipse.dirigible.ide.workspace.ui.shared.IValidationStatus;
import org.eclipse.dirigible.ide.workspace.ui.viewer.WorkspaceViewer;
import org.eclipse.dirigible.ide.workspace.ui.wizard.file.Messages;
import org.eclipse.dirigible.ide.workspace.ui.wizard.file.NewFileWizardModel;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NewFileWizardMainPage
extends FocusableWizardPage {
    private static final long serialVersionUID = 9151517663731999150L;
    private static final String FILE_NAME = Messages.NewFileWizardMainPage_FILE_NAME;
    private static final String PARENT_LOCATION = Messages.NewFileWizardMainPage_PARENT_LOCATION;
    private static final String PAGE_NAME = "Main Page";
    private static final String PAGE_TITLE = Messages.NewFileWizardMainPage_PAGE_TITLE;
    private static final String PAGE_DESCRIPTION = Messages.NewFileWizardMainPage_PAGE_DESCRIPTION;
    private Text parentLocationField = null;
    private Text fileNameField = null;
    private WorkspaceViewer workspaceViewer = null;
    private NewFileWizardModel model = null;

    public NewFileWizardMainPage(NewFileWizardModel model) {
        super(PAGE_NAME);
        this.setTitle(PAGE_TITLE);
        this.setDescription(PAGE_DESCRIPTION);
        this.model = model;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.setControl((Control)composite);
        composite.setLayout((Layout)new GridLayout(1, false));
        Label parentLocationLabel = new Label(composite, 0);
        parentLocationLabel.setText(PARENT_LOCATION);
        parentLocationLabel.setLayoutData((Object)new GridData(16384, 1024, false, false));
        this.parentLocationField = new Text(composite, 2048);
        this.parentLocationField.setLayoutData((Object)new GridData(4, 4, true, false));
        this.parentLocationField.addModifyListener(new ModifyListener(){
            private static final long serialVersionUID = -7765618126345654222L;

            public void modifyText(ModifyEvent event) {
                NewFileWizardMainPage.this.onParentLocationChanged(NewFileWizardMainPage.this.parentLocationField.getText());
            }
        });
        this.workspaceViewer = new WorkspaceViewer(composite, 2052);
        this.workspaceViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.workspaceViewer.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                NewFileWizardMainPage.this.onWorkspaceViewerSelected((IStructuredSelection)event.getSelection());
            }
        });
        Label fileNameLabel = new Label(composite, 0);
        fileNameLabel.setText(FILE_NAME);
        fileNameLabel.setLayoutData((Object)new GridData(16384, 1024, false, false));
        this.fileNameField = new Text(composite, 2048);
        this.fileNameField.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fileNameField.addModifyListener(new ModifyListener(){
            private static final long serialVersionUID = 6513005442028570556L;

            public void modifyText(ModifyEvent event) {
                NewFileWizardMainPage.this.onFileNameChanged(NewFileWizardMainPage.this.fileNameField.getText());
            }
        });
        this.setFocusable((Control)this.fileNameField);
        this.initialize();
    }

    private void onWorkspaceViewerSelected(IStructuredSelection selection) {
        Object element = selection.getFirstElement();
        if (element instanceof IContainer) {
            this.onWorkspaceContainerSelected((IContainer)element);
        }
    }

    public void setFileName(String name) {
        if (this.fileNameField == null || this.fileNameField.isDisposed()) {
            return;
        }
        if (!NewFileWizardMainPage.areEqual(this.fileNameField.getText(), name)) {
            this.fileNameField.setText(name);
        }
    }

    public void setParentLocation(String location) {
        if (this.parentLocationField == null || this.parentLocationField.isDisposed()) {
            return;
        }
        if (!NewFileWizardMainPage.areEqual(this.parentLocationField.getText(), location)) {
            this.parentLocationField.setText(location);
        }
    }

    private static boolean areEqual(Object a, Object b) {
        if (a == null && b == null) {
            return true;
        }
        if (a != null) {
            return a.equals(b);
        }
        return b.equals(a);
    }

    public void setWarningMessage(String message) {
        this.setMessage(message, 2);
    }

    public void setCanFinish(boolean value) {
        this.setPageComplete(value);
    }

    public void dispose() {
        this.workspaceViewer.dispose();
        this.parentLocationField = null;
        this.fileNameField = null;
        this.workspaceViewer = null;
        super.dispose();
    }

    public void initialize() {
        this.setFileName(this.model.getFileName());
        this.setParentLocation(this.model.getParentLocation());
        this.revalidate();
    }

    public void onFileNameChanged(String fileName) {
        this.model.setFileName(fileName);
        this.revalidate();
    }

    public void onParentLocationChanged(String parentLocation) {
        this.model.setParentLocation(parentLocation);
        this.revalidate();
    }

    public void onWorkspaceContainerSelected(IContainer container) {
        String location = container.getFullPath().toString();
        this.model.setParentLocation(location);
        this.setParentLocation(location);
        this.revalidate();
    }

    private void revalidate() {
        IValidationStatus status = this.model.validate();
        if (status.hasErrors()) {
            this.setErrorMessage(status.getMessage());
            this.setWarningMessage(null);
            this.setCanFinish(false);
        } else if (status.hasWarnings()) {
            this.setErrorMessage(null);
            this.setWarningMessage(status.getMessage());
            this.setCanFinish(true);
        } else {
            this.setErrorMessage(null);
            this.setWarningMessage(null);
            this.setCanFinish(true);
        }
    }
}

