/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.theme;

import org.eclipse.rap.rwt.internal.theme.QxType;
import org.eclipse.rap.rwt.internal.theme.ValueSelector;
import org.eclipse.rap.rwt.internal.theme.css.ConditionalValue;
import org.eclipse.swt.widgets.Widget;

public final class SimpleSelector
implements ValueSelector {
    private final String[] requiredConstraints;
    public static final SimpleSelector DEFAULT = new SimpleSelector(new String[0]);
    public static final SimpleSelector SELECTED = new SimpleSelector(new String[]{":selected"});
    public static final SimpleSelector INACTIVE = new SimpleSelector(new String[]{":inactive"});

    public SimpleSelector(String[] constraints) {
        this.requiredConstraints = constraints;
    }

    public QxType select(ConditionalValue[] values, Widget widget) {
        QxType result = null;
        int i = 0;
        while (i < values.length && result == null) {
            ConditionalValue condValue = values[i];
            String[] constraints = condValue.constraints;
            if (this.matches(constraints)) {
                result = condValue.value;
            }
            ++i;
        }
        return result;
    }

    private boolean matches(String[] constraints) {
        boolean result = true;
        int i = 0;
        while (i < constraints.length && result) {
            result = SimpleSelector.contains(this.requiredConstraints, constraints[i]);
            ++i;
        }
        return result;
    }

    private static boolean contains(String[] array, String string) {
        boolean result = false;
        int i = 0;
        while (i < array.length && !result) {
            result = array[i].equals(string);
            ++i;
        }
        return result;
    }
}

