/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.ext.indexing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.Version;
import org.eclipse.dirigible.repository.ext.indexing.EIndexingException;
import org.eclipse.dirigible.repository.ext.indexing.IIndex;
import org.eclipse.dirigible.repository.logging.Logger;

public class LuceneMemoryIndexer<T>
implements IIndex {
    private static final String FIELD_ID = "id";
    private static final String FIELD_CONTENT = "content";
    private static final Logger logger = Logger.getLogger(LuceneMemoryIndexer.class);
    private Directory directory = new RAMDirectory();
    private static Map<String, LuceneMemoryIndexer> indexes = Collections.synchronizedMap(new HashMap());
    private String indexName = null;
    private Date lastIndexed = new Date();

    public static LuceneMemoryIndexer getIndex(String indexName) {
        LuceneMemoryIndexer indexer = indexes.get(indexName);
        if (indexer == null) {
            indexer = new LuceneMemoryIndexer(indexName);
            indexes.put(indexName, indexer);
        }
        return indexer;
    }

    private LuceneMemoryIndexer(String indexName) {
        this.indexName = indexName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearIndex() throws EIndexingException {
        try {
            Directory directory = this.directory;
            synchronized (directory) {
                logger.debug("entering: clearIndex() : " + this.indexName);
                StandardAnalyzer analyzer = new StandardAnalyzer(Version.LUCENE_35);
                IndexWriterConfig config = null;
                IndexWriter iwriter = null;
                try {
                    config = new IndexWriterConfig(Version.LUCENE_35, (Analyzer)analyzer);
                    iwriter = new IndexWriter(this.directory, config);
                    iwriter.deleteAll();
                }
                finally {
                    if (iwriter != null) {
                        iwriter.close();
                    }
                }
                logger.debug("exiting: clearIndex() : " + this.indexName);
            }
        }
        catch (Exception e) {
            throw new EIndexingException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Document> search(String term) throws EIndexingException {
        try {
            ArrayList<Document> docs = new ArrayList<Document>();
            try {
                Directory directory = this.directory;
                synchronized (directory) {
                    logger.debug("entering: search(String term) : " + this.indexName);
                    StandardAnalyzer analyzer = new StandardAnalyzer(Version.LUCENE_35);
                    IndexSearcher isearcher = null;
                    IndexReader ireader = null;
                    try {
                        ireader = IndexReader.open((Directory)this.directory);
                        isearcher = new IndexSearcher(ireader);
                        QueryParser parser = new QueryParser(Version.LUCENE_35, FIELD_CONTENT, (Analyzer)analyzer);
                        Query query = parser.parse(term);
                        ScoreDoc[] hits = isearcher.search((Query)query, null, (int)100).scoreDocs;
                        int i = 0;
                        while (i < hits.length) {
                            Document hitDoc = isearcher.doc(hits[i].doc);
                            docs.add(hitDoc);
                            ++i;
                        }
                    }
                    finally {
                        if (isearcher != null) {
                            isearcher.close();
                        }
                        if (ireader != null) {
                            ireader.close();
                        }
                    }
                    logger.debug("exiting: search(String term) : " + this.indexName);
                }
            }
            catch (ParseException e) {
                logger.debug(e.getMessage());
            }
            return docs;
        }
        catch (Exception e) {
            throw new EIndexingException(e);
        }
    }

    public Document createDocument(String id, String content) throws EIndexingException {
        Document doc = new Document();
        doc.add((Fieldable)new Field(FIELD_ID, id, Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field(FIELD_CONTENT, content, Field.Store.YES, Field.Index.ANALYZED));
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indexDocument(Object document) throws EIndexingException {
        try {
            Directory directory = this.directory;
            synchronized (directory) {
                logger.debug("entering: indexDocument(Document document) : " + this.indexName);
                StandardAnalyzer analyzer = new StandardAnalyzer(Version.LUCENE_35);
                IndexWriterConfig config = null;
                IndexWriter iwriter = null;
                try {
                    config = new IndexWriterConfig(Version.LUCENE_35, (Analyzer)analyzer);
                    iwriter = new IndexWriter(this.directory, config);
                    iwriter.addDocument((Document)document);
                    iwriter.commit();
                    this.lastIndexed = new Date();
                }
                finally {
                    if (iwriter != null) {
                        iwriter.close();
                    }
                }
                logger.debug("exiting: indexRepository(IRepository repository) : " + this.indexName);
            }
        }
        catch (Exception e) {
            throw new EIndexingException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteDocument(Object document) throws EIndexingException {
        try {
            Directory directory = this.directory;
            synchronized (directory) {
                logger.debug("entering: indexDocument(Document document) : " + this.indexName);
                StandardAnalyzer analyzer = new StandardAnalyzer(Version.LUCENE_35);
                IndexWriterConfig config = null;
                IndexWriter iwriter = null;
                try {
                    config = new IndexWriterConfig(Version.LUCENE_35, (Analyzer)analyzer);
                    iwriter = new IndexWriter(this.directory, config);
                    Term term = new Term(FIELD_ID, ((Document)document).get(FIELD_ID));
                    iwriter.deleteDocuments(term);
                    iwriter.commit();
                    this.lastIndexed = new Date();
                }
                finally {
                    if (iwriter != null) {
                        iwriter.close();
                    }
                }
                logger.debug("exiting: indexRepository(IRepository repository) : " + this.indexName);
            }
        }
        catch (Exception e) {
            throw new EIndexingException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDocument(Object document) throws EIndexingException {
        try {
            Directory directory = this.directory;
            synchronized (directory) {
                logger.debug("entering: indexDocument(Document document) : " + this.indexName);
                StandardAnalyzer analyzer = new StandardAnalyzer(Version.LUCENE_35);
                IndexWriterConfig config = null;
                IndexWriter iwriter = null;
                try {
                    config = new IndexWriterConfig(Version.LUCENE_35, (Analyzer)analyzer);
                    iwriter = new IndexWriter(this.directory, config);
                    Term term = new Term(FIELD_ID, ((Document)document).get(FIELD_ID));
                    iwriter.updateDocument(term, (Document)document);
                    iwriter.commit();
                    this.lastIndexed = new Date();
                }
                finally {
                    if (iwriter != null) {
                        iwriter.close();
                    }
                }
                logger.debug("exiting: indexRepository(IRepository repository) : " + this.indexName);
            }
        }
        catch (Exception e) {
            throw new EIndexingException(e);
        }
    }

    @Override
    public Date getLastIndexed() {
        return this.lastIndexed;
    }
}

