/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.scripts.publish;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.dirigible.ide.common.CommonParameters;
import org.eclipse.dirigible.ide.publish.AbstractPublisher;
import org.eclipse.dirigible.ide.publish.IPublisher;
import org.eclipse.dirigible.ide.publish.PublishException;
import org.eclipse.dirigible.repository.api.ICollection;

public class ScriptsPublisher
extends AbstractPublisher
implements IPublisher {
    public void publish(IProject project) throws PublishException {
        try {
            ICollection targetContainer = this.getTargetProjectContainer(project, this.getRegistryLocation());
            IFolder sourceFolder = this.getSourceFolder(project, "ScriptingServices");
            this.copyAllFromTo((IContainer)sourceFolder, targetContainer);
        }
        catch (Exception ex) {
            throw new PublishException(ex.getMessage(), (Throwable)ex);
        }
    }

    public void activate(IProject project) throws PublishException {
        try {
            ICollection targetContainer = this.getTargetProjectContainer(project, CommonParameters.getScriptingContentSandbox());
            IFolder sourceFolder = this.getSourceFolder(project, "ScriptingServices");
            this.copyAllFromTo((IContainer)sourceFolder, targetContainer);
        }
        catch (Exception ex) {
            throw new PublishException(ex.getMessage(), (Throwable)ex);
        }
    }

    public String getFolderType() {
        return "ScriptingServices";
    }

    public boolean recognizedFile(IFile file) {
        return this.checkFolderType(file) && (".js".equals("." + file.getFileExtension()) || ".rb".equals("." + file.getFileExtension()) || ".groovy".equals("." + file.getFileExtension()) || ".java".equals("." + file.getFileExtension()) || ".command".equals("." + file.getFileExtension()));
    }

    public String getPublishedContainerMapping(IFile file) {
        if (".js".equals("." + file.getFileExtension())) {
            return "/js";
        }
        if (".rb".equals("." + file.getFileExtension())) {
            return "/rb";
        }
        if (".groovy".equals("." + file.getFileExtension())) {
            return "/groovy";
        }
        if (".java".equals("." + file.getFileExtension())) {
            return "/java";
        }
        if (".command".equals("." + file.getFileExtension())) {
            return "/command";
        }
        return null;
    }

    public String getActivatedContainerMapping(IFile file) {
        if (".js".equals("." + file.getFileExtension())) {
            return "/js-sandbox";
        }
        if (".rb".equals("." + file.getFileExtension())) {
            return "/rb-sandbox";
        }
        if (".groovy".equals("." + file.getFileExtension())) {
            return "/groovy-sandbox";
        }
        if (".java".equals("." + file.getFileExtension())) {
            return "/java-sandbox";
        }
        if (".command".equals("." + file.getFileExtension())) {
            return "/command-sandbox";
        }
        return null;
    }

    public boolean isAutoActivationAllowed() {
        return true;
    }

    protected String getSandboxLocation() {
        return CommonParameters.getScriptingContentSandbox();
    }

    public String getDebugEndpoint(IFile file) {
        if (".js".equals("." + file.getFileExtension())) {
            return String.valueOf(CommonParameters.getServicesUrl()) + "/js-debug" + this.generatePublishedPath(file);
        }
        return null;
    }

    protected String getRegistryLocation() {
        return "/db/dirigible/registry/public/ScriptingServices";
    }
}

