/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.workspace.wizard.project.commands;

import java.util.Iterator;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.dirigible.ide.workspace.dual.DownloadProjectWrapper;
import org.eclipse.dirigible.ide.workspace.wizard.project.export.DownloadDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class DownloadProjectHandler
extends AbstractHandler {
    public static final String PROJECT_NAME_SEPARATOR = "$";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection.size() == 1) {
            Object firstElement = selection.getFirstElement();
            if (firstElement instanceof IProject) {
                IProject project = (IProject)firstElement;
                DownloadDialog downloadDialog = new DownloadDialog(HandlerUtil.getActiveShell((ExecutionEvent)event));
                downloadDialog.setURL(DownloadProjectWrapper.getUrl((String)project.getName()));
                downloadDialog.open();
            }
        } else if (selection.size() > 1) {
            StringBuffer projectNames = new StringBuffer();
            Iterator iterator = selection.iterator();
            boolean dot = false;
            while (iterator.hasNext()) {
                Object element = iterator.next();
                if (!(element instanceof IProject)) continue;
                IProject project = (IProject)element;
                if (dot) {
                    projectNames.append(PROJECT_NAME_SEPARATOR);
                }
                projectNames.append(project.getName());
                dot = true;
            }
            DownloadDialog downloadDialog = new DownloadDialog(HandlerUtil.getActiveShell((ExecutionEvent)event));
            downloadDialog.setURL(DownloadProjectWrapper.getUrl((String)projectNames.toString()));
            downloadDialog.open();
        }
        return null;
    }
}

