/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.views.criteria;

import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.modelbase.sql.query.QuerySelect;
import org.eclipse.datatools.modelbase.sql.query.QueryStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryValueExpression;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryObject;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionColumn;
import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLDomainModel;
import org.eclipse.datatools.sqltools.sqlbuilder.model.VendorHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.util.LabelValuePair;
import org.eclipse.datatools.sqltools.sqlbuilder.views.BuilderUtility;
import org.eclipse.datatools.sqltools.sqlbuilder.views.ComboBoxCellEditor;
import org.eclipse.datatools.sqltools.sqlbuilder.views.DynamicComboBoxCellEditor;
import org.eclipse.datatools.sqltools.sqlbuilder.views.ITextProvider;
import org.eclipse.datatools.sqltools.sqlbuilder.views.NavigableTableViewer;
import org.eclipse.datatools.sqltools.sqlbuilder.views.criteria.CriteriaContentProvider;
import org.eclipse.datatools.sqltools.sqlbuilder.views.criteria.CriteriaElement;
import org.eclipse.datatools.sqltools.sqlbuilder.views.criteria.CriteriaModifier;
import org.eclipse.datatools.sqltools.sqlbuilder.views.criteria.CriteriaValueExpression;
import org.eclipse.datatools.sqltools.sqlbuilder.views.criteria.RemoveCriteriaAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.help.WorkbenchHelp;

public class CriteriaGridViewer
extends NavigableTableViewer
implements IMenuListener {
    public static final String P_STATEMENT_COLUMN = "org.eclipse.datatools.sqltools.sqlbuilder.CriteriaGridViewer.P_STATEMENT_COLUMN";
    public static final String P_STATEMENT_OPERATOR = "org.eclipse.datatools.sqltools.sqlbuilder.CriteriaGridViewer.P_STATEMENT_OPERATOR";
    public static final String P_STATEMENT_VALUE = "org.eclipse.datatools.sqltools.sqlbuilder.CriteriaGridViewer.P_STATEMENT_VALUE";
    public static final String P_STATEMENT_ANDOR = "org.eclipse.datatools.sqltools.sqlbuilder.CriteriaGridViewer.P_STATEMENT_ANDOR";
    public static final String P_STATEMENT_AS_TABLE_ROWS = "org.eclipse.datatools.sqltools.sqlbuilder.CriteriaGridViewer.P_STATEMENT_AS_TABLE_ROWS";
    public static final String[] dB2EveryplaceOperators = new String[]{"=", "<", "<=", ">", ">=", "<>", "IS NULL", "IS NOT NULL", "LIKE", "NOT LIKE", "IN", "NOT IN"};
    public static final String[] operators = new String[]{"=", "<", "<=", ">", ">=", "<>", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL", "LIKE", "NOT LIKE", "IN", "NOT IN", "EXISTS", "XMLEXISTS"};
    String[] columnProperties;
    boolean isHaving;
    DynamicComboBoxCellEditor columnEditor;
    ComboBoxCellEditor operatorEditor;
    DynamicComboBoxCellEditor rightPredicateValueEditor;
    ComboBoxCellEditor andOrEditor;
    Table table;
    SQLQueryObject currentSQLStatement;
    TableColumn c1;
    TableColumn c2;
    TableColumn c3;
    TableColumn c4;
    SQLDomainModel domainModel;

    public CriteriaGridViewer(int style, SQLDomainModel domainModel, Composite parent, boolean having) {
        super(new Table(parent, style | 0x800));
        this.domainModel = domainModel;
        this.isHaving = having;
        this.table = this.getTable();
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        WorkbenchHelp.setHelp((Control)this.table, (String)"org.eclipse.datatools.sqltools.sqlbuilder.sqss0010");
        this.columnEditor = new DynamicComboBoxCellEditor((Composite)this.table, null, (Object)this);
        ITextProvider columnTextProvider = new ITextProvider(){

            public String getText(Object value) {
                CriteriaElement critElem;
                QueryValueExpression valExpr;
                String text = null;
                if (value instanceof CriteriaElement && (valExpr = (critElem = (CriteriaElement)value).getColumn()) != null) {
                    text = valExpr.getSQL();
                }
                return text;
            }
        };
        this.columnEditor.setTextProvider(columnTextProvider);
        this.c1 = new TableColumn(this.table, 0);
        this.c1.setText(Messages._UI_COLUMN_COLUMN);
        this.operatorEditor = new ComboBoxCellEditor((Composite)this.table, null);
        ITextProvider operatorTextProvider = new ITextProvider(){

            public String getText(Object value) {
                String text = null;
                if (value instanceof CriteriaElement) {
                    CriteriaElement critElem = (CriteriaElement)value;
                    text = critElem.getOperator();
                }
                return text;
            }
        };
        this.operatorEditor.setTextProvider(operatorTextProvider);
        this.c2 = new TableColumn(this.table, 0);
        this.c2.setText(Messages._UI_COLUMN_CRITERIA_OPERATOR);
        VendorHelper vHelper = new VendorHelper(domainModel.getDatabase());
        if (vHelper.isDB2Everyplace()) {
            this.fillOperatorComboBox(dB2EveryplaceOperators);
        } else {
            this.fillOperatorComboBox(operators);
        }
        this.rightPredicateValueEditor = new DynamicComboBoxCellEditor((Composite)this.table, null, (Object)this);
        ITextProvider rightPredTextProvider = new ITextProvider(){

            public String getText(Object value) {
                String text = null;
                if (value instanceof CriteriaElement) {
                    CriteriaElement critElem = (CriteriaElement)value;
                    text = critElem.getValue();
                }
                return text;
            }
        };
        this.rightPredicateValueEditor.setTextProvider(rightPredTextProvider);
        this.c3 = new TableColumn(this.table, 0);
        this.c3.setText(Messages._UI_COLUMN_CRITERIA_VALUE);
        this.andOrEditor = new ComboBoxCellEditor((Composite)this.table, null);
        ITextProvider andOrTextProvider = new ITextProvider(){

            public String getText(Object value) {
                String text = null;
                if (value instanceof CriteriaElement) {
                    CriteriaElement critElem = (CriteriaElement)value;
                    text = critElem.getAndOr();
                }
                return text;
            }
        };
        this.andOrEditor.setTextProvider(andOrTextProvider);
        this.c4 = new TableColumn(this.table, 0);
        this.c4.setText(Messages._UI_COLUMN_CRTIERIA_AND_OR);
        this.fillAndOrComboBox();
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(160));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(110));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(140));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(70));
        this.table.setLayout((Layout)layout);
        String[] properties = new String[]{P_STATEMENT_COLUMN, P_STATEMENT_OPERATOR, P_STATEMENT_VALUE, P_STATEMENT_ANDOR};
        this.setColumnProperties(properties);
        this.setCellModifier(new CriteriaModifier());
        CellEditor[] editors = new CellEditor[]{this.columnEditor, this.operatorEditor, this.rightPredicateValueEditor, this.andOrEditor};
        this.setCellEditors(editors);
        this.initialize();
    }

    public void refresh() {
        if (!this.isCellEditorActive()) {
            super.refresh();
        }
    }

    public void menuAboutToShow(IMenuManager menu) {
        RemoveCriteriaAction removeCriteriaAction = new RemoveCriteriaAction(this);
        menu.add((IAction)removeCriteriaAction);
        CriteriaValueExpression cvAction = new CriteriaValueExpression(this);
        menu.add((IAction)cvAction);
    }

    public void refreshCellEditor(int row) {
        boolean leftExprExistsExpression = false;
        boolean rightExprExistsExpression = false;
        Object obj = this.getElementAt(row);
        if (obj instanceof CriteriaElement) {
            CriteriaElement criteria = (CriteriaElement)obj;
            QueryValueExpression left = criteria.column;
            Object right = criteria.value;
            if (left != null) {
                leftExprExistsExpression = true;
                if (left instanceof ValueExpressionColumn) {
                    TableItem titem = this.table.getItem(row);
                    String opr = titem.getText(1);
                    if (opr.equalsIgnoreCase("") || opr.equalsIgnoreCase("=") || opr.equalsIgnoreCase("<") || opr.equalsIgnoreCase("<=") || opr.equalsIgnoreCase(">") || opr.equalsIgnoreCase(">=") || opr.equalsIgnoreCase("<>") || opr.equalsIgnoreCase("LIKE") || opr.equalsIgnoreCase("NOT LIKE")) {
                        this.rightPredicateValueEditor.setNeedQuotes(true);
                    } else {
                        this.rightPredicateValueEditor.setNeedQuotes(false);
                    }
                    ValueExpressionColumn sce = (ValueExpressionColumn)left;
                    this.rightPredicateValueEditor.setPairDataType(sce.getDataType());
                } else {
                    this.rightPredicateValueEditor.setNeedQuotes(false);
                }
            }
            if (right != null && right instanceof QueryValueExpression) {
                rightExprExistsExpression = true;
            }
        }
        if (this.getInput() instanceof QueryStatement || this.getInput() instanceof QuerySelect) {
            BuilderUtility.fillColumnComboBox(this.columnEditor, (SQLQueryObject)this.getInput(), true, leftExprExistsExpression);
            BuilderUtility.fillColumnComboBox(this.rightPredicateValueEditor, (SQLQueryObject)this.getInput(), true, rightExprExistsExpression);
        }
        CellEditor[] editors = new CellEditor[]{this.columnEditor, this.operatorEditor, this.rightPredicateValueEditor, this.andOrEditor};
        this.setCellEditors(editors);
    }

    protected void initialize() {
        this.initializeContentViewer();
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IContributionItem)new Separator("additions"));
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener((IMenuListener)this);
        Menu menu = contextMenu.createContextMenu(this.getControl());
        this.getControl().setMenu(menu);
    }

    protected void initializeContentViewer() {
        this.columnProperties = new String[4];
        this.columnProperties[0] = P_STATEMENT_COLUMN;
        this.columnProperties[1] = P_STATEMENT_OPERATOR;
        this.columnProperties[2] = P_STATEMENT_VALUE;
        this.columnProperties[3] = P_STATEMENT_ANDOR;
        CriteriaContentProvider contentProvider = new CriteriaContentProvider(this.domainModel, this.isHaving);
        this.setContentProvider((IContentProvider)contentProvider);
        this.setLabelProvider((IBaseLabelProvider)new CriteriaGridLabelProvider());
    }

    protected void inputChanged(Object input, Object oldInput) {
        super.inputChanged(input, oldInput);
        this.currentSQLStatement = (SQLQueryObject)input;
        this.setGridTitle();
    }

    private void setGridTitle() {
    }

    protected void fillOperatorComboBox(String[] operatorList) {
        DatabaseDefinition dbDef = this.domainModel.getDatabaseDefinition();
        LabelValuePair[] operatorItems = dbDef != null && dbDef.supportsXML() ? new LabelValuePair[operatorList.length] : new LabelValuePair[operatorList.length - 1];
        int i = 0;
        while (i < operatorItems.length) {
            operatorItems[i] = new LabelValuePair(operatorList[i], operatorList[i]);
            ++i;
        }
        this.operatorEditor.createItems(operatorItems);
    }

    protected void fillAndOrComboBox() {
        LabelValuePair[] andOrItems = new LabelValuePair[]{new LabelValuePair("", ""), new LabelValuePair("AND", "AND"), new LabelValuePair("OR", "OR")};
        this.andOrEditor.createItems(andOrItems);
    }

    public void setEnabled(boolean enable) {
        this.table.setEnabled(enable);
    }

    class CriteriaGridLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        CriteriaGridLabelProvider() {
        }

        public String getColumnText(Object object, int columnIndex) {
            if (object instanceof CriteriaElement) {
                CriteriaElement criteriaElement = (CriteriaElement)object;
                return criteriaElement.getColumnText(columnIndex);
            }
            return "";
        }

        public Image getColumnImage(Object object, int columnIndex) {
            return null;
        }
    }

    class ValueCellEditor
    extends TextCellEditor {
        public ValueCellEditor(Composite parent) {
            super(parent);
        }

        protected void doSetValue(Object value) {
            if (value instanceof CriteriaElement) {
                CriteriaElement cre = (CriteriaElement)value;
                String result = cre.getColumnText(2);
                super.doSetValue((Object)result);
            }
        }
    }
}

