/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.ui.wizards;

import java.io.File;
import java.util.Vector;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.ui.ProfileImageRegistry;
import org.eclipse.datatools.help.ContextProviderDelegate;
import org.eclipse.datatools.help.HelpUtil;
import org.eclipse.help.IContext;
import org.eclipse.help.IContextProvider;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class ExportProfilesDialog
extends TrayDialog
implements IContextProvider {
    private CheckboxTableViewer tvViewer;
    private Text txtFile;
    private Button btnEncryption;
    private IConnectionProfile[] mProfiles;
    private File mFile;
    private boolean mNeedEncryption;
    private ContextProviderDelegate contextProviderDelegate = new ContextProviderDelegate(ConnectivityUIPlugin.getDefault().getBundle().getSymbolicName());

    public ExportProfilesDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(80);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = this.createParentDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 20;
        gridLayout.numColumns = 3;
        container.setLayout((Layout)gridLayout);
        GridLayout groupGridLayout = new GridLayout();
        groupGridLayout.makeColumnsEqualWidth = true;
        groupGridLayout.numColumns = 3;
        Group group = this.createProfileSelectionGroup(container, (Layout)groupGridLayout);
        this.setupCheckboxTableViewer((Composite)group);
        this.createSelectAllButton((Composite)group, new GridData(64));
        new Label((Composite)group, 0);
        this.createDeselectAllButton((Composite)group, new GridData(64));
        this.createVerticalSpacingLabel(container);
        GridData gridData = new GridData();
        gridData.horizontalIndent = 5;
        this.createFilePathLabel(container, gridData);
        gridData = new GridData(768);
        gridData.widthHint = 243;
        this.setupFilePathText(container, gridData);
        this.createFilePathBrowseButton(container, new GridData(64));
        this.setupEncryptContentCheckbox(container);
        this.setupHelp((Control)this.getShell());
        return container;
    }

    protected Composite createParentDialogArea(Composite parent) {
        return (Composite)super.createDialogArea(parent);
    }

    protected Group createProfileSelectionGroup(Composite parent, Layout layout) {
        Group group = new Group(parent, 0);
        group.setText(ConnectivityUIPlugin.getDefault().getResourceString("ExportProfilesDialog.group.text"));
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        group.setLayoutData((Object)gridData);
        group.setLayout(layout);
        return group;
    }

    protected CheckboxTableViewer setupCheckboxTableViewer(Composite parent) {
        CheckboxTableViewer checkboxTableViewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)2816);
        checkboxTableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        checkboxTableViewer.setContentProvider((IContentProvider)new ContentProvider());
        Table table = checkboxTableViewer.getTable();
        GridData gridData_1 = new GridData(1808);
        gridData_1.horizontalSpan = 3;
        gridData_1.widthHint = 392;
        table.setLayoutData((Object)gridData_1);
        checkboxTableViewer.setInput(new Object());
        checkboxTableViewer.setSorter((ViewerSorter)new ProfileSorter());
        this.tvViewer = checkboxTableViewer;
        this.tvViewer.refresh();
        return this.tvViewer;
    }

    protected Button createSelectAllButton(Composite parent, Object layoutData) {
        Button button = new Button(parent, 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportProfilesDialog.this.tvViewer.setAllChecked(true);
            }
        });
        button.setLayoutData(layoutData);
        button.setText(ConnectivityUIPlugin.getDefault().getResourceString("ExportProfilesDialog.button.text"));
        return button;
    }

    protected Button createDeselectAllButton(Composite parent, Object layoutData) {
        Button button = new Button(parent, 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportProfilesDialog.this.tvViewer.setAllChecked(false);
            }
        });
        button.setLayoutData(layoutData);
        button.setText(ConnectivityUIPlugin.getDefault().getResourceString("ExportProfilesDialog.button.text1"));
        return button;
    }

    protected Label createVerticalSpacingLabel(Composite parent) {
        Label label = new Label(parent, 0);
        GridData gridData = new GridData(256);
        gridData.horizontalSpan = 3;
        gridData.widthHint = 495;
        label.setLayoutData((Object)gridData);
        return label;
    }

    protected Label createFilePathLabel(Composite parent, Object layoutData) {
        Label label = new Label(parent, 0);
        label.setLayoutData(layoutData);
        label.setText(ConnectivityUIPlugin.getDefault().getResourceString("ExportProfilesDialog.label.text"));
        return label;
    }

    protected Text setupFilePathText(Composite parent, Object layoutData) {
        Text text = new Text(parent, 2048);
        text.setLayoutData(layoutData);
        this.txtFile = text;
        return this.txtFile;
    }

    protected Button createFilePathBrowseButton(Composite parent, Object layoutData) {
        Button button = new Button(parent, 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String filePath = new FileDialog(ExportProfilesDialog.this.getShell()).open();
                if (filePath != null) {
                    ExportProfilesDialog.this.txtFile.setText(filePath);
                }
            }
        });
        button.setLayoutData(layoutData);
        button.setText(ConnectivityUIPlugin.getDefault().getResourceString("ExportProfilesDialog.button.text2"));
        return button;
    }

    protected Button setupEncryptContentCheckbox(Composite parent) {
        Button button = new Button(parent, 32);
        GridData gridData = new GridData(512);
        gridData.horizontalIndent = 10;
        gridData.horizontalSpan = 3;
        button.setLayoutData((Object)gridData);
        button.setText(ConnectivityUIPlugin.getDefault().getResourceString("ExportProfilesDialog.btnEncryption.text"));
        button.setSelection(true);
        this.btnEncryption = button;
        return this.btnEncryption;
    }

    protected void setupHelp(Control control) {
        control.setData(HelpUtil.CONTEXT_PROVIDER_KEY, (Object)this);
        String contextId = HelpUtil.getContextId((String)"CONTEXT_ID_EXPORT_PROFILES_DIALOG", (String)ConnectivityUIPlugin.getDefault().getBundle().getSymbolicName());
        HelpUtil.setHelp((Control)control, (String)contextId);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(ConnectivityUIPlugin.getDefault().getResourceString("ExportProfilesDialog.null.title"));
    }

    public IConnectionProfile[] getSelectedProfiles() {
        return this.mProfiles;
    }

    public File getFile() {
        return this.mFile;
    }

    public boolean needEncryption() {
        return this.mNeedEncryption;
    }

    protected void okPressed() {
        Vector<Object> vec = new Vector<Object>();
        Object[] elements = this.tvViewer.getCheckedElements();
        if (elements.length == 0) {
            MessageDialog.openError((Shell)this.getShell(), (String)ConnectivityUIPlugin.getDefault().getResourceString("dialog.title.error"), (String)ConnectivityUIPlugin.getDefault().getResourceString("actions.export.noselection"));
            return;
        }
        if (this.txtFile.getText().length() == 0) {
            MessageDialog.openError((Shell)this.getShell(), (String)ConnectivityUIPlugin.getDefault().getResourceString("dialog.title.error"), (String)ConnectivityUIPlugin.getDefault().getResourceString("actions.export.nofile"));
            return;
        }
        int i = 0;
        while (i < elements.length) {
            vec.add(elements[i]);
            ++i;
        }
        this.mProfiles = vec.toArray(new IConnectionProfile[0]);
        this.mFile = new File(this.txtFile.getText());
        String fileParent = this.mFile.getParent();
        boolean hasParent = fileParent != null && this.mFile.getParent().length() != 0;
        boolean pathEndsInFileSeparator = false;
        boolean hasValidParent = false;
        if (hasParent) {
            File parentFile = new File(fileParent);
            hasValidParent = parentFile.exists();
            pathEndsInFileSeparator = parentFile.isDirectory();
        }
        if (!(hasParent && hasValidParent && pathEndsInFileSeparator)) {
            MessageDialog.openError((Shell)this.getShell(), (String)ConnectivityUIPlugin.getDefault().getResourceString("dialog.title.error"), (String)ConnectivityUIPlugin.getDefault().getResourceString("actions.export.notvalidfile"));
            return;
        }
        this.mNeedEncryption = this.btnEncryption.getSelection();
        super.okPressed();
    }

    public IContext getContext(Object target) {
        return this.contextProviderDelegate.getContext(target);
    }

    public int getContextChangeMask() {
        return this.contextProviderDelegate.getContextChangeMask();
    }

    public String getSearchExpression(Object target) {
        return this.contextProviderDelegate.getSearchExpression(target);
    }

    class ContentProvider
    implements IStructuredContentProvider {
        ContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ProfileManager.getInstance().getProfiles();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class ProfileSorter
    extends ViewerSorter {
        private ProfileSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof IConnectionProfile && e2 instanceof IConnectionProfile) {
                return ((IConnectionProfile)e1).getName().compareToIgnoreCase(((IConnectionProfile)e2).getName());
            }
            return super.compare(viewer, e1, e2);
        }
    }

    class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TableLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            IConnectionProfile profile = (IConnectionProfile)element;
            return profile.getName();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            IConnectionProfile profile = (IConnectionProfile)element;
            return ProfileImageRegistry.getInstance().getProfileImage(profile.getProvider());
        }
    }
}

