/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ase.catalog;

import java.lang.ref.SoftReference;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.datatools.connectivity.sqm.core.definition.DataModelElementFactory;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCTableColumnLoader;
import org.eclipse.datatools.enablement.ase.ISybaseASECatalogTable;
import org.eclipse.datatools.enablement.ase.JDBCASEPlugin;
import org.eclipse.datatools.enablement.ase.catalog.ASETableColumnLoader;
import org.eclipse.datatools.enablement.ase.catalog.ASEUtil;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalog;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalogCheckConstraint;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalogColumn;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalogForeignKey;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalogIndex;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalogPrimaryKey;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalogSchema;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalogTrigger;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalogUniqueConstraint;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalogUtils;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.CacheInfo;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.CacheStrategyType;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.LockPromotionInfo;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.LockingSchemaType;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASEBaseTable;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASECache;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASEColumn;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASEColumnCheckConstraint;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASEDatabase;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASEPrimaryKey;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASESegment;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASEUniqueConstraint;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseasesqlmodelPackage;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.impl.SybaseasesqlmodelFactoryImpl;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.partition.ListRangePartitionItem;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.partition.PartitionPackage;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.partition.PartitionSegmentPair;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.partition.SybaseASEHashPartition;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.partition.SybaseASEListPartition;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.partition.SybaseASEPartition;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.partition.SybaseASERangePartition;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.partition.SybaseASERoundrobinPartition;
import org.eclipse.datatools.enablement.sybase.models.sybasesqlmodel.SybaseAuthorizedObject;
import org.eclipse.datatools.modelbase.sql.constraints.PrimaryKey;
import org.eclipse.datatools.modelbase.sql.schema.Catalog;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.emf.common.util.EList;

public class SybaseASEBaseTableLoader {
    protected SybaseASEBaseTable _masterObj;
    private Boolean columnsLoaded = Boolean.FALSE;
    private SoftReference columnLoaderRef;
    private Boolean indexesLoaded = Boolean.FALSE;
    private Boolean constraintsLoaded = Boolean.FALSE;
    private Boolean textImageSegmentLoaded = Boolean.FALSE;
    private Boolean triggerLoaded = Boolean.FALSE;
    protected Boolean tableInfoLoaded = Boolean.FALSE;
    private Boolean lockPromotionLoaded = Boolean.FALSE;
    private Boolean partitionInfoLoaded = Boolean.FALSE;
    private Boolean cacheInfoLoaded = Boolean.FALSE;
    private Boolean proxyTableInfoLoaded = Boolean.FALSE;
    private Boolean tableTypeIdStatusLoaded = Boolean.FALSE;
    private Boolean privilegesLoaded = Boolean.FALSE;
    private int tableId;
    private int status = -1;
    private List tableCheckConstraintList = new ArrayList();
    private List uniqueConstraintList = new ArrayList();
    private List foreignKeyList = new ArrayList();
    private PrimaryKey pk = null;
    public static final int DEFAULT_CONCURRENCY_THRESHOLD = 15;
    public static final String HASH = "hash";
    public static final String LIST = "list";
    public static final String RANGE = "range";
    public static final String ROUND_ROBIN = "roundrobin";

    public SybaseASEBaseTableLoader(SybaseASEBaseTable masterObj) {
        this._masterObj = masterObj;
    }

    public Connection getConnection() {
        Database db = this.getCatalogDatabase();
        if (db instanceof ICatalogObject) {
            return ((ICatalogObject)db).getConnection();
        }
        return null;
    }

    public Database getCatalogDatabase() {
        return this._masterObj.getSchema().getCatalog().getDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        if (this.isNeedRefresh()) {
            Boolean bl = this.columnsLoaded;
            synchronized (bl) {
                if (this.columnsLoaded.booleanValue()) {
                    this.columnsLoaded = Boolean.FALSE;
                }
            }
            bl = this.constraintsLoaded;
            synchronized (bl) {
                if (this.constraintsLoaded.booleanValue()) {
                    this.constraintsLoaded = Boolean.FALSE;
                }
            }
            bl = this.indexesLoaded;
            synchronized (bl) {
                if (this.indexesLoaded.booleanValue()) {
                    this.indexesLoaded = Boolean.FALSE;
                }
            }
            bl = this.triggerLoaded;
            synchronized (bl) {
                if (this.triggerLoaded.booleanValue()) {
                    this.triggerLoaded = Boolean.FALSE;
                }
            }
            bl = this.textImageSegmentLoaded;
            synchronized (bl) {
                if (this.textImageSegmentLoaded.booleanValue()) {
                    this.textImageSegmentLoaded = Boolean.FALSE;
                }
            }
            bl = this.tableInfoLoaded;
            synchronized (bl) {
                if (this.tableInfoLoaded.booleanValue()) {
                    this.tableInfoLoaded = Boolean.FALSE;
                }
            }
            bl = this.lockPromotionLoaded;
            synchronized (bl) {
                if (this.lockPromotionLoaded.booleanValue()) {
                    this.lockPromotionLoaded = Boolean.FALSE;
                }
            }
            bl = this.partitionInfoLoaded;
            synchronized (bl) {
                if (this.partitionInfoLoaded.booleanValue()) {
                    this.partitionInfoLoaded = Boolean.FALSE;
                }
            }
            bl = this.cacheInfoLoaded;
            synchronized (bl) {
                if (this.cacheInfoLoaded.booleanValue()) {
                    this.cacheInfoLoaded = Boolean.FALSE;
                }
            }
            bl = this.proxyTableInfoLoaded;
            synchronized (bl) {
                if (this.proxyTableInfoLoaded.booleanValue()) {
                    this.proxyTableInfoLoaded = Boolean.FALSE;
                }
            }
            bl = this.tableTypeIdStatusLoaded;
            synchronized (bl) {
                if (this.tableTypeIdStatusLoaded.booleanValue()) {
                    this.tableTypeIdStatusLoaded = Boolean.FALSE;
                }
            }
            bl = this.privilegesLoaded;
            synchronized (bl) {
                if (this.privilegesLoaded.booleanValue()) {
                    this.privilegesLoaded = Boolean.FALSE;
                }
            }
            if (this._masterObj instanceof ICatalogObject) {
                RefreshManager.getInstance().referesh((ICatalogObject)this._masterObj);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTableId() {
        Boolean bl = this.tableTypeIdStatusLoaded;
        synchronized (bl) {
            if (!this.tableTypeIdStatusLoaded.booleanValue()) {
                this.loadTableIdStat();
            }
        }
        return this.tableId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStatus() {
        Boolean bl = this.tableTypeIdStatusLoaded;
        synchronized (bl) {
            if (!this.tableTypeIdStatusLoaded.booleanValue()) {
                this.loadTableIdStat();
            }
        }
        return this.status;
    }

    private synchronized void loadTableIdStat() {
        boolean deliver;
        block6: {
            deliver = this._masterObj.eDeliver();
            this._masterObj.eSetDeliver(false);
            Connection conn = this.getConnection();
            PreparedStatement stmt = null;
            ResultSet rs = null;
            String oldCatalog = null;
            try {
                try {
                    oldCatalog = conn.getCatalog();
                    conn.setCatalog(this._masterObj.getSchema().getCatalog().getName());
                    stmt = conn.prepareStatement("SELECT o.id, o.type, o.sysstat2 FROM dbo.sysobjects AS o, dbo.sysusers AS u WHERE o.uid = u.uid AND u.name = ? AND o.name = ? AND (o.type = 'U' OR o.type = 'S')");
                    stmt.setString(1, this._masterObj.getSchema().getName());
                    stmt.setString(2, this._masterObj.getName());
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        int id = rs.getInt(1);
                        int status2 = rs.getInt(3);
                        this.tableId = id;
                        this.status = status2;
                    }
                }
                catch (SQLException e) {
                    JDBCASEPlugin.getDefault().log(e);
                    SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                throw throwable;
            }
            SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
        }
        this._masterObj.eSetDeliver(deliver);
        this.tableTypeIdStatusLoaded = Boolean.TRUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getColumns() {
        Boolean bl = this.columnsLoaded;
        synchronized (bl) {
            if (!this.columnsLoaded.booleanValue()) {
                this.loadColumns();
            }
        }
        return ((ISybaseASECatalogTable)this._masterObj).getColumnsSuper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getConstraints() {
        Boolean bl = this.constraintsLoaded;
        synchronized (bl) {
            if (!this.constraintsLoaded.booleanValue()) {
                this.loadConstraints();
            }
        }
        return ((ISybaseASECatalogTable)this._masterObj).getConstraintsSuper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getIndex() {
        Boolean bl = this.indexesLoaded;
        synchronized (bl) {
            if (!this.indexesLoaded.booleanValue()) {
                this.loadIndices();
            }
        }
        return ((ISybaseASECatalogTable)this._masterObj).getIndexSuper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SybaseASESegment getTextImageSegment() {
        Boolean bl = this.textImageSegmentLoaded;
        synchronized (bl) {
            if (!this.textImageSegmentLoaded.booleanValue()) {
                this.loadTextImageSegment();
            }
        }
        return ((ISybaseASECatalogTable)this._masterObj).getTextImageSegmentSuper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getTriggers() {
        Boolean bl = this.triggerLoaded;
        synchronized (bl) {
            if (!this.triggerLoaded.booleanValue()) {
                this.loadTriggers();
            }
        }
        return ((ISybaseASECatalogTable)this._masterObj).getTriggersSuper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockingSchemaType getLockSchema() {
        Boolean bl = this.tableInfoLoaded;
        synchronized (bl) {
            if (!this.tableInfoLoaded.booleanValue()) {
                this.loadTableInfo();
            }
        }
        return ((ISybaseASECatalogTable)this._masterObj).getLockSchemaSuper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFillFactor() {
        Boolean bl = this.tableInfoLoaded;
        synchronized (bl) {
            if (!this.tableInfoLoaded.booleanValue()) {
                this.loadTableInfo();
            }
        }
        return ((ISybaseASECatalogTable)this._masterObj).getFillFactorSuper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxRowPerPage() {
        Boolean bl = this.tableInfoLoaded;
        synchronized (bl) {
            if (!this.tableInfoLoaded.booleanValue()) {
                this.loadTableInfo();
            }
        }
        return ((ISybaseASECatalogTable)this._masterObj).getMaxRowPerPageSuper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getExpRowSize() {
        Boolean bl = this.tableInfoLoaded;
        synchronized (bl) {
            if (!this.tableInfoLoaded.booleanValue()) {
                this.loadTableInfo();
            }
        }
        return ((ISybaseASECatalogTable)this._masterObj).getExpRowSizeSuper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getReservePageGap() {
        Boolean bl = this.tableInfoLoaded;
        synchronized (bl) {
            if (!this.tableInfoLoaded.booleanValue()) {
                this.loadTableInfo();
            }
        }
        return ((ISybaseASECatalogTable)this._masterObj).getReservePageGapSuper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIdentityGap() {
        Boolean bl = this.tableInfoLoaded;
        synchronized (bl) {
            if (!this.tableInfoLoaded.booleanValue()) {
                this.loadTableInfo();
            }
        }
        return ((ISybaseASECatalogTable)this._masterObj).getIdentityGapSuper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SybaseASESegment getSegment() {
        Boolean bl = this.tableInfoLoaded;
        synchronized (bl) {
            if (!this.tableInfoLoaded.booleanValue()) {
                this.loadTableInfo();
            }
        }
        return ((ISybaseASECatalogTable)this._masterObj).getSegmentSuper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheInfo getTableOnlyCacheInfo() {
        Boolean bl = this.cacheInfoLoaded;
        synchronized (bl) {
            if (!this.cacheInfoLoaded.booleanValue()) {
                this.loadCacheInfo();
            }
        }
        return ((ISybaseASECatalogTable)this._masterObj).getTableOnlyCacheInfoSuper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheInfo getTextOnlyCacheInfo() {
        Boolean bl = this.cacheInfoLoaded;
        synchronized (bl) {
            if (!this.cacheInfoLoaded.booleanValue()) {
                this.loadCacheInfo();
            }
        }
        return ((ISybaseASECatalogTable)this._masterObj).getTextOnlyCacheInfoSuper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConcurrencyOptThreshold() {
        Boolean bl = this.tableInfoLoaded;
        synchronized (bl) {
            if (!this.tableInfoLoaded.booleanValue()) {
                this.loadTableInfo();
            }
        }
        return ((ISybaseASECatalogTable)this._masterObj).getConcurrencyOptThresholdSuper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPartitions() {
        if (this.getCatalogDatabase().getVersion().compareTo("15") >= 0) {
            return -1;
        }
        Boolean bl = this.tableInfoLoaded;
        synchronized (bl) {
            if (!this.tableInfoLoaded.booleanValue()) {
                this.loadTableInfo();
            }
        }
        return ((ISybaseASECatalogTable)this._masterObj).getPartitionsSuper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SybaseASEPartition getPartitionCondition() {
        if (this.getCatalogDatabase().getVersion().compareTo("15") < 0) {
            return null;
        }
        Boolean bl = this.tableInfoLoaded;
        synchronized (bl) {
            if (!this.tableInfoLoaded.booleanValue()) {
                this.loadPartitionInfo();
            }
        }
        return ((ISybaseASECatalogTable)this._masterObj).getPartitionConditionSuper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getLockPromotion() {
        Boolean bl = this.lockPromotionLoaded;
        synchronized (bl) {
            if (!this.lockPromotionLoaded.booleanValue()) {
                this.loadLockPromotion();
            }
        }
        return ((ISybaseASECatalogTable)this._masterObj).getLockPromotionSuper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getPrivileges() {
        Boolean bl = this.privilegesLoaded;
        synchronized (bl) {
            if (!this.privilegesLoaded.booleanValue()) {
                boolean deliver = this._masterObj.eDeliver();
                this._masterObj.eSetDeliver(false);
                this.loadPrivileges();
                this._masterObj.eSetDeliver(deliver);
                this.privilegesLoaded = Boolean.TRUE;
            }
        }
        return ((ISybaseASECatalogTable)this._masterObj).getPrivilegesSuper();
    }

    protected void loadPrivileges() {
        ((ISybaseASECatalogTable)this._masterObj).getPrivilegesSuper().clear();
        SybaseASECatalog catalog = (SybaseASECatalog)this._masterObj.getSchema().getCatalog();
        List privileges = SybaseASECatalogUtils.getPrivileges((SybaseAuthorizedObject)this._masterObj, catalog);
        ((ISybaseASECatalogTable)this._masterObj).getPrivilegesSuper().addAll((Collection)privileges);
    }

    private void loadLockPromotion() {
        boolean deliver;
        block7: {
            if (this.lockPromotionLoaded.booleanValue()) {
                return;
            }
            EList lpList = ((ISybaseASECatalogTable)this._masterObj).getLockPromotionSuper();
            lpList.clear();
            DataModelElementFactory factory = this.getDatabaseDefinition().getDataModelElementFactory();
            Connection conn = this.getConnection();
            deliver = this._masterObj.eDeliver();
            this._masterObj.eSetDeliver(false);
            PreparedStatement stmt = null;
            ResultSet rs = null;
            String oldCatalog = null;
            try {
                try {
                    oldCatalog = conn.getCatalog();
                    conn.setCatalog(this._masterObj.getSchema().getCatalog().getName());
                    stmt = conn.prepareStatement("select  lwm = object_info1, hwm = object_info2, pct = object_info3, attribute from sysattributes where class = 5 and  object_type = 'T' and  object = ?");
                    stmt.setInt(1, this.getTableId());
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        int iLWM = rs.getInt(1);
                        int iHWM = rs.getInt(2);
                        int iPCT = rs.getInt(3);
                        int iAtt = rs.getInt(4);
                        LockPromotionInfo lpInfo = (LockPromotionInfo)factory.create(SybaseasesqlmodelPackage.eINSTANCE.getLockPromotionInfo());
                        lpInfo.setRowLockPromotion(iAtt == 1);
                        lpInfo.setLWM(iLWM);
                        lpInfo.setHWM(iHWM);
                        lpInfo.setPCT(iPCT);
                        lpList.add((Object)lpInfo);
                    }
                }
                catch (SQLException e) {
                    JDBCASEPlugin.getDefault().log(e);
                    SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                throw throwable;
            }
            SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
        }
        this.lockPromotionLoaded = Boolean.TRUE;
        this._masterObj.eSetDeliver(deliver);
    }

    private void loadPartitionInfo() {
        List partitionValueList;
        List partitionSegmentPairs;
        String[] partitionCols;
        String partitionStrategy;
        SybaseASEPartition partition;
        DataModelElementFactory factory;
        boolean deliver;
        Connection conn;
        block18: {
            if (this.partitionInfoLoaded.booleanValue()) {
                return;
            }
            conn = this.getConnection();
            deliver = this._masterObj.eDeliver();
            this._masterObj.eSetDeliver(false);
            factory = this.getDatabaseDefinition().getDataModelElementFactory();
            partition = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            partitionStrategy = "";
            partitionCols = new String[]{};
            partitionSegmentPairs = null;
            partitionValueList = null;
            String oldCatalog = null;
            try {
                try {
                    oldCatalog = conn.getCatalog();
                    conn.setCatalog(this._masterObj.getSchema().getCatalog().getName());
                    stmt = conn.prepareStatement("select number = (select count(*) from syspartitions p  where p.id = o.id and p.indid < 2 ), partition_type = isnull((select v.name from master.dbo.spt_values v where v.type = 'PN' and v.number = i.partitiontype), 'roundrobin') from .sysobjects o, sysindexes i where  o.id = ? and i.id = o.id and i.indid <2");
                    stmt.setInt(1, this.getTableId());
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        partitionStrategy = rs.getString(2);
                        rs.getInt(1);
                    }
                }
                catch (SQLException e) {
                    JDBCASEPlugin.getDefault().log(e);
                    SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                    break block18;
                }
            }
            catch (Throwable throwable) {
                SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                throw throwable;
            }
            SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
        }
        if (!partitionStrategy.equals(ROUND_ROBIN)) {
            partitionCols = this.loadPartitionColumn(conn);
        }
        if (partitionStrategy.equals(HASH) || partitionStrategy.equals(ROUND_ROBIN)) {
            partitionSegmentPairs = this.getPartitionSegmentPairs(partitionStrategy, conn);
        } else {
            partitionValueList = this.getPartitionValueList(conn);
        }
        if (partitionStrategy.equals(ROUND_ROBIN)) {
            partition = (SybaseASEPartition)factory.create(PartitionPackage.eINSTANCE.getSybaseASERoundrobinPartition());
            ((SybaseASERoundrobinPartition)partition).getPartitionSegmentPairs().addAll((Collection)partitionSegmentPairs);
        } else if (partitionStrategy.equals(HASH)) {
            partition = (SybaseASEPartition)factory.create(PartitionPackage.eINSTANCE.getSybaseASEHashPartition());
            int i = 0;
            while (i < partitionCols.length) {
                Column col = (Column)ASEUtil.getSQLObject((Collection)this.getColumns(), partitionCols[i]);
                ((SybaseASEHashPartition)partition).getColumns().add((Object)col);
                ++i;
            }
            ((SybaseASEHashPartition)partition).getPartitionSegmentPairs().addAll((Collection)partitionSegmentPairs);
        } else if (partitionStrategy.equals(LIST)) {
            partition = (SybaseASEPartition)factory.create(PartitionPackage.eINSTANCE.getSybaseASEListPartition());
            ((SybaseASEListPartition)partition).setColumn((SybaseASEColumn)ASEUtil.getSQLObject((Collection)this.getColumns(), partitionCols[0]));
            ((SybaseASEListPartition)partition).getListPartitionItems().addAll((Collection)partitionValueList);
        } else {
            partition = (SybaseASEPartition)factory.create(PartitionPackage.eINSTANCE.getSybaseASERangePartition());
            int i = 0;
            while (i < partitionCols.length) {
                Column col = (Column)ASEUtil.getSQLObject((Collection)this.getColumns(), partitionCols[i]);
                ((SybaseASERangePartition)partition).getColumns().add((Object)col);
                ++i;
            }
            ((SybaseASERangePartition)partition).getRangePartitionItems().addAll((Collection)partitionValueList);
        }
        this._masterObj.setPartitionCondition(partition);
        this.partitionInfoLoaded = Boolean.TRUE;
        this._masterObj.eSetDeliver(deliver);
    }

    private String[] loadPartitionColumn(Connection conn) {
        ArrayList<String> colnameList;
        block6: {
            PreparedStatement stmt = null;
            ResultSet rs = null;
            colnameList = new ArrayList<String>();
            String oldCatalog = null;
            try {
                try {
                    oldCatalog = conn.getCatalog();
                    conn.setCatalog(this._masterObj.getSchema().getCatalog().getName());
                    stmt = conn.prepareStatement("select column_name = c.name, column_type = isnull(x.xtname, isnull(get_xtypename(c.xtype,c.xdbid), t.name)) from syscolumns c, sysxtypes x, systypes t where id = ? and c.xtype *= x.xtid and c.usertype *= t.usertype and colid in (select colid from syspartitionkeys where id = ? )");
                    stmt.setInt(1, this.getTableId());
                    stmt.setInt(2, this.getTableId());
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        colnameList.add(rs.getString(1));
                    }
                }
                catch (SQLException e) {
                    JDBCASEPlugin.getDefault().log(e);
                    SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                throw throwable;
            }
            SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
        }
        return colnameList.toArray(new String[colnameList.size()]);
    }

    private List getPartitionSegmentPairs(String partitionStrategy, Connection conn) {
        ArrayList<PartitionSegmentPair> results;
        block6: {
            DataModelElementFactory factory = this.getDatabaseDefinition().getDataModelElementFactory();
            results = new ArrayList<PartitionSegmentPair>();
            PreparedStatement stmt = null;
            ResultSet rs = null;
            String oldCatalog = null;
            try {
                try {
                    oldCatalog = conn.getCatalog();
                    conn.setCatalog(this._masterObj.getSchema().getCatalog().getName());
                    stmt = partitionStrategy.equals(HASH) ? conn.prepareStatement("select partition_name = case when p.indid = 1 then p.cdataptnname else p.name end, segment = s.name, partition_id = isnull(p.partitionid,0), condition_id = i.conditionid, status = isnull(p.status,0) from syspartitions p, sysindexes i, syssegments s where i.id = p.id and i.id = ? and p.indid < 2 and i.indid = 0 and s.segment = p.segment  and i.conditionid is not null and p.name like '%' order by p.partitionid") : conn.prepareStatement("select partition_name = case when p.indid = 1 then p.cdataptnname else p.name end, segment = s.name, partition_id = isnull(p.partitionid,0), condition_id = i.conditionid, status = isnull(p.status,0) from syspartitions p, sysindexes i, syssegments s where i.id = p.id and i.id = ? and p.indid < 2 and i.indid < 2 and s.segment = p.segment  and i.conditionid is not null and p.name like '%' order by p.partitionid");
                    stmt.setInt(1, this.getTableId());
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        String partitionName = rs.getString(1);
                        String segmentName = rs.getString(2);
                        PartitionSegmentPair psp = (PartitionSegmentPair)factory.create(PartitionPackage.eINSTANCE.getPartitionSegmentPair());
                        psp.setPartitionName(partitionName);
                        psp.setSegment(this.getSegment(segmentName));
                        results.add(psp);
                    }
                }
                catch (SQLException e) {
                    JDBCASEPlugin.getDefault().log(e);
                    SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                throw throwable;
            }
            SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
        }
        return results;
    }

    private List getPartitionValueList(Connection conn) {
        ArrayList<ListRangePartitionItem> results;
        block6: {
            DataModelElementFactory factory = this.getDatabaseDefinition().getDataModelElementFactory();
            results = new ArrayList<ListRangePartitionItem>();
            PreparedStatement stmt = null;
            ResultSet rs = null;
            String oldCatalog = null;
            try {
                try {
                    oldCatalog = conn.getCatalog();
                    conn.setCatalog(this._masterObj.getSchema().getCatalog().getName());
                    stmt = conn.prepareStatement("select partition_name = case when p.indid = 1 then p.cdataptnname else p.name end, segment = s.name, condition = c.text, status = isnull(p.status,0) from syspartitions p, sysindexes i, syssegments s, syscomments c where c.partitionid = p.partitionid and c.id = i.conditionid and i.id = p.id and i.id = ? and p.indid < 2 and i.indid = 0 and s.segment = p.segment  and i.conditionid is not null and p.name like '%' order by p.partitionid");
                    stmt.setInt(1, this.getTableId());
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        String partitionName = rs.getString(1);
                        String segmentName = rs.getString(2);
                        String condition = rs.getString(3);
                        ListRangePartitionItem lrpi = (ListRangePartitionItem)factory.create(PartitionPackage.eINSTANCE.getListRangePartitionItem());
                        lrpi.setPartitionName(partitionName);
                        lrpi.setSegment(this.getSegment(segmentName));
                        lrpi.getValues().addAll(this.getConditionValues(condition));
                        results.add(lrpi);
                    }
                }
                catch (SQLException e) {
                    JDBCASEPlugin.getDefault().log(e);
                    SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                throw throwable;
            }
            SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
        }
        return results;
    }

    private Collection getConditionValues(String condition) {
        ArrayList<String> values = new ArrayList<String>();
        String strValues = condition.substring(condition.indexOf(40) + 1, condition.lastIndexOf(41));
        StringTokenizer st = new StringTokenizer(strValues, ",");
        while (st.hasMoreTokens()) {
            String strVal = ((String)st.nextElement()).trim();
            values.add(strVal);
        }
        return values;
    }

    private void loadColumns() {
        try {
            boolean deliver = this._masterObj.eDeliver();
            this._masterObj.eSetDeliver(false);
            EList columns = ((ISybaseASECatalogTable)this._masterObj).getColumnsSuper();
            ArrayList existingCols = new ArrayList(columns);
            this.getColumnLoader().clearColumns((List)columns);
            ((ASETableColumnLoader)this.getColumnLoader()).loadColumns((List)columns, existingCols);
            this._masterObj.eSetDeliver(deliver);
            this.columnsLoaded = Boolean.TRUE;
        }
        catch (Exception e) {
            JDBCASEPlugin.getDefault().log(e);
        }
    }

    protected final JDBCTableColumnLoader getColumnLoader() {
        if (this.columnLoaderRef == null || this.columnLoaderRef.get() == null) {
            this.columnLoaderRef = new SoftReference<JDBCTableColumnLoader>(this.createColumnLoader());
        }
        return (JDBCTableColumnLoader)this.columnLoaderRef.get();
    }

    protected JDBCTableColumnLoader createColumnLoader() {
        return new ASETableColumnLoader((ICatalogObject)this._masterObj);
    }

    private void loadConstraints() {
        if (this.constraintsLoaded.booleanValue()) {
            return;
        }
        EList constraintList = ((ISybaseASECatalogTable)this._masterObj).getConstraintsSuper();
        Connection connection = this.getConnection();
        boolean deliver = this._masterObj.eDeliver();
        this._masterObj.eSetDeliver(false);
        constraintList.clear();
        this.loadForeignKey(constraintList, connection);
        this.loadUniqueConstraintAndPriamryKey(constraintList, connection);
        this.loadTableCheckConstraint(constraintList, connection);
        this.loadColumnCheckConstraint(constraintList);
        this.constraintsLoaded = Boolean.TRUE;
        this._masterObj.eSetDeliver(deliver);
    }

    private void loadColumnCheckConstraint(EList constraintList) {
        EList colList = this._masterObj.getColumns();
        int i = 0;
        while (i < colList.size()) {
            SybaseASECatalogColumn col = (SybaseASECatalogColumn)((Object)colList.get(i));
            SybaseASEColumnCheckConstraint inlineRule = col.getColumnCheck();
            if (inlineRule != null) {
                constraintList.add((Object)inlineRule);
            }
            ++i;
        }
    }

    private void loadForeignKey(EList constraintList, Connection conn) {
        block8: {
            ArrayList<SybaseASECatalogForeignKey> tempList = new ArrayList<SybaseASECatalogForeignKey>();
            PreparedStatement stmt = null;
            ResultSet rs = null;
            String oldCatalog = null;
            try {
                try {
                    oldCatalog = conn.getCatalog();
                    conn.setCatalog(this._masterObj.getSchema().getCatalog().getName());
                    stmt = conn.prepareStatement("SELECT CONSTRAINT_NAME =object_name(constrid,frgndbid) FROM sysreferences WHERE tableid=?  order by 1");
                    stmt.setInt(1, this.getTableId());
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        String constrName = rs.getString(1);
                        SybaseASECatalogForeignKey fk = (SybaseASECatalogForeignKey)ASEUtil.getSQLObject(this.foreignKeyList, constrName);
                        if (fk != null) {
                            constraintList.add((Object)fk);
                            fk.refresh();
                        } else {
                            fk = new SybaseASECatalogForeignKey();
                            fk.setName(constrName);
                            constraintList.add((Object)fk);
                        }
                        tempList.add(fk);
                    }
                    this.foreignKeyList = tempList;
                }
                catch (Exception e) {
                    JDBCASEPlugin.getDefault().log(e);
                    SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                throw throwable;
            }
            SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
        }
    }

    private void loadUniqueConstraintAndPriamryKey(EList constraintList, Connection conn) {
        block14: {
            ArrayList<SybaseASEUniqueConstraint> tempList = new ArrayList<SybaseASEUniqueConstraint>();
            PreparedStatement stmt = null;
            ResultSet rs = null;
            String oldCatalog = null;
            try {
                try {
                    oldCatalog = conn.getCatalog();
                    conn.setCatalog(this._masterObj.getSchema().getCatalog().getName());
                    stmt = conn.prepareStatement("SELECT COLUMNS_COUNT = i.keycnt, i.name , INDEX_ID = i.indid, STATUS = i.status, STATUS2 = i.status2, FILL_FACTOR = isnull(i.fill_factor,0), MAXROWSPERPAGE = isnull(i.maxrowsperpage,0), RES_PAGE_GAP = isnull(i.res_page_gap,0), SEGMENT_NAME = s.name FROM sysindexes i, syssegments s WHERE i.segment = s.segment AND i.id = ? AND i.indid > 0 AND i.status2 & 2 = 2");
                    stmt.setInt(1, this.getTableId());
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        String name = rs.getString(2);
                        int status = rs.getInt(4);
                        int status2 = rs.getInt(5);
                        boolean systemGenedName = false;
                        if ((status2 & 8) == 8) {
                            systemGenedName = true;
                        }
                        Object uniqConstr = null;
                        SybaseASECatalogPrimaryKey primarykey = null;
                        if ((status & 0x800) == 2048) {
                            if (this.pk != null && this.pk.getName().equals(name)) {
                                primarykey = (SybaseASEPrimaryKey)this.pk;
                                constraintList.add((Object)primarykey);
                                ((ICatalogObject)primarykey).refresh();
                                uniqConstr = primarykey.getAseUniqueConstraint();
                            } else {
                                primarykey = new SybaseASECatalogPrimaryKey();
                                primarykey.setName(name);
                                uniqConstr = SybaseasesqlmodelFactoryImpl.init().createSybaseASEUniqueConstraint();
                                primarykey.setAseUniqueConstraint((SybaseASEUniqueConstraint)uniqConstr);
                                uniqConstr.setName(name);
                            }
                        } else {
                            uniqConstr = (SybaseASEUniqueConstraint)ASEUtil.getSQLObject(this.uniqueConstraintList, name);
                            if (uniqConstr != null) {
                                constraintList.add(uniqConstr);
                                ((ICatalogObject)uniqConstr).refresh();
                            } else {
                                uniqConstr = new SybaseASECatalogUniqueConstraint();
                                uniqConstr.setName(name);
                            }
                        }
                        uniqConstr.setSystemGenedName(systemGenedName);
                        if (primarykey != null) {
                            this.pk = primarykey;
                            constraintList.add((Object)primarykey);
                            continue;
                        }
                        tempList.add((SybaseASEUniqueConstraint)uniqConstr);
                        constraintList.add(uniqConstr);
                    }
                    this.uniqueConstraintList = tempList;
                }
                catch (SQLException e) {
                    JDBCASEPlugin.getDefault().log(e);
                    SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                    break block14;
                }
            }
            catch (Throwable throwable) {
                SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                throw throwable;
            }
            SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
        }
    }

    private void loadTableCheckConstraint(EList constraintList, Connection conn) {
        block8: {
            ArrayList<SybaseASECatalogCheckConstraint> tempList = new ArrayList<SybaseASECatalogCheckConstraint>();
            PreparedStatement stmt = null;
            ResultSet rs = null;
            String oldCatalog = null;
            try {
                try {
                    oldCatalog = conn.getCatalog();
                    conn.setCatalog(this._masterObj.getSchema().getCatalog().getName());
                    stmt = conn.prepareStatement("SELECT o.name,u.name FROM sysconstraints a, sysobjects o, sysusers u WHERE a.tableid = ? AND u.uid=o.uid AND  a.status & 128 = 128 AND a.constrid not in (select domain from syscolumns where id = ?)AND o.id = a.constrid ORDER BY a.constrid");
                    stmt.setInt(1, this.getTableId());
                    stmt.setInt(2, this.getTableId());
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        String checkName = rs.getString(1);
                        SybaseASECatalogCheckConstraint check = (SybaseASECatalogCheckConstraint)ASEUtil.getSQLObject(this.tableCheckConstraintList, checkName);
                        if (check != null) {
                            constraintList.add((Object)check);
                            check.refresh();
                        } else {
                            check = new SybaseASECatalogCheckConstraint();
                            check.setName(checkName);
                            constraintList.add((Object)check);
                        }
                        tempList.add(check);
                    }
                    this.tableCheckConstraintList = tempList;
                }
                catch (Exception e) {
                    JDBCASEPlugin.getDefault().log(e);
                    SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                throw throwable;
            }
            SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
        }
    }

    private void loadIndices() {
        boolean deliver;
        block9: {
            if (this.indexesLoaded.booleanValue()) {
                return;
            }
            deliver = this._masterObj.eDeliver();
            this._masterObj.eSetDeliver(false);
            EList indexList = ((ISybaseASECatalogTable)this._masterObj).getIndexSuper();
            ArrayList existingIndices = new ArrayList(indexList);
            indexList.clear();
            String catalogName = ((SybaseASECatalogSchema)this._masterObj.getSchema()).getCatalog().getName();
            Connection conn = this.getConnection();
            PreparedStatement stmt = null;
            ResultSet rs = null;
            String oldCatalog = null;
            try {
                try {
                    oldCatalog = conn.getCatalog();
                    conn.setCatalog(catalogName);
                    stmt = conn.prepareStatement("SELECT I.name, I.status2 FROM sysindexes I WHERE I.id = ? AND I.indid BETWEEN 1 AND 254 AND ((I.status & 16 = 16 OR I.status2 & 512 = 512) OR (I.status & 16 = 0 AND I.status2 & 512 = 0))  order by 1");
                    stmt.setInt(1, this.getTableId());
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        String indexName = rs.getString(1);
                        boolean isSysGen = (rs.getInt(2) & 2) == 2;
                        SQLObject element = ASEUtil.getSQLObject(existingIndices, indexName);
                        SybaseASECatalogIndex index = null;
                        if (element != null) {
                            index = (SybaseASECatalogIndex)element;
                            indexList.add((Object)index);
                            ((SybaseASECatalogSchema)this._masterObj.getSchema()).getSuperIndices().add((Object)index);
                            ((ICatalogObject)element).refresh();
                        } else {
                            index = new SybaseASECatalogIndex();
                            index.setName(indexName);
                            indexList.add((Object)index);
                            ((SybaseASECatalogSchema)this._masterObj.getSchema()).getSuperIndices().add((Object)index);
                        }
                        index.setSystemGenerated(isSysGen);
                    }
                }
                catch (Exception e) {
                    JDBCASEPlugin.getDefault().log(e);
                    SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                throw throwable;
            }
            SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
        }
        this.indexesLoaded = Boolean.TRUE;
        this._masterObj.eSetDeliver(deliver);
    }

    private void loadTextImageSegment() {
        boolean deliver;
        block7: {
            if (this.textImageSegmentLoaded.booleanValue()) {
                return;
            }
            deliver = this._masterObj.eDeliver();
            this._masterObj.eSetDeliver(false);
            PreparedStatement stmt = null;
            ResultSet rs = null;
            Connection conn = this.getConnection();
            String oldCatalog = null;
            try {
                try {
                    oldCatalog = conn.getCatalog();
                    conn.setCatalog(this._masterObj.getSchema().getCatalog().getName());
                    stmt = conn.prepareStatement("SELECT I.name,S.name FROM dbo.sysindexes I, dbo.syssegments S WHERE I.id = ? AND I.segment = S.segment AND I.indid=255");
                    stmt.setInt(1, this.getTableId());
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        String segmentName = rs.getString(2);
                        if (segmentName == null || segmentName.equals("")) continue;
                        SybaseASESegment s = this.getSegment(segmentName);
                        this._masterObj.setTextImageSegment(s);
                    }
                }
                catch (SQLException e) {
                    JDBCASEPlugin.getDefault().log(e);
                    SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                throw throwable;
            }
            SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
        }
        this._masterObj.eSetDeliver(deliver);
        this.textImageSegmentLoaded = Boolean.TRUE;
    }

    private void loadTriggers() {
        boolean deliver;
        block9: {
            if (this.triggerLoaded.booleanValue()) {
                return;
            }
            deliver = this._masterObj.eDeliver();
            this._masterObj.eSetDeliver(false);
            EList triggerList = ((ISybaseASECatalogTable)this._masterObj).getTriggersSuper();
            ArrayList existingTriggers = new ArrayList(triggerList);
            triggerList.clear();
            Connection conn = this.getConnection();
            PreparedStatement stmt = null;
            ResultSet rs = null;
            String oldCatalog = null;
            try {
                try {
                    oldCatalog = conn.getCatalog();
                    conn.setCatalog(this._masterObj.getSchema().getCatalog().getName());
                    stmt = conn.prepareStatement("SELECT o.name, U.name, o.sysstat2 AS TRIGGER_CREATOR FROM sysobjects o, sysusers U WHERE o.type='TR' and o.deltrig = ? AND o.uid = U.uid order by 1");
                    stmt.setInt(1, this.getTableId());
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        boolean enableTrigger;
                        String trigName = rs.getString(1);
                        String creatorName = rs.getString(2);
                        boolean bl = enableTrigger = rs.getInt(3) != 1;
                        if (trigName == null) continue;
                        SybaseASECatalogTrigger trigger = (SybaseASECatalogTrigger)ASEUtil.getSQLObject(existingTriggers, trigName);
                        Schema creator = (Schema)ASEUtil.getSQLObject((Collection)this._masterObj.getSchema().getCatalog().getSchemas(), creatorName);
                        if (trigger != null) {
                            triggerList.add((Object)trigger);
                            ((SybaseASECatalogSchema)creator).getSuperTriggers().add((Object)trigger);
                            trigger.refresh();
                        } else {
                            trigger = new SybaseASECatalogTrigger();
                            trigger.setName(trigName);
                            ((SybaseASECatalogSchema)creator).getSuperTriggers().add((Object)trigger);
                            triggerList.add((Object)trigger);
                        }
                        trigger.setEnabled(enableTrigger);
                    }
                }
                catch (Exception e) {
                    JDBCASEPlugin.getDefault().log(e);
                    SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                throw throwable;
            }
            SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
        }
        this.triggerLoaded = Boolean.TRUE;
        this._masterObj.eSetDeliver(deliver);
    }

    protected void loadTableInfo() {
        boolean deliver;
        block11: {
            if (this.tableInfoLoaded.booleanValue()) {
                return;
            }
            Connection conn = this.getConnection();
            deliver = this._masterObj.eDeliver();
            this._masterObj.eSetDeliver(false);
            PreparedStatement stmt = null;
            ResultSet rs = null;
            String oldCatalog = null;
            try {
                try {
                    oldCatalog = conn.getCatalog();
                    conn.setCatalog(this._masterObj.getSchema().getCatalog().getName());
                    stmt = this.getConnection().prepareStatement("SELECT o.sysstat2,s.name,isnull(i.maxrowsperpage,0),isnull(i.exp_rowsize,0),isnull(i.res_page_gap,0),isnull(i.identitygap,0),isnull(i.fill_factor,0),(SELECT count(*) FROM dbo.syspartitions p WHERE p.id=o.id),o.id FROM dbo.sysobjects o,dbo.sysusers u, dbo.sysindexes i, dbo.syssegments s WHERE u.uid=o.uid AND i.id = o.id AND s.segment = i.segment AND i.indid<2 AND (o.type='U' OR  o.type='S') AND u.name = ? AND o.name = ?");
                    stmt.setString(1, this._masterObj.getSchema().getName());
                    stmt.setString(2, this._masterObj.getName());
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        int status = rs.getInt(1);
                        String segmentName = rs.getString(2);
                        int maxRowPerPage = rs.getInt(3);
                        int expRowSize = rs.getInt(4);
                        int resPageGap = rs.getInt(5);
                        int identityGap = rs.getInt(6);
                        int fillFactor = rs.getInt(7);
                        int partitionNumb = rs.getInt(8);
                        boolean isAPL = false;
                        LockingSchemaType lockingType = null;
                        if ((status & 0x8000) == 32768) {
                            lockingType = LockingSchemaType.LOCKDATAROWS_LITERAL;
                            maxRowPerPage = 0;
                        } else if ((status & 0x4000) == 16384) {
                            lockingType = LockingSchemaType.LOCKDATAPAGES_LITERAL;
                            maxRowPerPage = 0;
                        } else {
                            lockingType = LockingSchemaType.LOCKALLPAGES_LITERAL;
                            isAPL = true;
                            expRowSize = 0;
                        }
                        this._masterObj.setMaxRowPerPage(maxRowPerPage);
                        this._masterObj.setExpRowSize(expRowSize);
                        this._masterObj.setReservePageGap(resPageGap);
                        this._masterObj.setIdentityGap(identityGap);
                        this._masterObj.setFillFactor(fillFactor);
                        this._masterObj.setSegment(this.getSegment(segmentName));
                        this._masterObj.setLockSchema(lockingType);
                        this._masterObj.setPartitions(partitionNumb);
                        if (isAPL) continue;
                        int concurrencyThreshold = this.getConcurrencyThreshold(conn);
                        this._masterObj.setConcurrencyOptThreshold(concurrencyThreshold);
                    }
                }
                catch (SQLException e) {
                    JDBCASEPlugin.getDefault().log(e);
                    SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                    break block11;
                }
            }
            catch (Throwable throwable) {
                SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                throw throwable;
            }
            SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
        }
        this.tableInfoLoaded = Boolean.TRUE;
        this._masterObj.eSetDeliver(deliver);
    }

    private int getConcurrencyThreshold(Connection conn) {
        int concThreshold;
        block6: {
            concThreshold = 15;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            String oldCatalog = null;
            try {
                try {
                    oldCatalog = conn.getCatalog();
                    conn.setCatalog(this._masterObj.getSchema().getCatalog().getName());
                    stmt = conn.prepareStatement("select conopt_thld from systabstats where id = ? and indid = 0");
                    stmt.setInt(1, this.getTableId());
                    rs = stmt.executeQuery();
                    if (rs.next()) {
                        concThreshold = rs.getInt(1);
                    }
                }
                catch (SQLException e) {
                    JDBCASEPlugin.getDefault().log(e);
                    SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                throw throwable;
            }
            SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
        }
        return concThreshold;
    }

    private void loadCacheInfo() {
        CacheInfo textOnlyCache;
        CacheInfo tableOnlyCache;
        boolean deliver;
        block18: {
            String oldCatalog;
            ResultSet rs;
            PreparedStatement stmt;
            Connection conn;
            DataModelElementFactory factory;
            block16: {
                if (this.cacheInfoLoaded.booleanValue()) {
                    return;
                }
                deliver = this._masterObj.eDeliver();
                this._masterObj.eSetDeliver(false);
                this._masterObj.setTableOnlyCacheInfo(null);
                this._masterObj.setTextOnlyCacheInfo(null);
                tableOnlyCache = null;
                textOnlyCache = null;
                factory = this.getDatabaseDefinition().getDataModelElementFactory();
                conn = this.getConnection();
                stmt = null;
                rs = null;
                oldCatalog = null;
                try {
                    try {
                        oldCatalog = conn.getCatalog();
                        conn.setCatalog(this._masterObj.getSchema().getCatalog().getName());
                        stmt = conn.prepareStatement("SELECT char_value,object_type FROM sysattributes WHERE class=3 AND attribute=0 AND object= ? AND object_info1 IN (null,255)");
                        stmt.setInt(1, this.getTableId());
                        rs = stmt.executeQuery();
                        while (rs.next()) {
                            String cacheName = rs.getString(1);
                            String cacheType = rs.getString(2);
                            boolean isTextOnly = cacheType.equals("T");
                            CacheInfo cacheInfo = (CacheInfo)factory.create(SybaseasesqlmodelPackage.eINSTANCE.getCacheInfo());
                            SybaseASECache cache = (SybaseASECache)ASEUtil.getSQLObject((Collection)((SybaseASEDatabase)this.getCatalogDatabase()).getCaches(), cacheName);
                            cacheInfo.setCache(cache);
                            if (isTextOnly) {
                                textOnlyCache = cacheInfo;
                                continue;
                            }
                            tableOnlyCache = cacheInfo;
                        }
                    }
                    catch (SQLException e) {
                        JDBCASEPlugin.getDefault().log(e);
                        SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                        break block16;
                    }
                }
                catch (Throwable throwable) {
                    SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                    throw throwable;
                }
                SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
            }
            try {
                try {
                    conn.setCatalog(this._masterObj.getSchema().getCatalog().getName());
                    stmt = conn.prepareStatement("select i.name, i.indid, i.status2 from sysindexes i where i.id = ?");
                    stmt.setInt(1, this.getTableId());
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        int idxId = rs.getInt(2);
                        int status2 = rs.getInt(3);
                        if (idxId == 0) {
                            if (tableOnlyCache == null) {
                                tableOnlyCache = (CacheInfo)factory.create(SybaseasesqlmodelPackage.eINSTANCE.getCacheInfo());
                            }
                            tableOnlyCache.setCacheStrategy(this.getTableCacheStrategy(status2));
                            continue;
                        }
                        if (textOnlyCache == null) {
                            textOnlyCache = (CacheInfo)factory.create(SybaseasesqlmodelPackage.eINSTANCE.getCacheInfo());
                        }
                        textOnlyCache.setCacheStrategy(this.getTableCacheStrategy(status2));
                    }
                }
                catch (SQLException e) {
                    JDBCASEPlugin.getDefault().log(e);
                    SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                    break block18;
                }
            }
            catch (Throwable throwable) {
                SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                throw throwable;
            }
            SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
        }
        this._masterObj.setTextOnlyCacheInfo(textOnlyCache);
        this._masterObj.setTableOnlyCacheInfo(tableOnlyCache);
        this.cacheInfoLoaded = Boolean.TRUE;
        this._masterObj.eSetDeliver(deliver);
    }

    private int getTableCacheStrategy(int status2) {
        boolean isPrefetchUnable = (status2 & 0x10) != 0;
        boolean isMRUUnable = (status2 & 0x20) != 0;
        int cacheStrategy = 0;
        if (!isPrefetchUnable) {
            cacheStrategy |= CacheStrategyType.PREFETCH_LITERAL.getValue();
        }
        if (!isMRUUnable) {
            cacheStrategy |= CacheStrategyType.MRU_LITERAL.getValue();
        }
        return cacheStrategy;
    }

    private DatabaseDefinition getDatabaseDefinition() {
        Database d = this._masterObj.getSchema().getCatalog().getDatabase();
        return RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(d);
    }

    private SybaseASESegment getSegment(String segmentName) {
        Catalog catalog = this._masterObj.getSchema().getCatalog();
        EList segmentList = ((SybaseASECatalog)catalog).getSegments();
        int i = 0;
        while (i < segmentList.size()) {
            SybaseASESegment segment = (SybaseASESegment)segmentList.get(i);
            if (segment.getName().equals(segmentName)) {
                return segment;
            }
            ++i;
        }
        return null;
    }

    public boolean isNeedRefresh() {
        return this.columnsLoaded != false || this.indexesLoaded != false || this.constraintsLoaded != false || this.textImageSegmentLoaded != false || this.triggerLoaded != false || this.tableInfoLoaded != false || this.lockPromotionLoaded != false || this.partitionInfoLoaded != false || this.cacheInfoLoaded != false || this.proxyTableInfoLoaded != false || this.tableTypeIdStatusLoaded != false || this.privilegesLoaded != false;
    }
}

