/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.internal.core.definition;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.sqm.core.SQMServices;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.definition.IDatabaseRecognizer;
import org.eclipse.datatools.connectivity.sqm.internal.core.util.GenericCatalogMessages;

public class ConfigElementDatabaseRecognizer
implements IDatabaseRecognizer,
IExecutableExtension {
    public static final String DB_DEFN_MAPPING = "dbDefinitionMapping";
    private List<DbDefinitionMapping> m_dbDefnMappings;

    public ConfigElementDatabaseRecognizer(IExtension dbRecognitionExtension) throws CoreException {
        this.init(dbRecognitionExtension);
    }

    public ConfigElementDatabaseRecognizer() {
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.init(config.getDeclaringExtension());
    }

    private void init(IExtension dbRecognitionExtension) throws CoreException {
        IConfigurationElement[] configElements = dbRecognitionExtension.getConfigurationElements();
        if (configElements.length == 0) {
            return;
        }
        this.m_dbDefnMappings = new ArrayList<DbDefinitionMapping>(configElements.length);
        int i = 0;
        while (i < configElements.length) {
            if (configElements[i].getName().equals(DB_DEFN_MAPPING)) {
                IConfigurationElement dbDefnMapElement = configElements[i];
                this.m_dbDefnMappings.add(new DbDefinitionMapping(dbDefnMapElement));
            }
            ++i;
        }
    }

    public boolean hasJdbcMappings() {
        return this.m_dbDefnMappings != null && !this.m_dbDefnMappings.isEmpty();
    }

    public DatabaseDefinition recognize(Connection connection) {
        if (connection == null || !this.hasJdbcMappings()) {
            return null;
        }
        String jdbcProduct = null;
        String jdbcVersion = null;
        try {
            jdbcProduct = connection.getMetaData().getDatabaseProductName();
            jdbcVersion = connection.getMetaData().getDatabaseProductVersion();
        }
        catch (SQLException sQLException) {
            return null;
        }
        if (jdbcVersion == null) {
            return null;
        }
        for (DbDefinitionMapping dbDefnMap : this.m_dbDefnMappings) {
            if (!dbDefnMap.matchesIgnoreCase(jdbcProduct, jdbcVersion) && !dbDefnMap.matchesPattern(jdbcProduct, jdbcVersion)) continue;
            return SQMServices.getDatabaseDefinitionRegistry().getDefinition(dbDefnMap.m_dbProduct, dbDefnMap.m_dbVersion);
        }
        return null;
    }

    private class DbDefinitionMapping {
        private static final String JDBC_PRODUCT_NAME = "jdbcDatabaseProductName";
        private static final String JDBC_PRODUCT_VERSION = "jdbcDatabaseProductVersion";
        private static final String DB_DEFINITION_PRODUCT = "dbdefinitionProduct";
        private static final String DB_DEFINITION_VERSION = "dbdefinitionVersion";
        private String m_jdbcProductName;
        private String m_jdbcProductVersion;
        private String m_dbProduct;
        private String m_dbVersion;

        private DbDefinitionMapping(IConfigurationElement dbDefnMapElement) throws CoreException {
            this.m_jdbcProductName = dbDefnMapElement.getAttribute(JDBC_PRODUCT_NAME);
            this.m_jdbcProductVersion = dbDefnMapElement.getAttribute(JDBC_PRODUCT_VERSION);
            this.m_dbProduct = dbDefnMapElement.getAttribute(DB_DEFINITION_PRODUCT);
            this.m_dbVersion = dbDefnMapElement.getAttribute(DB_DEFINITION_VERSION);
            if (this.m_jdbcProductVersion == null || this.m_dbProduct == null || this.m_dbVersion == null) {
                throw new CoreException((IStatus)new Status(4, dbDefnMapElement.getNamespaceIdentifier(), GenericCatalogMessages.bind((String)GenericCatalogMessages.DEFN_MISSING_ATTRIBUTE_VALUES, (Object)ConfigElementDatabaseRecognizer.DB_DEFN_MAPPING)));
            }
        }

        boolean matchesIgnoreCase(String jdbcDbProductName, String jdbcDbProductVersion) {
            if (!this.m_jdbcProductVersion.equalsIgnoreCase(jdbcDbProductVersion)) {
                return false;
            }
            if (this.m_jdbcProductName == null) {
                return true;
            }
            return this.m_jdbcProductName.equalsIgnoreCase(jdbcDbProductName);
        }

        boolean matchesPattern(String jdbcDbProductName, String jdbcDbProductVersion) {
            Matcher m;
            Pattern p;
            block5: {
                block4: {
                    try {
                        p = Pattern.compile(this.m_jdbcProductVersion);
                        m = p.matcher(jdbcDbProductVersion);
                        if (m.matches()) break block4;
                        return false;
                    }
                    catch (Exception exception) {
                        return false;
                    }
                }
                if (this.m_jdbcProductName != null) break block5;
                return true;
            }
            p = Pattern.compile(this.m_jdbcProductName);
            m = p.matcher(jdbcDbProductName);
            return m.matches();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DbDefinitionMapping)) {
                return false;
            }
            DbDefinitionMapping thatObj = (DbDefinitionMapping)obj;
            if (!this.matchesIgnoreCase(thatObj.m_jdbcProductName, thatObj.m_jdbcProductVersion)) {
                return false;
            }
            if (!this.m_dbProduct.equalsIgnoreCase(thatObj.m_dbProduct)) {
                return false;
            }
            return this.m_dbVersion.equalsIgnoreCase(thatObj.m_dbVersion);
        }
    }
}

