/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.search;

import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.ui.search.ElementQuerySpecification;
import org.eclipse.jdt.ui.search.IMatchPresentation;
import org.eclipse.jdt.ui.search.IQueryParticipant;
import org.eclipse.jdt.ui.search.ISearchRequestor;
import org.eclipse.jdt.ui.search.PatternQuerySpecification;
import org.eclipse.jdt.ui.search.QuerySpecification;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;

public class LaunchConfigurationQueryParticipant
implements IQueryParticipant {
    private UIParticipant uiParticipant;

    public int estimateTicks(QuerySpecification query) {
        if (this.isValid(query)) {
            return 50;
        }
        return 0;
    }

    public synchronized IMatchPresentation getUIParticipant() {
        if (this.uiParticipant == null) {
            this.uiParticipant = new UIParticipant();
        }
        return this.uiParticipant;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void search(ISearchRequestor requestor, QuerySpecification query, IProgressMonitor monitor) throws CoreException {
        if (!this.isValid(query)) {
            return;
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("", 11);
        try {
            Pattern pattern = null;
            if (query instanceof ElementQuerySpecification) {
                ElementQuerySpecification elementQuery = (ElementQuerySpecification)query;
                IJavaElement element = elementQuery.getElement();
                if (!(element instanceof IMember)) return;
                IMember member = (IMember)element;
                IType type = null;
                if (member.getElementType() == 7) {
                    type = (IType)member;
                } else if (member.getElementType() == 9 && ((IMethod)member).isMainMethod()) {
                    type = member.getDeclaringType();
                }
                if (type == null) return;
                pattern = Pattern.compile(this.quotePattern(type.getFullyQualifiedName('$')));
            }
            if (query instanceof PatternQuerySpecification) {
                PatternQuerySpecification patternQuery = (PatternQuerySpecification)query;
                int flags = patternQuery.isCaseSensitive() ? 0 : 2;
                String quotedPattern = this.quotePattern(patternQuery.getPattern());
                pattern = Pattern.compile(quotedPattern, flags);
            }
            if (monitor.isCanceled()) {
                return;
            }
            monitor.worked(1);
            this.searchLaunchConfigurations(query.getScope(), requestor, pattern, (IProgressMonitor)new SubProgressMonitor(monitor, 7));
            return;
        }
        finally {
            monitor.done();
        }
    }

    private String quotePattern(String pattern) {
        StringTokenizer t = new StringTokenizer(pattern, ".?*$()", true);
        StringBuilder buf = new StringBuilder();
        String token = null;
        while (t.hasMoreTokens()) {
            token = t.nextToken();
            switch (token.charAt(0)) {
                case '.': {
                    buf.append('\\');
                    break;
                }
                case '*': 
                case '?': {
                    buf.append('.');
                    break;
                }
                case '$': {
                    buf.append('\\');
                    break;
                }
                case '(': {
                    buf.append('\\');
                    break;
                }
                case ')': {
                    buf.append('\\');
                }
            }
            buf.append(token);
        }
        return buf.toString();
    }

    private boolean isValid(QuerySpecification query) {
        switch (query.getLimitTo()) {
            case 2: 
            case 3: {
                break;
            }
            default: {
                return false;
            }
        }
        if (query instanceof ElementQuerySpecification) {
            IJavaElement element = ((ElementQuerySpecification)query).getElement();
            return element.getElementType() == 7 || element.getElementType() == 9;
        }
        if (query instanceof PatternQuerySpecification) {
            PatternQuerySpecification patternQuery = (PatternQuerySpecification)query;
            switch (patternQuery.getSearchFor()) {
                case -1: 
                case 0: 
                case 5: 
                case 9: 
                case 10: {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean matches(IJavaSearchScope scope, ILaunchConfiguration config, Pattern pattern) throws CoreException {
        if (!(config.exists() && config.getType().isPublic() && DebugUIPlugin.doLaunchConfigurationFiltering((ILaunchConfiguration)config))) {
            return false;
        }
        String mainTypeName = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, null);
        if (mainTypeName == null) {
            return false;
        }
        try {
            mainTypeName = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(mainTypeName);
        }
        catch (CoreException coreException) {
            return false;
        }
        if (!pattern.matcher(mainTypeName).matches()) {
            return false;
        }
        IResource[] resources = config.getMappedResources();
        if (resources != null) {
            IResource[] iResourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (scope.encloses(resource.getFullPath().toString())) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private void searchLaunchConfigurations(IJavaSearchScope scope, ISearchRequestor requestor, Pattern pattern, IProgressMonitor monitor) throws CoreException {
        ILaunchConfiguration[] configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations();
        monitor.beginTask("Searching for launch configurations", configs.length);
        try {
            ILaunchConfiguration[] iLaunchConfigurationArray = configs;
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration config = iLaunchConfigurationArray[n2];
                if (monitor.isCanceled()) {
                    return;
                }
                monitor.worked(1);
                if (this.matches(scope, config, pattern)) {
                    requestor.reportMatch(new Match((Object)config, 0, 0));
                }
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
    }

    private static class UIParticipant
    implements IMatchPresentation {
        private UIParticipant() {
        }

        public ILabelProvider createLabelProvider() {
            return DebugUITools.newDebugModelPresentation();
        }

        public void showMatch(Match match, int currentOffset, int currentLength, boolean activate) throws PartInitException {
            Object o = match.getElement();
            if (o instanceof ILaunchConfiguration && activate) {
                try {
                    ILaunchConfiguration config = (ILaunchConfiguration)o;
                    Set modes = config.getType().getSupportedModeCombinations();
                    ILaunchGroup group = null;
                    Set mode2 = null;
                    for (Set mode2 : modes) {
                        if (mode2.size() == 1 && (group = DebugUITools.getLaunchGroup((ILaunchConfiguration)config, (String)((String)mode2.iterator().next()))) != null) break;
                    }
                    if (group == null || !config.exists()) {
                        return;
                    }
                    DebugUITools.openLaunchConfigurationDialog((Shell)JDIDebugUIPlugin.getActiveWorkbenchShell(), (ILaunchConfiguration)config, (String)group.getIdentifier(), (IStatus)Status.OK_STATUS);
                }
                catch (CoreException ce) {
                    JDIDebugUIPlugin.log(ce);
                }
            }
        }
    }
}

