/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.manipulation.CleanUpContextCore;
import org.eclipse.jdt.core.manipulation.CleanUpRequirementsCore;
import org.eclipse.jdt.core.manipulation.ICleanUpFixCore;
import org.eclipse.jdt.internal.corext.fix.BooleanValueRatherThanComparisonFixCore;
import org.eclipse.jdt.internal.ui.fix.AbstractCleanUpCore;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;

public class BooleanValueRatherThanComparisonCleanUpCore
extends AbstractCleanUpCore {
    public BooleanValueRatherThanComparisonCleanUpCore(Map<String, String> options) {
        super(options);
    }

    public BooleanValueRatherThanComparisonCleanUpCore() {
    }

    @Override
    public CleanUpRequirementsCore getRequirementsCore() {
        return new CleanUpRequirementsCore(this.requireAST(), false, false, null);
    }

    public boolean requireAST() {
        return this.isEnabled("cleanup.boolean_value_rather_than_comparison");
    }

    @Override
    public ICleanUpFixCore createFixCore(CleanUpContextCore context) throws CoreException {
        CompilationUnit compilationUnit = context.getAST();
        if (compilationUnit == null || !this.isEnabled("cleanup.boolean_value_rather_than_comparison")) {
            return null;
        }
        return BooleanValueRatherThanComparisonFixCore.createCleanUp(compilationUnit);
    }

    @Override
    public String[] getStepDescriptions() {
        if (this.isEnabled("cleanup.boolean_value_rather_than_comparison")) {
            return new String[]{MultiFixMessages.BooleanValueRatherThanComparisonCleanUp_description};
        }
        return new String[0];
    }

    @Override
    public String getPreview() {
        if (this.isEnabled("cleanup.boolean_value_rather_than_comparison")) {
            return "boolean booleanValue = isValid;\nboolean booleanValue2 = !isValid;\nboolean booleanValue3 = i <= 0;\nboolean booleanValue4 = !booleanObject;\n";
        }
        return "boolean booleanValue = isValid == true;\nboolean booleanValue2 = isValid == false;\nboolean booleanValue3 = Boolean.FALSE.equals(i > 0);\nboolean booleanValue4 = booleanObject.equals(Boolean.FALSE);\n";
    }
}

