/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.TargetSourceRangeComputer;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.GenericVisitor;
import org.eclipse.jdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.util.TightSourceRangeComputer;
import org.eclipse.text.edits.TextEditGroup;

public abstract class ConvertLoopOperation
extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
    protected static final String FOR_LOOP_ELEMENT_IDENTIFIER = "element";
    protected static final IStatus ERROR_STATUS = new Status(4, "org.eclipse.jdt.core.manipulation", "");
    private static final Map<String, String> IRREG_NOUNS = Stream.of(new AbstractMap.SimpleImmutableEntry<String, String>("Children", "Child"), new AbstractMap.SimpleImmutableEntry<String, String>("Entries", "Entry"), new AbstractMap.SimpleImmutableEntry<String, String>("Proxies", "Proxy"), new AbstractMap.SimpleImmutableEntry<String, String>("Indices", "Index")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    private static final Set<String> NO_BASE_TYPES = Stream.of("integers", "floats", "doubles", "booleans", "bytes", "chars", "shorts", "longs").collect(Collectors.toSet());
    private static final Set<String> CUT_PREFIX = Stream.of("all").collect(Collectors.toSet());
    private static final Set<String> IRREG_ENDINGS = Stream.of("xes", "ies", "oes", "ses", "hes", "zes", "ves", "ces", "ss", "is", "us", "os", "as").collect(Collectors.toSet());
    private final ForStatement fStatement;
    private ConvertLoopOperation fOperation;
    private ConvertLoopOperation fChildLoopOperation;
    private final String[] fUsedNames;

    public ConvertLoopOperation(ForStatement statement, String[] usedNames) {
        this.fStatement = statement;
        this.fUsedNames = usedNames;
    }

    public void setBodyConverter(ConvertLoopOperation operation) {
        this.fOperation = operation;
    }

    public void setChildLoopOperation(ConvertLoopOperation operation) {
        this.fChildLoopOperation = operation;
    }

    public ConvertLoopOperation getChildLoopOperation() {
        return this.fChildLoopOperation;
    }

    public abstract String getIntroducedVariableName();

    public abstract IStatus satisfiesPreconditions();

    protected abstract Statement convert(CompilationUnitRewrite var1, TextEditGroup var2, LinkedProposalModelCore var3) throws CoreException;

    protected ForStatement getForStatement() {
        return this.fStatement;
    }

    protected Statement getBody(CompilationUnitRewrite cuRewrite, TextEditGroup group, LinkedProposalModelCore positionGroups) throws CoreException {
        if (this.fOperation != null) {
            return this.fOperation.convert(cuRewrite, group, positionGroups);
        }
        return (Statement)cuRewrite.getASTRewrite().createMoveTarget((ASTNode)this.getForStatement().getBody());
    }

    protected String[] getUsedVariableNames() {
        final ArrayList<String> results = new ArrayList<String>();
        ForStatement forStatement = this.getForStatement();
        CompilationUnit root = (CompilationUnit)forStatement.getRoot();
        Collection<String> variableNames = new ScopeAnalyzer(root).getUsedVariableNames(forStatement.getStartPosition(), forStatement.getLength());
        results.addAll(variableNames);
        forStatement.accept((ASTVisitor)new GenericVisitor(){

            @Override
            public boolean visit(SingleVariableDeclaration node) {
                results.add(node.getName().getIdentifier());
                return super.visit(node);
            }

            @Override
            public boolean visit(VariableDeclarationFragment fragment) {
                results.add(fragment.getName().getIdentifier());
                return super.visit(fragment);
            }
        });
        results.addAll(Arrays.asList(this.fUsedNames));
        return results.toArray(new String[results.size()]);
    }

    @Override
    public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore positionGroups) throws CoreException {
        TextEditGroup group = this.createTextEditGroup(FixMessages.Java50Fix_ConvertToEnhancedForLoop_description, cuRewrite);
        ASTRewrite rewrite = cuRewrite.getASTRewrite();
        TightSourceRangeComputer rangeComputer = rewrite.getExtendedSourceRangeComputer() instanceof TightSourceRangeComputer ? (TightSourceRangeComputer)rewrite.getExtendedSourceRangeComputer() : new TightSourceRangeComputer();
        rangeComputer.addTightSourceNode((ASTNode)this.getForStatement());
        rewrite.setTargetSourceRangeComputer((TargetSourceRangeComputer)rangeComputer);
        Statement statement = this.convert(cuRewrite, group, positionGroups);
        ForStatement node = this.getForStatement();
        ASTNodes.replaceButKeepComment(rewrite, (ASTNode)node, (ASTNode)statement, group);
    }

    public static String modifybasename(String suggestedName) {
        String name = suggestedName;
        for (String string : CUT_PREFIX) {
            char afterPrefix;
            if (string.length() >= suggestedName.length() || !Character.isUpperCase(afterPrefix = suggestedName.charAt(string.length())) && afterPrefix != '_' || !suggestedName.toLowerCase().startsWith(string)) continue;
            String nameWithoutPrefix = suggestedName.substring(string.length());
            name = nameWithoutPrefix.startsWith("_") && nameWithoutPrefix.length() > 1 ? nameWithoutPrefix.substring(1) : nameWithoutPrefix;
            if (name.length() != 1) break;
            return name;
        }
        for (Map.Entry entry : IRREG_NOUNS.entrySet()) {
            String suffix = (String)entry.getKey();
            if (!name.toLowerCase().endsWith(suffix.toLowerCase())) continue;
            String firstPart = name.substring(0, name.length() - suffix.length());
            return String.valueOf(firstPart) + (String)entry.getValue();
        }
        for (String string : NO_BASE_TYPES) {
            if (!name.equalsIgnoreCase(string)) continue;
            return FOR_LOOP_ELEMENT_IDENTIFIER;
        }
        for (String string : IRREG_ENDINGS) {
            if (!name.toLowerCase().endsWith(string)) continue;
            return FOR_LOOP_ELEMENT_IDENTIFIER;
        }
        if (name.length() > 2 && name.endsWith("s")) {
            return name.substring(0, name.length() - 1);
        }
        return FOR_LOOP_ELEMENT_IDENTIFIER;
    }
}

