/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.TargetSourceRangeComputer;
import org.eclipse.jdt.core.manipulation.ICleanUpFixCore;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.text.edits.TextEditGroup;

public class PrimitiveComparisonFixCore
extends CompilationUnitRewriteOperationsFixCore {
    public static ICleanUpFixCore createCleanUp(CompilationUnit compilationUnit) {
        ArrayList<PrimitiveComparisonFixOperation> operations = new ArrayList<PrimitiveComparisonFixOperation>();
        PrimitiveComparisonFinder finder = new PrimitiveComparisonFinder(operations);
        compilationUnit.accept((ASTVisitor)finder);
        if (operations.isEmpty()) {
            return null;
        }
        CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[] ops = operations.toArray(new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[0]);
        return new PrimitiveComparisonFixCore(FixMessages.PrimitiveComparisonFix_convert_compareTo_to_primitive_comparison, compilationUnit, ops);
    }

    protected PrimitiveComparisonFixCore(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[] fixRewriteOperations) {
        super(name, compilationUnit, fixRewriteOperations);
    }

    public static final class PrimitiveComparisonFinder
    extends ASTVisitor {
        private List<PrimitiveComparisonFixOperation> fResult;

        public PrimitiveComparisonFinder(List<PrimitiveComparisonFixOperation> ops) {
            this.fResult = ops;
        }

        public boolean visit(MethodInvocation visited) {
            if (visited.getExpression() != null && visited.arguments().size() == 1) {
                Class[] wrapperClasses;
                Class[] classArray = wrapperClasses = new Class[]{Integer.class, Boolean.class, Long.class, Double.class, Character.class, Float.class, Short.class, Byte.class};
                int n = wrapperClasses.length;
                int n2 = 0;
                while (n2 < n) {
                    Class wrapperClass = classArray[n2];
                    String canonicalName = wrapperClass.getCanonicalName();
                    String primitiveName = Bindings.getUnboxedTypeName(canonicalName);
                    if (ASTNodes.isPrimitive((Expression)visited.arguments().get(0), primitiveName) && ASTNodes.usesGivenSignature(visited, canonicalName, "compareTo", canonicalName)) {
                        MethodInvocation methodInvocation = ASTNodes.as(visited.getExpression(), MethodInvocation.class);
                        if (methodInvocation != null && ASTNodes.usesGivenSignature(methodInvocation, canonicalName, "valueOf", primitiveName) && ASTNodes.isPrimitive((Expression)methodInvocation.arguments().get(0), primitiveName)) {
                            this.fResult.add(new PrimitiveComparisonFixOperation(visited, (Expression)methodInvocation.arguments().get(0), wrapperClass));
                            return false;
                        }
                        ClassInstanceCreation classInstanceCreation = ASTNodes.as(visited.getExpression(), ClassInstanceCreation.class);
                        if (classInstanceCreation != null && ASTNodes.hasType(classInstanceCreation.getType().resolveBinding(), canonicalName) && ASTNodes.isPrimitive((Expression)classInstanceCreation.arguments().get(0), primitiveName)) {
                            this.fResult.add(new PrimitiveComparisonFixOperation(visited, (Expression)classInstanceCreation.arguments().get(0), wrapperClass));
                            return false;
                        }
                        CastExpression castExpression = ASTNodes.as(visited.getExpression(), CastExpression.class);
                        if (castExpression != null && ASTNodes.hasType(castExpression.getType().resolveBinding(), canonicalName) && ASTNodes.isPrimitive(castExpression.getExpression(), primitiveName)) {
                            this.fResult.add(new PrimitiveComparisonFixOperation(visited, castExpression.getExpression(), wrapperClass));
                            return false;
                        }
                        return true;
                    }
                    ++n2;
                }
            }
            return true;
        }
    }

    public static class PrimitiveComparisonFixOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
        private final MethodInvocation visited;
        private final Expression primitiveValue;
        private final Class<?> wrapperClass;

        public PrimitiveComparisonFixOperation(MethodInvocation visited, Expression primitiveValue, Class<?> wrapperClass) {
            this.visited = visited;
            this.primitiveValue = primitiveValue;
            this.wrapperClass = wrapperClass;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            AST ast = cuRewrite.getRoot().getAST();
            TextEditGroup group = this.createTextEditGroup(MultiFixMessages.PrimitiveComparisonCleanUp_description, cuRewrite);
            rewrite.setTargetSourceRangeComputer(new TargetSourceRangeComputer(){

                public TargetSourceRangeComputer.SourceRange computeSourceRange(ASTNode nodeWithComment) {
                    if (Boolean.TRUE.equals(nodeWithComment.getProperty("untouchComment"))) {
                        return new TargetSourceRangeComputer.SourceRange(nodeWithComment.getStartPosition(), nodeWithComment.getLength());
                    }
                    return super.computeSourceRange(nodeWithComment);
                }
            });
            MethodInvocation compareMethod = ast.newMethodInvocation();
            compareMethod.setExpression((Expression)ast.newSimpleName(this.wrapperClass.getSimpleName()));
            compareMethod.setName(ast.newSimpleName("compare"));
            compareMethod.arguments().add(ASTNodes.createMoveTarget(rewrite, ASTNodes.getUnparenthesedExpression(this.primitiveValue)));
            compareMethod.arguments().add(ASTNodes.createMoveTarget(rewrite, ASTNodes.getUnparenthesedExpression((Expression)this.visited.arguments().get(0))));
            ASTNodes.replaceButKeepComment(rewrite, (ASTNode)this.visited, (ASTNode)compareMethod, group);
        }
    }
}

