/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.syntaxcoloring;

import com.google.inject.Singleton;
import java.util.regex.Pattern;
import org.eclipse.xtext.ui.editor.syntaxcoloring.AbstractAntlrTokenToAttributeIdMapper;

@Singleton
public class DefaultAntlrTokenToAttributeIdMapper
extends AbstractAntlrTokenToAttributeIdMapper {
    private static final Pattern QUOTED = Pattern.compile("(?:^'([^']*)'$)|(?:^\"([^\"]*)\")$", 8);
    private static final Pattern PUNCTUATION = Pattern.compile("\\p{Punct}*");

    @Override
    protected String calculateId(String tokenName, int tokenType) {
        if (PUNCTUATION.matcher(tokenName).matches()) {
            return "punctuation";
        }
        if (QUOTED.matcher(tokenName).matches()) {
            return "keyword";
        }
        if ("RULE_STRING".equals(tokenName)) {
            return "string";
        }
        if ("RULE_INT".equals(tokenName)) {
            return "number";
        }
        if ("RULE_ML_COMMENT".equals(tokenName) || "RULE_SL_COMMENT".equals(tokenName)) {
            return "comment";
        }
        return "default";
    }
}

