/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.signature.comments;

import com.google.common.base.Objects;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.comma.signature.interfaceSignature.Command;
import org.eclipse.comma.signature.interfaceSignature.InterfaceEvent;
import org.eclipse.comma.signature.interfaceSignature.Parameter;
import org.eclipse.comma.types.types.Type;
import org.eclipse.comma.types.utilities.TypeUtilities;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.MapExtensions;

public class InterfaceEventComment {
    private String commentString;
    private InterfaceEvent event = null;
    private boolean valid = true;
    private String errorDescription = "";
    private String eventComment = "";
    private String returnComment = "";
    private Map<String, String> paramComments = new HashMap<String, String>();
    private final String paramRegex = "^\\\\param\\s+\\w|\\s\\\\param\\s+\\w";
    private final String returnRegex = "^\\\\return\\s|\\s\\\\return\\s|^\\\\return$|\\s\\\\return$";
    private final String wordRegex = "\\w+";
    private final Pattern paramPattern = Pattern.compile("^\\\\param\\s+\\w|\\s\\\\param\\s+\\w");
    private final Pattern returnPattern = Pattern.compile("^\\\\return\\s|\\s\\\\return\\s|^\\\\return$|\\s\\\\return$");
    private final Pattern wordPattern = Pattern.compile("\\w+");

    public InterfaceEventComment(InterfaceEvent event, String commentString) {
        this.commentString = commentString;
        this.event = event;
        if (commentString != null) {
            this.parse();
            this.validate();
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    public String getEventComment() {
        return this.eventComment;
    }

    public String getReturnComment() {
        return this.returnComment;
    }

    public String getCPPComments() {
        String _result;
        String _xblockexpression = null;
        String _replace = this.eventComment.replace("\n", "\n    ");
        String result = String.valueOf(_replace) + "\n";
        EList<Parameter> _parameters = this.event.getParameters();
        for (Parameter p : _parameters) {
            _result = result;
            int _indexOf = this.event.getParameters().indexOf((Object)p);
            String _string = Integer.valueOf(_indexOf + 1).toString();
            String _plus = "    \\param arg" + _string;
            String _plus_1 = String.valueOf(_plus) + " ";
            String _replace_1 = this.getCommentForParam(p.getName()).replace("\n", "\n    ");
            String _plus_2 = String.valueOf(_plus_1) + _replace_1;
            String _result_1 = result = String.valueOf(_result) + _plus_2;
            result = String.valueOf(_result_1) + "\n";
        }
        if (this.event instanceof Command) {
            boolean _not;
            boolean _isVoid = TypeUtilities.isVoid((Type)((Command)this.event).getType());
            boolean bl = _not = !_isVoid;
            if (_not) {
                _result = result;
                String _replace_1 = this.returnComment.replace("\n", "\n    ");
                String _plus = "    \\return " + _replace_1;
                result = String.valueOf(_result) + _plus;
            }
        }
        _xblockexpression = result;
        return _xblockexpression;
    }

    public String getCommentForParam(String paramName) {
        String _xblockexpression = null;
        String result = this.paramComments.get(paramName);
        if (result == null) {
            result = "";
        }
        _xblockexpression = result;
        return _xblockexpression;
    }

    public String getErrorMessage() {
        return this.errorDescription;
    }

    private void validate() {
        boolean _equals_2;
        boolean _not_2;
        if (this.commentString == null) {
            return;
        }
        this.errorDescription = "";
        if (this.eventComment.contains("\\return") || MapExtensions.filter(this.paramComments, (Functions.Function2)new Functions.Function2<String, String, Boolean>(){

            public Boolean apply(String p1, String p2) {
                return p2.contains("\\return");
            }
        }).size() > 0 || this.returnComment.contains("\\return")) {
            this.errorDescription = "Improper nesting of comment tags\n";
        }
        EList<Parameter> _parameters = this.event.getParameters();
        for (Parameter p : _parameters) {
            boolean _not;
            boolean _containsKey = this.paramComments.containsKey(p.getName());
            boolean bl = _not = !_containsKey;
            if (!_not) continue;
            String _errorDescription = this.errorDescription;
            String _name = p.getName();
            String _plus = "Missing comment for parameter " + _name;
            String _plus_1 = String.valueOf(_plus) + "\n";
            this.errorDescription = String.valueOf(_errorDescription) + _plus_1;
        }
        List _list = IterableExtensions.toList(this.paramComments.keySet());
        for (final String p_1 : _list) {
            boolean _equals;
            Functions.Function1<Parameter, Boolean> _function = new Functions.Function1<Parameter, Boolean>(){

                public Boolean apply(Parameter pp) {
                    return pp.getName().equals(p_1);
                }
            };
            int _size = IterableExtensions.size((Iterable)IterableExtensions.filter(this.event.getParameters(), (Functions.Function1)_function));
            boolean bl = _equals = _size == 0;
            if (!_equals) continue;
            String _errorDescription_1 = this.errorDescription;
            this.errorDescription = String.valueOf(_errorDescription_1) + "Commented parameter with name " + p_1 + " is not among event parameters" + "\n";
        }
        if (this.event instanceof Command) {
            boolean _not_1;
            boolean _isVoid = TypeUtilities.isVoid((Type)((Command)this.event).getType());
            boolean bl = _not_1 = !_isVoid;
            if (_not_1) {
                boolean _equals_1 = Objects.equal((Object)this.returnComment, (Object)"");
                if (_equals_1) {
                    String _errorDescription_2 = this.errorDescription;
                    this.errorDescription = String.valueOf(_errorDescription_2) + "Missing comment for return of the command \n";
                }
            } else if (this.returnComment != "") {
                String _errorDescription_3 = this.errorDescription;
                this.errorDescription = String.valueOf(_errorDescription_3) + "return comment is present for command of type void \n";
            }
        } else if (this.returnComment != "") {
            String _errorDescription_4 = this.errorDescription;
            this.errorDescription = String.valueOf(_errorDescription_4) + "return comment is not applicable \n";
        }
        boolean bl = _not_2 = !(_equals_2 = this.errorDescription.equals(""));
        if (_not_2) {
            this.valid = false;
        }
    }

    private void parseParam(String str) {
        boolean _equals;
        Matcher wm = this.wordPattern.matcher(str);
        wm.find();
        String paramName = str.substring(0, wm.end());
        int _end = wm.end();
        int _length = str.length();
        boolean bl = _equals = _end == _length;
        if (_equals) {
            return;
        }
        String docStr = str.substring(wm.end());
        Matcher pm = this.paramPattern.matcher(docStr);
        boolean _find = pm.find();
        if (_find) {
            String comment = docStr.substring(0, pm.start()).trim();
            this.paramComments.put(paramName, comment);
            int _end_1 = pm.end();
            int _minus = _end_1 - 1;
            this.parseParam(docStr.substring(_minus));
        } else {
            Matcher rm = this.returnPattern.matcher(docStr);
            boolean _find_1 = rm.find();
            if (_find_1) {
                String comment_1 = docStr.substring(0, rm.start()).trim();
                this.paramComments.put(paramName, comment_1);
                int _end_2 = rm.end();
                int _minus_1 = _end_2 - 1;
                this.parseReturn(docStr.substring(_minus_1));
            } else {
                String comment_2 = docStr.trim();
                this.paramComments.put(paramName, comment_2);
            }
        }
    }

    private String parseReturn(String str) {
        this.returnComment = str.trim();
        return this.returnComment;
    }

    private String parse() {
        String _xblockexpression = null;
        String docStr = this.commentString;
        Matcher pm = this.paramPattern.matcher(docStr);
        String _xifexpression = null;
        boolean _find = pm.find();
        if (_find) {
            int i = pm.start();
            if (i > 0) {
                this.eventComment = docStr.substring(0, i).trim();
            }
            int _end = pm.end();
            int _minus = _end - 1;
            docStr = docStr.substring(_minus);
            this.parseParam(docStr);
        } else {
            String _xblockexpression_1 = null;
            Matcher rm = this.returnPattern.matcher(docStr);
            String _xifexpression_1 = null;
            boolean _find_1 = rm.find();
            if (_find_1) {
                String _xblockexpression_2 = null;
                int i_1 = rm.start();
                if (i_1 > 0) {
                    this.eventComment = docStr.substring(0, i_1).trim();
                }
                int _end_1 = rm.end();
                int _minus_1 = _end_1 - 1;
                docStr = docStr.substring(_minus_1);
                _xifexpression_1 = _xblockexpression_2 = this.parseReturn(docStr);
            } else {
                _xifexpression_1 = this.eventComment = docStr.trim();
            }
            _xifexpression = _xblockexpression_1 = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }
}

