/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.simulator;

import java.util.stream.Collectors;
import org.eclipse.comma.behavior.behavior.State;
import org.eclipse.comma.behavior.behavior.StateMachine;
import org.eclipse.comma.evaluator.EAction;
import org.eclipse.comma.evaluator.EHelper;
import org.eclipse.comma.evaluator.EVariable;
import org.eclipse.comma.evaluator.EVariableCollection;
import org.eclipse.comma.signature.interfaceSignature.DIRECTION;
import org.eclipse.comma.signature.interfaceSignature.InterfaceEvent;
import org.eclipse.comma.signature.interfaceSignature.impl.CommandImpl;
import org.eclipse.comma.signature.interfaceSignature.impl.SignalImpl;

public class Helper {
    static String actionToSymbol(Object action) {
        if (action instanceof EAction) {
            return EHelper.actionToSymbol((EAction)((EAction)action));
        }
        if (action instanceof CommandImpl) {
            return "C";
        }
        if (action instanceof SignalImpl) {
            return "S";
        }
        throw new RuntimeException("Not supported");
    }

    static String stateMachineName(State state) {
        return ((StateMachine)state.eContainer()).getName();
    }

    static String actionToString(Object action, EVariableCollection parameters) {
        if (action instanceof EAction) {
            return EHelper.actionToString((EAction)((EAction)action));
        }
        if (action instanceof InterfaceEvent) {
            InterfaceEvent event = (InterfaceEvent)action;
            String parametersStr = String.join((CharSequence)", ", event.getParameters().stream().map(p -> {
                if (p.getDirection() == DIRECTION.OUT) {
                    return "_";
                }
                if (parameters.has(p.getName())) {
                    return EHelper.variableToString((EVariable)parameters.get(p.getName()));
                }
                return "?";
            }).collect(Collectors.toList()));
            return String.format("%s(%s)", Helper.getMethodName(action), parametersStr);
        }
        throw new RuntimeException("Not supported");
    }

    static String getMethodName(Object action) {
        if (action instanceof EAction) {
            return ((EAction)action).method;
        }
        if (action instanceof InterfaceEvent) {
            return ((InterfaceEvent)action).getName();
        }
        throw new RuntimeException("Not supported");
    }
}

