/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.nd.java;

import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.internal.compiler.classfmt.JavaBinaryNames;
import org.eclipse.jdt.internal.core.nd.Nd;
import org.eclipse.jdt.internal.core.nd.db.IString;
import org.eclipse.jdt.internal.core.nd.field.FieldInt;
import org.eclipse.jdt.internal.core.nd.field.FieldList;
import org.eclipse.jdt.internal.core.nd.field.FieldManyToOne;
import org.eclipse.jdt.internal.core.nd.field.FieldOneToMany;
import org.eclipse.jdt.internal.core.nd.field.FieldOneToOne;
import org.eclipse.jdt.internal.core.nd.field.FieldShort;
import org.eclipse.jdt.internal.core.nd.field.FieldString;
import org.eclipse.jdt.internal.core.nd.field.StructDef;
import org.eclipse.jdt.internal.core.nd.java.NdAnnotation;
import org.eclipse.jdt.internal.core.nd.java.NdBinding;
import org.eclipse.jdt.internal.core.nd.java.NdConstant;
import org.eclipse.jdt.internal.core.nd.java.NdMethodAnnotationData;
import org.eclipse.jdt.internal.core.nd.java.NdMethodException;
import org.eclipse.jdt.internal.core.nd.java.NdMethodParameter;
import org.eclipse.jdt.internal.core.nd.java.NdTypeAnnotation;
import org.eclipse.jdt.internal.core.nd.java.NdTypeParameter;
import org.eclipse.jdt.internal.core.nd.java.NdTypeSignature;
import org.eclipse.jdt.internal.core.nd.java.NdVariable;
import org.eclipse.jdt.internal.core.nd.util.CharArrayUtils;
import org.eclipse.jdt.internal.core.util.CharArrayBuffer;

public class NdMethod
extends NdBinding {
    public static final FieldString METHOD_NAME;
    public static final FieldShort METHOD_FLAGS;
    public static final FieldOneToMany<NdVariable> DECLARED_VARIABLES;
    public static final FieldList<NdMethodParameter> PARAMETERS;
    public static final FieldOneToOne<NdConstant> DEFAULT_VALUE;
    public static final FieldList<NdMethodException> EXCEPTIONS;
    public static final FieldManyToOne<NdTypeSignature> RETURN_TYPE;
    public static final FieldOneToOne<NdMethodAnnotationData> ANNOTATION_DATA;
    public static final FieldInt DECLARATION_POSITION;
    public static final StructDef<NdMethod> type;
    public static final byte FLG_GENERIC_SIGNATURE_PRESENT = 1;
    public static final byte FLG_THROWS_SIGNATURE_PRESENT = 2;

    static {
        type = StructDef.create(NdMethod.class, NdBinding.type);
        METHOD_NAME = type.addString();
        METHOD_FLAGS = type.addShort();
        PARAMETERS = FieldList.create(type, NdMethodParameter.type);
        DECLARED_VARIABLES = FieldOneToMany.create(type, NdVariable.DECLARING_METHOD);
        DEFAULT_VALUE = FieldOneToOne.create(type, NdConstant.type, NdConstant.PARENT_METHOD);
        EXCEPTIONS = FieldList.create(type, NdMethodException.type);
        RETURN_TYPE = FieldManyToOne.create(type, NdTypeSignature.USED_AS_RETURN_TYPE);
        ANNOTATION_DATA = FieldOneToOne.create(type, NdMethodAnnotationData.type, NdMethodAnnotationData.METHOD);
        DECLARATION_POSITION = type.addInt();
        type.done();
    }

    public NdMethod(Nd nd, long address) {
        super(nd, address);
    }

    public NdMethodParameter createNewParameter() {
        return PARAMETERS.append(this.getNd(), this.getAddress());
    }

    public void allocateParameters(int numParameters) {
        PARAMETERS.allocate(this.nd, this.address, numParameters);
    }

    public IString getMethodName() {
        return METHOD_NAME.get(this.getNd(), this.address);
    }

    public void setMethodName(char[] selectorAndDescriptor) {
        METHOD_NAME.put(this.getNd(), this.getAddress(), selectorAndDescriptor);
    }

    public char[][] getParameterNames() {
        List<NdMethodParameter> params = this.getMethodParameters();
        int index = 0;
        char[][] result = new char[params.size()][];
        int idx = 0;
        while (idx < result.length) {
            NdMethodParameter param = params.get(idx);
            if (!param.isCompilerDefined()) {
                result[index] = param.getName().getChars();
                ++index;
            }
            ++idx;
        }
        return CharArrayUtils.subarray(result, 0, index);
    }

    public List<NdMethodParameter> getMethodParameters() {
        return PARAMETERS.asList(this.getNd(), this.address);
    }

    public List<NdAnnotation> getAnnotations() {
        NdMethodAnnotationData annotationData = this.getAnnotationData();
        if (annotationData != null) {
            return annotationData.getAnnotations();
        }
        return Collections.emptyList();
    }

    public void setDefaultValue(NdConstant value) {
        DEFAULT_VALUE.put(this.getNd(), this.address, value);
    }

    public NdConstant getDefaultValue() {
        return DEFAULT_VALUE.get(this.getNd(), this.address);
    }

    public void setReturnType(NdTypeSignature createTypeSignature) {
        RETURN_TYPE.put(this.getNd(), this.address, createTypeSignature);
    }

    public List<NdTypeAnnotation> getTypeAnnotations() {
        NdMethodAnnotationData annotationData = this.getAnnotationData();
        if (annotationData != null) {
            return annotationData.getTypeAnnotations();
        }
        return Collections.emptyList();
    }

    public List<NdMethodException> getExceptions() {
        return EXCEPTIONS.asList(this.getNd(), this.address);
    }

    public NdTypeSignature getReturnType() {
        return RETURN_TYPE.get(this.getNd(), this.address);
    }

    public int getFlags() {
        return METHOD_FLAGS.get(this.getNd(), this.address);
    }

    public boolean hasAllFlags(int flags) {
        int ourFlags = this.getFlags();
        return (ourFlags & flags) == flags;
    }

    public void setFlags(int flags) {
        METHOD_FLAGS.put(this.getNd(), this.address, (short)(this.getFlags() | flags));
    }

    public void setTagBits(long bits) {
        if (bits != 0L) {
            this.createAnnotationData().setTagBits(bits);
        } else {
            NdMethodAnnotationData annotationData = this.getAnnotationData();
            if (annotationData != null) {
                annotationData.setTagBits(bits);
            }
        }
    }

    public long getTagBits() {
        NdMethodAnnotationData annotations = this.getAnnotationData();
        if (annotations == null) {
            return 0L;
        }
        return annotations.getTagBits();
    }

    public String toString() {
        try {
            CharArrayBuffer arrayBuffer = new CharArrayBuffer();
            arrayBuffer.append(this.getSelector());
            this.getGenericSignature(arrayBuffer, true);
            return arrayBuffer.toString();
        }
        catch (RuntimeException runtimeException) {
            return super.toString();
        }
    }

    public char[] getSelector() {
        IString methodName = METHOD_NAME.get(this.getNd(), this.getAddress());
        char[] methodNameString = methodName.getChars();
        int bracketIndex = CharArrayUtils.indexOf('(', methodNameString);
        if (bracketIndex == -1) {
            bracketIndex = methodNameString.length;
        }
        return CharArrayUtils.subarray(methodNameString, 0, bracketIndex);
    }

    public boolean isConstructor() {
        return JavaBinaryNames.isConstructor(this.getSelector());
    }

    public boolean isClInit() {
        return JavaBinaryNames.isClinit(this.getSelector());
    }

    public void getGenericSignature(CharArrayBuffer result, boolean includeExceptions) {
        NdTypeParameter.getSignature(result, this.getTypeParameters());
        result.append('(');
        for (NdMethodParameter next : this.getMethodParameters()) {
            if (next.isCompilerDefined()) continue;
            next.getType().getSignature(result);
        }
        result.append(')');
        NdTypeSignature returnType = this.getReturnType();
        if (returnType == null) {
            result.append('V');
        } else {
            returnType.getSignature(result);
        }
        if (includeExceptions) {
            List<NdMethodException> exceptions = this.getExceptions();
            for (NdMethodException next : exceptions) {
                result.append('^');
                next.getExceptionType().getSignature(result);
            }
        }
    }

    public NdMethodAnnotationData createAnnotationData() {
        NdMethodAnnotationData result = this.getAnnotationData();
        if (result == null) {
            result = new NdMethodAnnotationData(this);
        }
        return result;
    }

    private NdMethodAnnotationData getAnnotationData() {
        return ANNOTATION_DATA.get(this.getNd(), this.getAddress());
    }

    public NdMethodException createException(NdTypeSignature createTypeSignature) {
        NdMethodException result = EXCEPTIONS.append(this.getNd(), this.getAddress());
        result.setExceptionType(createTypeSignature);
        return result;
    }

    public void allocateExceptions(int length) {
        EXCEPTIONS.allocate(this.nd, this.address, length);
    }

    public NdAnnotation createAnnotation() {
        return this.createAnnotationData().createAnnotation();
    }

    public NdTypeAnnotation createTypeAnnotation() {
        return this.createAnnotationData().createTypeAnnotation();
    }

    public void allocateAnnotations(int length) {
        if (length > 0) {
            this.createAnnotationData().allocateAnnotations(length);
        }
    }

    public void allocateTypeAnnotations(int length) {
        if (length > 0) {
            this.createAnnotationData().allocateTypeAnnotations(length);
        }
    }

    public void setDeclarationPosition(int position) {
        DECLARATION_POSITION.put(this.getNd(), this.getAddress(), position);
    }

    public int getDeclarationPosition() {
        return DECLARATION_POSITION.get(this.getNd(), this.getAddress());
    }

    public char[] getMethodDescriptor() {
        char[] name = this.getMethodName().getChars();
        int descriptorStart = CharArrayUtils.indexOf('(', name, 0, name.length);
        return CharArrayUtils.subarray(name, descriptorStart, name.length);
    }
}

