/*
 * Copyright (c) 2017 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api.stack.primitive;

import org.eclipse.collections.api.block.function.primitive.BooleanToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BooleanPredicate;
import org.eclipse.collections.api.list.primitive.BooleanList;
import org.eclipse.collections.api.ordered.primitive.OrderedBooleanIterable;
import org.eclipse.collections.api.stack.StackIterable;

/**
 * This file was automatically generated from template file primitiveStack.stg.
 *
 * @since 3.0.
 */
public interface BooleanStack extends OrderedBooleanIterable
{
    /**
     * Returns the top of the stack.
     */
    boolean peek();

    /**
     * Returns BooleanList of the number of elements specified by the count, beginning with the top of the stack.
     */
    BooleanList peek(int count);

    /**
     * Returns the element at the specified index.
     *
     * @param index the location to peek into
     */
    boolean peekAt(int index);

    @Override
    BooleanStack select(BooleanPredicate predicate);

    @Override
    BooleanStack reject(BooleanPredicate predicate);

    @Override
    <V> StackIterable<V> collect(BooleanToObjectFunction<? extends V> function);

    /**
     * Follows the same general contract as {@link StackIterable#equals(Object)}.
     */
    @Override
    boolean equals(Object o);

    /**
     * Follows the same general contract as {@link StackIterable#hashCode()}.
     */
    @Override
    int hashCode();

    ImmutableBooleanStack toImmutable();
}
