/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.smvExporter.ui.commands;

import eu.fbk.eclipse.standardtools.ExecOcraCommands.ui.services.OCRAExecService;
import eu.fbk.eclipse.standardtools.StateMachineTranslatorToSmv.ui.services.SmvExportServiceUI;
import eu.fbk.eclipse.standardtools.nuXmvService.ui.utils.NuXmvDirectoryUtil;
import eu.fbk.eclipse.standardtools.utils.core.model.AbstractStateMachineModel;
import eu.fbk.eclipse.standardtools.utils.core.model.AbstractSystemModel;
import eu.fbk.eclipse.standardtools.utils.ui.commands.AbstractJobCommand;
import eu.fbk.eclipse.standardtools.utils.ui.dialogs.MessageCommunicationDialog;
import eu.fbk.eclipse.standardtools.utils.ui.dialogs.MessageTimeModelDialog;
import eu.fbk.eclipse.standardtools.utils.ui.utils.DialogUtil;
import eu.fbk.eclipse.standardtools.utils.ui.utils.OCRADirectoryUtil;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.polarsys.chess.contracts.profile.chesscontract.util.EntityUtil;
import org.polarsys.chess.service.core.exceptions.NoComponentException;
import org.polarsys.chess.service.core.model.ChessSystemModel;
import org.polarsys.chess.service.core.model.UMLStateMachineModel;
import org.polarsys.chess.service.gui.utils.SelectionUtil;
import org.polarsys.chess.smvExporter.ui.utils.SMVGenerationDialogUtil;

public class ExportModelToMonolithicSMVCommand
extends AbstractJobCommand {
    private static final Logger logger = Logger.getLogger(ExportModelToMonolithicSMVCommand.class);
    private SelectionUtil selectionUtil = SelectionUtil.getInstance();
    private DialogUtil dialogUtil = DialogUtil.getInstance();
    private EntityUtil entityUtil = EntityUtil.getInstance();

    public ExportModelToMonolithicSMVCommand() {
        super("Monolithic SMV file generation");
    }

    private Package getPackageFromSelectedObject(ExecutionEvent event) throws NoComponentException {
        ISelection selection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection();
        logger.debug((Object)("current selection: " + selection));
        Object selectedUmlElement = this.selectionUtil.getUmlSelectedObject((Object)selection);
        logger.debug((Object)("selectedUmlElement: " + selectedUmlElement));
        if (selectedUmlElement instanceof Package) {
            return (Package)selectedUmlElement;
        }
        throw new NoComponentException();
    }

    public void execPreJobOperations(ExecutionEvent event, IProgressMonitor monitor) throws Exception {
        SmvExportServiceUI smvExportServiceUI = SmvExportServiceUI.getInstance((AbstractSystemModel)ChessSystemModel.getInstance(), (AbstractStateMachineModel)UMLStateMachineModel.getInstance());
        NuXmvDirectoryUtil nuXmvDirectoryUtil = NuXmvDirectoryUtil.getInstance();
        OCRADirectoryUtil ocraDirectoryUtil = OCRADirectoryUtil.getInstance();
        OCRAExecService ocraExecService = OCRAExecService.getInstance((AbstractSystemModel)ChessSystemModel.getInstance());
        Class umlSelectedComponent = null;
        Package pkg = null;
        try {
            umlSelectedComponent = this.selectionUtil.getUmlComponentFromSelectedObject(event);
        }
        catch (NoComponentException noComponentException) {
            try {
                pkg = this.getPackageFromSelectedObject(event);
            }
            catch (NoComponentException ex) {
                this.dialogUtil.showMessage_ExceptionError((Exception)((Object)ex));
                throw new ExecutionException(ex.getMessage());
            }
        }
        if (pkg == null) {
            pkg = umlSelectedComponent.getNearestPackage();
        }
        if (!this.entityUtil.isSystemViewPackage((Element)pkg)) {
            logger.debug((Object)"Wrong model package, aborting.");
            ExecutionException e = new ExecutionException("Please select a package from <<SystemView>>");
            this.dialogUtil.showMessage_ExceptionError((Exception)e);
            throw e;
        }
        umlSelectedComponent = this.entityUtil.getSystemComponent(pkg);
        if (umlSelectedComponent == null) {
            logger.debug((Object)"System block not found, aborting.");
            ExecutionException e = new ExecutionException("The package does not have a <<System>> block or it has more than one. Please check.");
            this.dialogUtil.showMessage_ExceptionError((Exception)e);
            throw e;
        }
        int timeSpecification = MessageTimeModelDialog.openQuestion((boolean)true);
        boolean isAsyncCommunication = !MessageCommunicationDialog.openQuestion((boolean)false);
        String smvFileDirectory = nuXmvDirectoryUtil.getSmvFileDirectory();
        String monolithicSMVFilePath = event.getParameter("file_name");
        if (monolithicSMVFilePath == null) {
            monolithicSMVFilePath = nuXmvDirectoryUtil.getMonolithicSMVFilePath(umlSelectedComponent.getName());
        }
        String smvMapDirPath = nuXmvDirectoryUtil.getSmvFileDirectory();
        String ossDirPath = ocraDirectoryUtil.getOSSDirPath();
        Resource umlSelectedResource = umlSelectedComponent.eResource();
        logger.debug((Object)"exportSmv");
        HashMap smvPathComponentNameMap = smvExportServiceUI.exportSmv((Object)umlSelectedComponent, false, smvFileDirectory, monitor, timeSpecification);
        logger.debug((Object)"createMonolithicSMV");
        if (!ocraExecService.createMonolithicSMV((Object)umlSelectedComponent, umlSelectedResource, smvPathComponentNameMap, timeSpecification, isAsyncCommunication, true, false, ossDirPath, smvMapDirPath, monolithicSMVFilePath, true, monitor)) {
            ExecutionException e = new ExecutionException("createMonolithicSMV command failed.");
            DialogUtil.getInstance().showMessage_ExceptionError((Exception)e);
            throw e;
        }
        String showPopup = event.getParameter("show_popup");
        if (showPopup != null && showPopup.equals("true")) {
            SMVGenerationDialogUtil smvGenerationDialogUtil = SMVGenerationDialogUtil.getInstance();
            smvGenerationDialogUtil.showMessage_SmvGenerationDone(monolithicSMVFilePath);
        }
    }

    public void execJobCommand(ExecutionEvent event, IProgressMonitor monitor) throws Exception {
    }

    public void execPostJobOperations(ExecutionEvent event, NullProgressMonitor nullProgressMonitor) throws Exception {
    }
}

