(type State (enum <#list stateMachine.states as state>${state.name} </#list>))
(type InitTransition (enum <#list stateMachine.initTransitions as trans>${trans.name} </#list>))
(type Transition (enum <#list stateMachine.transitions as trans>${trans.name} </#list>))

(entry main)

(globals
	; state machine variables
	(var |state| State)
	(var |init_transition| InitTransition)
	(var |transition| Transition)
	; input ports<#list inputPorts as attr>
	(var |${attr.name}| ${setType(attr)})</#list>
	; output ports<#list outputPorts as attr>
	(var |${attr.name}| ${setType(attr)})</#list>
	; attributes<#list attributes as attr>
	(var |${attr.name}| ${setType(attr)})</#list>
	; array length
	<#list inputPorts as attr>${getArrayLengthVar(attr)}</#list><#list outputPorts as attr>${getArrayLengthVar(attr)}</#list><#list attributes as attr>${getArrayLengthVar(attr)}</#list>
	)

(function |init| () (return)
	(locals (var |guard_cond| bool))
	(seq
		(jump <#list stateMachine.initTransitions as transition>(label |choice_init_trans_${transition.name}|)</#list>)
		
		<#list stateMachine.initTransitions as transition>
		; check if the current init transition is '${transition.name}' 	
		(label |choice_init_trans_${transition.name}|)
			(call (const |guard_${transition.name}| (fun () (bool))) |guard_cond|)
			(assume |guard_cond|)
			(call (const |effect_${transition.name}| (fun () ())))
			; update state machine variables
			(assign |state| (const |${transition.outState}| State))
			(assign |init_transition|  (const |${transition.name}| InitTransition))
		(jump (label |end_init|))
		</#list>
		
		(label |end_init|))
)

(function |step| () (return)
	; the variable 'guard_cond' stores the value of each guard condition
	(locals (var |guard_cond| bool))
	(seq
	    (jump <#list stateMachine.states as state>(label |choice_state_${state.name}|) </#list>)

		<#list stateMachine.states as state>
		; check if the current state is '${state.name}'
		(label |choice_state_${state.name}|)
		(assume (op eq |state| (const |${state.name}| State)))
		(seq
			(jump <#list state.outTransitions as transition>(label |choice_trans_${transition.name}|)</#list>))
		(jump (label |end_step|))
		
		</#list>			
		<#list stateMachine.transitions as transition>
		; check if the current transition is '${transition.name}' 	
		(label |choice_trans_${transition.name}|)
			(call (const |guard_${transition.name}| (fun () (bool)))|guard_cond|)
			(assume |guard_cond|)
			(call (const |effect_${transition.name}| (fun () ())))
			; update state machine variables
			(assign |state| (const |${transition.outState}| State))
			(assign |transition| (const |${transition.name}| Transition))
		(jump (label |end_step|))

		</#list>
		
		(label |end_step|))
)

; the RHS of the assignment of each function 'guard_...' is translated from the guards expressions written in CleanC
<#list stateMachine.initTransitions as transition>
(function |guard_${transition.name}| () (return (var |ret| bool))
${transition.guardBody}
	)
	
</#list>
<#list stateMachine.transitions as transition>
(function |guard_${transition.name}| () (return (var |ret| bool))
${transition.guardBody}
	)
	
</#list>

; the body of each function 'effect_...' is translated from the effects statements written in CleanC
<#list stateMachine.initTransitions as transition>
(function |effect_${transition.name}| () (return )
${transition.effectBody}
	)
	
</#list>
<#list stateMachine.transitions as transition>
(function |effect_${transition.name}| () (return )
${transition.effectBody}
	)
</#list>

(function |read_inputs| () (return)
   (locals )
   ;;(assume (const true bool))
   (seq       
	   ; input ports<#list inputPorts as attr>
       (havoc |${attr.name}|)</#list>
	   ; output ports<#list outputPorts as attr>
	   (havoc |${attr.name}|)</#list>
	   ; attributes<#list attributes as attr>
	   (havoc |${attr.name}|)</#list>
     )
   )
   
; the main function	
(function |main| () (return)
        (locals )
        (seq
           (call (const |read_inputs| (fun () ())))
           (call (const |init| (fun () ())) )
           (label |LTL.init|)
           (call (const |read_inputs| (fun () ())))
           (label |while-true|)
           (label |LTL.pre_step|)
           (call (const |step| (fun () ())) )
           (label |LTL.post_step|)
           (call (const |read_inputs| (fun () ())))           
           (jump (label |while-true|))
           ))
<#function setType attr>
  <#if attr.isArray>
    <#return setArrayType(attr.type)>
  </#if> 
  <#return setSimpleType(attr.type)>
</#function>
<#function setSimpleType type>
  <#if type == "Boolean">
    <#return "bool">
  </#if>
  <#if type == "Real">
    <#return "real">
  </#if>
  <#if type == "Integer">
    <#return "int">
  </#if>
  <#return type>
</#function>
<#function setArrayType type>
  <#if type == "Boolean">
    <#return "(map int bool)">
  </#if>
  <#if type == "Real">
    <#return "(map int real)">
  </#if>
  <#if type == "Integer">
    <#return "(map int int)">
  </#if>
  <#return type>
</#function>
<#function getArrayLengthVar attr>
  <#if attr.isArray>
    <#return "(var |"+attr.name+"_length| int)\n">
  </#if> 
  <#return "">
</#function>