/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.utils.ui.dialogs;

import org.eclipse.jface.dialogs.IconAndMessageDialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class MessageTimeModelDialog
extends IconAndMessageDialog {
    public static String PLUGIN_ID = "eu.fbk.eclipse.standardtools.utils";
    private String[] buttonLabels;
    private Button[] buttons;
    private int defaultButtonIndex;
    private String title;
    private Image titleImage;
    private Image image = null;
    private Control customArea;
    private boolean noHybridTime = false;

    public MessageTimeModelDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex, boolean onlyDiscreteTime) {
        super(parentShell);
        this.init(dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, defaultIndex, onlyDiscreteTime, dialogButtonLabels);
    }

    public MessageTimeModelDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, int defaultIndex, boolean noHybridTime, String ... dialogButtonLabels) {
        super(parentShell);
        this.init(dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, defaultIndex, noHybridTime, dialogButtonLabels);
    }

    private void init(String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, int defaultIndex, boolean noHybridTime, String ... dialogButtonLabels) {
        this.title = dialogTitle;
        this.titleImage = dialogTitleImage;
        this.message = dialogMessage;
        this.image = this.getQuestionImage();
        this.noHybridTime = noHybridTime;
        this.buttonLabels = dialogButtonLabels;
        this.defaultButtonIndex = defaultIndex;
    }

    protected void buttonPressed(int buttonId) {
        this.setReturnCode(buttonId);
        this.close();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
        if (this.titleImage != null) {
            shell.setImage(this.titleImage);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.buttons = new Button[this.buttonLabels.length];
        int i = 0;
        while (i < this.buttonLabels.length) {
            Button button;
            String label = this.buttonLabels[i];
            this.buttons[i] = button = this.createButton(parent, i, label, this.defaultButtonIndex == i);
            ++i;
        }
    }

    protected Control createCustomArea(Composite parent) {
        return null;
    }

    protected Control createDialogArea(Composite parent) {
        this.createMessageArea(parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.horizontalSpan = 2;
        composite.setLayoutData((Object)data);
        this.customArea = this.createCustomArea(composite);
        if (this.customArea == null) {
            this.customArea = new Label(composite, 0);
        }
        return composite;
    }

    protected Button getButton(int index) {
        if (this.buttons == null || index < 0 || index >= this.buttons.length) {
            return null;
        }
        return this.buttons[index];
    }

    protected int getMinimumMessageWidth() {
        return this.convertHorizontalDLUsToPixels(300);
    }

    protected void handleShellCloseEvent() {
        super.handleShellCloseEvent();
        this.setReturnCode(-1);
    }

    public int open() {
        return super.open();
    }

    public static int open(int kind, Shell parent, String title, String message, int style, boolean noHybridTime) {
        MessageTimeModelDialog dialog = new MessageTimeModelDialog(parent, title, null, message, kind, 0, noHybridTime, MessageTimeModelDialog.getButtonLabels(kind));
        dialog.setShellStyle(dialog.getShellStyle() | (style &= 0x10000000));
        return dialog.open();
    }

    static String[] getButtonLabels(int kind) {
        String[] dialogButtonLabels = new String[]{"Hybrid", "Discrete", "Timed"};
        return dialogButtonLabels;
    }

    public static int openQuestion(boolean noHybridTime) {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        return MessageTimeModelDialog.open(1, shell, "Question", "Which model of time is used in the system?", 0, noHybridTime);
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button button = super.createButton(parent, id, label, defaultButton);
        if (this.noHybridTime && id == 0) {
            button.setEnabled(false);
        }
        if (defaultButton && !this.customShouldTakeFocus()) {
            button.setFocus();
        }
        return button;
    }

    protected boolean customShouldTakeFocus() {
        if (this.customArea instanceof Label) {
            return false;
        }
        if (this.customArea instanceof CLabel) {
            return (this.customArea.getStyle() & 0x80000) > 0;
        }
        return true;
    }

    public Image getImage() {
        return this.image;
    }

    protected String[] getButtonLabels() {
        return this.buttonLabels;
    }

    protected int getDefaultButtonIndex() {
        return this.defaultButtonIndex;
    }

    protected void setButtons(Button ... buttons) {
        if (buttons == null) {
            throw new NullPointerException("The array of buttons cannot be null.");
        }
        this.buttons = buttons;
    }

    protected void setButtonLabels(String ... buttonLabels) {
        if (buttonLabels == null) {
            throw new NullPointerException("The array of button labels cannot be null.");
        }
        this.buttonLabels = buttonLabels;
    }
}

