/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.editor.properties.validation;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecorationContext;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelDecorator;
import org.eclipse.sirius.editor.tools.internal.marker.SiriusEditorInterpreterMarkerService;
import org.eclipse.sirius.ui.business.api.descriptor.ComposedImageDescriptor;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class SiriusInterpreterErrorDecorator
extends LabelDecorator
implements ILabelDecorator {
    public static final ImageDescriptor ERROR_OVERLAY_DESC = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sirius.ui", (String)"/icons/full/validation/error_co.png");
    public static final ImageDescriptor ERROR_OVERLAY_DESC_CHILDREN_ONLY = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sirius.ui", (String)"/icons/full/validation/error_co_children_only.png");
    public static final ImageDescriptor WARNING_OVERLAY_DESC = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sirius.ui", (String)"/icons/full/validation/warning_co.png");
    public static final ImageDescriptor WARNING_OVERLAY_DESC_CHILDREN_ONLY = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sirius.ui", (String)"/icons/full/validation/warning_co_children_only.png");
    public static final ImageDescriptor INFO_OVERLAY_DESC = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sirius.ui", (String)"/icons/full/validation/info_co.png");
    public static final ImageDescriptor INFO_OVERLAY_DESC_CHILDREN_ONLY = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sirius.ui", (String)"/icons/full/validation/info_co_children_only.png");
    private List<ILabelProviderListener> listeners = new ArrayList<ILabelProviderListener>(1);
    private IResource resource;

    public SiriusInterpreterErrorDecorator(URI uri) {
        if (uri.isPlatformPlugin()) {
            String pluginResourceString = uri.toString();
            if (pluginResourceString != null) {
                this.resource = ResourcesPlugin.getWorkspace().getRoot();
            }
        } else {
            String platformResourceString = uri.toPlatformString(true);
            if (platformResourceString == null) {
                platformResourceString = uri.toFileString();
            }
            if (platformResourceString != null) {
                this.resource = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(platformResourceString));
            }
        }
    }

    public void addListener(ILabelProviderListener listener) {
        this.listeners.add(listener);
    }

    public Image decorateImage(Image image, Object element) {
        return image;
    }

    public Image decorateImage(Image image, Object element, IDecorationContext context) {
        Collection<IMarker> markersForElementAndChildren;
        String uriForElement = this.getURIForElement(element);
        if (uriForElement != null && !(markersForElementAndChildren = SiriusEditorInterpreterMarkerService.getValidationMarkersForElementAndChildren(this.resource, uriForElement)).isEmpty()) {
            ArrayList markersForElementOnly = Lists.newArrayList(SiriusEditorInterpreterMarkerService.getValidationMarkersForElement(this.resource, uriForElement));
            Iterator<IMarker> iter = markersForElementAndChildren.iterator();
            int globalSeverity = -1;
            while (globalSeverity < 2 && iter.hasNext()) {
                int severity;
                IMarker marker = iter.next();
                try {
                    severity = (Integer)marker.getAttribute("severity");
                }
                catch (CoreException coreException) {
                    severity = 1;
                }
                if (severity <= globalSeverity) continue;
                globalSeverity = severity;
            }
            if (globalSeverity >= 0) {
                ComposedImage img = this.decorateSeverity(image, globalSeverity, markersForElementOnly.isEmpty());
                ComposedImageDescriptor descriptor = new ComposedImageDescriptor(img);
                return SiriusEditPlugin.getPlugin().getImage((ImageDescriptor)descriptor);
            }
        }
        return image;
    }

    private String getURIForElement(Object element) {
        EObject eObject;
        Resource emfResource;
        String uri = null;
        if (element instanceof EObject && (emfResource = (eObject = (EObject)element).eResource()) != null) {
            String uriFragment = emfResource.getURIFragment((EObject)element);
            uri = String.valueOf(emfResource.getURI().toString()) + "#" + uriFragment;
        }
        return uri;
    }

    private ComposedImage decorateSeverity(Image image, Integer severity, boolean childrenContainsErrorButNotElement) {
        ArrayList<Image> images = new ArrayList<Image>(2);
        images.add(image);
        if (severity == 2) {
            if (childrenContainsErrorButNotElement) {
                images.add(SiriusEditPlugin.getPlugin().getImage(ERROR_OVERLAY_DESC_CHILDREN_ONLY));
            } else {
                images.add(SiriusEditPlugin.getPlugin().getImage(ERROR_OVERLAY_DESC));
            }
        } else if (severity == 1) {
            if (childrenContainsErrorButNotElement) {
                images.add(SiriusEditPlugin.getPlugin().getImage(WARNING_OVERLAY_DESC_CHILDREN_ONLY));
            } else {
                images.add(SiriusEditPlugin.getPlugin().getImage(WARNING_OVERLAY_DESC));
            }
        } else if (severity == 0) {
            if (childrenContainsErrorButNotElement) {
                images.add(SiriusEditPlugin.getPlugin().getImage(INFO_OVERLAY_DESC_CHILDREN_ONLY));
            } else {
                images.add(SiriusEditPlugin.getPlugin().getImage(INFO_OVERLAY_DESC));
            }
        }
        ComposedImage ci = new ComposedImage(images){

            public List<ComposedImage.Point> getDrawPoints(ComposedImage.Size size) {
                ArrayList<ComposedImage.Point> results = new ArrayList<ComposedImage.Point>();
                results.add(new ComposedImage.Point());
                ComposedImage.Point overlay = new ComposedImage.Point();
                overlay.x = 0;
                overlay.y = 7;
                results.add(overlay);
                return results;
            }
        };
        return ci;
    }

    public String decorateText(String text, Object element) {
        return text;
    }

    public String decorateText(String text, Object element, IDecorationContext context) {
        return text;
    }

    public void dispose() {
        this.listeners = new ArrayList<ILabelProviderListener>(1);
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public boolean prepareDecoration(Object element, String originalText, IDecorationContext context) {
        return true;
    }

    public void removeListener(ILabelProviderListener listener) {
        this.listeners.remove(listener);
    }
}

