/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.diagram;

import eu.fbk.eclipse.standardtools.diagram.ContainerDescriptor;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DocumentGenerator {
    private static final Logger logger = Logger.getLogger(DocumentGenerator.class);
    private String name;
    private String type;
    private ContainerDescriptor containerDescriptor;
    private Template template;

    public boolean init(String name, String type) {
        try {
            DocumentType.valueOf(type);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.error((Object)("Unsupported document type: " + type));
            return false;
        }
        this.name = name;
        this.type = type;
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_22);
        try {
            ClassTemplateLoader classTemplateLoader = new ClassTemplateLoader(this.getClass(), "templates");
            cfg.setTemplateLoader((TemplateLoader)classTemplateLoader);
            logger.debug((Object)("Load TemplateLoader: " + cfg.getTemplateLoader().toString()));
            this.template = cfg.getTemplate(String.valueOf(type) + "_model.ftl");
        }
        catch (IOException e) {
            logger.error((Object)e);
            return false;
        }
        cfg.setDefaultEncoding("UTF-8");
        cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        return true;
    }

    public void setContainerDescriptor(ContainerDescriptor containerDescriptor) {
        this.containerDescriptor = containerDescriptor;
    }

    public void generate(String directoryName) {
        HashMap<String, Object> documentMap = new HashMap<String, Object>();
        documentMap.put("title", this.name);
        documentMap.put("descriptors", this.getContainerDescriptors(this.containerDescriptor));
        ArrayList<Map<String, Object>> containers = new ArrayList<Map<String, Object>>();
        documentMap.put("containers", containers);
        for (ContainerDescriptor containerDescriptor : this.containerDescriptor.getFlatDescriptorList()) {
            containers.add(containerDescriptor.serialize());
        }
        try {
            FileWriter out = new FileWriter(String.valueOf(directoryName) + File.separator + "document." + this.type);
            this.template.process(documentMap, (Writer)out);
            ((Writer)out).close();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    private List<Object> getContainerDescriptors(ContainerDescriptor descriptor) {
        ArrayList<Object> descriptors = new ArrayList<Object>();
        descriptors.add(descriptor.serialize());
        return descriptors;
    }

    public List<ContainerDescriptor> getContainerDescriptors() {
        return this.containerDescriptor.children;
    }

    public ContainerDescriptor getRootContainerDescriptor() {
        return this.containerDescriptor;
    }

    public static enum DocumentType {
        html,
        tex;


        public static String[] getValuesAsStringArray() {
            String[] names = new String[DocumentType.values().length];
            int index = 0;
            DocumentType[] documentTypeArray = DocumentType.values();
            int n = documentTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                DocumentType state = documentTypeArray[n2];
                names[index++] = state.name();
                ++n2;
            }
            return names;
        }
    }
}

