/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardTools.KratosExecService.ui.utils;

import eu.fbk.eclipse.standardtools.utils.ui.utils.DirectoryUtil;
import java.io.File;
import org.apache.log4j.Logger;

public class KratosDirectoryUtil {
    private static final Logger logger = Logger.getLogger(KratosDirectoryUtil.class);
    private final String KRATOS_FILES_PATH = String.valueOf(File.separator) + "Kratos";
    private final String KRATOS_K2_DIR_PATH = String.valueOf(this.KRATOS_FILES_PATH) + File.separator + "Files";
    private final String KRATOS_RESULTS_DIR_PATH = String.valueOf(this.KRATOS_FILES_PATH) + File.separator + "Results";
    private static KratosDirectoryUtil kratosDirectoryUtil;
    private static DirectoryUtil directoryUtil;

    static {
        directoryUtil = DirectoryUtil.getInstance();
    }

    public static KratosDirectoryUtil getInstance() {
        if (kratosDirectoryUtil == null) {
            kratosDirectoryUtil = new KratosDirectoryUtil();
        }
        return kratosDirectoryUtil;
    }

    public String getK2FileDirectory() throws Exception {
        return String.valueOf(directoryUtil.getCurrentProjectDir()) + this.KRATOS_FILES_PATH;
    }

    public String getK2DirPath() throws Exception {
        String ossDirPath = String.valueOf(directoryUtil.getCurrentProjectDir()) + this.KRATOS_K2_DIR_PATH;
        logger.debug((Object)("ossDirPath: " + ossDirPath));
        return ossDirPath;
    }

    private String getKratosResultsDirPath(String baseDir) {
        String resultsDirPath = String.valueOf(baseDir) + this.KRATOS_RESULTS_DIR_PATH;
        logger.debug((Object)("resultsFilePath: " + resultsDirPath));
        return resultsDirPath;
    }

    private String createKratosResultsFileDir(String baseDir) {
        String dirPath = this.getKratosResultsDirPath(baseDir);
        File theDirectory = new File(dirPath);
        theDirectory.mkdirs();
        return dirPath;
    }

    private String getKratosResultFilePath(String ossFileName, String baseDir, String commandType, String extension) {
        logger.debug((Object)("KratosFileName: " + ossFileName));
        String resultsFileDir = this.createKratosResultsFileDir(baseDir);
        String filePath = String.valueOf(resultsFileDir) + File.separator + ossFileName.replace(".", "_") + "_" + commandType + "." + extension;
        return filePath;
    }

    public String getCommandCheckModelCommandResultPath(String selectedComponentName) throws Exception {
        return this.getKratosResultFilePath("output_" + selectedComponentName, directoryUtil.getCurrentProjectDir(), "kratos_model_checking_result", "txt");
    }

    public String getCommandInjectPropertyIntoModelResultPath(String selectedComponentName) throws Exception {
        return this.getKratosResultFilePath(selectedComponentName, directoryUtil.getCurrentProjectDir(), "with_property", "k2");
    }

    public String getCommandInjectPropertyIntoModelPropertyFile() throws Exception {
        String resultsFileDir = this.createKratosResultsFileDir(directoryUtil.getCurrentProjectDir());
        String filePath = String.valueOf(resultsFileDir) + File.separator + "kratos_property" + "." + "txt";
        return filePath;
    }
}

