/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.signal;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import org.eclipse.internal.net4j.bundle.OM;
import org.eclipse.net4j.buffer.BufferInputStream;
import org.eclipse.net4j.buffer.BufferOutputStream;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;
import org.eclipse.net4j.util.io.IOTimeoutException;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Signal
implements Runnable {
    public static final long NO_TIMEOUT = -1L;
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_SIGNAL, Signal.class);
    private SignalProtocol<?> protocol;
    private short id;
    private String name;
    private int correlationID;
    private BufferInputStream bufferInputStream;
    private BufferOutputStream bufferOutputStream;
    private InputStream wrappedInputStream;
    private OutputStream wrappedOutputStream;
    private Object currentStream;

    public Signal(SignalProtocol<?> protocol, short id, String name) {
        this.protocol = protocol;
        this.id = id;
        this.name = name;
    }

    public Signal(SignalProtocol<?> protocol, short id) {
        this(protocol, id, null);
    }

    public Signal(SignalProtocol<?> protocol, Enum<?> literal) {
        this(protocol, (short)literal.ordinal(), literal.name());
    }

    public SignalProtocol<?> getProtocol() {
        LifecycleUtil.checkActive(this.protocol);
        return this.protocol;
    }

    public final short getID() {
        return this.id;
    }

    public String getName() {
        if (this.name == null) {
            this.name = ReflectUtil.getSimpleClassName((Object)this);
        }
        return this.name;
    }

    public final int getCorrelationID() {
        return this.correlationID;
    }

    public String toString() {
        return MessageFormat.format("Signal[protocol={0}, id={1}, name={2}, correlation={3}{4}]", this.getProtocol().getType(), this.getID(), this.getName(), this.getCorrelationID(), this.getAdditionalInfo());
    }

    protected String getAdditionalInfo() {
        return "";
    }

    @Override
    public final void run() {
        String threadName = null;
        try {
            try {
                if (OM.SET_SIGNAL_THREAD_NAME) {
                    threadName = this.getClass().getSimpleName();
                    Thread.currentThread().setName(threadName);
                }
                this.runSync();
            }
            catch (Exception ex) {
                if (TRACER.isEnabled()) {
                    TRACER.trace("Exception in signal", (Throwable)ex);
                }
                if (threadName != null) {
                    Thread.currentThread().setName(String.valueOf(threadName) + "(FINISHED)");
                }
            }
        }
        finally {
            if (threadName != null) {
                Thread.currentThread().setName(String.valueOf(threadName) + "(FINISHED)");
            }
        }
    }

    protected final BufferInputStream getBufferInputStream() {
        return this.bufferInputStream;
    }

    protected final BufferOutputStream getBufferOutputStream() {
        return this.bufferOutputStream;
    }

    protected final void flush() throws IOException {
        if (this.currentStream instanceof OutputStream) {
            ((OutputStream)this.currentStream).flush();
        }
    }

    protected boolean closeChannelAfterMe() {
        return false;
    }

    protected boolean closeInputStreamAfterMe() {
        return true;
    }

    protected boolean closeOutputStreamAfterMe() {
        return true;
    }

    protected InputStream getCurrentInputStream() {
        if (this.currentStream instanceof InputStream) {
            return (InputStream)this.currentStream;
        }
        return null;
    }

    protected OutputStream getCurrentOutputStream() {
        if (this.currentStream instanceof OutputStream) {
            return (OutputStream)this.currentStream;
        }
        return null;
    }

    protected InputStream wrapInputStream(InputStream in) throws IOException {
        this.currentStream = this.getProtocol().wrapInputStream(in);
        return (InputStream)this.currentStream;
    }

    protected OutputStream wrapOutputStream(OutputStream out) throws IOException {
        this.currentStream = this.getProtocol().wrapOutputStream(out);
        return (OutputStream)this.currentStream;
    }

    protected void finishInputStream(InputStream in) throws IOException {
        this.currentStream = null;
        this.protocol.finishInputStream(in);
    }

    protected void finishOutputStream(OutputStream out) throws IOException {
        this.currentStream = null;
        this.protocol.finishOutputStream(out);
    }

    protected abstract void execute(BufferInputStream var1, BufferOutputStream var2) throws Exception;

    void runSync() throws Exception {
        Exception exception = null;
        try {
            try {
                this.execute(this.bufferInputStream, this.bufferOutputStream);
            }
            catch (IOTimeoutException ex) {
                exception = ex.createTimeoutException();
                throw exception;
            }
            catch (Exception ex) {
                exception = ex;
                throw exception;
            }
        }
        catch (Throwable throwable) {
            if (this.closeInputStreamAfterMe()) {
                IOUtil.closeSilent((Closeable)(this.wrappedInputStream != null ? this.wrappedInputStream : this.bufferInputStream));
            }
            if (this.closeOutputStreamAfterMe()) {
                IOUtil.closeSilent((Closeable)(this.wrappedOutputStream != null ? this.wrappedOutputStream : this.bufferOutputStream));
            }
            this.protocol.stopSignal(this, exception);
            throw throwable;
        }
        if (this.closeInputStreamAfterMe()) {
            IOUtil.closeSilent((Closeable)(this.wrappedInputStream != null ? this.wrappedInputStream : this.bufferInputStream));
        }
        if (this.closeOutputStreamAfterMe()) {
            IOUtil.closeSilent((Closeable)(this.wrappedOutputStream != null ? this.wrappedOutputStream : this.bufferOutputStream));
        }
        this.protocol.stopSignal(this, exception);
    }

    void setCorrelationID(int correlationID) {
        this.correlationID = correlationID;
    }

    void setBufferInputStream(BufferInputStream inputStream) {
        this.bufferInputStream = inputStream;
    }

    void setBufferOutputStream(BufferOutputStream outputStream) {
        this.bufferOutputStream = outputStream;
    }

    void doOutput(BufferOutputStream out) throws Exception {
        if (TRACER.isEnabled()) {
            TRACER.format("================ {0}: {1}", new Object[]{this.getOutputMeaning(), this});
        }
        this.wrappedOutputStream = this.wrapOutputStream(out);
        ExtendedDataOutputStream extended = ExtendedDataOutputStream.wrap((OutputStream)this.wrappedOutputStream);
        try {
            try {
                this.doExtendedOutput(extended);
            }
            catch (Error ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw ex;
            }
        }
        finally {
            this.finishOutputStream(this.wrappedOutputStream);
        }
        boolean ccam = this.closeChannelAfterMe();
        out.flushWithEOS(ccam);
    }

    void doInput(BufferInputStream in) throws Exception {
        if (TRACER.isEnabled()) {
            TRACER.format("================ {0}: {1}", new Object[]{this.getInputMeaning(), this});
        }
        this.wrappedInputStream = this.wrapInputStream(in);
        ExtendedDataInputStream extended = ExtendedDataInputStream.wrap((InputStream)this.wrappedInputStream);
        try {
            try {
                this.doExtendedInput(extended);
            }
            catch (Error ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw ex;
            }
        }
        finally {
            this.finishInputStream(this.wrappedInputStream);
        }
    }

    void doExtendedOutput(ExtendedDataOutputStream out) throws Exception {
    }

    void doExtendedInput(ExtendedDataInputStream in) throws Exception {
    }

    abstract String getOutputMeaning();

    abstract String getInputMeaning();
}

