/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.StateMachineTranslatorToSmv.core.stateMachineModelTranslator.visitors;

import eu.fbk.eclipse.standardtools.ast.ASTElements.ASTElement;
import eu.fbk.eclipse.standardtools.ast.ASTElements.ASTElementsFactory;
import eu.fbk.eclipse.standardtools.ast.ASTElements.AbsOp;
import eu.fbk.eclipse.standardtools.ast.ASTElements.AdditionOp;
import eu.fbk.eclipse.standardtools.ast.ASTElements.AndLogicOP;
import eu.fbk.eclipse.standardtools.ast.ASTElements.AndOp;
import eu.fbk.eclipse.standardtools.ast.ASTElements.Atom;
import eu.fbk.eclipse.standardtools.ast.ASTElements.Attribute;
import eu.fbk.eclipse.standardtools.ast.ASTElements.CastExpression;
import eu.fbk.eclipse.standardtools.ast.ASTElements.ComplementOp;
import eu.fbk.eclipse.standardtools.ast.ASTElements.ConstInteger;
import eu.fbk.eclipse.standardtools.ast.ASTElements.ConstReal;
import eu.fbk.eclipse.standardtools.ast.ASTElements.Context;
import eu.fbk.eclipse.standardtools.ast.ASTElements.CountOp;
import eu.fbk.eclipse.standardtools.ast.ASTElements.ElementOfList;
import eu.fbk.eclipse.standardtools.ast.ASTElements.Equal;
import eu.fbk.eclipse.standardtools.ast.ASTElements.ForAllPredicate;
import eu.fbk.eclipse.standardtools.ast.ASTElements.FullyQualifiedSymbol;
import eu.fbk.eclipse.standardtools.ast.ASTElements.ImpliesLogicOp;
import eu.fbk.eclipse.standardtools.ast.ASTElements.LeftShiftOp;
import eu.fbk.eclipse.standardtools.ast.ASTElements.LessThan;
import eu.fbk.eclipse.standardtools.ast.ASTElements.LocalVariable;
import eu.fbk.eclipse.standardtools.ast.ASTElements.MaxOp;
import eu.fbk.eclipse.standardtools.ast.ASTElements.MinOp;
import eu.fbk.eclipse.standardtools.ast.ASTElements.ModuleOp;
import eu.fbk.eclipse.standardtools.ast.ASTElements.NegativeOp;
import eu.fbk.eclipse.standardtools.ast.ASTElements.NotEqual;
import eu.fbk.eclipse.standardtools.ast.ASTElements.NotLogicOP;
import eu.fbk.eclipse.standardtools.ast.ASTElements.OrLogicOP;
import eu.fbk.eclipse.standardtools.ast.ASTElements.OrOp;
import eu.fbk.eclipse.standardtools.ast.ASTElements.ParameterList;
import eu.fbk.eclipse.standardtools.ast.ASTElements.ParameterListIterator;
import eu.fbk.eclipse.standardtools.ast.ASTElements.PositiveOp;
import eu.fbk.eclipse.standardtools.ast.ASTElements.Predicate;
import eu.fbk.eclipse.standardtools.ast.ASTElements.Real;
import eu.fbk.eclipse.standardtools.ast.ASTElements.Symbol;
import eu.fbk.eclipse.standardtools.ast.ASTElements.TransitionEffect;
import eu.fbk.eclipse.standardtools.ast.ASTElements.TransitionGuard;
import eu.fbk.eclipse.standardtools.ast.ASTElements.TruePredicate;
import eu.fbk.eclipse.standardtools.ast.ASTElements.TypeSpecifier;
import eu.fbk.eclipse.standardtools.ast.ASTElements.XorOp;
import eu.fbk.eclipse.standardtools.utils.core.utils.SysMLElementExtractor;
import eu.fbk.tools.editor.c.expression.expression.AdditiveExpression;
import eu.fbk.tools.editor.c.expression.expression.AllExpression;
import eu.fbk.tools.editor.c.expression.expression.AndExpression;
import eu.fbk.tools.editor.c.expression.expression.AssignmentExpression;
import eu.fbk.tools.editor.c.expression.expression.BooleanLiteral;
import eu.fbk.tools.editor.c.expression.expression.DecimalLiteral;
import eu.fbk.tools.editor.c.expression.expression.DeclarationSpecifier;
import eu.fbk.tools.editor.c.expression.expression.EqualityExpression;
import eu.fbk.tools.editor.c.expression.expression.ExclusiveOrExpression;
import eu.fbk.tools.editor.c.expression.expression.Expression;
import eu.fbk.tools.editor.c.expression.expression.FloatingPointLiteral;
import eu.fbk.tools.editor.c.expression.expression.Identifier;
import eu.fbk.tools.editor.c.expression.expression.InclusiveOrExpression;
import eu.fbk.tools.editor.c.expression.expression.LogicalAndExpression;
import eu.fbk.tools.editor.c.expression.expression.LogicalOrExpression;
import eu.fbk.tools.editor.c.expression.expression.MultiplicativeExpression;
import eu.fbk.tools.editor.c.expression.expression.ParsExpression;
import eu.fbk.tools.editor.c.expression.expression.PostfixExpression;
import eu.fbk.tools.editor.c.expression.expression.RelationalExpression;
import eu.fbk.tools.editor.c.expression.expression.ShiftExpression;
import eu.fbk.tools.editor.c.expression.expression.UnaryExpression;
import eu.fbk.tools.editor.c.statement.statement.AssertStatement;
import eu.fbk.tools.editor.c.statement.statement.AssignmentStatement;
import eu.fbk.tools.editor.c.statement.statement.BreakStatement;
import eu.fbk.tools.editor.c.statement.statement.CompoundStatement;
import eu.fbk.tools.editor.c.statement.statement.Declaration;
import eu.fbk.tools.editor.c.statement.statement.DeclarationList;
import eu.fbk.tools.editor.c.statement.statement.DeclarationSpecifiers;
import eu.fbk.tools.editor.c.statement.statement.Declarator;
import eu.fbk.tools.editor.c.statement.statement.ExpressionStatement;
import eu.fbk.tools.editor.c.statement.statement.ForStatement;
import eu.fbk.tools.editor.c.statement.statement.IfStatement;
import eu.fbk.tools.editor.c.statement.statement.InitDeclarator;
import eu.fbk.tools.editor.c.statement.statement.InitDeclaratorList;
import eu.fbk.tools.editor.c.statement.statement.Initializer;
import eu.fbk.tools.editor.c.statement.statement.InitializerList;
import eu.fbk.tools.editor.c.statement.statement.IterationStatement;
import eu.fbk.tools.editor.c.statement.statement.LabeledStatement;
import eu.fbk.tools.editor.c.statement.statement.StatementList;
import eu.fbk.tools.editor.c.statement.statement.SwitchStatement;
import eu.fbk.tools.editor.c.visitor.CachedCleanCVisitorAction;
import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class CleanCExprToAST
extends CachedCleanCVisitorAction {
    private ASTElementsFactory astFactory = ASTElementsFactory.eINSTANCE;
    private SysMLElementExtractor elementExtractor;

    public CleanCExprToAST(SysMLElementExtractor elementExtractor) {
        this.elementExtractor = elementExtractor;
        elementExtractor.extractAllLiterals();
    }

    public EObject getTransitionGuard(EObject inputObject) throws Exception {
        TransitionGuard tg = this.astFactory.createTransitionGuard();
        System.out.println("getTransitionGuard inputObject: " + inputObject);
        tg.setGuard(this.processPredicate(inputObject));
        return tg;
    }

    public EObject getTransitionEffect(EObject inputObject) throws Exception {
        TransitionEffect te = this.astFactory.createTransitionEffect();
        System.out.println("getTransitionEffect inputObject: " + inputObject);
        Object res = super.getOutputObject(inputObject);
        te.getStatements().addAll((Collection)res);
        return te;
    }

    public void action(LogicalOrExpression e) throws Exception {
        OrLogicOP res = this.astFactory.createOrLogicOP();
        res.getOperands().add((Object)this.processPredicate((EObject)e.getLeft()));
        res.getOperands().add((Object)this.processPredicate((EObject)e.getRight()));
        this.putOutputObject((EObject)e, res);
    }

    public void action(LogicalAndExpression e) throws Exception {
        AndLogicOP res = this.astFactory.createAndLogicOP();
        res.getOperands().add((Object)this.processPredicate((EObject)e.getLeft()));
        res.getOperands().add((Object)this.processPredicate((EObject)e.getRight()));
        this.putOutputObject((EObject)e, res);
    }

    public void action(InclusiveOrExpression e) throws Exception {
        OrOp res = this.astFactory.createOrOp();
        res.setLeft((eu.fbk.eclipse.standardtools.ast.ASTElements.Expression)this.getOutputObject((EObject)e.getLeft()));
        res.setRight((eu.fbk.eclipse.standardtools.ast.ASTElements.Expression)this.getOutputObject((EObject)e.getRight()));
        this.putOutputObject((EObject)e, res);
    }

    public void action(ExclusiveOrExpression e) throws Exception {
        XorOp res = this.astFactory.createXorOp();
        res.setLeft((eu.fbk.eclipse.standardtools.ast.ASTElements.Expression)this.getOutputObject((EObject)e.getLeft()));
        res.setRight((eu.fbk.eclipse.standardtools.ast.ASTElements.Expression)this.getOutputObject((EObject)e.getRight()));
        this.putOutputObject((EObject)e, res);
    }

    public void action(AndExpression e) throws Exception {
        AndOp res = this.astFactory.createAndOp();
        res.setLeft((eu.fbk.eclipse.standardtools.ast.ASTElements.Expression)this.getOutputObject((EObject)e.getLeft()));
        res.setRight((eu.fbk.eclipse.standardtools.ast.ASTElements.Expression)this.getOutputObject((EObject)e.getRight()));
        this.putOutputObject((EObject)e, res);
    }

    public void action(EqualityExpression e) throws Exception {
        if (e.getOp().equals("==")) {
            Equal res = this.astFactory.createEqual();
            res.setLeft((eu.fbk.eclipse.standardtools.ast.ASTElements.Expression)this.getOutputObject((EObject)e.getLeft()));
            res.setRight((eu.fbk.eclipse.standardtools.ast.ASTElements.Expression)this.getOutputObject((EObject)e.getRight()));
            this.putOutputObject((EObject)e, res);
        } else if (e.getOp().equals("!=")) {
            NotEqual res = this.astFactory.createNotEqual();
            res.setLeft((eu.fbk.eclipse.standardtools.ast.ASTElements.Expression)this.getOutputObject((EObject)e.getLeft()));
            res.setRight((eu.fbk.eclipse.standardtools.ast.ASTElements.Expression)this.getOutputObject((EObject)e.getRight()));
            this.putOutputObject((EObject)e, res);
        } else {
            throw new Exception("Operator not valid: " + e.getOp());
        }
    }

    public void action(RelationalExpression e) throws Exception {
        LessThan res = null;
        switch (e.getOp()) {
            case "<": {
                res = this.astFactory.createLessThan();
                break;
            }
            case ">": {
                res = this.astFactory.createGreaterThan();
                break;
            }
            case "<=": {
                res = this.astFactory.createLessEqualThan();
                break;
            }
            case ">=": {
                res = this.astFactory.createGreaterEqualThan();
                break;
            }
            default: {
                throw new Exception("RelationalExpression not valid: " + e.getOp());
            }
        }
        res.setLeft((eu.fbk.eclipse.standardtools.ast.ASTElements.Expression)this.getOutputObject((EObject)e.getLeft()));
        res.setRight((eu.fbk.eclipse.standardtools.ast.ASTElements.Expression)this.getOutputObject((EObject)e.getRight()));
        this.putOutputObject((EObject)e, res);
    }

    public void action(ShiftExpression e) throws Exception {
        LeftShiftOp res = null;
        switch (e.getOp()) {
            case "<<": {
                res = this.astFactory.createLeftShiftOp();
                break;
            }
            case ">>": {
                res = this.astFactory.createRigthShiftOp();
                break;
            }
            default: {
                throw new Exception("ShiftExpression not valid: " + e.getOp());
            }
        }
        res.setLeft((eu.fbk.eclipse.standardtools.ast.ASTElements.Expression)this.getOutputObject((EObject)e.getLeft()));
        res.setRight((eu.fbk.eclipse.standardtools.ast.ASTElements.Expression)this.getOutputObject((EObject)e.getRight()));
        this.putOutputObject((EObject)e, res);
    }

    public void action(AdditiveExpression e) throws Exception {
        AdditionOp res = null;
        switch (e.getOp()) {
            case "+": {
                res = this.astFactory.createAdditionOp();
                break;
            }
            case "-": {
                res = this.astFactory.createSubtractionOp();
                break;
            }
            default: {
                throw new Exception("AdditiveExpression not valid: " + e.getOp());
            }
        }
        res.setLeft((eu.fbk.eclipse.standardtools.ast.ASTElements.Expression)this.getOutputObject((EObject)e.getLeft()));
        res.setRight((eu.fbk.eclipse.standardtools.ast.ASTElements.Expression)this.getOutputObject((EObject)e.getRight()));
        this.putOutputObject((EObject)e, res);
    }

    public void action(MultiplicativeExpression e) throws Exception {
        ModuleOp res = null;
        switch (e.getOp()) {
            case "*": {
                res = this.astFactory.createMultiplicationOp();
                break;
            }
            case "/": {
                res = this.astFactory.createDivisionOp();
                break;
            }
            case "%": {
                res = this.astFactory.createModuleOp();
                break;
            }
            default: {
                throw new Exception("MultiplicativeExpression not valid: " + e.getOp());
            }
        }
        res.setLeft((eu.fbk.eclipse.standardtools.ast.ASTElements.Expression)this.getOutputObject((EObject)e.getLeft()));
        res.setRight((eu.fbk.eclipse.standardtools.ast.ASTElements.Expression)this.getOutputObject((EObject)e.getRight()));
        this.putOutputObject((EObject)e, res);
    }

    public void action(eu.fbk.tools.editor.c.expression.expression.CastExpression e) throws Exception {
        CastExpression res = this.astFactory.createCastExpression();
        res.setTypeSpecifier((TypeSpecifier)this.getOutputObject((EObject)e.getTypeSpecifier()));
        res.setExpression((eu.fbk.eclipse.standardtools.ast.ASTElements.Expression)this.getOutputObject((EObject)e.getRight()));
        this.putOutputObject((EObject)e, res);
    }

    public void action(UnaryExpression e) throws Exception {
        NotLogicOP res = null;
        switch (e.getOp()) {
            case "+": {
                res = this.astFactory.createPositiveOp();
                ((PositiveOp)res).setExpr((eu.fbk.eclipse.standardtools.ast.ASTElements.Expression)this.getOutputObject((EObject)e.getRight()));
                break;
            }
            case "-": {
                res = this.astFactory.createNegativeOp();
                ((NegativeOp)res).setExpr((eu.fbk.eclipse.standardtools.ast.ASTElements.Expression)this.getOutputObject((EObject)e.getRight()));
                break;
            }
            case "~": {
                res = this.astFactory.createComplementOp();
                ((ComplementOp)res).setExpr((eu.fbk.eclipse.standardtools.ast.ASTElements.Expression)this.getOutputObject((EObject)e.getRight()));
                break;
            }
            case "!": {
                res = this.astFactory.createNotLogicOP();
                res.setExpr((eu.fbk.eclipse.standardtools.ast.ASTElements.Expression)this.getOutputObject((EObject)e.getRight()));
                break;
            }
            default: {
                throw new Exception("UnaryExpression not valid: " + e.getOp());
            }
        }
        this.putOutputObject((EObject)e, res);
    }

    public void action(PostfixExpression e) throws Exception {
        if (e.getIndex() != null) {
            FullyQualifiedSymbol identifier = (FullyQualifiedSymbol)this.getOutputObject((EObject)e.getLeft());
            eu.fbk.eclipse.standardtools.ast.ASTElements.Expression index = (eu.fbk.eclipse.standardtools.ast.ASTElements.Expression)this.getOutputObject((EObject)e.getIndex());
            String atomName = identifier.getAtom().getName();
            ElementOfList elementOfList = this.astFactory.createElementOfList();
            elementOfList.setName(atomName);
            elementOfList.setIndex(index);
            identifier.setAtom((Atom)elementOfList);
            this.putOutputObject((EObject)e, identifier);
        } else if (e.getLeft() != null && e.getRight() == null) {
            Identifier i = (Identifier)e.getLeft();
            EList argList = null;
            if (e.getArgumentList() != null) {
                argList = e.getArgumentList().getExpression();
            }
            ASTElement res = this.cleanCFunctionCall(i, (EList<Expression>)argList);
            this.putOutputObject((EObject)e, res);
        } else if (e.getLeft() != null && e.getRight() != null) {
            throw new Exception("Dot Notation not supported.");
        }
    }

    private ASTElement cleanCFunctionCall(Identifier functionName, EList<Expression> cleanCArgList) throws Exception {
        if (functionName.equals("next")) {
            throw new Exception("\"next\" not supported.");
        }
        if (functionName.equals("abs")) {
            if (cleanCArgList == null || cleanCArgList.size() != 1) {
                this.throwMissingArgException(functionName);
            }
            AbsOp res = this.astFactory.createAbsOp();
            res.setExpr((eu.fbk.eclipse.standardtools.ast.ASTElements.Expression)this.getOutputObject((EObject)cleanCArgList.get(0)));
            return res;
        }
        if (functionName.equals("count")) {
            if (cleanCArgList == null) {
                this.throwMissingArgException(functionName);
            }
            CountOp res = this.astFactory.createCountOp();
            for (Expression arg : cleanCArgList) {
                res.getOperands().add((Object)((eu.fbk.eclipse.standardtools.ast.ASTElements.Expression)this.getOutputObject((EObject)arg)));
            }
            return res;
        }
        if (functionName.equals("min")) {
            if (cleanCArgList == null || cleanCArgList.size() != 2) {
                this.throwMissingArgException(functionName);
            }
            MinOp res = this.astFactory.createMinOp();
            res.setLeft((eu.fbk.eclipse.standardtools.ast.ASTElements.Expression)this.getOutputObject((EObject)cleanCArgList.get(0)));
            res.setRight((eu.fbk.eclipse.standardtools.ast.ASTElements.Expression)this.getOutputObject((EObject)cleanCArgList.get(1)));
            return res;
        }
        if (functionName.equals("max")) {
            if (cleanCArgList == null || cleanCArgList.size() != 2) {
                this.throwMissingArgException(functionName);
            }
            MaxOp res = this.astFactory.createMaxOp();
            res.setLeft((eu.fbk.eclipse.standardtools.ast.ASTElements.Expression)this.getOutputObject((EObject)cleanCArgList.get(0)));
            res.setRight((eu.fbk.eclipse.standardtools.ast.ASTElements.Expression)this.getOutputObject((EObject)cleanCArgList.get(1)));
            return res;
        }
        if (functionName.equals("sin") || functionName.equals("cos") || functionName.equals("tan") || functionName.equals("exp") || functionName.equals("ln") || functionName.equals("pow") || functionName.equals("floor") || functionName.equals("extend") || functionName.equals("resize") || functionName.equals("swconst") || functionName.equals("uwconst") || functionName.equals("word1") || functionName.equals("bool") || functionName.equals("toint") || functionName.equals("signed") || functionName.equals("unsigned") || functionName.equals("sizeof")) {
            throw new Exception("Unsupported Function Call: " + functionName);
        }
        throw new Exception("Unsupported generic function call: " + functionName);
    }

    private void throwMissingArgException(Identifier functionName) throws Exception {
        throw new Exception("No argument for '" + functionName + "'");
    }

    public void action(ParsExpression e) throws Exception {
        this.putOutputObject((EObject)e, this.getOutputObject((EObject)e.getExp()));
    }

    public void action(Identifier e) throws Exception {
        FullyQualifiedSymbol res = null;
        String idName = e.getName();
        if (this.elementExtractor.isInputPort(idName)) {
            System.out.println("intput port: " + idName);
            res = this.setSelfFullyQualifiedSymbol((FullyQualifiedSymbol)this.astFactory.createInputPort(), idName);
        } else if (this.elementExtractor.isOutputPort(idName)) {
            System.out.println("output port: " + idName);
            res = this.setSelfFullyQualifiedSymbol((FullyQualifiedSymbol)this.astFactory.createOutputPort(), idName);
        } else if (this.elementExtractor.isStaticPort(idName)) {
            System.out.println("output port: " + idName);
            res = this.setSelfFullyQualifiedSymbol((FullyQualifiedSymbol)this.astFactory.createParameter(), idName);
        } else if (this.elementExtractor.isStaticAttribute(idName)) {
            System.out.println("static attribute: " + idName);
            res = this.setSelfFullyQualifiedSymbol((FullyQualifiedSymbol)this.astFactory.createParameter(), idName);
        } else if (this.elementExtractor.isNonStaticAttribute(idName)) {
            System.out.println("non static attribute: " + idName);
            res = this.setSelfFullyQualifiedSymbol((FullyQualifiedSymbol)this.astFactory.createVariable(), idName);
        } else if (this.elementExtractor.isEnumLiteral(idName)) {
            res = this.setSymbol((Symbol)this.astFactory.createSetLiteral(), idName);
        } else {
            if (this.elementExtractor.isEvent(idName)) {
                throw new Exception("Events not supported yet");
            }
            if (this.isParameterListIterator(e.eContainer(), e.getName())) {
                res = this.astFactory.createLocalVariable();
                Context ctx = this.astFactory.createContext();
                ctx.getAtoms().add((Object)this.astFactory.createLocalAtom());
                ParameterListIterator it = this.astFactory.createParameterListIterator();
                it.setName(idName);
                ((LocalVariable)res).setAtom((Atom)it);
                ((LocalVariable)res).setCtx(ctx);
            } else if (this.isLocalVariable(e.getName(), e.eContainer())) {
                res = this.astFactory.createLocalVariable();
                Context ctx = this.astFactory.createContext();
                ctx.getAtoms().add((Object)this.astFactory.createLocalAtom());
                Attribute attr = this.astFactory.createAttribute();
                attr.setName(idName);
                ((LocalVariable)res).setAtom((Atom)attr);
                ((LocalVariable)res).setCtx(ctx);
            } else {
                throw new Exception("Identifier '" + idName + "' not recognized");
            }
        }
        this.putOutputObject((EObject)e, res);
    }

    private boolean isLocalVariable(String name, EObject eContainer) {
        return true;
    }

    private boolean isParameterListIterator(EObject e, String itName) {
        if (e == null) {
            return false;
        }
        if (e instanceof AllExpression) {
            return ((AllExpression)e).getIteratorId().getName().equals(itName);
        }
        return this.isParameterListIterator(e.eContainer(), itName);
    }

    private FullyQualifiedSymbol setSelfFullyQualifiedSymbol(FullyQualifiedSymbol res, String attributeName) {
        Context ctx = this.astFactory.createContext();
        ctx.getAtoms().add((Object)this.astFactory.createSelfAtom());
        res.setCtx(ctx);
        Attribute attribute = this.astFactory.createAttribute();
        attribute.setName(attributeName);
        res.setAtom((Atom)attribute);
        return res;
    }

    private Symbol setSymbol(Symbol res, String attributeName) {
        Attribute attribute = this.astFactory.createAttribute();
        attribute.setName(attributeName);
        res.setAtom((Atom)attribute);
        return res;
    }

    public void action(DecimalLiteral e) throws Exception {
        ConstInteger res = this.astFactory.createConstInteger();
        res.setValue(Integer.valueOf(e.getValue()));
        this.putOutputObject((EObject)e, res);
    }

    public void action(FloatingPointLiteral e) throws Exception {
        ConstReal res = this.astFactory.createConstReal();
        res.setValue(Double.valueOf(e.getValue()));
        this.putOutputObject((EObject)e, res);
    }

    public void action(BooleanLiteral e) throws Exception {
        TruePredicate res = null;
        switch (e.getValue()) {
            case "true": {
                res = this.astFactory.createTruePredicate();
                break;
            }
            case "false": {
                res = this.astFactory.createFalsePredicate();
                break;
            }
            default: {
                throw new Exception("BooleanLiteral not valid: " + e.getValue());
            }
        }
        this.putOutputObject((EObject)e, res);
    }

    public void action(AllExpression e) throws Exception {
        ForAllPredicate res = this.astFactory.createForAllPredicate();
        String itName = e.getIteratorId().getName();
        ParameterListIterator it = this.astFactory.createParameterListIterator();
        it.setName(itName);
        res.setIter(it);
        FullyQualifiedSymbol listId = (FullyQualifiedSymbol)this.getOutputObject((EObject)e.getListId());
        ParameterList parList = this.astFactory.createParameterList();
        parList.setName(listId.getAtom().getName());
        res.setList(parList);
        ImpliesLogicOp implLogicOp = this.astFactory.createImpliesLogicOp();
        implLogicOp.setLeft((eu.fbk.eclipse.standardtools.ast.ASTElements.Expression)this.astFactory.createTruePredicate());
        implLogicOp.setRight((eu.fbk.eclipse.standardtools.ast.ASTElements.Expression)this.getOutputObject((EObject)e.getExpression()));
        res.setPred(implLogicOp);
        res.setTypeSpecifier((TypeSpecifier)this.getOutputObject(e.getIteratorType()));
        this.putOutputObject((EObject)e, res);
    }

    private Predicate processPredicate(EObject cleanCElement) throws Exception {
        System.out.println("in processPredicate cleanCElement: " + cleanCElement);
        eu.fbk.eclipse.standardtools.ast.ASTElements.Expression astElement = (eu.fbk.eclipse.standardtools.ast.ASTElements.Expression)this.getOutputObject(cleanCElement);
        if (astElement instanceof FullyQualifiedSymbol) {
            Equal equal = this.astFactory.createEqual();
            equal.setLeft(astElement);
            equal.setRight((eu.fbk.eclipse.standardtools.ast.ASTElements.Expression)this.astFactory.createTruePredicate());
            return equal;
        }
        return (Predicate)astElement;
    }

    public void action(eu.fbk.tools.editor.c.expression.expression.TypeSpecifier e) throws Exception {
        TypeSpecifier res = this.handleTypeSpecifier(e.getName());
        this.putOutputObject((EObject)e, res);
    }

    public void action(DeclarationSpecifier e) throws Exception {
        TypeSpecifier res = this.handleTypeSpecifier(e.getName());
        this.putOutputObject((EObject)e, res);
    }

    private TypeSpecifier handleTypeSpecifier(String name) throws Exception {
        Real res = null;
        switch (name) {
            case "void": {
                res = this.astFactory.createVoid();
                break;
            }
            case "boolean": {
                res = this.astFactory.createBoolean();
                break;
            }
            case "integer": {
                res = this.astFactory.createInteger();
                break;
            }
            case "real": {
                res = this.astFactory.createReal();
                break;
            }
        }
        if (res == null) {
            this.throwUnsupportedExpressionException("TypeSpecifier");
        }
        return res;
    }

    public void action(IfStatement e) throws Exception {
        this.throwUnsupportedExpressionException("IfStatement");
    }

    public void action(AssignmentExpression e) throws Exception {
        this.throwUnsupportedExpressionException("AssignmentExpression");
    }

    public void action(AssignmentStatement e) throws Exception {
        this.throwUnsupportedExpressionException("AssignmentStatement");
    }

    public void action(StatementList e) throws Exception {
        this.throwUnsupportedExpressionException("StatementList");
    }

    public void action(CompoundStatement e) throws Exception {
        this.throwUnsupportedExpressionException("CompoundStatement");
    }

    public void action(AssertStatement e) throws Exception {
        this.throwUnsupportedExpressionException("AssertStatement");
    }

    public void action(IterationStatement e) throws Exception {
        this.throwUnsupportedExpressionException("IterationStatement");
    }

    protected void throwUnsupportedExpressionException(String objectName) throws Exception {
        throw new Exception("Statement " + objectName + " not supported as CleanC Expression.");
    }

    public void action(DeclarationList e) throws Exception {
        this.throwUnsupportedExpressionException("DeclarationList");
    }

    public void action(Declaration e) throws Exception {
        this.throwUnsupportedExpressionException("Declaration");
    }

    public void action(DeclarationSpecifiers e) throws Exception {
        this.throwUnsupportedExpressionException("DeclarationSpecifiers");
    }

    public void action(Declarator e) throws Exception {
        this.throwUnsupportedExpressionException("Declarator");
    }

    public void action(InitDeclarator e) throws Exception {
        this.throwUnsupportedExpressionException("InitDeclarator");
    }

    public void action(InitDeclaratorList e) throws Exception {
        this.throwUnsupportedExpressionException("InitDeclaratorList");
    }

    public void action(LabeledStatement e) throws Exception {
        this.throwUnsupportedExpressionException("LabeledStatement");
    }

    public void action(SwitchStatement e) throws Exception {
        this.throwUnsupportedExpressionException("SwitchStatement");
    }

    public void action(BreakStatement e) throws Exception {
        this.throwUnsupportedExpressionException("BreakStatement");
    }

    public void action(ForStatement e) throws Exception {
        this.throwUnsupportedExpressionException("ForStatement");
    }

    public void action(ExpressionStatement e) throws Exception {
        if (e.getExpression() != null) {
            this.throwUnsupportedExpressionException("ExpressionStatement");
        }
    }

    public void action(Initializer e) throws Exception {
        this.throwUnsupportedExpressionException("Initializer");
    }

    public void action(InitializerList e) throws Exception {
        this.throwUnsupportedExpressionException("InitializerList");
    }
}

