/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.StateMachineTranslatorToSmv.core.stateMachineModelTranslator.visitors;

import eu.fbk.eclipse.standardtools.StateMachineTranslatorToSmv.core.utils.AstNameResolutor;
import eu.fbk.eclipse.standardtools.ast.ASTElements.ASTElementsPackage;
import eu.fbk.eclipse.standardtools.ast.ASTElements.AbsOp;
import eu.fbk.eclipse.standardtools.ast.ASTElements.AdditionOp;
import eu.fbk.eclipse.standardtools.ast.ASTElements.AndLogicOP;
import eu.fbk.eclipse.standardtools.ast.ASTElements.AndOp;
import eu.fbk.eclipse.standardtools.ast.ASTElements.AssertStatement;
import eu.fbk.eclipse.standardtools.ast.ASTElements.AssignStatement;
import eu.fbk.eclipse.standardtools.ast.ASTElements.Atom;
import eu.fbk.eclipse.standardtools.ast.ASTElements.Attribute;
import eu.fbk.eclipse.standardtools.ast.ASTElements.BinaryProposition;
import eu.fbk.eclipse.standardtools.ast.ASTElements.Boolean;
import eu.fbk.eclipse.standardtools.ast.ASTElements.CaseStatement;
import eu.fbk.eclipse.standardtools.ast.ASTElements.CastExpression;
import eu.fbk.eclipse.standardtools.ast.ASTElements.ComplementOp;
import eu.fbk.eclipse.standardtools.ast.ASTElements.ConstHexadecimal;
import eu.fbk.eclipse.standardtools.ast.ASTElements.ConstInteger;
import eu.fbk.eclipse.standardtools.ast.ASTElements.ConstOctal;
import eu.fbk.eclipse.standardtools.ast.ASTElements.ConstReal;
import eu.fbk.eclipse.standardtools.ast.ASTElements.Context;
import eu.fbk.eclipse.standardtools.ast.ASTElements.CountOp;
import eu.fbk.eclipse.standardtools.ast.ASTElements.DeclarationStatement;
import eu.fbk.eclipse.standardtools.ast.ASTElements.DivisionOp;
import eu.fbk.eclipse.standardtools.ast.ASTElements.ElementOfList;
import eu.fbk.eclipse.standardtools.ast.ASTElements.Equal;
import eu.fbk.eclipse.standardtools.ast.ASTElements.Event;
import eu.fbk.eclipse.standardtools.ast.ASTElements.EventCall;
import eu.fbk.eclipse.standardtools.ast.ASTElements.EventRecept;
import eu.fbk.eclipse.standardtools.ast.ASTElements.FalsePredicate;
import eu.fbk.eclipse.standardtools.ast.ASTElements.ForAllPredicate;
import eu.fbk.eclipse.standardtools.ast.ASTElements.ForAllStatement;
import eu.fbk.eclipse.standardtools.ast.ASTElements.ForStatement;
import eu.fbk.eclipse.standardtools.ast.ASTElements.FullyQualifiedSymbol;
import eu.fbk.eclipse.standardtools.ast.ASTElements.GreaterEqualThan;
import eu.fbk.eclipse.standardtools.ast.ASTElements.GreaterThan;
import eu.fbk.eclipse.standardtools.ast.ASTElements.ITEStatement;
import eu.fbk.eclipse.standardtools.ast.ASTElements.ITStatement;
import eu.fbk.eclipse.standardtools.ast.ASTElements.ImpliesLogicOp;
import eu.fbk.eclipse.standardtools.ast.ASTElements.InputPort;
import eu.fbk.eclipse.standardtools.ast.ASTElements.Integer;
import eu.fbk.eclipse.standardtools.ast.ASTElements.LeftShiftOp;
import eu.fbk.eclipse.standardtools.ast.ASTElements.LessEqualThan;
import eu.fbk.eclipse.standardtools.ast.ASTElements.LessThan;
import eu.fbk.eclipse.standardtools.ast.ASTElements.LocalAtom;
import eu.fbk.eclipse.standardtools.ast.ASTElements.LocalVariable;
import eu.fbk.eclipse.standardtools.ast.ASTElements.MaxOp;
import eu.fbk.eclipse.standardtools.ast.ASTElements.MinOp;
import eu.fbk.eclipse.standardtools.ast.ASTElements.ModuleOp;
import eu.fbk.eclipse.standardtools.ast.ASTElements.MultiplicationOp;
import eu.fbk.eclipse.standardtools.ast.ASTElements.NAryLogicOP;
import eu.fbk.eclipse.standardtools.ast.ASTElements.NegativeOp;
import eu.fbk.eclipse.standardtools.ast.ASTElements.NotEqual;
import eu.fbk.eclipse.standardtools.ast.ASTElements.NotLogicOP;
import eu.fbk.eclipse.standardtools.ast.ASTElements.OrLogicOP;
import eu.fbk.eclipse.standardtools.ast.ASTElements.OrOp;
import eu.fbk.eclipse.standardtools.ast.ASTElements.OutputPort;
import eu.fbk.eclipse.standardtools.ast.ASTElements.Parameter;
import eu.fbk.eclipse.standardtools.ast.ASTElements.ParameterList;
import eu.fbk.eclipse.standardtools.ast.ASTElements.ParameterListIterator;
import eu.fbk.eclipse.standardtools.ast.ASTElements.PositiveOp;
import eu.fbk.eclipse.standardtools.ast.ASTElements.Predicate;
import eu.fbk.eclipse.standardtools.ast.ASTElements.Real;
import eu.fbk.eclipse.standardtools.ast.ASTElements.RigthShiftOp;
import eu.fbk.eclipse.standardtools.ast.ASTElements.SelfAtom;
import eu.fbk.eclipse.standardtools.ast.ASTElements.SetLiteral;
import eu.fbk.eclipse.standardtools.ast.ASTElements.StateLiteral;
import eu.fbk.eclipse.standardtools.ast.ASTElements.Statement;
import eu.fbk.eclipse.standardtools.ast.ASTElements.SubComponent;
import eu.fbk.eclipse.standardtools.ast.ASTElements.SubtractionOp;
import eu.fbk.eclipse.standardtools.ast.ASTElements.SwitchCaseStatement;
import eu.fbk.eclipse.standardtools.ast.ASTElements.Symbol;
import eu.fbk.eclipse.standardtools.ast.ASTElements.TransitionEffect;
import eu.fbk.eclipse.standardtools.ast.ASTElements.TransitionGuard;
import eu.fbk.eclipse.standardtools.ast.ASTElements.TruePredicate;
import eu.fbk.eclipse.standardtools.ast.ASTElements.TypeSpecifier;
import eu.fbk.eclipse.standardtools.ast.ASTElements.UnaryLogicOP;
import eu.fbk.eclipse.standardtools.ast.ASTElements.Variable;
import eu.fbk.eclipse.standardtools.ast.ASTElements.Void;
import eu.fbk.eclipse.standardtools.ast.ASTElements.XorOp;
import eu.fbk.eclipse.standardtools.ast.utils.AstElementExtractor;
import eu.fbk.eclipse.standardtools.ast.visitors.ast.CachedAstVisitorAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class ASTToK2
extends CachedAstVisitorAction {
    private AstElementExtractor astElementExtractor;
    private AstNameResolutor astNameResolutor;

    public ASTToK2(AstElementExtractor astElementExtractor, AstNameResolutor astNameResolutor) {
        this.astElementExtractor = astElementExtractor;
        this.astNameResolutor = astNameResolutor;
    }

    private String processConstant(String varName, String typeName) {
        return "(const |" + varName + "| " + typeName + ")";
    }

    private String processVariable(String varName, String typeName) {
        return "(var |" + varName + "| " + typeName + ")";
    }

    private String processCastExpresson(String type, String expr) {
        String artimeticCast = "0";
        return "(typecast " + type + " " + expr + " " + artimeticCast + " )";
    }

    private String processOperation(String operator, String expr) {
        return "(op " + operator + " " + expr + ")";
    }

    private String processOperation(String operator, String expr1, String expr2) {
        return "(op " + operator + " " + expr1 + " " + expr2 + ")";
    }

    private String processAssignment(String expr1, String expr2, boolean addNewLine) {
        return "(assign " + expr1 + " " + expr2 + ")" + (addNewLine ? "\n" : "");
    }

    private String processAssume(String condition) {
        String res = "(assume " + condition + ")\n";
        return res;
    }

    private String processAssert(AssertStatement o, Predicate predicate) throws Exception {
        String uniqueName = this.getUniqueName((EObject)o);
        String endLabel = this.createEndLabel(uniqueName);
        String[] labels = new String[]{this.createTrueConditionLabel(uniqueName), endLabel};
        String errorLabel = this.createErrorLabel(uniqueName);
        String elseStatement = "(! " + this.processLabel(errorLabel, false) + " :error " + uniqueName + "-failure)\n";
        String condition = (String)this.getOutputObject((EObject)predicate);
        String resultVar = this.getResultVarName((EObject)predicate);
        String res = "";
        res = res.concat(this.processJumpLabels(labels));
        res = res.concat(this.processITstatement(condition, resultVar, elseStatement, labels[0], endLabel, true));
        res = res.concat(this.processLabel(endLabel, true));
        return res;
    }

    private String createErrorLabel(String uniqueName) {
        return String.valueOf(uniqueName) + ".error";
    }

    private String createEndLabel(String uniqueName) {
        return String.valueOf(uniqueName) + ".end";
    }

    private String retrieveSysMLTypeAsK2Type(FullyQualifiedSymbol o) throws Exception {
        String typeName = this.astElementExtractor.retrieveSysMLTypeName(o);
        return this.returnK2Type(typeName);
    }

    private String returnK2Type(String typeName) {
        if (typeName.equals("Real")) {
            return "real";
        }
        if (typeName.equals("Boolean")) {
            return "bool";
        }
        if (typeName.equals("Integer")) {
            return "int";
        }
        return typeName;
    }

    private String processJumpLabels(String[] labels) {
        String res = "";
        String[] stringArray = labels;
        int n = labels.length;
        int n2 = 0;
        while (n2 < n) {
            String label = stringArray[n2];
            res = res.concat(String.valueOf(this.processLabel(label, false)) + " ");
            ++n2;
        }
        return "(jump " + res + ")" + "\n";
    }

    private String processLabel(String label, boolean addNewLine) {
        return String.valueOf(addNewLine ? "\n" : "") + "(label " + label + ")" + (addNewLine ? "\n" : "");
    }

    private String processITEStatement(Predicate condition, EList<Statement> thenStatementList, String thenLabel, EList<Statement> elseStatementList, String elseLabel, String thenEndLabel, String elseEndLabel) throws Exception {
        String k2Condition = (String)this.getOutputObject((EObject)condition);
        String k2ResultVar = this.getResultVarName((EObject)condition);
        String k2ThenStatement = "";
        for (Statement thenStmt : thenStatementList) {
            k2ThenStatement = k2ThenStatement.concat((String)this.getOutputObject((EObject)thenStmt));
        }
        String k2ElseStatement = "";
        for (Statement elseStmt : elseStatementList) {
            k2ElseStatement = k2ElseStatement.concat((String)this.getOutputObject((EObject)elseStmt));
        }
        String res = this.processITEstatement(k2Condition, k2ResultVar, k2ThenStatement, thenLabel, k2ElseStatement, elseLabel, thenEndLabel, elseEndLabel);
        return res;
    }

    private String processITstatement(String k2Condition, String resultConditionVar, String k2ThenStatement, String labelThen, String labelEnd, boolean invertCondition) {
        String res = "";
        res = res.concat(this.processLabel(labelThen, true));
        if (resultConditionVar != null) {
            res = res.concat(k2Condition);
            k2Condition = resultConditionVar;
        }
        res = res.concat(this.processAssume(invertCondition ? this.processOperation("not", k2Condition) : k2Condition));
        res = res.concat(k2ThenStatement);
        res = res.concat(this.processJumpLabel(labelEnd));
        return res;
    }

    private String processITEstatement(String k2Condition, String resultConditionVar, String k2ThenStatement, String labelThen, String k2ElseStatement, String labelElse, String labelThenEnd, String labelThenElse) {
        String res = "";
        String condition = k2Condition;
        res = res.concat(this.processLabel(labelThen, true));
        if (resultConditionVar != null) {
            condition = resultConditionVar;
        }
        res = res.concat(this.processAssume(condition));
        res = res.concat(k2ThenStatement);
        res = res.concat(this.processJumpLabel(labelThenEnd));
        res = res.concat(this.processLabel(labelElse, true));
        if (resultConditionVar != null) {
            condition = resultConditionVar;
        }
        res = res.concat(this.processAssume(this.processOperation("not", condition)));
        res = res.concat(k2ElseStatement);
        res = res.concat(this.processJumpLabel(labelThenElse));
        return res;
    }

    private String processJumpLabel(String label) {
        return "(jump " + this.processLabel(label, false) + ")\n";
    }

    private String retrieveLocalTypeAsK2Type(LocalVariable o) throws Exception {
        String typeName = "";
        typeName = o.getAtom() instanceof ParameterListIterator ? this.retrieveParameterListIteratorTypeName(o) : this.retrieveLocalTypeName(o);
        return typeName;
    }

    private String retrieveParameterListIteratorTypeName(LocalVariable o) throws Exception {
        LocalVariable elem = o;
        while (elem.eContainer() != null) {
            if ((elem = elem.eContainer()) instanceof ForAllPredicate && this.sameName((Atom)((ForAllPredicate)elem).getIter(), o.getAtom())) {
                return this.retrieveTypeSpecifier(((ForAllPredicate)elem).getTypeSpecifier());
            }
            if (!(elem instanceof ForAllStatement) || !this.sameName((Atom)((ForAllStatement)elem).getIter(), o.getAtom())) continue;
            return this.retrieveTypeSpecifier(((ForAllStatement)elem).getTypeSpecifier());
        }
        return null;
    }

    private boolean sameName(Atom atom1, Atom atom2) {
        return this.getAtomName(atom1).equals(this.getAtomName(atom2));
    }

    private String retrieveLocalTypeName(LocalVariable o) throws Exception {
        LocalVariable elem = o;
        while (elem.eContainer() != null) {
            elem = elem.eContainer();
        }
        TreeIterator allElements = elem.eAllContents();
        if (allElements != null) {
            Collection declStatements = EcoreUtil.getObjectsByType(ASTToK2.iterator2Collection(allElements), (EClassifier)ASTElementsPackage.eINSTANCE.getDeclarationStatement());
            for (DeclarationStatement decl : declStatements) {
                if (!this.sameName(o.getAtom(), decl.getVariable().getAtom())) continue;
                return (String)this.getOutputObject((EObject)decl.getTypeSpecifier());
            }
        }
        return null;
    }

    private static <T> Collection<T> iterator2Collection(Iterator<T> iter) {
        ArrayList<T> list = new ArrayList<T>();
        while (iter.hasNext()) {
            T item = iter.next();
            list.add(item);
        }
        return list;
    }

    private String processMapAt(String arrayName, String indexName) {
        return "(mapat " + arrayName + " " + indexName + ")";
    }

    private String processIncrVar(String varName) {
        return this.processAssignment(varName, this.processOperation("add", varName, this.processConstant("1", "int")), true);
    }

    private String assignBoolVar(String varName, String initValue) {
        return this.processAssignment(varName, this.processConstant(initValue, "bool"), true);
    }

    private String assignIntVar(String varName, String initValue) {
        return this.processAssignment(varName, this.processConstant(initValue, "int"), true);
    }

    private List<String> returnDeclarations(EObject elem) throws Exception {
        ArrayList<String> declarations = new ArrayList<String>();
        TreeIterator allElements = elem.eAllContents();
        if (allElements != null) {
            this.handleForAllPredicateDeclarations(elem, declarations);
            this.handleForAllStatementDeclarations(elem, declarations);
            this.handleDeclarationStatements(elem, declarations);
            this.handleResultVariablesDeclarations(elem, declarations);
        }
        return declarations;
    }

    private void handleResultVariablesDeclarations(EObject elem, List<String> declarations) throws Exception {
        Collection elements = ASTToK2.iterator2Collection(elem.eAllContents());
        Collection predicates = EcoreUtil.getObjectsByType(elements, (EClassifier)ASTElementsPackage.eINSTANCE.getPredicate());
        for (Predicate predicate : predicates) {
            String res_var = this.getResultVarName((EObject)predicate);
            if (res_var == null || predicate instanceof ImpliesLogicOp && ((ImpliesLogicOp)predicate).getLeft() instanceof TruePredicate) continue;
            declarations.add(this.processVariable(res_var, "bool"));
        }
    }

    private void handleDeclarationStatements(EObject elem, List<String> declarations) throws Exception {
        Collection declarationStatements = EcoreUtil.getObjectsByType((Collection)elem.eContents(), (EClassifier)ASTElementsPackage.eINSTANCE.getDeclarationStatement());
        for (DeclarationStatement declarationStatement : declarationStatements) {
            String res = this.processLocalVariableDeclaration(declarationStatement.getVariable());
            declarations.add(res);
        }
    }

    private void handleForAllStatementDeclarations(EObject elem, List<String> declarations) throws Exception {
        Collection forAllStatements = EcoreUtil.getObjectsByType((Collection)elem.eContents(), (EClassifier)ASTElementsPackage.eINSTANCE.getForAllStatement());
        for (ForAllStatement forAllStatement : forAllStatements) {
            String uniqueName = this.getUniqueName((EObject)forAllStatement);
            String index = String.valueOf(uniqueName) + "_i";
            declarations.add(this.processVariable(index, "int"));
            declarations.add(this.processVariable((String)this.getOutputObject((EObject)forAllStatement.getIter()), (String)this.getOutputObject((EObject)forAllStatement.getTypeSpecifier())));
        }
    }

    private void handleForAllPredicateDeclarations(EObject elem, List<String> declarations) throws Exception {
        Collection elements = ASTToK2.iterator2Collection(elem.eAllContents());
        Collection forAllPredicates = EcoreUtil.getObjectsByType(elements, (EClassifier)ASTElementsPackage.eINSTANCE.getForAllPredicate());
        for (ForAllPredicate forAllPredicate : forAllPredicates) {
            String uniqueName = this.getUniqueName((EObject)forAllPredicate);
            String index = String.valueOf(uniqueName) + "_i";
            declarations.add(this.processVariable(index, "int"));
            declarations.add(this.processVariable((String)this.getOutputObject((EObject)forAllPredicate.getIter()), (String)this.getOutputObject((EObject)forAllPredicate.getTypeSpecifier())));
        }
    }

    public void action(SelfAtom o) throws Exception {
    }

    public void action(Attribute o) throws Exception {
        String attributeName = this.astNameResolutor.getUniqueLocalVariableName((Atom)o);
        attributeName = attributeName == null ? this.getAtomName((Atom)o) : "|" + attributeName + "|";
        this.putOutputObject((EObject)o, attributeName);
    }

    public void action(Context o) throws Exception {
        Atom contextAtom;
        if (o.getAtoms().isEmpty()) {
            return;
        }
        if (o.getAtoms().size() > 1) {
            this.unsupportedDotNotationException();
        }
        if (!((contextAtom = (Atom)o.getAtoms().get(0)) instanceof SelfAtom) && !(contextAtom instanceof LocalAtom)) {
            this.unsupportedDotNotationException();
        }
    }

    private void unsupportedDotNotationException() throws Exception {
        throw new Exception("Dot notation not supported");
    }

    public void action(ConstInteger o) throws Exception {
        String res = this.processConstant(String.valueOf(o.getValue()), "int");
        this.putOutputObject((EObject)o, res);
    }

    public void action(SetLiteral o) throws Exception {
        String literalName = (String)this.getOutputObject((EObject)o.getAtom());
        String enumName = this.astElementExtractor.returnEnumTypeName((Symbol)o);
        String res = this.processConstant(literalName, enumName);
        this.putOutputObject((EObject)o, res);
    }

    public void action(StateLiteral o) throws Exception {
        String literalName = (String)this.getOutputObject((EObject)o.getAtom());
        String enumName = this.astElementExtractor.returnEnumTypeName((Symbol)o);
        String res = this.processConstant(literalName, enumName);
        this.putOutputObject((EObject)o, res);
    }

    public void action(Parameter o) throws Exception {
        String typeName = this.retrieveSysMLTypeAsK2Type((FullyQualifiedSymbol)o);
        String varName = (String)this.getOutputObject((EObject)o.getAtom());
        String res = this.processConstant(varName, typeName);
        this.putOutputObject((EObject)o, res);
    }

    public void action(Variable o) throws Exception {
        String varName = (String)this.getOutputObject((EObject)o.getAtom());
        this.putOutputObject((EObject)o, varName);
    }

    private String processLocalVariableDeclaration(LocalVariable v) throws Exception {
        String typeName = this.retrieveLocalTypeAsK2Type(v);
        String varName = (String)this.getOutputObject((EObject)v.getAtom());
        return this.processVariable(varName, typeName);
    }

    public void action(TruePredicate o) throws Exception {
        String res = this.processConstant("true", "bool");
        this.putOutputObject((EObject)o, res);
    }

    public void action(FalsePredicate o) throws Exception {
        String res = this.processConstant("false", "bool");
        this.putOutputObject((EObject)o, res);
    }

    public void action(NotLogicOP o) throws Exception {
        String res = this.handleOperation((EObject)o, "not");
        this.putOutputObject((EObject)o, res);
    }

    private String getChildResVarValue(UnaryLogicOP o) throws Exception {
        return this.handleResVar((EObject)o.getExpr());
    }

    private String handleResVar(EObject o) throws Exception {
        String expr = (String)this.getOutputObject(o);
        String childResVar = this.getResultVarName(o);
        if (childResVar != null) {
            return expr;
        }
        return "";
    }

    private String handleOperation(EObject o, String operationName) throws Exception {
        String res = "";
        String currResultVarName = this.createResultVarName(o);
        if (o instanceof UnaryLogicOP) {
            res = res.concat(this.getChildResVarValue((UnaryLogicOP)o));
            res = res.concat(this.processAssignment(currResultVarName, this.processOperation(operationName, this.getOutputOrResultVar((EObject)((UnaryLogicOP)o).getExpr())), true));
        } else if (o instanceof BinaryProposition) {
            res = res.concat(this.handleChildResVar((BinaryProposition)o));
            String operation = "";
            operation = operationName.equals("ne") ? this.processOperation("not", this.processOperation("equal", this.getOutputOrResultVar((EObject)((BinaryProposition)o).getLeft()), this.getOutputOrResultVar((EObject)((BinaryProposition)o).getRight()))) : this.processOperation(operationName, this.getOutputOrResultVar((EObject)((BinaryProposition)o).getLeft()), this.getOutputOrResultVar((EObject)((BinaryProposition)o).getRight()));
            res = res.concat(this.processAssignment(currResultVarName, operation, true));
        } else if (o instanceof NAryLogicOP) {
            EList predicates = ((NAryLogicOP)o).getOperands();
            if (predicates.size() != 2) {
                throw new Exception("NAryLogicOP with " + predicates.size() + " predicates is not supported.");
            }
            res = res.concat(this.handleChildResVar((NAryLogicOP)o));
            res = res.concat(this.processAssignment(currResultVarName, this.processOperation(operationName, this.getOutputOrResultVar((EObject)predicates.get(0)), this.getOutputOrResultVar((EObject)predicates.get(1))), true));
        } else {
            throw new Exception("Unsupported ASTElement " + o);
        }
        return res;
    }

    private String handleChildResVar(BinaryProposition o) throws Exception {
        String res = "";
        if (!(res = res.concat(this.handleResVar((EObject)o.getLeft()))).equals("") && !res.substring(res.length() - 1).equals("\n")) {
            res = res.concat("\n");
        }
        res = res.concat(this.handleResVar((EObject)o.getRight()));
        return res;
    }

    private String handleChildResVar(NAryLogicOP o) throws Exception {
        String res = "";
        if (!(res = res.concat(this.handleResVar((EObject)o.getOperands().get(0)))).equals("") && !res.substring(res.length() - 1).equals("\n")) {
            res = res.concat("\n");
        }
        res = res.concat(this.handleResVar((EObject)o.getOperands().get(1)));
        return res;
    }

    private String getOutputOrResultVar(EObject o) throws Exception {
        String childResVar = this.getResultVarName(o);
        if (childResVar != null) {
            return childResVar;
        }
        return (String)this.getOutputObject(o);
    }

    private String createResultVarName(EObject o) throws Exception {
        return "|" + this.astNameResolutor.createResultVariableName(o) + "|";
    }

    private void setResultVarName(EObject o, String varName) throws Exception {
        this.astNameResolutor.setResultVariableName(o, varName);
    }

    private String getResultVarName(EObject o) throws Exception {
        return this.astNameResolutor.getResultVariableName(o);
    }

    public void action(ImpliesLogicOp o) throws Exception {
        if (o.getLeft() instanceof TruePredicate) {
            String res = "";
            this.setResultVarName((EObject)o, this.getResultVarName((EObject)o.getRight()));
            res = res.concat(this.handleResVar((EObject)o.getRight()));
            this.putOutputObject((EObject)o, res);
        } else {
            String currResultVarName = this.createResultVarName((EObject)o);
            String res = "";
            res = res.concat(this.handleResVar((EObject)o.getLeft()));
            res = res.concat(this.handleResVar((EObject)o.getRight()));
            String leftExpr = this.getOutputOrResultVar((EObject)o.getLeft());
            String rightExpr = this.getOutputOrResultVar((EObject)o.getRight());
            String notLeftExpr = this.processOperation("not", leftExpr);
            res = res.concat(this.processAssignment(currResultVarName, this.processOperation("or", notLeftExpr, rightExpr), true));
            this.putOutputObject((EObject)o, res);
        }
    }

    public void action(AndLogicOP o) throws Exception {
        String res = this.handleOperation((EObject)o, "and");
        this.putOutputObject((EObject)o, res);
    }

    public void action(OrLogicOP o) throws Exception {
        String res = this.handleOperation((EObject)o, "or");
        this.putOutputObject((EObject)o, res);
    }

    public void action(Equal o) throws Exception {
        String res = this.handleOperation((EObject)o, "eq");
        this.putOutputObject((EObject)o, res);
    }

    public void action(LessThan o) throws Exception {
        String res = this.handleOperation((EObject)o, "lt");
        this.putOutputObject((EObject)o, res);
    }

    public void action(LessEqualThan o) throws Exception {
        String res = this.handleOperation((EObject)o, "le");
        this.putOutputObject((EObject)o, res);
    }

    public void action(GreaterThan o) throws Exception {
        String res = this.handleOperation((EObject)o, "gt");
        this.putOutputObject((EObject)o, res);
    }

    public void action(GreaterEqualThan o) throws Exception {
        String res = this.handleOperation((EObject)o, "ge");
        this.putOutputObject((EObject)o, res);
    }

    public void action(AssignStatement o) throws Exception {
        String left = (String)this.getOutputObject((EObject)o.getLhs());
        String right = this.getOutputOrResultVar((EObject)o.getRhs());
        String res = "";
        res = res.concat(this.handleResVar((EObject)o.getRhs()));
        res = res.concat(this.processAssignment(left, right, true));
        this.putOutputObject((EObject)o, res);
    }

    public void action(TransitionGuard o) throws Exception {
        String res = "";
        String declList = "\t(locals ";
        for (String decl : this.returnDeclarations((EObject)o)) {
            declList = String.valueOf(declList.concat(decl)) + " ";
        }
        declList = declList.concat(")\n");
        res = res.concat(declList);
        String childPredicate = "";
        childPredicate = childPredicate.concat(this.handleResVar((EObject)o.getGuard()));
        childPredicate = childPredicate.concat(this.processAssignment("|ret|", this.getOutputOrResultVar((EObject)o.getGuard()), true));
        childPredicate = childPredicate.replaceAll("\n", "\n\t\t");
        String stmtList = "\t(seq\n\t\t" + childPredicate + ")";
        res = res.concat(stmtList);
        this.putOutputObject((EObject)o, res);
    }

    public void action(TransitionEffect o) throws Exception {
        String declList = "";
        String stmtList = this.processStatementsList((EList<Statement>)o.getStatements());
        for (String decl : this.returnDeclarations((EObject)o)) {
            declList = String.valueOf(declList.concat(decl)) + " ";
        }
        declList = "\t(locals " + declList.replaceAll("\n", "\n\t\t") + ")\n";
        stmtList = "\t(seq\n\t\t" + stmtList.replaceAll("\n", "\n\t\t") + ")\n";
        String res = declList.concat(stmtList);
        this.putOutputObject((EObject)o, res);
    }

    private String processStatementsList(EList<Statement> statements) throws Exception {
        String stmtList = "";
        for (Statement stmt : statements) {
            String smvStmt = (String)this.getOutputObject((EObject)stmt);
            if (smvStmt == "") continue;
            stmtList = stmtList.concat(smvStmt);
        }
        return stmtList;
    }

    public void action(ConstReal o) throws Exception {
        String res = this.processConstant(String.valueOf(o.getValue()), "real");
        this.putOutputObject((EObject)o, res);
    }

    public void action(ConstHexadecimal o) throws Exception {
        throw new Exception("ConstHexadecimal not supported in K2.");
    }

    public void action(ConstOctal o) throws Exception {
        throw new Exception("ConstOctal not supported in K2.");
    }

    public void action(NotEqual o) throws Exception {
        String res = this.handleOperation((EObject)o, "ne");
        this.putOutputObject((EObject)o, res);
    }

    public void action(PositiveOp o) throws Exception {
        throw new Exception("PositiveOp not supported in K2.");
    }

    public void action(NegativeOp o) throws Exception {
        throw new Exception("NegativeOp not supported in K2.");
    }

    public void action(AbsOp o) throws Exception {
        throw new Exception("AbsOp not supported in K2.");
    }

    public void action(CountOp o) throws Exception {
        throw new Exception("CountOp not supported in K2.");
    }

    public void action(MinOp o) throws Exception {
        throw new Exception("MinOp not supported in K2.");
    }

    public void action(MaxOp o) throws Exception {
        throw new Exception("MaxOp not supported in K2.");
    }

    public void action(AdditionOp o) throws Exception {
        String leftExpr = (String)this.getOutputObject((EObject)o.getLeft());
        String rightExpr = (String)this.getOutputObject((EObject)o.getRight());
        String res = this.processOperation("add", leftExpr, rightExpr);
        this.putOutputObject((EObject)o, res);
    }

    public void action(SubtractionOp o) throws Exception {
        String leftExpr = (String)this.getOutputObject((EObject)o.getLeft());
        String rightExpr = (String)this.getOutputObject((EObject)o.getRight());
        String res = this.processOperation("sub", leftExpr, rightExpr);
        this.putOutputObject((EObject)o, res);
    }

    public void action(MultiplicationOp o) throws Exception {
        String leftExpr = (String)this.getOutputObject((EObject)o.getLeft());
        String rightExpr = (String)this.getOutputObject((EObject)o.getRight());
        String res = this.processOperation("mul", leftExpr, rightExpr);
        this.putOutputObject((EObject)o, res);
    }

    public void action(DivisionOp o) throws Exception {
        String leftExpr = (String)this.getOutputObject((EObject)o.getLeft());
        String rightExpr = (String)this.getOutputObject((EObject)o.getRight());
        String res = this.processOperation("div", leftExpr, rightExpr);
        this.putOutputObject((EObject)o, res);
    }

    public void action(ModuleOp o) throws Exception {
        throw new Exception("ModuleOp not supported in K2.");
    }

    public void action(ComplementOp o) throws Exception {
        String expr = (String)this.getOutputObject((EObject)o.getExpr());
        String res = this.processOperation("bitnot", expr);
        this.putOutputObject((EObject)o, res);
    }

    public void action(LeftShiftOp o) throws Exception {
        String leftExpr = (String)this.getOutputObject((EObject)o.getLeft());
        String rightExpr = (String)this.getOutputObject((EObject)o.getRight());
        String res = this.processOperation("lshift", leftExpr, rightExpr);
        this.putOutputObject((EObject)o, res);
    }

    public void action(RigthShiftOp o) throws Exception {
        String leftExpr = (String)this.getOutputObject((EObject)o.getLeft());
        String rightExpr = (String)this.getOutputObject((EObject)o.getRight());
        String res = this.processOperation("rshift", leftExpr, rightExpr);
        this.putOutputObject((EObject)o, res);
    }

    public void action(AndOp o) throws Exception {
        String leftExpr = (String)this.getOutputObject((EObject)o.getLeft());
        String rightExpr = (String)this.getOutputObject((EObject)o.getRight());
        String res = this.processOperation("bitand", leftExpr, rightExpr);
        this.putOutputObject((EObject)o, res);
    }

    public void action(OrOp o) throws Exception {
        String leftExpr = (String)this.getOutputObject((EObject)o.getLeft());
        String rightExpr = (String)this.getOutputObject((EObject)o.getRight());
        String res = this.processOperation("bitor", leftExpr, rightExpr);
        this.putOutputObject((EObject)o, res);
    }

    public void action(XorOp o) throws Exception {
        String leftExpr = (String)this.getOutputObject((EObject)o.getLeft());
        String rightExpr = (String)this.getOutputObject((EObject)o.getRight());
        String res = this.processOperation("bitxor", leftExpr, rightExpr);
        this.putOutputObject((EObject)o, res);
    }

    public void action(InputPort o) throws Exception {
        String varName = (String)this.getOutputObject((EObject)o.getAtom());
        this.putOutputObject((EObject)o, varName);
    }

    public void action(OutputPort o) throws Exception {
        String varName = (String)this.getOutputObject((EObject)o.getAtom());
        this.putOutputObject((EObject)o, varName);
    }

    public void action(SubComponent o) throws Exception {
        throw new Exception("Node '" + o + "' (dot notation) not supported.");
    }

    public void action(Event o) throws Exception {
        throw new Exception("Events not supported yet.");
    }

    public void action(EventCall o) throws Exception {
        throw new Exception("Events not supported yet.");
    }

    public void action(EventRecept o) throws Exception {
        throw new Exception("Events not supported yet.");
    }

    public void action(ITStatement o) throws Exception {
        String uniqueName = this.getUniqueName((EObject)o);
        String[] labels = this.createConditionLabels(uniqueName);
        String endLabel = this.createEndLabel(uniqueName);
        String condition = (String)this.getOutputObject((EObject)o.getCondition());
        String resultVar = this.getResultVarName((EObject)o.getCondition());
        String res = "";
        if (resultVar != null) {
            res = res.concat(condition);
        }
        res = res.concat(this.processJumpLabels(labels));
        res = res.concat(this.processITEStatement(o.getCondition(), (EList<Statement>)o.getThen(), labels[0], (EList<Statement>)new BasicEList(), labels[1], endLabel, endLabel));
        res = res.concat(this.processLabel(endLabel, true));
        this.putOutputObject((EObject)o, res);
    }

    public void action(ITEStatement o) throws Exception {
        String uniqueName = this.getUniqueName((EObject)o);
        String[] labels = this.createConditionLabels(uniqueName);
        String endLabel = this.createEndLabel(uniqueName);
        String condition = (String)this.getOutputObject((EObject)o.getCondition());
        String resultVar = this.getResultVarName((EObject)o.getCondition());
        String res = "";
        if (resultVar != null) {
            res = res.concat(condition);
        }
        res = res.concat(this.processJumpLabels(labels));
        res = res.concat(this.processITEStatement(o.getCondition(), (EList<Statement>)o.getThen(), labels[0], (EList<Statement>)o.getElseStmt(), labels[1], endLabel, endLabel));
        res = res.concat(this.processLabel(endLabel, true));
        this.putOutputObject((EObject)o, res);
    }

    public void action(AssertStatement o) throws Exception {
        String res = this.processAssert(o, o.getCondition());
        this.putOutputObject((EObject)o, res);
    }

    public void action(ForAllPredicate o) throws Exception {
        String iterator = (String)this.getOutputObject((EObject)o.getIter());
        String list = (String)this.getOutputObject((EObject)o.getList());
        String uniqueName = this.getUniqueName((EObject)o);
        String[] labels = this.createConditionLabels(uniqueName);
        String initLabel = this.createStartLabel(uniqueName);
        String endLabel = this.createEndLabel(uniqueName);
        String currResultVarName = this.createResultVarName((EObject)o);
        String index = String.valueOf(uniqueName) + "_i";
        String size = this.getArrayLengthVar(o.getList());
        String res = "";
        res = res.concat(this.assignBoolVar(currResultVarName, "true"));
        res = res.concat(this.assignIntVar(index, "0"));
        res = res.concat(this.assignIntVar(size, this.getArrayLengthValue(o.getList())));
        res = res.concat(this.processLabel(initLabel, true));
        res = res.concat(this.processAssignment(iterator, this.processMapAt(list, index), true));
        res = res.concat(this.handleResVar((EObject)o.getPred()));
        res = res.concat(this.processJumpLabels(labels));
        String thenStmt = String.valueOf(this.processAssignment(currResultVarName, this.processOperation("and", currResultVarName, this.getOutputOrResultVar((EObject)o.getPred())), true)) + this.processIncrVar(index);
        String elseStmt = "";
        String loopCondition = this.processOperation("lt", index, size);
        res = res.concat(this.processITEstatement(loopCondition, null, thenStmt, labels[0], elseStmt, labels[1], initLabel, endLabel));
        res = res.concat(this.processLabel(endLabel, true));
        this.putOutputObject((EObject)o, res);
    }

    public void action(CastExpression o) throws Exception {
        String type = (String)this.getOutputObject((EObject)o.getTypeSpecifier());
        String expr = (String)this.getOutputObject((EObject)o.getExpression());
        String res = this.processCastExpresson(type, expr);
        this.putOutputObject((EObject)o, res);
    }

    public void action(TypeSpecifier o) throws Exception {
        String res = this.retrieveTypeSpecifier(o);
        this.putOutputObject((EObject)o, res);
    }

    private String retrieveTypeSpecifier(TypeSpecifier o) {
        String res = null;
        if (o instanceof Boolean) {
            res = "bool";
        } else if (o instanceof Real) {
            res = "real";
        } else if (o instanceof Integer) {
            res = "int";
        } else if (o instanceof Void) {
            res = "VOID";
        }
        return res;
    }

    public void action(ElementOfList o) throws Exception {
        String index = (String)this.getOutputObject((EObject)o.getIndex());
        String res = this.processMapAt(this.getAtomName((Atom)o), index);
        this.putOutputObject((EObject)o, res);
    }

    public void action(LocalVariable o) throws Exception {
        String varName = (String)this.getOutputObject((EObject)o.getAtom());
        this.putOutputObject((EObject)o, varName);
    }

    public void action(DeclarationStatement o) throws Exception {
        if (o.getRhs() != null) {
            String left = (String)this.getOutputObject((EObject)o.getVariable());
            String right = this.getOutputOrResultVar((EObject)o.getRhs());
            String res = "";
            res = res.concat(this.handleResVar((EObject)o.getRhs()));
            res = res.concat(this.processAssignment(left, right, true));
            this.putOutputObject((EObject)o, res);
        } else {
            this.putOutputObject((EObject)o, "");
        }
    }

    public void action(LocalAtom o) throws Exception {
    }

    public void action(ForStatement o) throws Exception {
        String uniqueName = this.getUniqueName((EObject)o);
        String stmtList = "";
        for (Statement then : o.getStatementList()) {
            stmtList = stmtList.concat((String)this.getOutputObject((EObject)then));
        }
        String[] labels = this.createConditionLabels(uniqueName);
        String initLabel = this.createStartLabel(uniqueName);
        String endLabel = this.createEndLabel(uniqueName);
        String condition = (String)this.getOutputObject((EObject)o.getCondition());
        String resultVarCondition = this.getResultVarName((EObject)o.getCondition());
        String initAssignment = (String)this.getOutputObject((EObject)o.getInitAssignment());
        String incrAssignment = (String)this.getOutputObject((EObject)o.getIncrementAssignment());
        String res = String.valueOf(initAssignment) + this.processLabel(initLabel, true);
        if (resultVarCondition != null) {
            res = res.concat(condition);
        }
        res = res.concat(this.processJumpLabels(labels));
        res = res.concat(this.processITEstatement(condition, resultVarCondition, String.valueOf(stmtList) + incrAssignment, labels[0], "", labels[1], initLabel, endLabel));
        res = res.concat(this.processLabel(endLabel, true));
        this.putOutputObject((EObject)o, res);
    }

    private String createStartLabel(String uniqueName) {
        return String.valueOf(uniqueName) + ".start";
    }

    private String createFalseConditionLabel(String uniqueName) {
        return String.valueOf(uniqueName) + ".cond.false";
    }

    private String createTrueConditionLabel(String uniqueName) {
        return String.valueOf(uniqueName) + ".cond.true";
    }

    public void action(ForAllStatement o) throws Exception {
        String itStatement = (String)this.getOutputObject((EObject)o.getStatement());
        String iterator = (String)this.getOutputObject((EObject)o.getIter());
        String list = (String)this.getOutputObject((EObject)o.getList());
        String uniqueName = this.getUniqueName((EObject)o);
        String[] labels = this.createConditionLabels(uniqueName);
        String initLabel = this.createStartLabel(uniqueName);
        String endLabel = this.createEndLabel(uniqueName);
        String index = String.valueOf(uniqueName) + "_i";
        String size = this.getArrayLengthVar(o.getList());
        String res = "";
        res = res.concat(this.assignIntVar(index, "0"));
        res = res.concat(this.assignIntVar(size, this.getArrayLengthValue(o.getList())));
        res = res.concat(this.processLabel(initLabel, true));
        res = res.concat(this.processAssignment(iterator, this.processMapAt(list, index), true));
        res = res.concat(this.processJumpLabels(labels));
        String condition = this.processOperation("lt", index, size);
        res = res.concat(this.processITstatement(condition, null, String.valueOf(itStatement) + this.processAssignment(this.processMapAt(list, index), iterator, true) + this.processIncrVar(index), labels[0], initLabel, false));
        res = res.concat(this.processITstatement(condition, null, "", labels[1], endLabel, true));
        res = res.concat(this.processLabel(endLabel, true));
        this.putOutputObject((EObject)o, res);
    }

    private String[] createConditionLabels(String uniqueName) {
        String[] labels = new String[]{this.createTrueConditionLabel(uniqueName), this.createFalseConditionLabel(uniqueName)};
        return labels;
    }

    private String getUniqueName(EObject o) throws Exception {
        return this.astNameResolutor.getUniqueName(o);
    }

    private String getArrayLengthVar(ParameterList list) throws Exception {
        return String.valueOf((String)this.getOutputObject((EObject)list)) + "_length";
    }

    private String getArrayLengthValue(ParameterList list) throws Exception {
        String[] multiplicity = this.astElementExtractor.getAttributeMultiplicity(this.getAtomName((Atom)list));
        return multiplicity[1];
    }

    public void action(SwitchCaseStatement o) throws Exception {
        String uniqueName = this.getUniqueName((EObject)o);
        String[] labels = this.createCasesLabels(o, uniqueName);
        String defaultLabel = this.createDefaultLabel(uniqueName);
        String endLabel = this.createEndLabel(uniqueName);
        String res = "";
        res = res.concat(this.handleResVar((EObject)o.getExpression()));
        String k2Expr = this.getOutputOrResultVar((EObject)o.getExpression());
        res = res.concat(this.processJumpLabels(labels));
        int i = 0;
        while (i < labels.length) {
            CaseStatement caseStatement = (CaseStatement)o.getCases().get(i);
            String k2Value = (String)this.getOutputObject((EObject)caseStatement.getValue());
            String k2Condition = this.processOperation("eq", k2Expr, k2Value);
            String k2CaseStatement = this.processStatementsList((EList<Statement>)caseStatement.getStatements());
            res = res.concat(this.processITstatement(k2Condition, null, k2CaseStatement, labels[i], endLabel, false));
            ++i;
        }
        String k2TrueCondition = this.processConstant("true", "bool");
        EList defaultStatements = o.getDefaultStatement();
        String k2DefaultStatement = this.processStatementsList((EList<Statement>)defaultStatements);
        res = res.concat(this.processITstatement(k2TrueCondition, null, k2DefaultStatement, defaultLabel, endLabel, false));
        res = res.concat(this.processLabel(endLabel, true));
        this.putOutputObject((EObject)o, res);
    }

    private String createDefaultLabel(String uniqueName) {
        return String.valueOf(uniqueName) + ".default";
    }

    private String[] createCasesLabels(SwitchCaseStatement o, String uniqueName) {
        String[] labels = new String[o.getCases().size()];
        int i = 0;
        while (i < labels.length) {
            labels[i] = String.valueOf(uniqueName) + ".case." + i;
            ++i;
        }
        return labels;
    }

    public void action(CaseStatement o) throws Exception {
    }

    public void action(ParameterListIterator o) throws Exception {
        String attributeName = this.astNameResolutor.getUniqueLocalVariableName((Atom)o);
        if (attributeName == null) {
            attributeName = this.getAtomName((Atom)o);
        }
        this.putOutputObject((EObject)o, attributeName);
    }

    public void action(ParameterList o) throws Exception {
        this.putOutputObject((EObject)o, this.getAtomName((Atom)o));
    }

    private String getAtomName(Atom o) {
        return "|" + o.getName() + "|";
    }
}

