/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.StateMachineTranslatorToSmv.core.stateMachineModelTranslator;

import eu.fbk.eclipse.standardtools.StateMachineTranslatorToSmv.core.stateMachineModelTranslator.FreeMarkerUtil;
import eu.fbk.eclipse.standardtools.StateMachineTranslatorToSmv.core.stateMachineModelTranslator.serializers.SysMLSerializer;
import eu.fbk.eclipse.standardtools.utils.core.model.AbstractStateMachineModel;
import eu.fbk.eclipse.standardtools.utils.core.model.AbstractSystemModel;
import freemarker.template.Template;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.transaction.TransactionalEditingDomain;

public class CHESSModelToCodeTranslatorCore {
    private static final Logger logger = Logger.getLogger(CHESSModelToCodeTranslatorCore.class);
    private Template templateK2StateMachine;
    private SysMLSerializer.SupportedLanguage inputLanguage;
    private FreeMarkerUtil.SupportedLanguage outputLanguage;
    private SysMLSerializer sysMLSerializer;
    AbstractSystemModel abstractSystemModel;
    AbstractStateMachineModel abstractStateMachineModel;

    public CHESSModelToCodeTranslatorCore(SysMLSerializer.SupportedLanguage inputLanguage, FreeMarkerUtil.SupportedLanguage outputLanguage, AbstractSystemModel abstractSystemModel, AbstractStateMachineModel abstractStateMachineModel) {
        logger.debug((Object)("CHESSModelToCodeTranslatorCore: " + (Object)((Object)inputLanguage) + " " + (Object)((Object)outputLanguage)));
        this.inputLanguage = inputLanguage;
        this.outputLanguage = outputLanguage;
        this.sysMLSerializer = new SysMLSerializer(abstractSystemModel, abstractStateMachineModel);
        if (outputLanguage.equals((Object)FreeMarkerUtil.SupportedLanguage.K2)) {
            this.initK2Templates("k2_state_machine_templ.ftl");
        }
        this.abstractStateMachineModel = abstractStateMachineModel;
        this.abstractSystemModel = abstractSystemModel;
    }

    public List<Object> exportBlocksAsCode(List<String> selectedBlocksNames, List<?> blocksAsClasses, String selectedDirectory, TransactionalEditingDomain domain, IProgressMonitor monitor) throws Exception {
        logger.debug((Object)"exportBlocksAsCode");
        ArrayList<Object> blocks = new ArrayList<Object>();
        this.sysMLSerializer.resetErrors();
        for (Object blockAsClass : blocksAsClasses) {
            if (monitor.isCanceled()) {
                throw new Exception("Generazione codice interrotta");
            }
            String className = this.abstractSystemModel.getName(blockAsClass);
            if (selectedBlocksNames.contains(className)) {
                logger.debug((Object)("export Block " + className + " as Class"));
                if (this.outputLanguage.equals((Object)FreeMarkerUtil.SupportedLanguage.K2)) {
                    monitor.subTask("Creazione file " + className + ".k2");
                }
                blocks.add(this.exportBlockAsCode(blockAsClass, selectedDirectory, className, domain, monitor));
                monitor.worked(1);
                continue;
            }
            logger.debug((Object)("skip Block " + className + " as Class"));
        }
        ArrayList<Exception> errors = this.sysMLSerializer.getErrors();
        logger.debug((Object)("Numero errori Esportazione Classi " + errors.size()));
        if (!errors.isEmpty()) {
            this.throwErrorsException("Exporting classes", errors);
        }
        return blocks;
    }

    public Map<String, Object> exportBlockAsCode(Object blockAsClass, String selectedDirectory, String fileNameNoExt, TransactionalEditingDomain domain, IProgressMonitor monitor) throws Exception {
        File selectedFolder = new File(selectedDirectory);
        selectedFolder.mkdirs();
        int numPrevErrors = this.sysMLSerializer.getErrors().size();
        logger.debug((Object)("prev errors: " + numPrevErrors));
        Map<String, Object> serializedBlock = this.sysMLSerializer.serializeBlock(blockAsClass, this.inputLanguage, this.outputLanguage, domain);
        String className = this.abstractSystemModel.getName(blockAsClass);
        logger.debug((Object)"----------------------------------");
        logger.debug((Object)"----------------------------------");
        logger.debug((Object)("serialized " + className));
        ArrayList<Exception> errors = this.sysMLSerializer.getErrors();
        if (fileNameNoExt == null) {
            fileNameNoExt = className;
        }
        logger.debug((Object)("errors: " + errors.size()));
        if (numPrevErrors == errors.size()) {
            logger.info((Object)("No errors. Export Block " + className + " as " + (Object)((Object)this.outputLanguage) + " class."));
            if (this.outputLanguage.equals((Object)FreeMarkerUtil.SupportedLanguage.K2)) {
                String fileExtension = ".k2";
                Writer out = this.instantiateFileWriter(String.valueOf(selectedDirectory) + File.separator + fileNameNoExt + fileExtension);
                this.templateK2StateMachine.process(serializedBlock, out);
                out.close();
            }
            return serializedBlock;
        }
        this.throwErrorsException("Exporting class", errors);
        return null;
    }

    private void throwErrorsException(String process, ArrayList<Exception> errors) throws Exception {
        if (errors.isEmpty()) {
            return;
        }
        String message = "In " + process + ", the following errors were found: \n";
        for (Exception error : errors) {
            error.printStackTrace();
            message = message.concat("- " + error.getMessage() + "\n");
        }
        throw new Exception(message);
    }

    private Writer instantiateFileWriter(String filePath) throws IOException {
        logger.debug((Object)("filePath: '" + filePath + "'"));
        File file = new File(filePath);
        file.createNewFile();
        FileOutputStream fileOutoutStream = new FileOutputStream(filePath);
        return new OutputStreamWriter((OutputStream)fileOutoutStream, "UTF-8");
    }

    private void initK2Templates(String templateName) {
        logger.debug((Object)"initCsvTemplates");
        FreeMarkerUtil freeMarkerUtil = new FreeMarkerUtil();
        this.templateK2StateMachine = freeMarkerUtil.init(templateName, FreeMarkerUtil.SupportedLanguage.K2);
    }
}

