/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.wizards.pages;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.api.util.ReflectionHelper;
import org.eclipse.sirius.common.ui.tools.api.util.SWTUtil;
import org.eclipse.sirius.ui.tools.api.views.ViewHelper;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public class SemanticElementSelectionWizardPage
extends WizardPage {
    private Composite pageComposite;
    private TreeViewer treeViewer;
    private final Session root;
    private RepresentationDescription representationDescription;
    private FilteredTree tree;

    public SemanticElementSelectionWizardPage(Session root) {
        super(Messages.SemanticElementSelectionWizardPage_title);
        this.setTitle(Messages.SemanticElementSelectionWizardPage_title);
        this.root = root;
        this.setMessage(Messages.SemanticElementSelectionWizardPage_message);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.pageComposite = new Composite(parent, 0);
        this.pageComposite.setLayout((Layout)new GridLayout());
        this.pageComposite.setLayoutData((Object)new GridData(4, 4, false, false));
        this.treeViewer = this.createTreeViewer(this.pageComposite);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SemanticElementSelectionWizardPage.this.setPageComplete(SemanticElementSelectionWizardPage.this.isPageComplete());
            }
        });
        this.treeViewer.setInput((Object)this.root);
        this.setControl((Control)this.pageComposite);
    }

    private TreeViewer createTreeViewer(Composite parent) {
        this.tree = SWTUtil.createFilteredTree((Composite)parent, (int)2820, (PatternFilter)new EObjectFilter());
        ReflectionHelper.invokeMethodWithoutException((Object)this.tree, (String)"setQuickSelectionMode", (Class[])new Class[]{Boolean.TYPE}, (Object[])new Object[]{true});
        TreeViewer viewer = this.tree.getViewer();
        GridData gridData = new GridData(4, 4, true, true);
        viewer.getControl().setLayoutData((Object)gridData);
        viewer.getTree().setHeaderVisible(false);
        viewer.getTree().setLinesVisible(false);
        viewer.setContentProvider((IContentProvider)new SessionContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(ViewHelper.INSTANCE.createAdapterFactory()));
        return viewer;
    }

    public EObject getSelectedElement() {
        ISelection selection = this.treeViewer.getSelection();
        if (selection instanceof StructuredSelection && ((StructuredSelection)selection).getFirstElement() instanceof EObject && DialectManager.INSTANCE.canCreate((EObject)((StructuredSelection)selection).getFirstElement(), this.representationDescription)) {
            return (EObject)((StructuredSelection)selection).getFirstElement();
        }
        return null;
    }

    public boolean isPageComplete() {
        return this.getSelectedElement() != null;
    }

    public void setRepresentation(RepresentationDescription representation) {
        this.representationDescription = representation;
    }

    public void update() {
        this.treeViewer.refresh();
        if (this.tree.getFilterControl() != null) {
            this.tree.getFilterControl().setText("*");
        }
    }

    private class EObjectFilter
    extends PatternFilter {
        private EObjectFilter() {
        }

        protected boolean isLeafMatch(Viewer viewer, Object element) {
            if (SemanticElementSelectionWizardPage.this.representationDescription != null && element instanceof EObject && DialectManager.INSTANCE.canCreate((EObject)element, SemanticElementSelectionWizardPage.this.representationDescription)) {
                return super.isLeafMatch(viewer, element);
            }
            return false;
        }
    }

    private static final class SessionContentProvider
    implements ITreeContentProvider {
        private static Object[] empty = new Object[0];

        public Object[] getChildren(Object parentElement) {
            Object[] children = empty;
            if (parentElement instanceof Session) {
                children = ((Session)parentElement).getSemanticResources().toArray();
            } else if (parentElement instanceof EObject) {
                children = ((EObject)parentElement).eContents().toArray();
            } else if (parentElement instanceof Resource) {
                children = ((Resource)parentElement).getContents().toArray();
            }
            return children;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

