/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.contractEditor.view;

import eu.fbk.eclipse.standardtools.contractEditor.core.IContractEditorService;
import eu.fbk.eclipse.standardtools.xtextService.ui.type.Port;
import eu.fbk.eclipse.standardtools.xtextService.ui.utils.XTextEditorViewer;
import eu.fbk.tools.editor.contract.expression.validation.PortProposalProvider;
import eu.fbk.tools.editor.contract.expression.validation.ProposalProvider;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public abstract class ContractEditorView
extends ViewPart {
    private Object contract;
    private Object component;
    static String PLUGIN_ID = "eu.fbk.eclipse.standardtools.contractEditor.customContractEditor";
    private IContractEditorService contractEditorService = (IContractEditorService)PlatformUI.getWorkbench().getService(IContractEditorService.class);
    private ISelectionListener listener;
    private SelectionListener contractListListener;
    private Listener addAssumptionListener;
    private Listener browseAssumptionListener;
    private Listener addGuaranteeListener;
    private Listener browseGuaranteeListener;
    private ISelectionChangedListener assumeEditorListener;
    private ISelectionChangedListener guaranteeEditorListener;

    private void assignContract(Object clazz) {
        this.contract = clazz;
    }

    private void assignComponent(Object clazz) {
        this.component = clazz;
    }

    private void assignContractLabel(String contractName) {
        if (contractName != null) {
            this.contractEditorService.setSelectedContractNameLabel("Selected Contract", contractName);
        }
    }

    private void checkContract(Object contract) {
        this.assignContract(contract);
        this.assignContractLabel(this.getContractName(contract));
        String assume = this.getAssumeStrFromContract(contract);
        this.setAssumption(assume);
        String guarantee = this.getGuaranteeStrFromContract(contract);
        this.setGuarantee(guarantee);
        this.cleanContractOwnerPorts();
        EList<?> ports = this.getContractOwnerPorts(contract);
        XTextEditorViewer.addPorts(this.getXTextPorts(ports));
        this.cleanContractOwnerEnumValues();
        this.addEnumValues(this.getEnumValuesFromContractOwnerPorts(contract));
        this.cleanContractOwnerDefines();
        XTextEditorViewer.addDefines((String[])this.getContractOwnerDefinesNames(contract));
    }

    private void checkComponent(Object component) {
        this.assignComponent(component);
        this.setContractsNameList(this.getContractListStr(component));
        this.contractEditorService.disableFormalPropertiesButtons();
    }

    private void initListeners() {
        if (this.listener == null) {
            this.listener = new ISelectionListener(){

                public void selectionChanged(IWorkbenchPart part, ISelection sel) {
                    Object component;
                    ContractEditorView.this.contractEditorService.prepareEmptyContractEditorView();
                    Object contract = ContractEditorView.this.returnContract(sel);
                    if (contract != null) {
                        ContractEditorView.this.checkContract(contract);
                    }
                    if ((component = ContractEditorView.this.returnComponent(sel)) != null) {
                        ContractEditorView.this.checkComponent(component);
                    }
                }
            };
        }
        if (this.contractListListener == null) {
            this.contractListListener = new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    String contractName = ContractEditorView.this.contractEditorService.getSelectedContractNameLabel();
                    ContractEditorView.this.contract = ContractEditorView.this.extractContractFromComponent(ContractEditorView.this.component, contractName);
                    ContractEditorView.this.checkContract(ContractEditorView.this.contract);
                    ContractEditorView.this.contractEditorService.setSelectedContractNameLabel("Selected Class", ContractEditorView.this.getComponentName(ContractEditorView.this.component));
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            };
        }
        if (this.addAssumptionListener == null) {
            this.addAssumptionListener = new Listener(){

                public void handleEvent(Event e) {
                    switch (e.type) {
                        case 13: {
                            ContractEditorView.this.createAssumption(ContractEditorView.this.contract);
                            String assumption = ContractEditorView.this.getAssumeStrFromContract(ContractEditorView.this.contract);
                            ContractEditorView.this.setAssumption(assumption);
                        }
                    }
                }
            };
        }
        if (this.browseAssumptionListener == null) {
            this.browseAssumptionListener = new Listener(){

                public void handleEvent(Event e) {
                    switch (e.type) {
                        case 13: {
                            String assumption = ContractEditorView.this.browseAssumptionButtonPressed(ContractEditorView.this.contract);
                            ContractEditorView.this.setAssumption(assumption);
                        }
                    }
                }
            };
        }
        if (this.addGuaranteeListener == null) {
            this.addGuaranteeListener = new Listener(){

                public void handleEvent(Event e) {
                    switch (e.type) {
                        case 13: {
                            ContractEditorView.this.createGuarantee(ContractEditorView.this.contract);
                            String guarantee = ContractEditorView.this.getGuaranteeStrFromContract(ContractEditorView.this.contract);
                            ContractEditorView.this.setGuarantee(guarantee);
                        }
                    }
                }
            };
        }
        if (this.browseGuaranteeListener == null) {
            this.browseGuaranteeListener = new Listener(){

                public void handleEvent(Event e) {
                    switch (e.type) {
                        case 13: {
                            String guarantee = ContractEditorView.this.browseGuaranteeButtonPressed(ContractEditorView.this.contract);
                            ContractEditorView.this.setGuarantee(guarantee);
                        }
                    }
                }
            };
        }
        if (this.assumeEditorListener == null) {
            this.assumeEditorListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (ContractEditorView.this.contractEditorService.isAssumeEditorEditable()) {
                        String textChanged = ContractEditorView.this.contractEditorService.getAssumeEditorText();
                        ContractEditorView.this.assumptionEditorchanged(ContractEditorView.this.contract, textChanged);
                    }
                }
            };
        }
        if (this.guaranteeEditorListener == null) {
            this.guaranteeEditorListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (ContractEditorView.this.contractEditorService.isGuaranteeEditorEditable()) {
                        String textChanged = ContractEditorView.this.contractEditorService.getGuaranteeEditorText();
                        ContractEditorView.this.guaranteeEditorchanged(ContractEditorView.this.contract, textChanged);
                    }
                }
            };
        }
    }

    private void setContractsNameList(String[] contractsName) {
        this.contractEditorService.setContractList(contractsName);
    }

    private void setAssumption(String assume) {
        if (assume != null) {
            this.contractEditorService.setAssumeEditorText(assume);
        }
    }

    private void setGuarantee(String guarantee) {
        if (guarantee != null) {
            this.contractEditorService.setGuaranteeEditorText(guarantee);
        }
    }

    private void cleanContractOwnerPorts() {
        XTextEditorViewer.cleanPorts();
    }

    private ProposalProvider.VariableType getXTextPortType(Object port) {
        return this.getXTextAttributeType(port);
    }

    private ProposalProvider.VariableType getXTextAttributeType(Object attribute) {
        if (this.isBoolAttribute(attribute)) {
            return ProposalProvider.VariableType.BOOLEAN;
        }
        if (this.isContinuousAttribute(attribute)) {
            return ProposalProvider.VariableType.CONTINUOUS;
        }
        if (this.isEnumAttribute(attribute)) {
            return ProposalProvider.VariableType.ENUM;
        }
        if (this.isEventAttribute(attribute)) {
            return ProposalProvider.VariableType.EVENT;
        }
        if (this.isIntAttribute(attribute)) {
            return ProposalProvider.VariableType.INTEGER;
        }
        if (this.isNumberAttribute(attribute)) {
            return ProposalProvider.VariableType.NUMBER;
        }
        if (this.isRealAttribute(attribute)) {
            return ProposalProvider.VariableType.REAL;
        }
        if (this.isWordAttribute(attribute)) {
            return ProposalProvider.VariableType.WORD;
        }
        return null;
    }

    private PortProposalProvider.PortDirection getXTextPortDirection(Object port) {
        if (this.isInputPort(port)) {
            return PortProposalProvider.PortDirection.IN;
        }
        if (this.isOutputPort(port)) {
            return PortProposalProvider.PortDirection.OUT;
        }
        if (this.isInOutPort(port)) {
            return PortProposalProvider.PortDirection.IN_OUT;
        }
        return null;
    }

    private EList<Port> getXTextPorts(EList<?> ports) {
        BasicEList xTextPorts = new BasicEList();
        for (Object port : ports) {
            String portName = this.getPortName(port);
            PortProposalProvider.PortDirection portDirection = this.getXTextPortDirection(port);
            ProposalProvider.VariableType portType = this.getXTextPortType(port);
            xTextPorts.add((Object)new Port(portName, portDirection, portType));
        }
        return xTextPorts;
    }

    private void cleanContractOwnerEnumValues() {
        XTextEditorViewer.cleanEnumValues();
    }

    private void addEnumValues(String[] enumValues) {
        XTextEditorViewer.addEnumValues((String[])enumValues);
    }

    private void cleanContractOwnerDefines() {
        XTextEditorViewer.cleanDefines();
    }

    public abstract String[] getContractListStr(Object var1);

    public abstract String[] getContractOwnerInputPortsNames(Object var1);

    public abstract String[] getEnumValuesFromContractOwnerPorts(Object var1);

    public abstract String[] getContractOwnerOutputPortsNames(Object var1);

    public abstract String[] getContractOwnerInputOutputPortsNames(Object var1);

    public abstract String[] getContractOwnerDefinesNames(Object var1);

    public abstract String getAssumeStrFromContract(Object var1);

    public abstract String getGuaranteeStrFromContract(Object var1);

    public abstract String getContractName(Object var1);

    public abstract String getComponentName(Object var1);

    public abstract Object returnComponent(ISelection var1);

    public abstract Object returnContract(ISelection var1);

    public abstract EList<?> getContractOwnerPorts(Object var1);

    public abstract EList<?> getContractOwnerAttributes(Object var1);

    public abstract boolean isNumberAttribute(Object var1);

    public abstract boolean isIntAttribute(Object var1);

    public abstract boolean isEventAttribute(Object var1);

    public abstract boolean isEnumAttribute(Object var1);

    public abstract boolean isBoolAttribute(Object var1);

    public abstract boolean isContinuousAttribute(Object var1);

    public abstract boolean isWordAttribute(Object var1);

    public abstract boolean isRealAttribute(Object var1);

    public abstract boolean isInOutPort(Object var1);

    public abstract boolean isOutputPort(Object var1);

    public abstract boolean isInputPort(Object var1);

    public abstract String getPortName(Object var1);

    public void createPartControl(Composite parent) {
        this.contractEditorService.createGUI(parent, this.getSite().getPage());
        this.initListeners();
        this.contractEditorService.assignListeners(this.contractListListener, this.addAssumptionListener, this.browseAssumptionListener, this.addGuaranteeListener, this.browseGuaranteeListener, this.listener, this.assumeEditorListener, this.guaranteeEditorListener, null);
    }

    public void setFocus() {
    }

    public void dispose() {
        if (this.listener != null) {
            this.getSite().getPage().removeSelectionListener(this.listener);
        }
    }

    public abstract Object extractContractFromComponent(Object var1, String var2);

    public abstract void createAssumption(Object var1);

    public abstract String browseAssumptionButtonPressed(Object var1);

    public abstract void createGuarantee(Object var1);

    public abstract String browseGuaranteeButtonPressed(Object var1);

    public abstract void guaranteeEditorchanged(Object var1, String var2);

    public abstract void assumptionEditorchanged(Object var1, String var2);
}

