/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.contractEditor.propertyTab;

import eu.fbk.eclipse.standardtools.contractEditor.core.IContractEditorService;
import eu.fbk.eclipse.standardtools.utils.core.model.AbstractSystemModel;
import eu.fbk.eclipse.standardtools.xtextService.core.utils.XtextElementsUtil;
import eu.fbk.eclipse.standardtools.xtextService.ui.utils.XTextEditorViewer;
import java.io.IOException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public abstract class ContractEditorTab
extends AbstractPropertySection {
    private Object contract;
    private Object component;
    static String PLUGIN_ID = "eu.fbk.eclipse.standardtools.contractEditor.core";
    private IContractEditorService contractEditorService;
    private SelectionListener contractListListener;
    private Listener addAssumptionListener;
    private Listener addContractListener;
    private Listener browseAssumptionListener;
    private Listener addGuaranteeListener;
    private Listener browseGuaranteeListener;
    private ISelectionChangedListener assumeEditorListener;
    private ISelectionChangedListener guaranteeEditorListener;
    private AbstractSystemModel systemModel = this.getSystemModel();
    private XtextElementsUtil xtextElementsUtil = XtextElementsUtil.getInstance((AbstractSystemModel)this.systemModel);

    public ContractEditorTab() {
        this.contractEditorService = (IContractEditorService)PlatformUI.getWorkbench().getService(IContractEditorService.class);
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        this.contractEditorService.createGUI(parent, aTabbedPropertySheetPage.getSite().getPage());
        this.initListeners();
        this.contractEditorService.assignListeners(this.contractListListener, this.addAssumptionListener, this.browseAssumptionListener, this.addGuaranteeListener, this.browseGuaranteeListener, null, this.assumeEditorListener, this.guaranteeEditorListener, this.addContractListener);
    }

    public void setInput(IWorkbenchPart part, ISelection sel) {
        Object component;
        this.contractEditorService.prepareEmptyContractEditorView();
        Object contract = this.returnContract(sel);
        if (contract != null) {
            this.updateContractEditorTabFromSelectedContract(contract);
        }
        if ((component = this.returnComponent(sel)) != null) {
            this.updateContractEditorTabFromSelectedComponent(component);
        }
    }

    public abstract AbstractSystemModel getSystemModel();

    public abstract String[] getContractListStr(Object var1);

    public abstract String getAssumeStrFromContract(Object var1);

    public abstract String getAssumeQualifiedNameFromContract(Object var1);

    public abstract String getGuaranteeStrFromContract(Object var1);

    public abstract String getGuaranteeQualifiedNameFromContract(Object var1);

    public abstract Object returnComponent(ISelection var1);

    public abstract Object returnContract(ISelection var1);

    public abstract Object extractContractFromComponent(Object var1, String var2);

    public abstract void createAssumption(Object var1);

    public abstract void createContractProperty(Object var1, String var2);

    public abstract String browseAssumptionButtonPressed(Object var1);

    public abstract void createGuarantee(Object var1);

    public abstract String browseGuaranteeButtonPressed(Object var1);

    public abstract void guaranteeEditorchanged(Object var1, String var2);

    public abstract void assumptionEditorchanged(Object var1, String var2);

    public abstract Resource getResourceFromContract(Object var1);

    private void assignContractLabel(String contractName) {
        this.contractEditorService.setSelectedContractNameLabel("Selected Contract", contractName);
    }

    private void assignComponentLabel(String componentName) {
        this.contractEditorService.setSelectedContractNameLabel("Selected Class", componentName);
    }

    private void updateContractEditorTabFromSelectedContract(Object contract) {
        this.contract = contract;
        this.assignContractLabel(this.systemModel.getContractQualifiedName(contract));
        String assume = this.getAssumeStrFromContract(contract);
        this.setAssumption(assume);
        String assumeQualifiedName = this.getAssumeQualifiedNameFromContract(contract);
        this.setAssumptionQualifiedName(assumeQualifiedName);
        String guarantee = this.getGuaranteeStrFromContract(contract);
        this.setGuarantee(guarantee);
        String guaranteeQualifiedName = this.getGuaranteeQualifiedNameFromContract(contract);
        this.setGuaranteeQualifiedName(guaranteeQualifiedName);
        Object component = this.systemModel.getNearestOwnerComponent(contract);
        XTextEditorViewer.enableCheckOnVariables();
        XTextEditorViewer.setBooleanCheck((boolean)true);
        XTextEditorViewer.cleanPorts();
        XTextEditorViewer.addPorts((EList)this.xtextElementsUtil.getXTextPortsFromComponent(component));
        XTextEditorViewer.cleanParameters();
        XTextEditorViewer.addParameters((EList)this.xtextElementsUtil.getXTextParametersFromComponent(component));
        XTextEditorViewer.cleanEnumValues();
        XTextEditorViewer.addEnumValues((String[])((String[])this.systemModel.getEnumValuesFromAttributes(component).toArray((Object[])new String[0])));
        XTextEditorViewer.cleanDefines();
        XTextEditorViewer.addDefines((String[])((String[])this.xtextElementsUtil.getXTextDefinesNamesFromComponent(component).toArray((Object[])new String[0])));
    }

    private void updateContractEditorTabFromSelectedComponent(Object component) {
        this.component = component;
        this.assignComponentLabel(this.systemModel.getComponentQualifiedName(component));
        this.setContractsNameList(this.getContractListStr(component));
        this.contractEditorService.disableFormalPropertiesButtons();
        this.setAssumptionQualifiedName("");
        this.setGuaranteeQualifiedName("");
    }

    private void initListeners() {
        if (this.contractListListener == null) {
            this.contractListListener = new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    String contractName = ContractEditorTab.this.contractEditorService.getSelectedContractNameLabel();
                    ContractEditorTab.this.contract = ContractEditorTab.this.extractContractFromComponent(ContractEditorTab.this.component, contractName);
                    ContractEditorTab.this.updateContractEditorTabFromSelectedContract(ContractEditorTab.this.contract);
                    ContractEditorTab.this.assignComponentLabel(ContractEditorTab.this.systemModel.getComponentName(ContractEditorTab.this.component));
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            };
        }
        if (this.addAssumptionListener == null) {
            this.addAssumptionListener = new Listener(){

                public void handleEvent(Event e) {
                    switch (e.type) {
                        case 13: {
                            ContractEditorTab.this.createAssumption(ContractEditorTab.this.contract);
                            String assumption = ContractEditorTab.this.getAssumeStrFromContract(ContractEditorTab.this.contract);
                            ContractEditorTab.this.setAssumption(assumption);
                            String assumeQualifiedName = ContractEditorTab.this.getAssumeQualifiedNameFromContract(ContractEditorTab.this.contract);
                            ContractEditorTab.this.setAssumptionQualifiedName(assumeQualifiedName);
                        }
                    }
                }
            };
        }
        if (this.addContractListener == null) {
            this.addContractListener = new Listener(){

                public void handleEvent(Event e) {
                    switch (e.type) {
                        case 13: {
                            ContractEditorTab.this.createContractProperty(ContractEditorTab.this.component, ContractEditorTab.this.contractEditorService.getNewContractName());
                            ContractEditorTab.this.setContractsNameList(ContractEditorTab.this.getContractListStr(ContractEditorTab.this.component));
                        }
                    }
                }
            };
        }
        if (this.browseAssumptionListener == null) {
            this.browseAssumptionListener = new Listener(){

                public void handleEvent(Event e) {
                    switch (e.type) {
                        case 13: {
                            String assumption = ContractEditorTab.this.browseAssumptionButtonPressed(ContractEditorTab.this.contract);
                            ContractEditorTab.this.setAssumption(assumption);
                            String assumeQualifiedName = ContractEditorTab.this.getAssumeQualifiedNameFromContract(ContractEditorTab.this.contract);
                            ContractEditorTab.this.setAssumptionQualifiedName(assumeQualifiedName);
                        }
                    }
                }
            };
        }
        if (this.addGuaranteeListener == null) {
            this.addGuaranteeListener = new Listener(){

                public void handleEvent(Event e) {
                    switch (e.type) {
                        case 13: {
                            ContractEditorTab.this.createGuarantee(ContractEditorTab.this.contract);
                            String guarantee = ContractEditorTab.this.getGuaranteeStrFromContract(ContractEditorTab.this.contract);
                            ContractEditorTab.this.setGuarantee(guarantee);
                            String guaranteeQualifiedName = ContractEditorTab.this.getGuaranteeQualifiedNameFromContract(ContractEditorTab.this.contract);
                            ContractEditorTab.this.setGuaranteeQualifiedName(guaranteeQualifiedName);
                        }
                    }
                }
            };
        }
        if (this.browseGuaranteeListener == null) {
            this.browseGuaranteeListener = new Listener(){

                public void handleEvent(Event e) {
                    switch (e.type) {
                        case 13: {
                            String guarantee = ContractEditorTab.this.browseGuaranteeButtonPressed(ContractEditorTab.this.contract);
                            ContractEditorTab.this.setGuarantee(guarantee);
                            String guaranteeQualifiedName = ContractEditorTab.this.getGuaranteeQualifiedNameFromContract(ContractEditorTab.this.contract);
                            ContractEditorTab.this.setGuaranteeQualifiedName(guaranteeQualifiedName);
                        }
                    }
                }
            };
        }
        if (this.assumeEditorListener == null) {
            this.assumeEditorListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (ContractEditorTab.this.contractEditorService.isAssumeEditorEditable()) {
                        String textChanged = ContractEditorTab.this.contractEditorService.getAssumeEditorText();
                        ContractEditorTab.this.assumptionEditorchanged(ContractEditorTab.this.contract, textChanged);
                        ContractEditorTab.this.contractEditorService.disableAddAssumptionButton();
                        String assumeQualifiedName = ContractEditorTab.this.getAssumeQualifiedNameFromContract(ContractEditorTab.this.contract);
                        ContractEditorTab.this.setAssumptionQualifiedName(assumeQualifiedName);
                        try {
                            ContractEditorTab.this.contractEditorService.showAssumeRuntimeErrors(ContractEditorTab.this.contract, ContractEditorTab.this.getResourceFromContract(ContractEditorTab.this.contract));
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            };
        }
        if (this.guaranteeEditorListener == null) {
            this.guaranteeEditorListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (ContractEditorTab.this.contractEditorService.isGuaranteeEditorEditable()) {
                        String textChanged = ContractEditorTab.this.contractEditorService.getGuaranteeEditorText();
                        ContractEditorTab.this.guaranteeEditorchanged(ContractEditorTab.this.contract, textChanged);
                        ContractEditorTab.this.contractEditorService.disableAddGuaranteeButton();
                        String guaranteeQualifiedName = ContractEditorTab.this.getGuaranteeQualifiedNameFromContract(ContractEditorTab.this.contract);
                        ContractEditorTab.this.setGuaranteeQualifiedName(guaranteeQualifiedName);
                        try {
                            ContractEditorTab.this.contractEditorService.showGuaranteeRuntimeErrors(ContractEditorTab.this.contract, ContractEditorTab.this.getResourceFromContract(ContractEditorTab.this.contract));
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            };
        }
    }

    private void setContractsNameList(String[] contractsName) {
        this.contractEditorService.setContractList(contractsName);
    }

    private void setAssumption(String assume) {
        this.contractEditorService.setAssumeEditorText(assume);
    }

    private void setAssumptionQualifiedName(String qualifiedName) {
        this.contractEditorService.setAssumeQualifiedNameLabel(qualifiedName);
    }

    private void setGuaranteeQualifiedName(String qualifiedName) {
        this.contractEditorService.setGuaranteeQualifiedNameLabel(qualifiedName);
    }

    private void setGuarantee(String guarantee) {
        this.contractEditorService.setGuaranteeEditorText(guarantee);
    }
}

