/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.business.internal.refresh;

import com.google.common.base.Objects;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.common.tools.api.util.RefreshIdsHolder;
import org.eclipse.sirius.table.business.internal.refresh.KeyCache;
import org.eclipse.sirius.table.metamodel.table.DFeatureColumn;
import org.eclipse.sirius.table.metamodel.table.description.ColumnMapping;

public class DFeatureColumnCandidate {
    private final String featureName;
    private final ColumnMapping mapping;
    private DFeatureColumn element;
    private final int hashCode;
    private RefreshIdsHolder ids;

    public DFeatureColumnCandidate(ColumnMapping mapping, String featureName, RefreshIdsHolder ids) {
        this.mapping = mapping;
        this.featureName = featureName;
        this.ids = ids;
        this.hashCode = this.computeHashCode();
    }

    public DFeatureColumnCandidate(DFeatureColumn tableElement, RefreshIdsHolder ids) {
        this.ids = ids;
        this.mapping = tableElement.getOriginMapping();
        this.featureName = tableElement.getFeatureName();
        this.element = tableElement;
        this.hashCode = this.computeHashCode();
    }

    public boolean comesFromTableElement() {
        return this.getOriginalElement() != null;
    }

    public DFeatureColumn getOriginalElement() {
        return this.element;
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int[] parts = new int[]{this.mapping == null ? 0 : this.getMappingID(), ((String)Objects.firstNonNull((Object)this.featureName, (Object)"")).hashCode()};
        return KeyCache.DEFAULT.getKey(String.valueOf(parts[0]) + "/" + parts[1]);
    }

    private Integer getMappingID() {
        return this.ids.getOrCreateID((EObject)this.mapping);
    }

    public boolean equals(Object obj) {
        Boolean result = null;
        if (this == obj) {
            result = true;
        }
        if (result == null && obj == null) {
            result = false;
        }
        if (result == null && !(obj instanceof DFeatureColumnCandidate)) {
            result = false;
        }
        DFeatureColumnCandidate other = (DFeatureColumnCandidate)obj;
        if (result == null && this.mapping == null) {
            if (other.mapping != null) {
                result = false;
            }
        } else if (result == null && !this.mapping.equals(other.mapping)) {
            result = false;
        }
        if (result == null && this.featureName == null) {
            if (other.featureName != null) {
                result = false;
            }
        } else if (result == null && !this.featureName.equals(other.featureName)) {
            result = false;
        }
        if (result == null) {
            result = true;
        }
        return result;
    }

    public ColumnMapping getMapping() {
        return this.mapping;
    }

    public String getFeatureName() {
        return this.featureName;
    }
}

