/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.profile.custom.edit.parts;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.editparts.UMLConnectionNodeEditPart;
import org.eclipse.papyrus.uml.diagram.common.util.AssociationUtil;
import org.eclipse.papyrus.uml.diagram.profile.custom.figure.AssociationFigure;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;

public abstract class AbstractAssociationEditPart
extends UMLConnectionNodeEditPart {
    protected static final String ASSOCIATION_END_LISTENERS_SOURCE = "AssociationEndListenersSource";
    protected static final String ASSOCIATION_END_LISTENERS_TARGET = "AssociationEndListenersTarget";

    public AbstractAssociationEditPart(View view) {
        super(view);
    }

    public void activate() {
        super.activate();
        this.addAssociationEndListeners();
    }

    protected void addAssociationEndListeners() {
        Association association;
        EObject semanticElement = this.resolveSemanticElement();
        if (semanticElement instanceof Association && (association = (Association)semanticElement).getMemberEnds().size() >= 2) {
            Property sourceEnd = this.getSourceProperty(association);
            Property targetEnd = this.getSourceProperty(association);
            this.addListenerFilter(ASSOCIATION_END_LISTENERS_SOURCE, (NotificationListener)this, (EObject)sourceEnd);
            this.addListenerFilter(ASSOCIATION_END_LISTENERS_TARGET, (NotificationListener)this, (EObject)targetEnd);
        }
    }

    public void deactivate() {
        this.removeAssociationEndListeners();
        super.deactivate();
    }

    protected void handleNotificationEvent(Notification event) {
        super.handleNotificationEvent(event);
        if (this.resolveSemanticElement() != null) {
            this.refreshVisuals();
        }
    }

    protected void refreshVisuals() {
        if (this.resolveSemanticElement() != null) {
            Association association;
            if (this.getSource() == null || this.getTarget() == null) {
                return;
            }
            if (((GraphicalEditPart)this.getSource()).resolveSemanticElement() == null || ((GraphicalEditPart)this.getTarget()).resolveSemanticElement() == null) {
                return;
            }
            if (this.getUMLElement() instanceof Association && (association = (Association)this.getUMLElement()).getMemberEnds() != null && 2 <= association.getMemberEnds().size()) {
                Property source = this.getSourceProperty(association);
                Property target = this.getTargetProperty(association);
                if (source == null || target == null) {
                    return;
                }
                if (!source.getType().equals(target.getType())) {
                    Property propertyGet0 = (Property)association.getMemberEnds().get(0);
                    Property propertyGet1 = (Property)association.getMemberEnds().get(1);
                    Type propertyTypeGet0 = propertyGet0.getType();
                    if (propertyTypeGet0 != null && propertyTypeGet0.equals(((GraphicalEditPart)this.getSource()).resolveSemanticElement())) {
                        source = propertyGet0;
                        target = propertyGet1;
                    } else {
                        source = propertyGet1;
                        target = propertyGet0;
                    }
                }
                int sourceType = 0;
                int targetType = 0;
                if (!source.getOwner().equals(this.resolveSemanticElement())) {
                    sourceType += 8;
                    ++sourceType;
                }
                if (!target.getOwner().equals(this.resolveSemanticElement())) {
                    targetType += 8;
                    ++targetType;
                }
                if (source.getAggregation() == AggregationKind.SHARED_LITERAL) {
                    targetType += 2;
                }
                if (target.getAggregation() == AggregationKind.SHARED_LITERAL) {
                    sourceType += 2;
                }
                if (source.getAggregation() == AggregationKind.COMPOSITE_LITERAL) {
                    targetType += 4;
                }
                if (target.getAggregation() == AggregationKind.COMPOSITE_LITERAL) {
                    sourceType += 4;
                }
                if (association.getNavigableOwnedEnds().contains((Object)source)) {
                    ++sourceType;
                }
                if (association.getNavigableOwnedEnds().contains((Object)target)) {
                    ++targetType;
                }
                if (this.getPrimaryShape() instanceof AssociationFigure) {
                    ((AssociationFigure)this.getPrimaryShape()).setEnd(sourceType, targetType);
                }
            }
        }
        super.refreshVisuals();
    }

    protected Property getSourceProperty(Association association) {
        return AssociationUtil.getSourceFirstEnd((Association)association);
    }

    protected Property getTargetProperty(Association association) {
        return AssociationUtil.getTargetSecondEnd((Association)association);
    }

    protected void removeAssociationEndListeners() {
        this.removeListenerFilter(ASSOCIATION_END_LISTENERS_SOURCE);
        this.removeListenerFilter(ASSOCIATION_END_LISTENERS_TARGET);
    }
}

