/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.diagram.ui.commands;

import eu.fbk.eclipse.standardtools.ModelTranslatorToOcra.core.services.OSSTranslatorServiceAPI;
import eu.fbk.eclipse.standardtools.diagram.DiagramDescriptor;
import eu.fbk.eclipse.standardtools.diagram.DocumentGenerator;
import eu.fbk.eclipse.standardtools.diagram.ui.docGenerators.DocumentGeneratorServiceFromOssModel;
import eu.fbk.eclipse.standardtools.diagram.ui.wizard.DocumentationWizard;
import eu.fbk.eclipse.standardtools.utils.core.model.AbstractSystemModel;
import eu.fbk.eclipse.standardtools.utils.ui.commands.AbstractJobCommand;
import eu.fbk.eclipse.standardtools.utils.ui.dialogs.MessageCommunicationDialog;
import eu.fbk.eclipse.standardtools.utils.ui.dialogs.MessageTimeModelDialog;
import eu.fbk.eclipse.standardtools.utils.ui.utils.DirectoryUtil;
import eu.fbk.tools.editor.oss.oss.AbstractComponent;
import eu.fbk.tools.editor.oss.oss.OSS;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Package;
import org.polarsys.chess.diagram.ui.services.CHESSDiagramsGeneratorService;
import org.polarsys.chess.diagram.ui.services.ResultsGeneratorService;
import org.polarsys.chess.service.core.exceptions.NoComponentException;
import org.polarsys.chess.service.core.model.ChessSystemModel;
import org.polarsys.chess.service.core.utils.AnalysisResultUtil;
import org.polarsys.chess.service.gui.utils.DialogUtils;
import org.polarsys.chess.service.gui.utils.SelectionUtil;

public class GenerateDocumentCommand
extends AbstractJobCommand {
    private SelectionUtil selectionUtil = SelectionUtil.getInstance();
    private ChessSystemModel chessToOCRAModelTranslator = ChessSystemModel.getInstance();
    private OSSTranslatorServiceAPI ocraTranslatorService = OSSTranslatorServiceAPI.getInstance((AbstractSystemModel)this.chessToOCRAModelTranslator);
    private DialogUtils dialogUtils = DialogUtils.getInstance();
    private CHESSDiagramsGeneratorService chessDiagramsGeneratorService = CHESSDiagramsGeneratorService.getInstance();
    private DirectoryUtil directoryUtils = DirectoryUtil.getInstance();
    private DocumentGeneratorServiceFromOssModel documentGeneratorService;
    private Class umlSelectedComponent;
    private int timeSpecification;
    private boolean isAsyncCommunication;
    private String outputDirectoryName;
    private String currentProjectName;
    private Collection<Diagram> chessDiagrams;
    private String imageExtension;
    private String docFormat;
    private Package activePackage;
    private boolean goAhead;

    public GenerateDocumentCommand() {
        super("Generate Documentation");
    }

    private Package getDiagramPackage(Diagram diagram) {
        Package diagramPackage = null;
        EObject diagramElement = diagram.getElement();
        if (diagramElement instanceof Package) {
            diagramPackage = (Package)diagramElement;
        } else if (diagramElement instanceof Class) {
            diagramPackage = ((Class)diagramElement).getNearestPackage();
        }
        return diagramPackage;
    }

    public void execPreJobOperations(ExecutionEvent event, final IProgressMonitor monitor) throws Exception {
        try {
            this.umlSelectedComponent = this.selectionUtil.getUmlComponentFromSelectedObject(event);
        }
        catch (NoComponentException noComponentException) {
            this.umlSelectedComponent = AnalysisResultUtil.getInstance().getSystemComponentFromEvent(event);
        }
        this.activePackage = this.umlSelectedComponent.getNearestPackage();
        this.timeSpecification = MessageTimeModelDialog.openQuestion((boolean)false);
        this.isAsyncCommunication = !MessageCommunicationDialog.openQuestion((boolean)false);
        this.outputDirectoryName = this.dialogUtils.getDirectoryNameFromDialog();
        this.currentProjectName = this.directoryUtils.getCurrentProjectName();
        this.chessDiagrams = this.chessDiagramsGeneratorService.getDiagrams();
        this.goAhead = true;
        if (this.outputDirectoryName == null || this.outputDirectoryName.isEmpty()) {
            this.goAhead = false;
            return;
        }
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        DocumentationWizard docWizard = new DocumentationWizard();
        WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)docWizard);
        wizardDialog.setHelpAvailable(false);
        if (wizardDialog.open() != 0) {
            System.out.println("Cancel pressed");
            this.goAhead = false;
            return;
        }
        System.out.println("Ok pressed");
        this.goAhead = true;
        this.docFormat = docWizard.getDocumentFormat();
        this.imageExtension = ".svg";
        if (this.docFormat.equals("tex")) {
            this.imageExtension = ".pdf";
        }
        OSS ossModel = this.ocraTranslatorService.exportRootComponentToOssModel((Object)this.umlSelectedComponent, this.timeSpecification, this.isAsyncCommunication, monitor);
        this.documentGeneratorService = new DocumentGeneratorServiceFromOssModel(ossModel, (AbstractSystemModel)this.chessToOCRAModelTranslator, (Object)this.activePackage);
        this.documentGeneratorService.setParametersBeforeDocumentGeneration(this.outputDirectoryName, this.imageExtension, docWizard.getShowLeafComponents(), docWizard.getShowInputPorts(), docWizard.getShowOutputPorts(), docWizard.getShowSubComponents(), docWizard.getShowParameters(), docWizard.getShowUninterpretedFunctions(), docWizard.getShowConnections(), docWizard.getShowInterfaceAssertions(), docWizard.getShowRefinementAssertions(), docWizard.getShowContracts(), docWizard.getShowContractRefinements(), docWizard.getShowParameterAssumptions(), docWizard.getShowDiagrams(), docWizard.getShowLocalAttributes(), docWizard.getShowDefines());
        final DocumentGenerator documentGenerator = this.documentGeneratorService.createDocumentFile(this.currentProjectName, this.docFormat, (AbstractComponent)ossModel.getSystem(), monitor);
        this.documentGeneratorService.addLocalAttributeDescriptors((Object)this.umlSelectedComponent, documentGenerator);
        ResultsGeneratorService resultsGeneratorService = new ResultsGeneratorService();
        resultsGeneratorService.setParametersBeforeDocumentGeneration(this.outputDirectoryName, docWizard.getShowCheckResults(), this.imageExtension);
        resultsGeneratorService.addResultsDescriptors(this.umlSelectedComponent, this.activePackage, documentGenerator);
        this.chessDiagramsGeneratorService.setParametersBeforeDiagramsGenerator(this.outputDirectoryName, this.imageExtension);
        Display defaultDisplay = Display.getDefault();
        defaultDisplay.syncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                HashSet<DiagramDescriptor> diagramDescriptors = new HashSet<DiagramDescriptor>();
                for (Diagram diagram : GenerateDocumentCommand.this.chessDiagrams) {
                    DiagramDescriptor dd;
                    if (GenerateDocumentCommand.this.getDiagramPackage(diagram) != GenerateDocumentCommand.this.activePackage || (dd = GenerateDocumentCommand.this.chessDiagramsGeneratorService.createDiagramWithDescriptor(diagram, shell, monitor)) == null) continue;
                    diagramDescriptors.add(dd);
                }
                GenerateDocumentCommand.this.documentGeneratorService.addDiagramDescriptors(diagramDescriptors, documentGenerator);
                GenerateDocumentCommand.this.documentGeneratorService.generateDocument(documentGenerator);
            }
        });
    }

    public void execJobCommand(ExecutionEvent event, IProgressMonitor monitor) throws Exception {
        if (!this.goAhead) {
            return;
        }
    }

    public void execPostJobOperations(ExecutionEvent event, NullProgressMonitor nullProgressMonitor) throws Exception {
    }
}

