/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.graph.text.ide.contentassist;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.elk.core.data.ILayoutMetaData;
import org.eclipse.elk.core.data.LayoutAlgorithmData;
import org.eclipse.elk.core.data.LayoutMetaDataService;
import org.eclipse.elk.core.data.LayoutOptionData;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkEdgeSection;
import org.eclipse.elk.graph.ElkGraphElement;
import org.eclipse.elk.graph.ElkLabel;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.ElkPort;
import org.eclipse.elk.graph.impl.ElkPropertyToValueMapEntryImpl;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.text.ElkGraphTextUtil;
import org.eclipse.elk.graph.text.services.ElkGraphGrammarAccess;
import org.eclipse.elk.graph.util.ElkGraphUtil;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.conversion.impl.IDValueConverter;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistEntry;
import org.eclipse.xtext.ide.editor.contentassist.IIdeContentProposalAcceptor;
import org.eclipse.xtext.ide.editor.contentassist.IProposalConflictHelper;
import org.eclipse.xtext.ide.editor.contentassist.IdeContentProposalProvider;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class ElkGraphProposalProvider
extends IdeContentProposalProvider {
    private static final Set<String> DISABLED_KEYWORDS = Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new String[]{"}", "]"}));
    private ElkGraphGrammarAccess grammar;
    private IDValueConverter idValueConverter;
    @Inject
    private IProposalConflictHelper conflictHelper;
    public static final String DISCO_LAYOUT_ALG_ID = "org.eclipse.elk.disco.componentCompaction.componentLayoutAlgorithm";

    @Inject
    public void initialize(Provider<IDValueConverter> idValueConverterProvider, final ElkGraphGrammarAccess grammarAccess) {
        IDValueConverter _doubleArrow;
        IDValueConverter _get = (IDValueConverter)idValueConverterProvider.get();
        Procedures.Procedure1<IDValueConverter> _function = new Procedures.Procedure1<IDValueConverter>(){

            public void apply(IDValueConverter it) {
                it.setRule((AbstractRule)grammarAccess.getIDRule());
            }
        };
        this.idValueConverter = _doubleArrow = (IDValueConverter)ObjectExtensions.operator_doubleArrow((Object)_get, (Procedures.Procedure1)_function);
        this.grammar = grammarAccess;
    }

    protected boolean filterKeyword(Keyword keyword, ContentAssistContext context) {
        return !DISABLED_KEYWORDS.contains(keyword.getValue()) && !Objects.equal((Object)keyword.getValue(), (Object)context.getPrefix());
    }

    protected void _createProposals(Keyword keyword, ContentAssistContext context, IIdeContentProposalAcceptor acceptor) {
        ContentAssistEntry entry;
        boolean _filterKeyword = this.filterKeyword(keyword, context);
        if (_filterKeyword && (entry = this.getProposalCreator().createProposal(keyword.getValue(), context)) != null) {
            entry.setKind("KEYWORD");
            entry.setSource((Object)keyword);
            acceptor.accept(entry, this.getProposalPriorities().getKeywordPriority(keyword.getValue(), entry));
        }
    }

    protected void _createProposals(Assignment assignment, ContentAssistContext context, IIdeContentProposalAcceptor acceptor) {
        boolean _matched = false;
        Assignment _keyAssignment_0 = this.grammar.getPropertyAccess().getKeyAssignment_0();
        if (Objects.equal((Object)assignment, (Object)_keyAssignment_0)) {
            _matched = true;
            this.completePropertyKey(context, acceptor);
        }
        if (!_matched) {
            Assignment _valueAssignment_2_3;
            Assignment _valueAssignment_2_2;
            Assignment _valueAssignment_2_1;
            Assignment _valueAssignment_2_0 = this.grammar.getPropertyAccess().getValueAssignment_2_0();
            if (Objects.equal((Object)assignment, (Object)_valueAssignment_2_0)) {
                _matched = true;
            }
            if (!_matched && Objects.equal((Object)assignment, (Object)(_valueAssignment_2_1 = this.grammar.getPropertyAccess().getValueAssignment_2_1()))) {
                _matched = true;
            }
            if (!_matched && Objects.equal((Object)assignment, (Object)(_valueAssignment_2_2 = this.grammar.getPropertyAccess().getValueAssignment_2_2()))) {
                _matched = true;
            }
            if (!_matched && Objects.equal((Object)assignment, (Object)(_valueAssignment_2_3 = this.grammar.getPropertyAccess().getValueAssignment_2_3()))) {
                _matched = true;
            }
            if (_matched) {
                this.completePropertyValue(context, acceptor);
            }
        }
        if (!_matched) {
            super._createProposals(assignment, context, acceptor);
        }
    }

    protected void completePropertyKey(ContentAssistContext context, IIdeContentProposalAcceptor acceptor) {
        EObject _currentModel;
        EObject model = _currentModel = context.getCurrentModel();
        boolean _matched = false;
        if (model instanceof ElkNode) {
            ElkNode _parent;
            boolean _tripleNotEquals;
            _matched = true;
            if (((ElkNode)model).getParent() == null || !((ElkNode)model).getChildren().isEmpty()) {
                this.proposeProperties((ElkGraphElement)model, ElkGraphTextUtil.getAlgorithm((ElkGraphElement)((ElkGraphElement)model)), LayoutOptionData.Target.PARENTS, context, acceptor);
            }
            boolean bl = _tripleNotEquals = (_parent = ((ElkNode)model).getParent()) != null;
            if (_tripleNotEquals) {
                this.proposeProperties((ElkGraphElement)model, ElkGraphTextUtil.getAlgorithm((ElkGraphElement)((ElkNode)model).getParent()), LayoutOptionData.Target.NODES, context, acceptor);
            }
        }
        if (!_matched && model instanceof ElkEdge) {
            _matched = true;
            this.proposeProperties((ElkGraphElement)model, ElkGraphTextUtil.getAlgorithm((ElkGraphElement)((ElkGraphElement)model)), LayoutOptionData.Target.EDGES, context, acceptor);
        }
        if (!_matched && model instanceof ElkPort) {
            _matched = true;
            this.proposeProperties((ElkGraphElement)model, ElkGraphTextUtil.getAlgorithm((ElkGraphElement)((ElkGraphElement)model)), LayoutOptionData.Target.PORTS, context, acceptor);
        }
        if (!_matched && model instanceof ElkLabel) {
            _matched = true;
            this.proposeProperties((ElkGraphElement)model, ElkGraphTextUtil.getAlgorithm((ElkGraphElement)((ElkGraphElement)model)), LayoutOptionData.Target.LABELS, context, acceptor);
        }
    }

    protected void proposeProperties(final ElkGraphElement element, final LayoutAlgorithmData algorithmData, final LayoutOptionData.Target targetType, final ContentAssistContext context, IIdeContentProposalAcceptor acceptor) {
        boolean _existsConflict = this.conflictHelper.existsConflict("a", context);
        if (_existsConflict) {
            return;
        }
        LayoutMetaDataService metaDataService = LayoutMetaDataService.getInstance();
        Functions.Function1<LayoutOptionData, Boolean> _function = new Functions.Function1<LayoutOptionData, Boolean>(){

            public Boolean apply(LayoutOptionData o) {
                return !(targetType != null && !o.getTargets().contains(targetType) || algorithmData != null && !algorithmData.knowsOption((IProperty)o) && !Objects.equal((Object)CoreOptions.ALGORITHM, (Object)o) || element != null && element.getProperties().map().containsKey(o));
            }
        };
        Iterable filteredOptions = IterableExtensions.filter((Iterable)metaDataService.getOptionData(), (Functions.Function1)_function);
        for (final LayoutOptionData option : filteredOptions) {
            Iterable suffix;
            boolean matchesName = !context.getPrefix().isEmpty() && option.getName().toLowerCase().contains(context.getPrefix().toLowerCase());
            List idSplit = Strings.split((String)option.getId(), (String)".");
            List _xifexpression = null;
            if (!matchesName) {
                _xifexpression = Strings.split((String)context.getPrefix(), (String)".");
            }
            List prefixSplit = _xifexpression;
            boolean foundMatch = false;
            int _size = idSplit.size();
            int i = _size - 1;
            if (i >= 1 && Objects.equal((Object)option.getGroup(), idSplit.get(i - 1))) {
                --i;
            }
            while (i >= 0 && !foundMatch) {
                suffix = IterableExtensions.drop((Iterable)idSplit, (int)i);
                if (metaDataService.getOptionDataBySuffix(IterableExtensions.join((Iterable)suffix, (CharSequence)".")) != null && (matchesName || this.startsWith(suffix, prefixSplit))) {
                    foundMatch = true;
                    continue;
                }
                --i;
            }
            if (!foundMatch) continue;
            suffix = IterableExtensions.drop((Iterable)idSplit, (int)i);
            ContentAssistEntry _contentAssistEntry = new ContentAssistEntry();
            Procedures.Procedure1<ContentAssistEntry> _function_1 = new Procedures.Procedure1<ContentAssistEntry>(){

                public void apply(ContentAssistEntry it) {
                    it.setProposal(ElkGraphProposalProvider.this.convert(suffix));
                    it.setPrefix(context.getPrefix());
                    it.setKind("PROPERTY");
                    it.setLabel(IterableExtensions.join((Iterable)suffix, (CharSequence)"."));
                    it.setDescription(ElkGraphProposalProvider.this.getDescription((ILayoutMetaData)option));
                    it.setDocumentation(option.getDescription());
                    it.setSource((Object)option);
                }
            };
            ContentAssistEntry entry = (ContentAssistEntry)ObjectExtensions.operator_doubleArrow((Object)_contentAssistEntry, (Procedures.Procedure1)_function_1);
            acceptor.accept(entry, this.getProposalPriorities().getDefaultPriority(entry));
        }
    }

    protected void completePropertyValue(ContentAssistContext context, IIdeContentProposalAcceptor acceptor) {
        IProperty property;
        EObject model = context.getCurrentModel();
        if (model instanceof ElkPropertyToValueMapEntryImpl && (property = ((ElkPropertyToValueMapEntryImpl)model).getKey()) instanceof LayoutOptionData) {
            if (Objects.equal((Object)CoreOptions.ALGORITHM, (Object)property) || Objects.equal((Object)((LayoutOptionData)property).getId(), (Object)DISCO_LAYOUT_ALG_ID)) {
                this.proposeAlgorithms(context, acceptor);
            } else {
                this.typeAwarePropertyValueProposal((LayoutOptionData)property, context, acceptor);
            }
        }
    }

    private Object typeAwarePropertyValueProposal(final LayoutOptionData property, ContentAssistContext context, IIdeContentProposalAcceptor acceptor) {
        Object _switchResult;
        block15: {
            block14: {
                _switchResult = null;
                LayoutOptionData.Type _type = property.getType();
                if (_type == null) break block14;
                switch (_type) {
                    case BOOLEAN: 
                    case ENUM: 
                    case ENUMSET: {
                        String[] choices = property.getChoices();
                        int i = 0;
                        while (i < choices.length) {
                            String proposal = choices[i];
                            Enum enumVal = property.getEnumValue(i);
                            final StringBuilder displayString = new StringBuilder(proposal);
                            int priority = 3;
                            boolean _isExperimentalPropertyValue = ElkGraphUtil.isExperimentalPropertyValue((Enum)enumVal);
                            if (_isExperimentalPropertyValue) {
                                displayString.append(" - Experimental");
                                priority = 1;
                            } else {
                                boolean _isAdvancedPropertyValue = ElkGraphUtil.isAdvancedPropertyValue((Enum)enumVal);
                                if (_isAdvancedPropertyValue) {
                                    displayString.append(" - Advanced");
                                    priority = 2;
                                }
                            }
                            Procedures.Procedure1<ContentAssistEntry> _function = new Procedures.Procedure1<ContentAssistEntry>(){

                                public void apply(ContentAssistEntry it) {
                                    it.setLabel(displayString.toString());
                                    it.setSource((Object)property);
                                }
                            };
                            ContentAssistEntry entry = this.getProposalCreator().createProposal(proposal, context, "VALUE", (Procedures.Procedure1)_function);
                            acceptor.accept(entry, this.getProposalPriorities().getDefaultPriority(entry));
                            ++i;
                        }
                        break block15;
                    }
                    case DOUBLE: {
                        Procedures.Procedure1<ContentAssistEntry> _function = new Procedures.Procedure1<ContentAssistEntry>(){

                            public void apply(ContentAssistEntry it) {
                                it.setLabel(property.getType().toString());
                                it.setSource((Object)property);
                            }
                        };
                        ContentAssistEntry entry = this.getProposalCreator().createProposal("0.0", context, "VALUE", (Procedures.Procedure1)_function);
                        acceptor.accept(entry, this.getProposalPriorities().getDefaultPriority(entry));
                        break;
                    }
                    case INT: {
                        Procedures.Procedure1<ContentAssistEntry> _function_1 = new Procedures.Procedure1<ContentAssistEntry>(){

                            public void apply(ContentAssistEntry it) {
                                it.setLabel(property.getType().toString());
                                it.setSource((Object)property);
                            }
                        };
                        ContentAssistEntry entry_1 = this.getProposalCreator().createProposal("0", context, "VALUE", (Procedures.Procedure1)_function_1);
                        acceptor.accept(entry_1, this.getProposalPriorities().getDefaultPriority(entry_1));
                        break;
                    }
                    case OBJECT: {
                        String _xtrycatchfinallyexpression = null;
                        try {
                            String _string = property.getOptionClass().newInstance().toString();
                            String _plus = "\"" + _string;
                            _xtrycatchfinallyexpression = String.valueOf(_plus) + "\"";
                        }
                        catch (Throwable _t) {
                            if (_t instanceof InstantiationException) {
                                InstantiationException e = (InstantiationException)_t;
                                _xtrycatchfinallyexpression = "";
                            }
                            if (_t instanceof IllegalAccessException) {
                                IllegalAccessException e_1 = (IllegalAccessException)_t;
                                _xtrycatchfinallyexpression = "";
                            }
                            throw Exceptions.sneakyThrow((Throwable)_t);
                        }
                        String proposal = _xtrycatchfinallyexpression;
                        Procedures.Procedure1<ContentAssistEntry> _function_2 = new Procedures.Procedure1<ContentAssistEntry>(){

                            public void apply(ContentAssistEntry it) {
                                it.setLabel(property.getType().toString());
                                it.setSource((Object)property);
                            }
                        };
                        ContentAssistEntry entry_2 = this.getProposalCreator().createProposal(proposal, context, "VALUE", (Procedures.Procedure1)_function_2);
                        acceptor.accept(entry_2, this.getProposalPriorities().getDefaultPriority(entry_2));
                        break;
                    }
                    default: {
                        _switchResult = null;
                        break;
                    }
                }
                break block15;
            }
            _switchResult = null;
        }
        return _switchResult;
    }

    protected void proposeAlgorithms(final ContentAssistContext context, IIdeContentProposalAcceptor acceptor) {
        boolean _existsConflict = this.conflictHelper.existsConflict("a", context);
        if (_existsConflict) {
            return;
        }
        LayoutMetaDataService metaDataService = LayoutMetaDataService.getInstance();
        Collection _algorithmData = metaDataService.getAlgorithmData();
        for (final LayoutAlgorithmData algorithm : _algorithmData) {
            Iterable suffix;
            boolean matchesName = !context.getPrefix().isEmpty() && algorithm.getName().toLowerCase().contains(context.getPrefix().toLowerCase());
            List idSplit = Strings.split((String)algorithm.getId(), (String)".");
            List _xifexpression = null;
            if (!matchesName) {
                _xifexpression = Strings.split((String)context.getPrefix(), (String)".");
            }
            List prefixSplit = _xifexpression;
            boolean foundMatch = false;
            int _size = idSplit.size();
            int i = _size - 1;
            while (i >= 0 && !foundMatch) {
                suffix = IterableExtensions.drop((Iterable)idSplit, (int)i);
                if (metaDataService.getAlgorithmDataBySuffix(IterableExtensions.join((Iterable)suffix, (CharSequence)".")) != null && (matchesName || this.startsWith(suffix, prefixSplit))) {
                    foundMatch = true;
                    continue;
                }
                --i;
            }
            if (!foundMatch) continue;
            suffix = IterableExtensions.drop((Iterable)idSplit, (int)i);
            ContentAssistEntry _contentAssistEntry = new ContentAssistEntry();
            Procedures.Procedure1<ContentAssistEntry> _function = new Procedures.Procedure1<ContentAssistEntry>(){

                public void apply(ContentAssistEntry it) {
                    it.setProposal(ElkGraphProposalProvider.this.convert(suffix));
                    it.setPrefix(context.getPrefix());
                    it.setKind("VALUE");
                    it.setLabel(IterableExtensions.join((Iterable)suffix, (CharSequence)"."));
                    it.setDescription(ElkGraphProposalProvider.this.getDescription((ILayoutMetaData)algorithm));
                    it.setDocumentation(algorithm.getDescription());
                    it.setSource((Object)algorithm);
                }
            };
            ContentAssistEntry entry = (ContentAssistEntry)ObjectExtensions.operator_doubleArrow((Object)_contentAssistEntry, (Procedures.Procedure1)_function);
            acceptor.accept(entry, this.getProposalPriorities().getDefaultPriority(entry));
        }
    }

    private boolean startsWith(Iterable<String> strings, List<String> prefix) {
        boolean _isEmpty = prefix.isEmpty();
        if (_isEmpty) {
            return true;
        }
        List stringList = IterableExtensions.toList(strings);
        int i = 0;
        while (i < stringList.size() - prefix.size() + 1) {
            int j = 0;
            boolean matches = true;
            while (j < prefix.size() && matches) {
                matches = ((String)stringList.get(i + j)).startsWith(prefix.get(j));
                ++j;
            }
            if (matches) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private String convert(Iterable<String> suffix) {
        Functions.Function1<String, String> _function = new Functions.Function1<String, String>(){

            public String apply(String it) {
                return ElkGraphProposalProvider.this.idValueConverter.toString((Object)it);
            }
        };
        return IterableExtensions.join((Iterable)IterableExtensions.map(suffix, (Functions.Function1)_function), (CharSequence)".");
    }

    private String getDescription(ILayoutMetaData data) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = data.getName();
        _builder.append(_name);
        _builder.append(" (");
        String _id = data.getId();
        _builder.append(_id);
        _builder.append(")");
        return _builder.toString();
    }

    protected Predicate<IEObjectDescription> getCrossrefFilter(CrossReference reference, ContentAssistContext context) {
        EObject model = context.getCurrentModel();
        if (model instanceof ElkEdgeSection) {
            CrossReference _incomingShapeElkConnectableShapeCrossReference_1_0_0_2_0;
            boolean _matched = false;
            CrossReference _incomingShapeElkConnectableShapeCrossReference_4_0_0_2_0 = this.grammar.getElkEdgeSectionAccess().getIncomingShapeElkConnectableShapeCrossReference_4_0_0_2_0();
            if (Objects.equal((Object)reference, (Object)_incomingShapeElkConnectableShapeCrossReference_4_0_0_2_0)) {
                _matched = true;
            }
            if (!_matched && Objects.equal((Object)reference, (Object)(_incomingShapeElkConnectableShapeCrossReference_1_0_0_2_0 = this.grammar.getElkSingleEdgeSectionAccess().getIncomingShapeElkConnectableShapeCrossReference_1_0_0_2_0()))) {
                _matched = true;
            }
            if (_matched) {
                return new SectionShapeFilter((ElkEdgeSection)model, 0);
            }
            if (!_matched) {
                CrossReference _outgoingShapeElkConnectableShapeCrossReference_1_0_1_2_0;
                CrossReference _outgoingShapeElkConnectableShapeCrossReference_4_0_1_2_0 = this.grammar.getElkEdgeSectionAccess().getOutgoingShapeElkConnectableShapeCrossReference_4_0_1_2_0();
                if (Objects.equal((Object)reference, (Object)_outgoingShapeElkConnectableShapeCrossReference_4_0_1_2_0)) {
                    _matched = true;
                }
                if (!_matched && Objects.equal((Object)reference, (Object)(_outgoingShapeElkConnectableShapeCrossReference_1_0_1_2_0 = this.grammar.getElkSingleEdgeSectionAccess().getOutgoingShapeElkConnectableShapeCrossReference_1_0_1_2_0()))) {
                    _matched = true;
                }
                if (_matched) {
                    return new SectionShapeFilter((ElkEdgeSection)model, 1);
                }
            }
        }
        final URI resourceURI = model.eResource().getURI();
        Predicate<IEObjectDescription> _function = new Predicate<IEObjectDescription>(){

            public boolean apply(IEObjectDescription candidate) {
                URI _trimFragment = candidate.getEObjectURI().trimFragment();
                return Objects.equal((Object)_trimFragment, (Object)resourceURI);
            }
        };
        return _function;
    }

    @FinalFieldsConstructor
    public static class SectionShapeFilter
    implements Predicate<IEObjectDescription> {
        private static final int INCOMING = 0;
        private static final int OUTGOING = 1;
        private final ElkEdgeSection section;
        private final int type;

        public boolean apply(IEObjectDescription input) {
            boolean _switchResult = false;
            int type = this.type;
            switch (type) {
                case 0: {
                    _switchResult = this.isInList(input, (List<? extends EObject>)this.section.getParent().getSources());
                    break;
                }
                case 1: {
                    _switchResult = this.isInList(input, (List<? extends EObject>)this.section.getParent().getTargets());
                    break;
                }
                default: {
                    _switchResult = true;
                }
            }
            return _switchResult;
        }

        private boolean isInList(final IEObjectDescription input, List<? extends EObject> list) {
            boolean _xblockexpression = false;
            EObject object = input.getEObjectOrProxy();
            boolean _xifexpression = false;
            boolean _eIsProxy = object.eIsProxy();
            if (_eIsProxy) {
                Functions.Function1<EObject, Boolean> _function = new Functions.Function1<EObject, Boolean>(){

                    public Boolean apply(EObject it) {
                        URI _uRI = EcoreUtil.getURI((EObject)it);
                        URI _eObjectURI = input.getEObjectURI();
                        return Objects.equal((Object)_uRI, (Object)_eObjectURI);
                    }
                };
                _xifexpression = IterableExtensions.exists(list, (Functions.Function1)_function);
            } else {
                _xifexpression = list.contains(object);
            }
            _xblockexpression = _xifexpression;
            return _xblockexpression;
        }

        public SectionShapeFilter(ElkEdgeSection section, int type) {
            this.section = section;
            this.type = type;
        }
    }
}

