/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.transaction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.commit.CDOChangeSetData;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.revision.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.internal.common.commit.CDOChangeSetDataImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDORevisionDeltaImpl;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDOFeatureDelta;
import org.eclipse.emf.internal.cdo.transaction.CDOUserSavepointImpl;
import org.eclipse.emf.spi.cdo.CDOTransactionStrategy;
import org.eclipse.emf.spi.cdo.InternalCDOSavepoint;
import org.eclipse.emf.spi.cdo.InternalCDOTransaction;
import org.eclipse.net4j.util.collection.MultiMap;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOSavepointImpl
extends CDOUserSavepointImpl
implements InternalCDOSavepoint {
    private final InternalCDOTransaction transaction;
    private Map<CDOID, CDORevision> baseNewObjects = CDOIDUtil.createMap();
    private Map<CDOID, CDOObject> newObjects = CDOIDUtil.createMap();
    private Map<CDOID, CDOObject> reattachedObjects = CDOIDUtil.createMap();
    private Map<CDOID, CDOObject> detachedObjects = new HashMap<CDOID, CDOObject>(){
        private static final long serialVersionUID = 1L;

        @Override
        public CDOObject put(CDOID key, CDOObject object) {
            Object object2 = CDOSavepointImpl.this.transaction.getViewMonitor();
            synchronized (object2) {
                CDOObject cDOObject;
                CDOSavepointImpl.this.transaction.lockView();
                try {
                    CDOSavepointImpl.this.baseNewObjects.remove(key);
                    CDOSavepointImpl.this.newObjects.remove(key);
                    CDOSavepointImpl.this.reattachedObjects.remove(key);
                    CDOSavepointImpl.this.dirtyObjects.remove(key);
                    CDOSavepointImpl.this.revisionDeltas.remove(key);
                    cDOObject = super.put(key, object);
                }
                catch (Throwable throwable) {
                    CDOSavepointImpl.this.transaction.unlockView();
                    throw throwable;
                }
                CDOSavepointImpl.this.transaction.unlockView();
                return cDOObject;
            }
        }
    };
    private Map<CDOID, CDOObject> dirtyObjects = CDOIDUtil.createMap();
    private Map<CDOID, CDORevisionDelta> revisionDeltas = new HashMap<CDOID, CDORevisionDelta>(){
        private static final long serialVersionUID = 1L;

        @Override
        public CDORevisionDelta put(CDOID id, CDORevisionDelta delta) {
            CDOSavepointImpl.this.transaction.clearResourcePathCacheIfNecessary(delta);
            return super.put(id, delta);
        }

        @Override
        public void putAll(Map<? extends CDOID, ? extends CDORevisionDelta> m) {
            throw new UnsupportedOperationException();
        }
    };
    private boolean wasDirty;

    public CDOSavepointImpl(InternalCDOTransaction transaction, InternalCDOSavepoint lastSavepoint) {
        super(transaction, lastSavepoint);
        this.transaction = transaction;
        this.wasDirty = transaction.isDirty();
    }

    @Override
    public InternalCDOTransaction getTransaction() {
        return (InternalCDOTransaction)super.getTransaction();
    }

    @Override
    public InternalCDOSavepoint getFirstSavePoint() {
        Object object = this.transaction.getViewMonitor();
        synchronized (object) {
            InternalCDOSavepoint internalCDOSavepoint;
            this.transaction.lockView();
            try {
                internalCDOSavepoint = (InternalCDOSavepoint)super.getFirstSavePoint();
            }
            catch (Throwable throwable) {
                this.transaction.unlockView();
                throw throwable;
            }
            this.transaction.unlockView();
            return internalCDOSavepoint;
        }
    }

    @Override
    public InternalCDOSavepoint getPreviousSavepoint() {
        Object object = this.transaction.getViewMonitor();
        synchronized (object) {
            InternalCDOSavepoint internalCDOSavepoint;
            this.transaction.lockView();
            try {
                internalCDOSavepoint = (InternalCDOSavepoint)super.getPreviousSavepoint();
            }
            catch (Throwable throwable) {
                this.transaction.unlockView();
                throw throwable;
            }
            this.transaction.unlockView();
            return internalCDOSavepoint;
        }
    }

    @Override
    public InternalCDOSavepoint getNextSavepoint() {
        Object object = this.transaction.getViewMonitor();
        synchronized (object) {
            InternalCDOSavepoint internalCDOSavepoint;
            this.transaction.lockView();
            try {
                internalCDOSavepoint = (InternalCDOSavepoint)super.getNextSavepoint();
            }
            catch (Throwable throwable) {
                this.transaction.unlockView();
                throw throwable;
            }
            this.transaction.unlockView();
            return internalCDOSavepoint;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.transaction.getViewMonitor();
        synchronized (object) {
            this.transaction.lockView();
            try {
                this.newObjects.clear();
                this.dirtyObjects.clear();
                this.revisionDeltas.clear();
                this.baseNewObjects.clear();
                this.detachedObjects.clear();
                this.reattachedObjects.clear();
            }
            finally {
                this.transaction.unlockView();
            }
        }
    }

    @Override
    public boolean wasDirty() {
        return this.wasDirty;
    }

    @Override
    public Map<CDOID, CDOObject> getNewObjects() {
        return this.newObjects;
    }

    @Override
    public Map<CDOID, CDOObject> getDetachedObjects() {
        return this.detachedObjects;
    }

    @Override
    public Map<CDOID, CDOObject> getReattachedObjects() {
        return this.reattachedObjects;
    }

    @Override
    public Map<CDOID, CDOObject> getDirtyObjects() {
        return this.dirtyObjects;
    }

    @Override
    @Deprecated
    public Set<CDOID> getSharedDetachedObjects() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void recalculateSharedDetachedObjects() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public ConcurrentMap<CDOID, CDORevisionDelta> getRevisionDeltas() {
        return new ConcurrentMap<CDOID, CDORevisionDelta>(){

            @Override
            public int size() {
                return CDOSavepointImpl.this.revisionDeltas.size();
            }

            @Override
            public boolean isEmpty() {
                return CDOSavepointImpl.this.revisionDeltas.isEmpty();
            }

            @Override
            public boolean containsKey(Object key) {
                return CDOSavepointImpl.this.revisionDeltas.containsKey(key);
            }

            @Override
            public boolean containsValue(Object value) {
                return CDOSavepointImpl.this.revisionDeltas.containsValue(value);
            }

            @Override
            public CDORevisionDelta get(Object key) {
                return (CDORevisionDelta)CDOSavepointImpl.this.revisionDeltas.get(key);
            }

            @Override
            public CDORevisionDelta put(CDOID key, CDORevisionDelta value) {
                return CDOSavepointImpl.this.revisionDeltas.put(key, value);
            }

            @Override
            public CDORevisionDelta remove(Object key) {
                return (CDORevisionDelta)CDOSavepointImpl.this.revisionDeltas.remove(key);
            }

            @Override
            public void putAll(Map<? extends CDOID, ? extends CDORevisionDelta> m) {
                CDOSavepointImpl.this.revisionDeltas.putAll(m);
            }

            @Override
            public void clear() {
                CDOSavepointImpl.this.revisionDeltas.clear();
            }

            @Override
            public Set<CDOID> keySet() {
                return CDOSavepointImpl.this.revisionDeltas.keySet();
            }

            @Override
            public Collection<CDORevisionDelta> values() {
                return CDOSavepointImpl.this.revisionDeltas.values();
            }

            @Override
            public Set<Map.Entry<CDOID, CDORevisionDelta>> entrySet() {
                return CDOSavepointImpl.this.revisionDeltas.entrySet();
            }

            @Override
            public boolean equals(Object o) {
                return CDOSavepointImpl.this.revisionDeltas.equals(o);
            }

            @Override
            public int hashCode() {
                return CDOSavepointImpl.this.revisionDeltas.hashCode();
            }

            @Override
            public CDORevisionDelta putIfAbsent(CDOID key, CDORevisionDelta value) {
                return null;
            }

            @Override
            public boolean remove(Object key, Object value) {
                return false;
            }

            @Override
            public boolean replace(CDOID key, CDORevisionDelta oldValue, CDORevisionDelta newValue) {
                return false;
            }

            @Override
            public CDORevisionDelta replace(CDOID key, CDORevisionDelta value) {
                return null;
            }
        };
    }

    @Override
    public Map<CDOID, CDORevisionDelta> getRevisionDeltas2() {
        return this.revisionDeltas;
    }

    public CDOChangeSetData getChangeSetData() {
        Object object = this.transaction.getViewMonitor();
        synchronized (object) {
            CDOChangeSetData cDOChangeSetData;
            this.transaction.lockView();
            try {
                cDOChangeSetData = this.createChangeSetData(this.newObjects, this.revisionDeltas, this.detachedObjects);
            }
            catch (Throwable throwable) {
                this.transaction.unlockView();
                throw throwable;
            }
            this.transaction.unlockView();
            return cDOChangeSetData;
        }
    }

    @Override
    public CDOChangeSetData getAllChangeSetData() {
        Object object = this.transaction.getViewMonitor();
        synchronized (object) {
            CDOChangeSetData cDOChangeSetData;
            this.transaction.lockView();
            try {
                cDOChangeSetData = this.createChangeSetData(this.getAllNewObjects(), this.getAllRevisionDeltas(), this.getAllDetachedObjects());
            }
            catch (Throwable throwable) {
                this.transaction.unlockView();
                throw throwable;
            }
            this.transaction.unlockView();
            return cDOChangeSetData;
        }
    }

    private CDOChangeSetData createChangeSetData(Map<CDOID, CDOObject> newObjects, Map<CDOID, CDORevisionDelta> revisionDeltas, Map<CDOID, CDOObject> detachedObjects) {
        ArrayList<CDORevision> newList = new ArrayList<CDORevision>(newObjects.size());
        for (CDOObject object : newObjects.values()) {
            newList.add(object.cdoRevision());
        }
        ArrayList<CDORevisionDelta> changedList = new ArrayList<CDORevisionDelta>(revisionDeltas.size());
        for (CDORevisionDelta delta : revisionDeltas.values()) {
            changedList.add(delta);
        }
        ArrayList<CDOIDAndVersion> detachedList = new ArrayList<CDOIDAndVersion>(detachedObjects.size());
        for (CDOID id : detachedObjects.keySet()) {
            detachedList.add(CDOIDUtil.createIDAndVersion((CDOID)id, (int)0));
        }
        return new CDOChangeSetDataImpl(newList, changedList, detachedList);
    }

    @Override
    public Map<CDOID, CDORevision> getBaseNewObjects() {
        return this.baseNewObjects;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<CDOID, CDOObject> getAllDirtyObjects() {
        Object object = this.transaction.getViewMonitor();
        synchronized (object) {
            this.transaction.lockView();
            try {
                if (this.getPreviousSavepoint() == null) {
                    Map<CDOID, CDOObject> map = Collections.unmodifiableMap(this.getDirtyObjects());
                    return map;
                }
                MultiMap.ListBased dirtyObjects = new MultiMap.ListBased();
                InternalCDOSavepoint savepoint = this;
                while (true) {
                    if (savepoint == null) {
                        MultiMap.ListBased listBased = dirtyObjects;
                        return listBased;
                    }
                    dirtyObjects.getDelegates().add(savepoint.getDirtyObjects());
                    savepoint = savepoint.getPreviousSavepoint();
                }
            }
            finally {
                this.transaction.unlockView();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<CDOID, CDOObject> getAllNewObjects() {
        Object object = this.transaction.getViewMonitor();
        synchronized (object) {
            this.transaction.lockView();
            try {
                if (this.getPreviousSavepoint() == null) {
                    Map<CDOID, CDOObject> map = Collections.unmodifiableMap(this.getNewObjects());
                    return map;
                }
                Map newObjects = CDOIDUtil.createMap();
                InternalCDOSavepoint savepoint = this.getFirstSavePoint();
                block7: while (true) {
                    if (savepoint == null) {
                        Map map = newObjects;
                        return map;
                    }
                    newObjects.putAll(savepoint.getNewObjects());
                    Iterator<CDOID> iterator = savepoint.getDetachedObjects().keySet().iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            savepoint = savepoint.getNextSavepoint();
                            continue block7;
                        }
                        CDOID removedID = iterator.next();
                        newObjects.remove(removedID);
                    }
                    break;
                }
            }
            finally {
                this.transaction.unlockView();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<CDOID, CDORevision> getAllBaseNewObjects() {
        Object object = this.transaction.getViewMonitor();
        synchronized (object) {
            this.transaction.lockView();
            try {
                if (this.getPreviousSavepoint() == null) {
                    Map<CDOID, CDORevision> map = Collections.unmodifiableMap(this.getBaseNewObjects());
                    return map;
                }
                MultiMap.ListBased newObjects = new MultiMap.ListBased();
                InternalCDOSavepoint savepoint = this;
                while (true) {
                    if (savepoint == null) {
                        MultiMap.ListBased listBased = newObjects;
                        return listBased;
                    }
                    newObjects.getDelegates().add(savepoint.getBaseNewObjects());
                    savepoint = savepoint.getPreviousSavepoint();
                }
            }
            finally {
                this.transaction.unlockView();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<CDOID, CDORevisionDelta> getAllRevisionDeltas() {
        Object object = this.transaction.getViewMonitor();
        synchronized (object) {
            this.transaction.lockView();
            try {
                if (this.getPreviousSavepoint() == null) {
                    Map<CDOID, CDORevisionDelta> map = Collections.unmodifiableMap(this.getRevisionDeltas2());
                    return map;
                }
                Map allRevisionDeltas = CDOIDUtil.createMap();
                InternalCDOSavepoint savepoint = this.getFirstSavePoint();
                while (savepoint != null) {
                    for (CDORevisionDelta revisionDelta : savepoint.getRevisionDeltas2().values()) {
                        CDOID id = revisionDelta.getID();
                        if (this.isNewObject(id)) continue;
                        CDORevisionDeltaImpl oldRevisionDelta = (CDORevisionDeltaImpl)allRevisionDeltas.get(id);
                        if (oldRevisionDelta == null) {
                            allRevisionDeltas.put(id, revisionDelta.copy());
                            continue;
                        }
                        for (CDOFeatureDelta delta : revisionDelta.getFeatureDeltas()) {
                            CDOFeatureDelta copy = ((InternalCDOFeatureDelta)delta).copy();
                            oldRevisionDelta.addFeatureDelta(copy, null);
                        }
                    }
                    Set<CDOID> reattachedObjects = savepoint.getReattachedObjects().keySet();
                    for (CDOID detachedID : savepoint.getDetachedObjects().keySet()) {
                        if (reattachedObjects.contains(detachedID)) continue;
                        allRevisionDeltas.remove(detachedID);
                    }
                    savepoint = savepoint.getNextSavepoint();
                }
                Map<CDOID, CDORevisionDelta> map = Collections.unmodifiableMap(allRevisionDeltas);
                return map;
            }
            finally {
                this.transaction.unlockView();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<CDOID, CDOObject> getAllDetachedObjects() {
        Object object = this.transaction.getViewMonitor();
        synchronized (object) {
            this.transaction.lockView();
            try {
                if (this.getPreviousSavepoint() == null && this.reattachedObjects.isEmpty()) {
                    Map<CDOID, CDOObject> map = Collections.unmodifiableMap(this.getDetachedObjects());
                    return map;
                }
                Map detachedObjects = CDOIDUtil.createMap();
                InternalCDOSavepoint savepoint = this.getFirstSavePoint();
                while (savepoint != null) {
                    for (Map.Entry<CDOID, CDOObject> entry : savepoint.getDetachedObjects().entrySet()) {
                        CDOID detachedID = entry.getKey();
                        if (this.isNewObject(detachedID)) continue;
                        CDOObject detachedObject = entry.getValue();
                        detachedObjects.put(detachedID, detachedObject);
                    }
                    for (CDOID reattachedID : savepoint.getReattachedObjects().keySet()) {
                        detachedObjects.remove(reattachedID);
                    }
                    savepoint = savepoint.getNextSavepoint();
                }
                Map map = detachedObjects;
                return map;
            }
            finally {
                this.transaction.unlockView();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isNewObject(CDOID id) {
        if (id.isTemporary()) {
            return true;
        }
        Object object = this.transaction.getViewMonitor();
        synchronized (object) {
            this.transaction.lockView();
            try {
                InternalCDOSavepoint savepoint = this;
                while (savepoint != null) {
                    if (savepoint.getNewObjects().containsKey(id)) {
                        return true;
                    }
                    savepoint = savepoint.getPreviousSavepoint();
                }
            }
            finally {
                this.transaction.unlockView();
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() {
        Object object = this.transaction.getViewMonitor();
        synchronized (object) {
            this.transaction.lockView();
            try {
                InternalCDOTransaction transaction = this.getTransaction();
                LifecycleUtil.checkActive((Object)transaction);
                CDOTransactionStrategy transactionStrategy = transaction.getTransactionStrategy();
                transactionStrategy.rollback(transaction, this);
            }
            finally {
                this.transaction.unlockView();
            }
        }
    }
}

