/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.chessmlprofile.Dependability.DependableComponent;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum AttackType implements Enumerator
{
    MASQUERADE_ATTACK(0, "masqueradeAttack", "masqueradeAttack"),
    DENIAL_OF_SERVICE_ATTACK(1, "denialOfServiceAttack", "denialOfServiceAttack"),
    BRUTE_FORCE_ATTACK(2, "bruteForceAttack", "bruteForceAttack"),
    DATA_SPOOFING_ATTACK(3, "dataSpoofingAttack", "dataSpoofingAttack");

    public static final int MASQUERADE_ATTACK_VALUE = 0;
    public static final int DENIAL_OF_SERVICE_ATTACK_VALUE = 1;
    public static final int BRUTE_FORCE_ATTACK_VALUE = 2;
    public static final int DATA_SPOOFING_ATTACK_VALUE = 3;
    private static final AttackType[] VALUES_ARRAY;
    public static final List<AttackType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new AttackType[]{MASQUERADE_ATTACK, DENIAL_OF_SERVICE_ATTACK, BRUTE_FORCE_ATTACK, DATA_SPOOFING_ATTACK};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static AttackType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AttackType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AttackType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AttackType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AttackType get(int value) {
        switch (value) {
            case 0: {
                return MASQUERADE_ATTACK;
            }
            case 1: {
                return DENIAL_OF_SERVICE_ATTACK;
            }
            case 2: {
                return BRUTE_FORCE_ATTACK;
            }
            case 3: {
                return DATA_SPOOFING_ATTACK;
            }
        }
        return null;
    }

    private AttackType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

