/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.tools.api.command.view;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.RefreshIdsHolder;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.DragAndDropTarget;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramMappingsManager;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramMappingsManagerRegistry;
import org.eclipse.sirius.diagram.business.internal.experimental.sync.AbstractDNodeCandidate;
import org.eclipse.sirius.diagram.business.internal.experimental.sync.DDiagramElementSynchronizer;
import org.eclipse.sirius.diagram.business.internal.experimental.sync.DDiagramSynchronizer;
import org.eclipse.sirius.diagram.business.internal.experimental.sync.DEdgeCandidate;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.MappingBasedDecoration;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.SemanticBasedDecoration;

public class CreateDDiagramElementCommand
extends RecordingCommand {
    private DragAndDropTarget container;
    private ModelAccessor accessor;
    private IInterpreter interpreter;
    private AbstractDNodeCandidate nodeCandidate;
    private DEdgeCandidate edgeCandidate;

    public CreateDDiagramElementCommand(TransactionalEditingDomain domain, EObject semantic, AbstractNodeMapping mapping, DragAndDropTarget container) {
        this(domain, semantic);
        this.container = container;
        this.nodeCandidate = new AbstractDNodeCandidate(mapping, semantic, container, RefreshIdsHolder.getOrCreateHolder((EObject)this.getParentDiagram()));
    }

    public CreateDDiagramElementCommand(TransactionalEditingDomain domain, EObject semantic, EdgeMapping mapping, EdgeTarget source, EdgeTarget target) {
        this(domain, semantic);
        this.container = (DragAndDropTarget)((Object)source);
        this.edgeCandidate = new DEdgeCandidate(mapping, semantic, source, target, RefreshIdsHolder.getOrCreateHolder((EObject)this.getParentDiagram()));
    }

    private CreateDDiagramElementCommand(TransactionalEditingDomain domain, EObject semantic) {
        super(domain);
        this.accessor = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor(semantic);
        this.interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(semantic);
    }

    protected void doExecute() {
        DDiagram diagram = this.getParentDiagram();
        Session session = SessionManager.INSTANCE.getSession(((DSemanticDiagram)diagram).getTarget());
        DiagramMappingsManager mappingManager = DiagramMappingsManagerRegistry.INSTANCE.getDiagramMappingsManager(session, diagram);
        DDiagramSynchronizer diagramSync = new DDiagramSynchronizer(this.interpreter, diagram.getDescription(), this.accessor);
        diagramSync.setDiagram((DSemanticDiagram)diagram);
        DDiagramElementSynchronizer elementSync = diagramSync.getElementSynchronizer();
        if (this.nodeCandidate != null) {
            elementSync.createNewNode(mappingManager, this.nodeCandidate, this.isBorder());
        } else if (this.edgeCandidate != null) {
            HashMap<EdgeMapping, Collection<MappingBasedDecoration>> edgeToMappingBasedDecoration = new HashMap<EdgeMapping, Collection<MappingBasedDecoration>>();
            HashMap<String, Collection<SemanticBasedDecoration>> edgeToSemanticBasedDecoration = new HashMap<String, Collection<SemanticBasedDecoration>>();
            Map<DiagramElementMapping, Collection<EdgeTarget>> mappingsToEdgeTargets = elementSync.computeMappingsToEdgeTargets(session.getSelectedViewpoints(false));
            diagramSync.computeDecorations(mappingsToEdgeTargets, edgeToSemanticBasedDecoration, edgeToMappingBasedDecoration);
            elementSync.createNewEdge(mappingManager, this.edgeCandidate, mappingsToEdgeTargets, edgeToMappingBasedDecoration, edgeToSemanticBasedDecoration);
        }
    }

    private boolean isBorder() {
        return false;
    }

    private DDiagram getParentDiagram() {
        DDiagram parentDiagram = null;
        if (this.container instanceof DDiagram) {
            parentDiagram = (DDiagram)this.container;
        } else if (this.container instanceof DDiagramElement) {
            parentDiagram = ((DDiagramElement)((Object)this.container)).getParentDiagram();
        }
        return parentDiagram;
    }
}

