/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.figures;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.PapyrusWrappingLabel;
import org.eclipse.papyrus.uml.diagram.common.draw2d.InteractionFigure;
import org.eclipse.papyrus.uml.diagram.common.draw2d.LeftToolbarLayout;
import org.eclipse.papyrus.uml.diagram.common.figure.node.InteractionRectangleFigure;
import org.eclipse.swt.graphics.Font;

public class StereotypeInteractionFigure
extends InteractionRectangleFigure {
    protected RectangleFigure createHeader() {
        this.interactionLabel = new PapyrusWrappingLabel(){

            public void setFont(Font f) {
                super.setFont(f);
                if (StereotypeInteractionFigure.this.stereotypesLabel != null) {
                    StereotypeInteractionFigure.this.stereotypesLabel.setFont(f);
                }
                if (StereotypeInteractionFigure.this.stereotypePropertiesInBraceContent != null) {
                    StereotypeInteractionFigure.this.stereotypePropertiesInBraceContent.setFont(f);
                }
            }
        };
        this.interactionLabel.setAlignment(2);
        this.interactionLabel.setBorder((Border)new MarginBorder(1, 1, 3, 3));
        this.interactionLabelContainer = new InteractionFigure(){

            protected void outlineShape(Graphics graphics) {
                Rectangle r = this.getBounds();
                int labelWidth = -1;
                for (Object obj : this.getChildren()) {
                    if (obj instanceof Label) {
                        labelWidth = Math.max(labelWidth, ((Label)obj).getPreferredSize().width);
                        continue;
                    }
                    if (!(obj instanceof WrappingLabel)) continue;
                    WrappingLabel wLabel = (WrappingLabel)obj;
                    labelWidth = Math.max(labelWidth, wLabel.getPreferredSize().width);
                }
                if (labelWidth <= 0) {
                    labelWidth = r.width / 4;
                } else if (labelWidth > r.width) {
                    labelWidth = r.width;
                }
                PointList points = new PointList();
                Point verticalStart = new Point();
                Point verticalEnd = new Point();
                Point diagonalStart = new Point();
                Point diagonalEnd = new Point();
                Point horizontalStart = new Point();
                Point horizontalEnd = new Point();
                verticalStart.x = r.x + labelWidth + 15;
                verticalStart.y = r.y;
                points.addPoint(verticalStart);
                verticalEnd.x = verticalStart.x;
                verticalEnd.y = verticalStart.y + r.height / 2 + 3;
                points.addPoint(verticalEnd);
                diagonalStart.x = verticalEnd.x;
                diagonalStart.y = verticalEnd.y;
                points.addPoint(diagonalStart);
                diagonalEnd.x = diagonalStart.x - r.height / 2 + 3;
                diagonalEnd.y = r.y + r.height - 1;
                points.addPoint(diagonalEnd);
                horizontalStart.x = diagonalEnd.x;
                horizontalStart.y = diagonalEnd.y;
                points.addPoint(horizontalStart);
                horizontalEnd.x = r.x;
                horizontalEnd.y = horizontalStart.y;
                points.addPoint(horizontalEnd);
                graphics.drawPolyline(points);
            }
        };
        this.interactionLabelContainer.setBorder((Border)new MarginBorder(3, 3, 3, 15));
        this.interactionLabelContainer.setLayoutManager((LayoutManager)new LeftToolbarLayout());
        this.interactionLabelContainer.add((IFigure)this.interactionLabel);
        Figure header = new Figure();
        header.setLayoutManager((LayoutManager)new ToolbarLayout(false));
        header.add((IFigure)this.interactionLabelContainer);
        RectangleFigure container = new RectangleFigure();
        container.setOutline(false);
        container.setFill(false);
        container.setLayoutManager((LayoutManager)new BorderLayout());
        container.add((IFigure)header, (Object)BorderLayout.LEFT);
        return container;
    }

    public void setStereotypes(String stereotypes) {
        if (stereotypes == null || stereotypes.trim().equals("")) {
            if (this.stereotypesLabel != null) {
                this.getStereotypeLabelContainer().remove((IFigure)this.stereotypesLabel);
                this.stereotypesLabel = null;
            }
            return;
        }
        super.setStereotypes(stereotypes);
    }

    public void setStereotypePropertiesInBrace(String stereotypeProperties) {
        if (stereotypeProperties == null || stereotypeProperties.trim().equals("")) {
            if (this.stereotypePropertiesInBraceContent != null) {
                this.getStereotypePropertiesInBraceLabelContainer().remove((IFigure)this.stereotypePropertiesInBraceContent);
                this.stereotypePropertiesInBraceContent = null;
            }
            return;
        }
        super.setStereotypePropertiesInBrace(stereotypeProperties);
    }

    protected IFigure getStereotypeLabelContainer() {
        return this.interactionLabelContainer;
    }

    protected IFigure getStereotypePropertiesInBraceLabelContainer() {
        return this.interactionLabelContainer;
    }
}

