/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.command;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.EditCommandRequestWrapper;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;

public class CreateElementAndNodeCommand
extends AbstractTransactionalCommand {
    protected ShapeNodeEditPart nodeEditPart;
    protected Point location;
    protected EObject parent;
    protected EObject element;
    protected TransactionalEditingDomain editingDomain;
    protected Command elementCreationCommand;
    protected Command nodeCreationCommand;
    protected Map<String, Object> createElementRequestParameters = new HashMap<String, Object>();
    protected IHintedType elementType;
    protected CreateViewRequest createViewRequest;
    private List affectedFiles;

    public CreateElementAndNodeCommand(TransactionalEditingDomain editingDomain, ShapeNodeEditPart nodeEditPart, EObject parent, IHintedType elementType, Point location) {
        super(editingDomain, "Create element and node command", null);
        this.nodeEditPart = nodeEditPart;
        this.location = location;
        this.parent = parent;
        this.editingDomain = editingDomain;
        this.elementType = elementType;
    }

    public List getAffectedFiles() {
        if (this.affectedFiles == null) {
            this.affectedFiles = this.getCreatedView() != null ? CreateElementAndNodeCommand.getWorkspaceFiles((EObject)this.getCreatedView()) : super.getAffectedFiles();
        }
        return this.affectedFiles;
    }

    public void putCreateElementRequestParameter(String key, Object value) {
        this.createElementRequestParameters.put(key, value);
    }

    public View getCreatedView() {
        List l;
        if (this.createViewRequest != null && !(l = (List)this.createViewRequest.getNewObject()).isEmpty() && l.get(0) instanceof CreateViewRequest.ViewDescriptor) {
            return (View)((CreateViewRequest.ViewDescriptor)l.get(0)).getAdapter(View.class);
        }
        return null;
    }

    public void undo() {
        if (this.nodeCreationCommand != null && this.nodeCreationCommand.canUndo()) {
            this.nodeCreationCommand.undo();
        }
        if (this.elementCreationCommand != null && this.elementCreationCommand.canUndo()) {
            this.elementCreationCommand.undo();
        }
    }

    protected EObject createModelElement() {
        CreateElementRequest req = new CreateElementRequest(this.editingDomain, this.parent, (IElementType)this.elementType);
        req.addParameters(this.createElementRequestParameters);
        this.elementCreationCommand = this.nodeEditPart.getCommand((Request)new EditCommandRequestWrapper((IEditCommandRequest)req));
        if (this.elementCreationCommand != null) {
            this.elementCreationCommand.execute();
            EObject result = req.getNewElement();
            if (result instanceof EObject) {
                return result;
            }
        }
        return null;
    }

    protected void createElementView() {
        if (this.nodeEditPart != null && this.getCreatedView() == null) {
            CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)new EObjectAdapter(this.element), Node.class, this.elementType.getSemanticHint(), this.nodeEditPart.getDiagramPreferencesHint());
            this.createViewRequest = new CreateViewRequest(descriptor);
            this.createViewRequest.setLocation(this.location);
            this.nodeCreationCommand = this.nodeEditPart.getCommand((Request)this.createViewRequest);
            if (this.nodeCreationCommand != null && this.nodeCreationCommand.canExecute()) {
                this.nodeCreationCommand.execute();
            }
        }
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.element = this.createModelElement();
        if (this.element != null) {
            this.createElementView();
        }
        return CommandResult.newOKCommandResult();
    }
}

