/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.transform;

import org.eclipse.core.runtime.Platform;
import org.eclipse.gmf.internal.bridge.transform.TransformToGenModelWizard;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class TransformToGenModelAction
implements IObjectActionDelegate {
    private static final int WIZARD_WIDTH_INCH = 6;
    private static final int WIZARD_HEIGHT_INCH = 6;
    private IWorkbenchPart myPart;
    private IStructuredSelection sselection;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.myPart = targetPart;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection structuredSelection;
        this.sselection = structuredSelection = (IStructuredSelection)selection;
    }

    public void run(IAction action) {
        int y;
        TransformToGenModelWizard wiz = this.createTransformToGenModelWizard();
        wiz.setWindowTitle(action.getText());
        wiz.init(PlatformUI.getWorkbench(), this.sselection);
        WizardDialog wd = new WizardDialog(this.getShell(), (IWizard)wiz);
        wd.create();
        Rectangle mb = this.getShell().getMonitor().getClientArea();
        Point dpi = this.getShell().getDisplay().getDPI();
        if ("macosx".equals(Platform.getOS())) {
            dpi = new Point(110, 110);
        }
        int width = dpi.x * 6;
        int height = dpi.y * 6;
        int x = mb.x + (mb.width - width) / 2;
        if (x < mb.x) {
            x = mb.x;
        }
        if ((y = mb.y + (mb.height - height) / 2) < mb.y) {
            y = mb.y;
        }
        wd.getShell().setLocation(x, y);
        wd.getShell().setSize(width, height);
        wd.open();
    }

    protected TransformToGenModelWizard createTransformToGenModelWizard() {
        return new TransformToGenModelWizard();
    }

    private Shell getShell() {
        return this.myPart.getSite().getShell();
    }
}

