/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.CleanCTranslatorToPython.core.visitors;

import eu.fbk.eclipse.standardtools.CleanCTranslatorToPython.core.utils.CleanCNavigator;
import eu.fbk.eclipse.standardtools.CleanCTranslatorToPython.core.utils.PythonUtil;
import eu.fbk.eclipse.standardtools.utils.core.utils.EObjectExtractor;
import eu.fbk.eclipse.standardtools.utils.core.utils.SysMLElementExtractor;
import eu.fbk.tools.editor.c.c.FunctionDefinition;
import eu.fbk.tools.editor.c.c.TranslationUnit;
import eu.fbk.tools.editor.c.expression.expression.AdditiveExpression;
import eu.fbk.tools.editor.c.expression.expression.AllExpression;
import eu.fbk.tools.editor.c.expression.expression.AndExpression;
import eu.fbk.tools.editor.c.expression.expression.ArgumentExpressionList;
import eu.fbk.tools.editor.c.expression.expression.AssignmentExpression;
import eu.fbk.tools.editor.c.expression.expression.BooleanLiteral;
import eu.fbk.tools.editor.c.expression.expression.CastExpression;
import eu.fbk.tools.editor.c.expression.expression.CharacterLiteral;
import eu.fbk.tools.editor.c.expression.expression.DecimalLiteral;
import eu.fbk.tools.editor.c.expression.expression.EnumSpecifier;
import eu.fbk.tools.editor.c.expression.expression.EnumeratorList;
import eu.fbk.tools.editor.c.expression.expression.EqualityExpression;
import eu.fbk.tools.editor.c.expression.expression.ExclusiveOrExpression;
import eu.fbk.tools.editor.c.expression.expression.Expression;
import eu.fbk.tools.editor.c.expression.expression.ExternalTypeSpecifier;
import eu.fbk.tools.editor.c.expression.expression.FloatingPointLiteral;
import eu.fbk.tools.editor.c.expression.expression.HexLiteral;
import eu.fbk.tools.editor.c.expression.expression.Identifier;
import eu.fbk.tools.editor.c.expression.expression.InclusiveOrExpression;
import eu.fbk.tools.editor.c.expression.expression.LogicalAndExpression;
import eu.fbk.tools.editor.c.expression.expression.LogicalOrExpression;
import eu.fbk.tools.editor.c.expression.expression.MultiplicativeExpression;
import eu.fbk.tools.editor.c.expression.expression.NumericalLiteral;
import eu.fbk.tools.editor.c.expression.expression.OctalLiteral;
import eu.fbk.tools.editor.c.expression.expression.ParsExpression;
import eu.fbk.tools.editor.c.expression.expression.PostfixExpression;
import eu.fbk.tools.editor.c.expression.expression.RelationalExpression;
import eu.fbk.tools.editor.c.expression.expression.ShiftExpression;
import eu.fbk.tools.editor.c.expression.expression.TypeQualifier;
import eu.fbk.tools.editor.c.expression.expression.TypeSpecifier;
import eu.fbk.tools.editor.c.expression.expression.UnaryExpression;
import eu.fbk.tools.editor.c.statement.statement.AllStatement;
import eu.fbk.tools.editor.c.statement.statement.AssertStatement;
import eu.fbk.tools.editor.c.statement.statement.AssignmentStatement;
import eu.fbk.tools.editor.c.statement.statement.BreakStatement;
import eu.fbk.tools.editor.c.statement.statement.CompoundStatement;
import eu.fbk.tools.editor.c.statement.statement.Declaration;
import eu.fbk.tools.editor.c.statement.statement.DeclarationList;
import eu.fbk.tools.editor.c.statement.statement.DeclarationSpecifiers;
import eu.fbk.tools.editor.c.statement.statement.Declarator;
import eu.fbk.tools.editor.c.statement.statement.DeclaratorSuffix;
import eu.fbk.tools.editor.c.statement.statement.ExpressionStatement;
import eu.fbk.tools.editor.c.statement.statement.ForStatement;
import eu.fbk.tools.editor.c.statement.statement.IdentifierList;
import eu.fbk.tools.editor.c.statement.statement.IfStatement;
import eu.fbk.tools.editor.c.statement.statement.InitDeclarator;
import eu.fbk.tools.editor.c.statement.statement.InitDeclaratorList;
import eu.fbk.tools.editor.c.statement.statement.Initializer;
import eu.fbk.tools.editor.c.statement.statement.InitializerList;
import eu.fbk.tools.editor.c.statement.statement.IterationStatement;
import eu.fbk.tools.editor.c.statement.statement.LabeledStatement;
import eu.fbk.tools.editor.c.statement.statement.ParameterDeclaration;
import eu.fbk.tools.editor.c.statement.statement.ParameterList;
import eu.fbk.tools.editor.c.statement.statement.ParameterTypeList;
import eu.fbk.tools.editor.c.statement.statement.ReturnStatement;
import eu.fbk.tools.editor.c.statement.statement.Statement;
import eu.fbk.tools.editor.c.statement.statement.StatementList;
import eu.fbk.tools.editor.c.statement.statement.SwitchStatement;
import eu.fbk.tools.editor.c.visitor.Visitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EObject;

public class CleanCTranslatorToPython
extends Visitor {
    public static final Logger logger = Logger.getLogger(CleanCTranslatorToPython.class);
    private boolean checkAttributesDeclaration;
    private EMap<EObject, String> translatorCache;
    private EMap<EObject, Integer> objectIndentation;
    private EObjectExtractor eObjExtractor;
    private SysMLElementExtractor SysMLExtractor;
    private List<String> literalsNamesMap;
    private PythonUtil pyUtil = new PythonUtil();
    private String cleanCTrue = "true";

    public CleanCTranslatorToPython(SysMLElementExtractor elementExtractor, boolean checkAttributesDeclaration, List<String> literalsNamesMap) {
        this.translatorCache = new BasicEMap();
        this.objectIndentation = new BasicEMap();
        this.checkAttributesDeclaration = checkAttributesDeclaration;
        this.SysMLExtractor = elementExtractor;
        this.literalsNamesMap = literalsNamesMap;
        elementExtractor.setCheckAttributesDeclaration(checkAttributesDeclaration);
    }

    public String processTransitionGuard(EObject o) throws Exception {
        return this.process(o);
    }

    public String processOperationBody(EObject o, Object returnType) throws Exception {
        return null;
    }

    public String process(EObject o) throws Exception {
        logger.debug((Object)("process: " + o));
        logger.trace((Object)"putIndentation..");
        this.putIndentation(o, 0);
        logger.trace((Object)"putIndentation DONE - putVariableInLocalCache..");
        this.eObjExtractor = new EObjectExtractor(o, this.literalsNamesMap);
        logger.trace((Object)"putVariableInLocalCache DONE - visit..");
        this.visit(o);
        logger.trace((Object)"visit DONE - getPyString..");
        String pyText = this.getPyString(o);
        logger.debug((Object)"getPyString DONE.");
        return pyText;
    }

    private String addSpace() {
        return " ";
    }

    public void setCheckAttributesDeclaration(boolean checkAttributesDeclaration) {
        this.checkAttributesDeclaration = checkAttributesDeclaration;
        this.SysMLExtractor.setCheckAttributesDeclaration(checkAttributesDeclaration);
    }

    private String getPyString(EObject object) throws Exception {
        if (!this.translatorCache.containsKey((Object)object)) {
            throw new Exception("Error in CleanCTranslatorToPython -- Unable to find the object: " + object.toString());
        }
        return (String)this.translatorCache.get((Object)object);
    }

    private void putPyString(EObject key, String value) throws Exception {
        this.translatorCache.put((Object)key, (Object)value);
    }

    private Integer getIndentationAsInt(EObject object) throws Exception {
        if (!this.objectIndentation.containsKey((Object)object)) {
            throw new Exception("Error in CleanCTranslatorToPython -- Unable to find the object: " + object.toString());
        }
        return (Integer)this.objectIndentation.get((Object)object);
    }

    private void putIndentation(EObject key, Integer value) {
        this.objectIndentation.put((Object)key, (Object)value);
    }

    public void visit(EObject o) throws Exception {
        if (!this.translatorCache.containsKey((Object)o)) {
            this.putIndentationToChildren(o);
            this.putDeclaredIterVariableToChilden(o);
            super.visit(o);
        }
    }

    private void putDeclaredIterVariableToChilden(EObject o) throws Exception {
        if (this.checkAttributesDeclaration) {
            IterationStatement s;
            boolean found = false;
            String itName = null;
            String blockTypeName = null;
            Statement stmt = null;
            if (o instanceof IterationStatement) {
                s = (IterationStatement)o;
                itName = s.getIteratorId().getName();
                blockTypeName = "";
                if (s.getIteratorType() instanceof TypeSpecifier) {
                    blockTypeName = ((TypeSpecifier)s.getIteratorType()).getName();
                }
                if (s.getIteratorType() instanceof ExternalTypeSpecifier) {
                    blockTypeName = ((ExternalTypeSpecifier)s.getIteratorType()).getId().getName();
                }
                stmt = s.getStatement();
                found = true;
            } else if (o instanceof AllExpression) {
                s = (AllExpression)o;
                itName = s.getIteratorId().getName();
                blockTypeName = "";
                if (s.getIteratorType() instanceof TypeSpecifier) {
                    blockTypeName = ((TypeSpecifier)s.getIteratorType()).getName();
                }
                if (s.getIteratorType() instanceof ExternalTypeSpecifier) {
                    blockTypeName = ((ExternalTypeSpecifier)s.getIteratorType()).getId().getName();
                }
                stmt = s.getExpression();
                found = true;
            } else if (o instanceof AllStatement) {
                s = (AllStatement)o;
                itName = s.getIteratorId().getName();
                blockTypeName = "";
                if (s.getIteratorType() instanceof TypeSpecifier) {
                    blockTypeName = ((TypeSpecifier)s.getIteratorType()).getName();
                }
                if (s.getIteratorType() instanceof ExternalTypeSpecifier) {
                    blockTypeName = ((ExternalTypeSpecifier)s.getIteratorType()).getId().getName();
                }
                stmt = s.getExpression();
                found = true;
            }
            HashMap containerCache = this.eObjExtractor.getDeclIterVariableFromLocalCache(o);
            if (found) {
                Object blockType = this.SysMLExtractor.getBlockType(blockTypeName);
                containerCache.put(itName, blockType);
                this.eObjExtractor.putDeclIterVariableInLocalCache((EObject)stmt, containerCache);
            } else {
                for (EObject i : o.eContents()) {
                    this.eObjExtractor.putDeclIterVariableInLocalCache(i, containerCache);
                }
            }
        }
    }

    private void putIndentationToChildren(EObject o) throws Exception {
        int currIndent = this.getIndentationAsInt(o);
        if (o.eContents() != null) {
            for (EObject i : o.eContents()) {
                if (o instanceof IterationStatement && ((IterationStatement)o).getStatement().equals(i) || o instanceof AllStatement && ((AllStatement)o).getExpression().equals(i) || o instanceof AllExpression && ((AllExpression)o).getExpression().equals(i) || o instanceof FunctionDefinition && ((FunctionDefinition)o).getStatement().equals(i) || o instanceof SwitchStatement && ((SwitchStatement)o).getStatement().equals(i) || o instanceof IfStatement && ((IfStatement)o).getStatement().equals(i) || o instanceof IfStatement && ((IfStatement)o).getElseStatement() != null && ((IfStatement)o).getElseStatement().equals(i)) {
                    this.putIndentation(i, currIndent + 1);
                    continue;
                }
                this.putIndentation(i, currIndent);
            }
        }
    }

    public void visitExternalTypeSpecifier(ExternalTypeSpecifier o) throws Exception {
        String res = this.getPyString((EObject)o.getId());
        this.putPyString((EObject)o, res);
    }

    public void visitTranslationUnit(TranslationUnit tu) throws Exception {
        String res = "";
        int i = 0;
        while (i < tu.getList().size()) {
            res = res.concat(this.getPyString((EObject)tu.getList().get(i)));
            res = i != tu.getList().size() - 1 ? res.concat(this.pyUtil.New3Lines) : res.concat("\n");
            ++i;
        }
        this.putPyString((EObject)tu, res);
    }

    public void visitFunctionDefinition(FunctionDefinition fd) throws Exception {
        String res = this.pyUtil.createFunctionDeclaration(this.getIndentationAsStr((EObject)fd), this.getPyString((EObject)fd.getDeclator()), this.getPyString((EObject)fd.getStatement()));
        this.putPyString((EObject)fd, res);
    }

    public void visitAssertStatement(AssertStatement s) throws Exception {
        String res = this.pyUtil.createPyAssert(this.getIndentationAsStr((EObject)s), this.getPyString((EObject)s.getExpression()));
        this.putPyString((EObject)s, res);
    }

    public void visitAssignmentStatement(AssignmentStatement s) throws Exception {
        String res = this.pyUtil.createStmt(this.getIndentationAsStr((EObject)s), this.getPyString((EObject)s.getExpression()));
        this.putPyString((EObject)s, res);
    }

    public void visitBreakStatement(BreakStatement s) throws Exception {
        String res = CleanCNavigator.isInsideSwitch((EObject)s) ? this.pyUtil.createPassStmt(this.getIndentationAsStr((EObject)s)) : this.pyUtil.createBreakStmt(this.getIndentationAsStr((EObject)s));
        this.putPyString((EObject)s, res);
    }

    public void visitCompoundStatement(CompoundStatement s) throws Exception {
        String res = "";
        if (s.getDecList() != null) {
            res = res.concat(this.getPyString((EObject)s.getDecList()));
        }
        if (s.getStmtList() != null) {
            res = res.concat(this.getPyString((EObject)s.getStmtList()));
        }
        if (s.getDecList() == null && s.getStmtList() == null) {
            res = res.concat(this.pyUtil.createPassStmt(this.getIndentationAsStr((EObject)s)));
        }
        this.putPyString((EObject)s, res);
    }

    public void visitForStatement(ForStatement s) throws Exception {
        this.putPyString((EObject)s, "");
        throw new Exception("visitForStatement not implemented yet");
    }

    public void visitIterationStatement(IterationStatement s) throws Exception {
        String res = this.pyUtil.createForStmt(this.getIndentationAsStr((EObject)s), this.getPyString((EObject)s.getIteratorId()), this.getPyString((EObject)s.getListId()), this.getPyString((EObject)s.getStatement()));
        this.putPyString((EObject)s, res);
    }

    public void visitLabeledStatement(LabeledStatement s) throws Exception {
        String res = "";
        if (s.getExpression() != null) {
            res = String.valueOf(this.getPyString((EObject)s.getExpression())) + ":" + "\n";
        }
        if (s.getStatement() != null) {
            res = res.concat(String.valueOf(this.getPyString((EObject)s.getStatement())) + "\n");
        }
        this.putPyString((EObject)s, res);
    }

    public void visitReturnStatement(ReturnStatement s) throws Exception {
        String returnIdName;
        Expression returnStatExpr = s.getExpression();
        String returnExprStr = this.getPyString((EObject)s.getExpression());
        if (this.checkAttributesDeclaration && returnStatExpr instanceof Identifier && this.SysMLExtractor.isEnumLiteralInCurrOperation(returnIdName = ((Identifier)returnStatExpr).getName())) {
            String enumPrefix = this.SysMLExtractor.getCurrOperationEnumTypeName();
            returnExprStr = this.pyUtil.createDotExpr(enumPrefix, returnIdName);
        }
        String res = this.pyUtil.createReturnStmt(this.getIndentationAsStr((EObject)s), returnExprStr);
        this.putPyString((EObject)s, res);
    }

    public void visitSwitchStatement(SwitchStatement s) throws Exception {
        String firstPartCondition = String.valueOf(this.getPyString((EObject)s.getExpression())) + " is ";
        String res = "";
        EList statements = ((CompoundStatement)s.getStatement()).getStmtList().getStatement();
        int i = 0;
        while (i < statements.size()) {
            res = i == 0 ? String.valueOf("if") + " " + firstPartCondition + this.getPyString((EObject)statements.get(i)) : (statements.get(i) instanceof LabeledStatement && ((LabeledStatement)statements.get(i)).getExpression() != null ? res.concat(String.valueOf(this.pyUtil.ElIf) + firstPartCondition + this.getPyString((EObject)statements.get(i))) : (statements.get(i) instanceof LabeledStatement ? res.concat(String.valueOf("else") + ":" + "\n" + this.getPyString((EObject)statements.get(i))) : res.concat(String.valueOf(this.getPyString((EObject)statements.get(i))) + "\n")));
            ++i;
        }
        this.putPyString((EObject)s, res);
    }

    public void visitExpressionStatement(ExpressionStatement s) throws Exception {
        String res = null;
        res = s.getExpression() != null ? this.pyUtil.createStmt(this.getIndentationAsStr((EObject)s), this.getPyString((EObject)s.getExpression())) : this.pyUtil.createPassStmt(this.getIndentationAsStr((EObject)s));
        this.putPyString((EObject)s, res);
    }

    public void visitIfStatement(IfStatement s) throws Exception {
        String res = this.pyUtil.createIfThenStatement(this.getPyString((EObject)s.getExpression()), this.getIndentationAsStr((EObject)s), this.getPyString((EObject)s.getStatement()));
        if (s.getElseStatement() != null) {
            res = res.concat("\n");
            res = res.concat(this.pyUtil.createElseStatement(this.getIndentationAsStr((EObject)s), this.getPyString((EObject)s.getElseStatement())));
        }
        this.putPyString((EObject)s, res);
    }

    private String getIndentationAsStr(EObject o) throws Exception {
        int num_indentation = this.getIndentationAsInt(o);
        String indentation = "";
        int i = 0;
        while (i < num_indentation) {
            indentation = indentation.concat("    ");
            ++i;
        }
        return indentation;
    }

    public void visitDeclaration(Declaration d) throws Exception {
        String res = this.getPyString((EObject)d.getDeclaratorList());
        this.putPyString((EObject)d, res);
    }

    public void visitInitDeclarator(InitDeclarator d) throws Exception {
        String res = "";
        if (d.getInitializer() != null) {
            res = res.concat(this.pyUtil.createDeclarator(this.getIndentationAsStr((EObject)d), this.getPyString((EObject)d.getDeclarator()), this.getPyString((EObject)d.getInitializer())));
            res = String.valueOf(res) + "\n";
        }
        this.putPyString((EObject)d, res);
    }

    public void visitDeclaratorSuffix(DeclaratorSuffix d) throws Exception {
        if (d.getExpression() != null) {
            String res = this.pyUtil.createExprInBrackets(this.getPyString((EObject)d.getExpression()));
            this.putPyString((EObject)d, res);
        } else if (d.getParameter() != null) {
            String res = this.pyUtil.createExprInParens(this.getPyString((EObject)d.getParameter()));
            this.putPyString((EObject)d, res);
        } else {
            String res = this.pyUtil.createExprInParens(null);
            this.putPyString((EObject)d, res);
        }
    }

    public void visitInitializer(Initializer i) throws Exception {
        String res = "";
        if (i.getExpression() != null) {
            res = this.getPyString((EObject)i.getExpression());
        }
        if (i.getList() != null) {
            res = this.pyUtil.createExprInBraces(this.getPyString((EObject)i.getList()));
        }
        this.putPyString((EObject)i, res);
    }

    public void visitParameterDeclaration(ParameterDeclaration p) throws Exception {
        String res = this.getPyString((EObject)p.getDeclarator());
        this.putPyString((EObject)p, res);
    }

    public void visitParameterTypeList(ParameterTypeList t) throws Exception {
        String res = this.getPyString((EObject)t.getList());
        this.putPyString((EObject)t, res);
    }

    public void visitLogicalOrExpression(LogicalOrExpression e) throws Exception {
        String res = this.pyUtil.createLogicOrProposition(this.getPyString((EObject)e.getLeft()), this.getPyString((EObject)e.getRight()));
        this.putPyString((EObject)e, res);
    }

    public void visitLogicalAndExpression(LogicalAndExpression e) throws Exception {
        String res = this.pyUtil.createLogicAndProposition(this.getPyString((EObject)e.getLeft()), this.getPyString((EObject)e.getRight()));
        this.putPyString((EObject)e, res);
    }

    public void visitInclusiveOrExpression(InclusiveOrExpression e) throws Exception {
        String res = this.pyUtil.createInclOrProposition(this.getPyString((EObject)e.getLeft()), this.getPyString((EObject)e.getRight()));
        this.putPyString((EObject)e, res);
    }

    public void visitExclusiveOrExpression(ExclusiveOrExpression e) throws Exception {
        String res = this.pyUtil.createExclOrProposition(this.getPyString((EObject)e.getLeft()), this.getPyString((EObject)e.getRight()));
        this.putPyString((EObject)e, res);
    }

    public void visitAndExpression(AndExpression e) throws Exception {
        String res = this.pyUtil.createAndProposition(this.getPyString((EObject)e.getLeft()), this.getPyString((EObject)e.getRight()));
        this.putPyString((EObject)e, res);
    }

    public void visitEqualityExpression(EqualityExpression e) throws Exception {
        String right = this.getPyString((EObject)e.getRight());
        if (this.checkAttributesDeclaration && e.getRight() instanceof Identifier) {
            Object leftExprType = this.getSysMLExpressionType(e.getLeft());
            String assignedValue = ((Identifier)e.getRight()).getName();
            if (this.SysMLExtractor.isEnumLiteral(assignedValue, leftExprType)) {
                String enumPrefix = this.SysMLExtractor.getEnumTypeName(leftExprType);
                right = this.pyUtil.createDotExpr(enumPrefix, assignedValue);
            }
        }
        String res = this.pyUtil.createBinaryProposition(this.getPyString((EObject)e.getLeft()), e.getOp(), right);
        this.putPyString((EObject)e, res);
    }

    public void visitRelationalExpression(RelationalExpression e) throws Exception {
        String res = this.pyUtil.createBinaryProposition(this.getPyString((EObject)e.getLeft()), e.getOp(), this.getPyString((EObject)e.getRight()));
        this.putPyString((EObject)e, res);
    }

    public void visitShiftExpression(ShiftExpression e) throws Exception {
        String res = this.pyUtil.createBinaryProposition(this.getPyString((EObject)e.getLeft()), e.getOp(), this.getPyString((EObject)e.getRight()));
        this.putPyString((EObject)e, res);
    }

    public void visitAdditiveExpression(AdditiveExpression e) throws Exception {
        String res = this.pyUtil.createBinaryProposition(this.getPyString((EObject)e.getLeft()), e.getOp(), this.getPyString((EObject)e.getRight()));
        this.putPyString((EObject)e, res);
    }

    public void visitMultiplicativeExpression(MultiplicativeExpression e) throws Exception {
        String res = this.pyUtil.createBinaryProposition(this.getPyString((EObject)e.getLeft()), e.getOp(), this.getPyString((EObject)e.getRight()));
        this.putPyString((EObject)e, res);
    }

    public void visitCastExpression(CastExpression e) throws Exception {
        String res = this.getPyString((EObject)e.getRight());
        this.putPyString((EObject)e, res);
    }

    public void visitUnaryExpression(UnaryExpression e) throws Exception {
        String res = e.getOp().equals("!") ? this.pyUtil.createNotProposition(this.getPyString((EObject)e.getRight())) : this.pyUtil.createUnaryProposition(e.getOp(), this.getPyString((EObject)e.getRight()));
        this.putPyString((EObject)e, res);
    }

    public void visitPostfixExpression(PostfixExpression postfixExpr) throws Exception {
        boolean isCommandOperationCall = false;
        String getRight = null;
        if (postfixExpr.getRight() != null) {
            getRight = this.getPyString((EObject)postfixExpr.getRight());
        } else {
            isCommandOperationCall = this.checkAttributesDeclaration ? this.isCommandOperationCall(postfixExpr) : false;
        }
        String res = this.getPyString((EObject)postfixExpr.getLeft());
        if (this.SysMLExtractor.isCallEvent(res)) {
            res = this.createGetCommandArgStr(res, getRight);
            this.putPyString((EObject)postfixExpr, res);
        } else if (postfixExpr.getIndex() != null) {
            res = String.valueOf(res) + this.pyUtil.createExprInBrackets(this.getPyString((EObject)postfixExpr.getIndex()));
            if (getRight != null) {
                res = res.concat(String.valueOf(".") + getRight);
            }
            this.putPyString((EObject)postfixExpr, res);
        } else if (postfixExpr.getArgumentList() != null) {
            res = isCommandOperationCall ? res.concat(String.valueOf("(") + " " + "self" + "," + this.getPyString((EObject)postfixExpr.getArgumentList()) + ")") : res.concat(this.pyUtil.createExprInParens(this.getPyString((EObject)postfixExpr.getArgumentList())));
            this.putPyString((EObject)postfixExpr, res);
        } else if (getRight != null) {
            if (!this.pyUtil.isExistsCall(getRight)) {
                res = res.concat(String.valueOf(".") + getRight);
            }
            this.putPyString((EObject)postfixExpr, res);
        } else {
            res = isCommandOperationCall ? res.concat(this.pyUtil.createExprInParens("self")) : res.concat(this.pyUtil.createExprInParens(null));
            this.putPyString((EObject)postfixExpr, res);
        }
    }

    private boolean isCommandOperationCall(PostfixExpression postfixExpr) throws Exception {
        String methodId = CleanCNavigator.getLeftMostIdentifier((Expression)postfixExpr);
        ArrayList<String> ids = CleanCNavigator.getBottomUpIdentifiersInPostfixExpression(postfixExpr.eContainer(), new ArrayList<String>());
        boolean res = this.isCommandOperationCall(postfixExpr, ids, methodId);
        return res;
    }

    private boolean isCommandOperationCall(PostfixExpression postfixExpr, ArrayList<String> ids, String methodName) throws Exception {
        Object blockType = this.retrieveBlockType((EObject)postfixExpr, ids);
        return this.SysMLExtractor.isCommandOperation(methodName, blockType);
    }

    private Object getArgumentExpressionType(ArgumentExpressionList cleanCObject, String methodName, ArrayList<String> ids, int paramIndex) throws Exception {
        Object blockType = this.retrieveBlockType((EObject)cleanCObject, ids);
        return this.SysMLExtractor.getArgumentType(paramIndex, methodName, blockType);
    }

    private Object retrieveBlockType(EObject cleanCObject, ArrayList<String> ids) throws Exception {
        Object block = this.SysMLExtractor.getCurrBlock();
        boolean isFirstElement = true;
        for (String id : ids) {
            if (!isFirstElement) {
                block = this.SysMLExtractor.retrieveBlockType(id, block);
            } else {
                Object newBlock = this.getSysMLType(cleanCObject, id, block);
                if (newBlock == null) {
                    throw new Exception("For expression " + cleanCObject + ", block type not found for element " + id + " in block " + block);
                }
                block = newBlock;
            }
            isFirstElement = false;
        }
        return block;
    }

    private Object retrieveSysMLType(EObject currCleanCElement, ArrayList<String> ids) throws Exception {
        Object type = this.SysMLExtractor.getCurrBlock();
        boolean firstElement = true;
        for (String id : ids) {
            logger.trace((Object)("I'm finding the type of id: " + id + ", the curr block is: " + this.SysMLExtractor.getCurrBlock()));
            if (firstElement) {
                logger.trace((Object)"first element");
                type = this.getSysMLTypeInCurrentBlock(currCleanCElement, id);
                if (type == null) {
                    logger.trace((Object)"type == null");
                    type = this.SysMLExtractor.getAttributeOrOperationType(id);
                }
            } else {
                logger.trace((Object)"not first element");
                type = this.SysMLExtractor.getAttributeOrOperationType(id, type);
            }
            logger.trace((Object)("type found for id: " + id + ", is type: " + type));
            firstElement = false;
        }
        if (type == null) {
            String idsStr = "";
            for (String id : ids) {
                idsStr = idsStr.concat(String.valueOf(id) + " - ");
            }
            throw new Exception("Type not found for " + idsStr);
        }
        return type;
    }

    public void visitParsExpression(ParsExpression e) throws Exception {
        String res = this.pyUtil.createExprInParens(this.getPyString((EObject)e.getExp()));
        this.putPyString((EObject)e, res);
    }

    public void visitArgumentExpressionList(ArgumentExpressionList e) throws Exception {
        String res = "";
        ArrayList<String> ids = null;
        String methodName = "";
        if (this.checkAttributesDeclaration) {
            PostfixExpression pf = CleanCNavigator.getFirstBottomUpPostFixExpression((EObject)e);
            ids = CleanCNavigator.getBottomUpIdentifiersInPostfixExpression((EObject)pf, new ArrayList<String>());
            methodName = ids.remove(ids.size() - 1);
        }
        int i = 0;
        while (i < e.getExpression().size()) {
            Object paramType;
            if (i != 0) {
                res = res.concat(this.addSpace());
            }
            String argumentExpressionPyStr = this.getPyString((EObject)e.getExpression().get(i));
            if (this.checkAttributesDeclaration && this.SysMLExtractor.isEnumLiteral(argumentExpressionPyStr, paramType = this.getArgumentExpressionType(e, methodName, ids, i))) {
                String enumPrefix = this.SysMLExtractor.getEnumTypeName(paramType);
                argumentExpressionPyStr = this.pyUtil.createDotExpr(enumPrefix, argumentExpressionPyStr);
            }
            res = res.concat(argumentExpressionPyStr);
            if (i != e.getExpression().size() - 1) {
                res = res.concat(",");
            }
            ++i;
        }
        this.putPyString((EObject)e, res);
    }

    public void visitEnumeratorList(EnumeratorList e) throws Exception {
        this.putPyString((EObject)e, "");
    }

    public void visitEnumSpecifier(EnumSpecifier e) throws Exception {
        this.putPyString((EObject)e, "");
    }

    public void visitIdentifier(Identifier e) throws Exception {
        String idName;
        String res = idName = e.getName();
        if (e.eContainer() == null || !(e.eContainer() instanceof PostfixExpression)) {
            if (this.SysMLExtractor.isCallEvent(idName)) {
                res = this.createIsTriggerStr(idName);
            }
            if (this.SysMLExtractor.isDeclaredInCurrentBlock(idName)) {
                res = this.pyUtil.createSelfDotExpr(idName);
            }
        } else if (CleanCNavigator.isLeftMostIdOfPostfixExpression(e) && this.SysMLExtractor.isDeclaredInCurrentBlock(idName)) {
            res = this.pyUtil.createSelfDotExpr(idName);
        }
        if (this.SysMLExtractor.isCommandArgument(idName)) {
            res = this.pyUtil.createGetCurrCommandArgStr(idName);
        }
        this.putPyString((EObject)e, res);
    }

    private String createIsTriggerStr(String idName) throws Exception {
        String operationName = this.SysMLExtractor.getCallEventOperationName(idName);
        return this.pyUtil.createIsTriggeredOperationCommand(operationName);
    }

    private String createGetCommandArgStr(String callEventName, String argAsStr) throws Exception {
        String operationName = this.SysMLExtractor.getCallEventOperationName(callEventName);
        return this.pyUtil.getCommandArgMethodName(operationName, argAsStr);
    }

    private Object getSysMLTypeInCurrentBlock(EObject cleanCObject, String variableName) throws Exception {
        return this.getSysMLType(cleanCObject, variableName, this.SysMLExtractor.getCurrBlock());
    }

    private Object getSysMLType(EObject cleanCObject, String variableName, Object block) throws Exception {
        if (this.eObjExtractor.isDeclatredIterator(cleanCObject, variableName)) {
            return this.eObjExtractor.getIteratorType(cleanCObject, variableName);
        }
        if (this.SysMLExtractor.isGloballyDeclared(variableName)) {
            return this.SysMLExtractor.getGlobalVariableTypeFromCache(variableName);
        }
        if (this.SysMLExtractor.isAttribute(variableName, block)) {
            return this.SysMLExtractor.getAttributeType(variableName, block);
        }
        if (this.SysMLExtractor.isOperation(variableName, block)) {
            return this.SysMLExtractor.getOperationReturnType(variableName, block);
        }
        return null;
    }

    public void visitBooleanLiteral(BooleanLiteral e) throws Exception {
        String res = this.pyUtil.createBooleanId(e.getValue().equals(this.cleanCTrue));
        this.putPyString((EObject)e, res);
    }

    public void visitDecimalLiteral(DecimalLiteral e) throws Exception {
        this.putPyString((EObject)e, e.getValue());
    }

    public void visitFloatingPointLiteral(FloatingPointLiteral e) throws Exception {
        String res = e.getValue();
        this.putPyString((EObject)e, res);
    }

    public void visitOctalLiteral(OctalLiteral e) throws Exception {
        throw new Exception("Error in CleanCTranslatorToPython -- Unable to translate the object: " + e.toString());
    }

    public void visitNumericalLiteral(NumericalLiteral e) throws Exception {
    }

    public void visitHexLiteral(HexLiteral e) throws Exception {
        throw new Exception("Error in CleanCTranslatorToPython -- Unable to translate the object: " + e.toString());
    }

    public void visitCharacterLiteral(CharacterLiteral e) throws Exception {
        String res = e.getValue();
        this.putPyString((EObject)e, res);
    }

    public void visitTypeSpecifier(TypeSpecifier t) throws Exception {
        this.putPyString((EObject)t, "");
    }

    public void visitTypeQualifier(TypeQualifier t) throws Exception {
        this.putPyString((EObject)t, "");
    }

    public void visitAssignmentExpression(AssignmentExpression s) throws Exception {
        String right = this.getPyString((EObject)s.getRight());
        if (this.checkAttributesDeclaration && s.getRight() instanceof Identifier) {
            Object leftExprType = this.getSysMLExpressionType(s.getLeft());
            String assignedValue = ((Identifier)s.getRight()).getName();
            if (this.SysMLExtractor.isEnumLiteral(assignedValue, leftExprType)) {
                String enumPrefix = this.SysMLExtractor.getEnumTypeName(leftExprType);
                right = this.pyUtil.createDotExpr(enumPrefix, assignedValue);
            }
        }
        String res = this.pyUtil.createAssignmentExpr(this.getPyString((EObject)s.getLeft()), s.getOp(), right);
        this.putPyString((EObject)s, res);
    }

    public void visitAllExpression(AllExpression s) throws Exception {
        logger.trace((Object)("visitAllExpression s.getExpression(): " + s.getExpression()));
        String res = this.pyUtil.createAllExpression(this.getPyString((EObject)s.getExpression()), this.getPyString((EObject)s.getIteratorId()), this.getPyString((EObject)s.getListId()));
        this.putPyString((EObject)s, res);
    }

    public void visitAllStatement(AllStatement s) throws Exception {
        logger.trace((Object)("visitAllStatement s.getExpression(): " + s.getExpression()));
        String res = this.pyUtil.createAllStatement(this.getIndentationAsStr((EObject)s.getExpression()), this.getPyString((EObject)s.getExpression()), this.getPyString((EObject)s.getIteratorId()), this.getPyString((EObject)s.getListId()));
        this.putPyString((EObject)s, res);
    }

    private Object getSysMLExpressionType(Expression expr) throws Exception {
        if (expr instanceof PostfixExpression) {
            ArrayList<String> ids = CleanCNavigator.getPostfixIds((PostfixExpression)expr);
            return this.retrieveSysMLType((EObject)expr, ids);
        }
        return this.getSysMLTypeInCurrentBlock((EObject)expr, ((Identifier)expr).getName());
    }

    public void addAllVariableInGlobalVariablesCache(HashMap<String, Object> typeAssignmentCache) {
        this.SysMLExtractor.addAllVariableInGlobalVariablesCache(typeAssignmentCache);
    }

    public void visitInitDeclaratorList(InitDeclaratorList d) throws Exception {
        String res = "";
        ArrayList<String> pyStmtList = new ArrayList<String>();
        int i = 0;
        while (i < d.getList().size()) {
            pyStmtList.add(this.getPyString((EObject)d.getList().get(i)));
            ++i;
        }
        res = this.pyUtil.createStatementList(pyStmtList);
        this.putPyString((EObject)d, res);
    }

    public void visitStatementList(StatementList s) throws Exception {
        String res = "";
        ArrayList<String> pyStmtList = new ArrayList<String>();
        int i = 0;
        while (i < s.getStatement().size()) {
            pyStmtList.add(this.getPyString((EObject)s.getStatement().get(i)));
            ++i;
        }
        res = this.pyUtil.createStatementListWithNl(pyStmtList);
        this.putPyString((EObject)s, res);
    }

    public void visitDeclarationList(DeclarationList d) throws Exception {
        String res = "";
        ArrayList<String> pyStmtList = new ArrayList<String>();
        int i = 0;
        while (i < d.getDeclaration().size()) {
            pyStmtList.add(this.getPyString((EObject)((Declaration)d.getDeclaration().get(i)).getDeclaratorList()));
            ++i;
        }
        res = this.pyUtil.createStatementList(pyStmtList);
        this.putPyString((EObject)d, res);
    }

    public void visitDeclarationSpecifiers(DeclarationSpecifiers d) throws Exception {
        String res = "";
        ArrayList<String> pyStmtList = new ArrayList<String>();
        int i = 0;
        while (i < d.getSpecifier().size()) {
            pyStmtList.add(this.getPyString((EObject)d.getSpecifier().get(i)));
            ++i;
        }
        res = this.pyUtil.createStatementListWithSpacesAndCommas(pyStmtList);
        this.putPyString((EObject)d, res);
    }

    public void visitDeclarator(Declarator d) throws Exception {
        String res = this.getPyString((EObject)d.getId());
        ArrayList<String> pyStmtList = new ArrayList<String>();
        int i = 0;
        while (i < d.getSuffixList().size()) {
            pyStmtList.add(this.getPyString((EObject)d.getSuffixList().get(i)));
            ++i;
        }
        res = res.concat(this.pyUtil.createStatementListWithCommas(pyStmtList));
        this.putPyString((EObject)d, res);
    }

    public void visitIdentifierList(IdentifierList il) throws Exception {
        String res = "";
        ArrayList<String> pyStmtList = new ArrayList<String>();
        int i = 0;
        while (i < il.getId().size()) {
            pyStmtList.add(this.getPyString((EObject)il.getId().get(i)));
            ++i;
        }
        res = this.pyUtil.createStatementListWithSpacesAndCommas(pyStmtList);
        this.putPyString((EObject)il, res);
    }

    public void visitInitializerList(InitializerList il) throws Exception {
        String res = "";
        ArrayList<String> pyStmtList = new ArrayList<String>();
        int i = 0;
        while (i < il.getList().size()) {
            pyStmtList.add(this.getPyString((EObject)il.getList().get(i)));
            ++i;
        }
        res = this.pyUtil.createStatementListWithSpacesAndCommas(pyStmtList);
        this.putPyString((EObject)il, res);
    }

    public void visitParameterList(ParameterList p) throws Exception {
        String res = String.valueOf("self") + "," + " ";
        ArrayList<String> pyStmtList = new ArrayList<String>();
        int i = 0;
        while (i < p.getList().size()) {
            pyStmtList.add(this.getPyString((EObject)p.getList().get(i)));
            ++i;
        }
        res = res.concat(this.pyUtil.createStatementListWithSpacesAndCommas(pyStmtList));
        this.putPyString((EObject)p, res);
    }
}

