/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.xtext.internal;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.session.SavingPolicy;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManagerListener;
import org.eclipse.sirius.business.internal.session.IsModifiedSavingPolicy;
import org.eclipse.sirius.common.xtext.internal.XtextSavingPolicy;
import org.eclipse.xtext.resource.XtextResource;

public class XtextSessionManagerListener
extends SessionManagerListener.Stub {
    public void notify(Session updated, int notification) {
        super.notify(updated, notification);
        switch (notification) {
            case 7: {
                this.changeSavingPolicyIfXtextIsUsed(updated);
                break;
            }
            case 11: {
                this.changeSavingPolicyIfXtextIsUsed(updated);
            }
        }
    }

    private void changeSavingPolicyIfXtextIsUsed(Session session) {
        TransactionalEditingDomain ted = session.getTransactionalEditingDomain();
        if (ted != null && !(session.getSavingPolicy() instanceof XtextSavingPolicy) && this.containsXtextResources(ted)) {
            session.setSavingPolicy((SavingPolicy)new XtextSavingPolicy((SavingPolicy)new IsModifiedSavingPolicy(ted)));
        }
    }

    protected boolean containsXtextResources(TransactionalEditingDomain ted) {
        return ted.getResourceSet() != null && Iterators.any((Iterator)ted.getResourceSet().getResources().iterator(), (Predicate)Predicates.instanceOf(XtextResource.class));
    }
}

