/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.editor.nusmv.smv;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum RTCTLUnaryOperator implements Enumerator
{
    EBF(0, "EBF", "EBF"),
    ABF(1, "ABF", "ABF"),
    EBG(2, "EBG", "EBG"),
    ABG(3, "ABG", "ABG");

    public static final int EBF_VALUE = 0;
    public static final int ABF_VALUE = 1;
    public static final int EBG_VALUE = 2;
    public static final int ABG_VALUE = 3;
    private static final RTCTLUnaryOperator[] VALUES_ARRAY;
    public static final List<RTCTLUnaryOperator> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new RTCTLUnaryOperator[]{EBF, ABF, EBG, ABG};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static RTCTLUnaryOperator get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RTCTLUnaryOperator result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RTCTLUnaryOperator getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RTCTLUnaryOperator result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RTCTLUnaryOperator get(int value) {
        switch (value) {
            case 0: {
                return EBF;
            }
            case 1: {
                return ABF;
            }
            case 2: {
                return EBG;
            }
            case 3: {
                return ABG;
            }
        }
        return null;
    }

    private RTCTLUnaryOperator(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

